/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import com.badlogic.gdx.Screen;
import com.badlogic.gdx.utils.ByteArray;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import ru.m210projects.Build.Architecture.MessageType;
import ru.m210projects.Build.Pattern.BuildFactory;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.LogSender;
import ru.m210projects.Build.Pattern.ScreenAdapters.DefaultPrecacheScreen;
import ru.m210projects.Build.Pattern.ScreenAdapters.GameAdapter;
import ru.m210projects.Build.Pattern.ScreenAdapters.MessageScreen;
import ru.m210projects.Build.Render.listeners.PrecacheListener;
import ru.m210projects.Build.filehandle.CacheResourceMap;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.input.GameProcessor;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.Wang.Config;
import ru.m210projects.Wang.Enemies.Bunny;
import ru.m210projects.Wang.Enemies.Coolg;
import ru.m210projects.Wang.Enemies.Coolie;
import ru.m210projects.Wang.Enemies.Eel;
import ru.m210projects.Wang.Enemies.GirlNinj;
import ru.m210projects.Wang.Enemies.Goro;
import ru.m210projects.Wang.Enemies.Hornet;
import ru.m210projects.Wang.Enemies.Lava;
import ru.m210projects.Wang.Enemies.Ninja;
import ru.m210projects.Wang.Enemies.Ripper;
import ru.m210projects.Wang.Enemies.Ripper2;
import ru.m210projects.Wang.Enemies.Serp;
import ru.m210projects.Wang.Enemies.Skel;
import ru.m210projects.Wang.Enemies.Skull;
import ru.m210projects.Wang.Enemies.Sumo;
import ru.m210projects.Wang.Enemies.Zilla;
import ru.m210projects.Wang.Enemies.Zombie;
import ru.m210projects.Wang.Factory.WangBoardService;
import ru.m210projects.Wang.Factory.WangEngine;
import ru.m210projects.Wang.Factory.WangFactory;
import ru.m210projects.Wang.Factory.WangInterpolation;
import ru.m210projects.Wang.Factory.WangMenuHandler;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Factory.WangProcessor;
import ru.m210projects.Wang.Factory.rts.RTSFile;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.JSector;
import ru.m210projects.Wang.JWeapon;
import ru.m210projects.Wang.LoadSave;
import ru.m210projects.Wang.Menus.Network.MenuMultiplayer;
import ru.m210projects.Wang.MiscActr;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Screens.AnmScreen;
import ru.m210projects.Wang.Screens.CreditsScreen;
import ru.m210projects.Wang.Screens.DemoScreen;
import ru.m210projects.Wang.Screens.DisconnectScreen;
import ru.m210projects.Wang.Screens.GameScreen;
import ru.m210projects.Wang.Screens.LoadingScreen;
import ru.m210projects.Wang.Screens.LogoAScreen;
import ru.m210projects.Wang.Screens.MenuScreen;
import ru.m210projects.Wang.Screens.NetScreen;
import ru.m210projects.Wang.Screens.PrecacheScreen;
import ru.m210projects.Wang.Screens.StatisticScreen;
import ru.m210projects.Wang.Screens.WangMessageScreen;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Type.ResourceHandler;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.VoxelScript;
import ru.m210projects.Wang.Weapon;

public class Main
extends BuildGame {
    public static final String appdef = "swgdx.def";
    public static final boolean NETTEST = false;
    public static Main game;
    public static WangEngine engine;
    public static WangBoardService boardService;
    public static Config cfg;
    public static WangNetwork gNet;
    public static LoadingScreen gLoadingScreen;
    public static GameScreen gGameScreen;
    public static DemoScreen gDemoScreen;
    public static LogoAScreen gLogoScreen;
    public static AnmScreen gAnmScreen;
    public static MenuScreen gMenuScreen;
    public static StatisticScreen gStatisticScreen;
    public static NetScreen gNetScreen;
    public static DisconnectScreen gDisconnectScreen;
    public static CreditsScreen gCreditsScreen;
    public static UserFlag mUserFlag;
    public static RTSFile RTS_File;
    public WangMenuHandler menu;
    public WangNetwork net;
    public final String mainGrp = "sw.grp";
    public WangInterpolation pIntSkip2;
    public WangInterpolation pIntSkip4;
    public final Runnable rMenu = new Runnable(){

        @Override
        public void run() {
            if (game.getScreen() != gAnmScreen || gAnmScreen.getAnim() != 0) {
                Sound.StopFX();
            }
            Sound.CDAudio_Play(2, true);
            Game.Level = 0;
            Main.this.nNetMode = BuildGame.NetMode.Single;
            WangNetwork.CommPlayers = 1;
            Main.gNet.MultiGameType = WangNetwork.MultiGameTypes.MULTI_GAME_NONE;
            Main.gNet.FakeMultiplayer = false;
            if (!Main.this.menu.gShowMenu) {
                Main.this.menu.mOpen(Main.this.menu.mMenus[0], -1);
            }
            Directory gameDir = Main.this.cache.getGameDirectory();
            if (Mmulti.numplayers > 1 || Main.gDemoScreen.demofiles.isEmpty() || Main.cfg.gDemoSeq == 0 || !gDemoScreen.showDemo(gameDir)) {
                Main.this.changeScreen(gMenuScreen);
            }
        }
    };

    public Main(List<String> args, GameConfig bcfg, String name, String version, boolean isRelease) throws IOException {
        super(args, bcfg, name, version, isRelease);
        game = this;
        cfg = (Config)bcfg;
        this.pIntSkip2 = new WangInterpolation(){

            @Override
            public int getSkipValue() {
                return Sprites.MoveSkip2 ? 1 : 0;
            }

            @Override
            public int getSkipMax() {
                return 2;
            }
        };
        this.pIntSkip4 = new WangInterpolation(){

            @Override
            public int getSkipValue() {
                return Sprites.MoveSkip4;
            }

            @Override
            public int getSkipMax() {
                return 4;
            }
        };
    }

    @Override
    protected MessageScreen createMessage(String header, String text, MessageType type) {
        return new WangMessageScreen(this, header, text, type);
    }

    @Override
    public GameProcessor createGameProcessor() {
        return new WangProcessor(this);
    }

    @Override
    public WangProcessor getProcessor() {
        return (WangProcessor)this.controller;
    }

    @Override
    public BuildFactory getFactory() {
        return new WangFactory(this);
    }

    @Override
    public boolean init() throws Exception {
        Entry kvxres;
        FileEntry filgdx;
        boardService = engine.getBoardService();
        Game.InitGame();
        Player.InitPlayerStates();
        Weapon.InitWeaponStates();
        JWeapon.InitJWeaponStates();
        Sprites.InitSprStates();
        Ninja.InitNinjaStates();
        Zombie.InitZombieStates();
        Ripper2.InitRipper2States();
        Bunny.InitBunnyStates();
        Goro.InitGoroStates();
        Ripper.InitRipperStates();
        MiscActr.InitMiscStates();
        Serp.InitSerpStates();
        Sumo.InitSumoStates();
        Zilla.InitZillaStates();
        GirlNinj.InitGNinjaStates();
        Coolg.InitCoolgStates();
        Coolie.InitCoolieStates();
        Skull.InitSkullStates();
        Skel.InitSkelStates();
        Lava.InitLavaStates();
        Eel.InitEelStates();
        Hornet.InitHornetStates();
        JSector.InitJSectorStructs();
        Sector.InitSectorStructs();
        Saveable.InitSaveable();
        Directory gameDir = this.cache.getGameDirectory();
        Console.out.println("Initializing def-scripts...");
        this.cache.loadGdxDef(this.baseDef, appdef, "swgdx.dat");
        if (cfg.isAutoloadFolder()) {
            Console.out.println("Initializing autoload folder");
            block9: for (Entry file : gameDir.getDirectory(gameDir.getEntry("autoload"))) {
                switch (file.getExtension()) {
                    case "PK3": 
                    case "ZIP": {
                        Group group = this.cache.newGroup(file);
                        Entry def = group.getEntry(appdef);
                        if (!def.exists()) continue block9;
                        this.cache.addGroup(group, CacheResourceMap.CachePriority.NORMAL);
                        this.baseDef.loadScript(file.getName(), def);
                        break;
                    }
                    case "DEF": {
                        this.baseDef.loadScript(file);
                    }
                }
            }
        }
        if ((filgdx = gameDir.getEntry(appdef)).exists()) {
            this.baseDef.loadScript(filgdx);
        }
        if ((kvxres = this.cache.getEntry("swvoxfil.txt", true)).exists()) {
            VoxelScript vox = new VoxelScript(kvxres);
            vox.apply(this.baseDef);
        }
        this.setDefs(this.baseDef);
        LoadSave.FindSaves(this.getUserDirectory());
        Sound.InitCDtracks();
        Main.game.pNet.ResetTimers();
        gLoadingScreen = new LoadingScreen(this);
        gGameScreen = new GameScreen(this);
        gDemoScreen = new DemoScreen(this);
        gLogoScreen = new LogoAScreen(this, 5.0f);
        gAnmScreen = new AnmScreen(this);
        gMenuScreen = new MenuScreen(this);
        gStatisticScreen = new StatisticScreen(this);
        gNetScreen = new NetScreen(this);
        gDisconnectScreen = new DisconnectScreen(this);
        gCreditsScreen = new CreditsScreen(this);
        gDemoScreen.checkDemoEntry(gameDir);
        return true;
    }

    public void MainMenu() {
        this.rMenu.run();
    }

    @Override
    public void show() {
        if (!this.args.isEmpty()) {
            this.parseArgumentsCommon();
            String netmode = this.args.getOrDefault("-netmode", "");
            String players = this.args.getOrDefault("-players", "");
            this.args.clear();
            if (!netmode.isEmpty()) {
                Console.out.println("Starting multiplayer as " + netmode, OsdColor.YELLOW);
                if (netmode.equalsIgnoreCase("master")) {
                    String[] param = new String[]{"-n0:" + (players.isEmpty() ? Integer.valueOf(2) : players), "-p " + cfg.getPort()};
                    ((MenuMultiplayer)this.menu.mMenus[12]).getMenuCreate(this).createGame(0, false, param);
                    return;
                }
                if (netmode.equalsIgnoreCase("slave")) {
                    String[] param = new String[]{"-n0", cfg.getmAddress(), "-p " + cfg.getPort()};
                    ((MenuMultiplayer)this.menu.mMenus[12]).getMenuJoin(this).joinGame(param);
                    return;
                }
            }
        }
        if (Game.rec != null) {
            Game.rec.close();
        }
        if (ResourceHandler.usecustomarts) {
            ResourceHandler.resetEpisodeResources();
        }
        this.changeScreen(gLogoScreen.setCallback(() -> {
            if (gAnmScreen.init(0)) {
                this.changeScreen(gAnmScreen.setCallback(this.rMenu).escSkipping(false));
            } else {
                this.MainMenu();
            }
        }));
    }

    @Override
    public void onDropEntry(FileEntry entry) {
        if (!entry.isExtension("map")) {
            return;
        }
        Console.out.println("Start dropped map: " + entry.getName());
        gGameScreen.newgame(false, entry, 0, 0, Game.Skill);
    }

    @Override
    public DefaultPrecacheScreen getPrecacheScreen(Runnable readyCallback, PrecacheListener listener) {
        return new PrecacheScreen(readyCallback, listener);
    }

    public void Disconnect() {
        if (Game.rec != null) {
            Game.rec.close();
        }
        this.changeScreen(gDisconnectScreen);
    }

    @Override
    public void dispose() {
        if (Game.rec != null) {
            Game.rec.close();
        }
        super.dispose();
    }

    @Override
    public LogSender getLogSender() {
        return new LogSender(this){

            @Override
            public byte[] reportData() {
                byte[] out;
                String text = "Mapname: " + gGameScreen.getTitle();
                text = text + "\r\n";
                text = text + "UserFlag: " + (Object)((Object)mUserFlag);
                text = text + "\r\n";
                if (mUserFlag == UserFlag.Addon && Game.currentGame != null) {
                    try {
                        text = text + "Episode filename: " + Game.currentGame.getPath() + "\r\n";
                        text = text + "Episode title: " + Game.currentGame.Title + "\r\n";
                        text = text + "Episode name: " + Game.currentGame.getNumEpisode(Game.Level) + "\r\n";
                        text = text + "\r\n";
                    }
                    catch (Exception e) {
                        text = text + "Episode filename get error \r\n";
                    }
                }
                text = text + "level " + Game.Level;
                text = text + "\r\n";
                text = text + "nDifficulty: " + Game.Skill;
                text = text + "\r\n";
                if (Game.Player[Mmulti.myconnectindex] != null) {
                    text = text + "PlayerX: " + Game.Player[Mmulti.myconnectindex].posx;
                    text = text + "\r\n";
                    text = text + "PlayerY: " + Game.Player[Mmulti.myconnectindex].posy;
                    text = text + "\r\n";
                    text = text + "PlayerZ: " + Game.Player[Mmulti.myconnectindex].posz;
                    text = text + "\r\n";
                    text = text + "PlayerAng: " + Game.Player[Mmulti.myconnectindex].getAnglef();
                    text = text + "\r\n";
                    text = text + "PlayerHoriz: " + Game.Player[Mmulti.myconnectindex].horiz;
                    text = text + "\r\n";
                    text = text + "PlayerSect: " + Game.Player[Mmulti.myconnectindex].cursectnum;
                    text = text + "\r\n";
                }
                if (mUserFlag == UserFlag.UserMap && Game.boardfilename != null) {
                    ByteArray array = new ByteArray();
                    byte[] data = Game.boardfilename.getBytes();
                    text = text + "\r\n<------Start Map data------->\r\n";
                    array.addAll(text.getBytes());
                    array.addAll(data);
                    array.addAll("\r\n<------End Map data------->\r\n".getBytes());
                    out = Arrays.copyOf(array.items, array.size);
                } else {
                    out = text.getBytes();
                }
                return out;
            }
        };
    }

    public boolean isScreenSaving() {
        Screen scr = this.getScreen();
        if (scr instanceof GameAdapter) {
            return ((GameAdapter)scr).isScreenSaving();
        }
        return false;
    }

    static {
        mUserFlag = UserFlag.None;
    }

    public static enum UserFlag {
        None,
        UserMap,
        Addon;


        public static UserFlag parseValue(byte index) {
            switch (index) {
                case 1: {
                    return Addon;
                }
                case 2: {
                    return UserMap;
                }
            }
            return None;
        }
    }
}

