/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Menus.Network;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuButton;
import ru.m210projects.Build.Pattern.MenuItems.MenuConteiner;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.MenuItems.MenuSwitch;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Wang.Factory.WangMenuHandler;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Menus.MenuUserContent;
import ru.m210projects.Wang.Menus.WangSwitch;
import ru.m210projects.Wang.Menus.WangTitle;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Type.EpisodeEntry;
import ru.m210projects.Wang.Type.GameInfo;

public class MenuNetwork
extends BuildMenu {
    private final Main app;
    private int mGameType = 1;
    private int mEpisodeId = 0;
    private int mLevelId = 0;
    private int mDifficulty = -1;
    private int mMonsters = 0;
    private int mFFire = 0;
    private int mMarkers = 1;
    private boolean TeamPlay = false;
    private boolean NetNuke = true;
    private int NetTimeLimit = 0;
    private int NetKillLimit = 0;
    private String mContent = "";
    private Object currentFile;
    private final int[] netEpisodeInfo = new int[3];
    private final MenuProc mLevelsUpdate;
    private final MenuConteiner mMenuLevel;
    private final MenuConteiner mMenuEpisode;
    private final MenuConteiner mMenuDifficulty;

    public MenuNetwork(final Main app) {
        super(app.pMenu);
        this.app = app;
        final WangMenuHandler menu = app.menu;
        this.addItem(new WangTitle("NETWORK GAME"), false);
        MenuConteiner pItem = new MenuConteiner(this, "Content", app.getFont(2), 35, 45, 240, new String[]{""}, 0, null){
            final /* synthetic */ MenuNetwork this$0;
            {
                this.this$0 = this$0;
                super(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
            }

            @Override
            public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
                switch (opt) {
                    case ENTER: 
                    case LMB: {
                        MenuUserContent usercont = (MenuUserContent)menu.mMenus[15];
                        if (!usercont.showmain) {
                            usercont.setShowMain(true);
                        }
                        Sound.StopSound();
                        handler.mOpen(usercont, -1);
                        return false;
                    }
                }
                return this.m_pMenu.mNavigation(opt);
            }

            @Override
            public void open() {
                if (!app.isCurrentScreen(Main.gGameScreen)) {
                    this.this$0.setEpisode(Game.defGame);
                }
            }

            @Override
            public void draw(MenuHandler handler) {
                this.list[0] = this.this$0.mContent.toCharArray();
                super.draw(handler);
            }
        };
        pItem.listFont = app.getFont(1);
        MenuConteiner mMenuGame = new MenuConteiner("Game Type", app.getFont(1), 35, 70, 240, null, 0, (handler, pItem112) -> {
            MenuConteiner item = (MenuConteiner)pItem112;
            this.mGameType = item.num;
        }){

            @Override
            public void open() {
                if (this.list == null) {
                    this.list = new char[][]{"WangBang (spawn)".toCharArray(), "WangBang (no spawn)".toCharArray(), "Cooperative".toCharArray()};
                }
                this.num = MenuNetwork.this.mGameType;
            }
        };
        this.mLevelsUpdate = (handler, pItem111) -> {
            MenuConteiner item = (MenuConteiner)pItem111;
            if (this.currentFile instanceof GameInfo) {
                GameInfo mGameInfo = (GameInfo)this.currentFile;
                int size = mGameInfo.episode[this.netEpisodeInfo[this.mEpisodeId]].nMaps;
                if (item.list == null || item.list.length != size) {
                    item.list = new char[size][];
                }
                for (int i = 0; i < size; ++i) {
                    item.list[i] = mGameInfo.episode[this.netEpisodeInfo[this.mEpisodeId]].gMapInfo[i] != null ? mGameInfo.episode[this.netEpisodeInfo[this.mEpisodeId]].gMapInfo[i].Description.toCharArray() : ("Null[" + i + "]").toCharArray();
                }
            } else {
                item.list = new char[1][];
                item.list[0] = "None".toCharArray();
            }
            item.num = 0;
            this.mLevelId = 0;
        };
        this.mMenuLevel = new MenuConteiner("Level", app.getFont(1), 35, 90, 240, null, 0, (handler, pItem110) -> {
            MenuConteiner item = (MenuConteiner)pItem110;
            this.mLevelId = item.num;
        }){

            @Override
            public void open() {
                this.num = MenuNetwork.this.mLevelId;
            }

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(MenuNetwork.this.currentFile instanceof GameInfo);
                this.text = ("Level " + (MenuNetwork.this.mLevelId + 1)).toCharArray();
                super.draw(handler);
            }
        };
        this.mMenuEpisode = new MenuConteiner("Episode", app.getFont(1), 35, 80, 240, null, 0, (handler, pItem19) -> {
            MenuConteiner item = (MenuConteiner)pItem19;
            this.mEpisodeId = item.num;
            this.mLevelsUpdate.run(menu, this.mMenuLevel);
        }){

            @Override
            public void open() {
                this.num = MenuNetwork.this.mEpisodeId;
            }

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(MenuNetwork.this.currentFile instanceof GameInfo);
                this.text = ("Episode " + (MenuNetwork.this.mEpisodeId + 1)).toCharArray();
                super.draw(handler);
            }
        };
        int pos = 90;
        this.mMenuDifficulty = new MenuConteiner("Monsters", app.getFont(1), 35, pos += 10, 240, null, 0, (handler, pItem18) -> {
            MenuConteiner item = (MenuConteiner)pItem18;
            this.mMonsters = item.num == 0 ? 1 : 0;
            this.mDifficulty = item.num - 1;
        }){

            @Override
            public void open() {
                this.num = MenuNetwork.this.mDifficulty + 1;
            }
        };
        WangSwitch mMenuMarkers = new WangSwitch("Markers", app.getFont(1), 35, pos += 10, 240, this.mMarkers == 1, (handler, pItem17) -> {
            MenuSwitch sw = (MenuSwitch)pItem17;
            this.mMarkers = sw.value ? 1 : 0;
        });
        MenuConteiner mMenuKills = new MenuConteiner("Kill Limit", app.getFont(1), 35, pos += 10, 240, null, this.NetKillLimit, (handler, pItem16) -> {
            MenuConteiner item = (MenuConteiner)pItem16;
            this.NetKillLimit = item.num;
        }){

            @Override
            public void open() {
                if (this.list == null) {
                    this.list = new char[WangNetwork.TimeLimitTable.length][];
                    this.list[0] = "Infinite".toCharArray();
                    for (int i = 1; i < this.list.length; ++i) {
                        this.list[i] = Integer.toString(i * 10).toCharArray();
                    }
                }
                this.num = MenuNetwork.this.NetKillLimit;
            }
        };
        MenuConteiner mMenuTime = new MenuConteiner("Time Limit", app.getFont(1), 35, pos += 10, 240, null, this.NetTimeLimit, (handler, pItem15) -> {
            MenuConteiner item = (MenuConteiner)pItem15;
            this.NetTimeLimit = item.num;
        }){

            @Override
            public void open() {
                if (this.list == null) {
                    this.list = new char[WangNetwork.TimeLimitTable.length][];
                    this.list[0] = "Infinite".toCharArray();
                    for (int i = 1; i < this.list.length; ++i) {
                        this.list[i] = (WangNetwork.TimeLimitTable[i] + " minutes").toCharArray();
                    }
                }
                this.num = MenuNetwork.this.NetTimeLimit;
            }
        };
        WangSwitch mMenuTeam = new WangSwitch("TeamPlay", app.getFont(1), 35, pos += 10, 240, this.TeamPlay, (handler, pItem14) -> {
            MenuSwitch sw = (MenuSwitch)pItem14;
            this.TeamPlay = sw.value;
        });
        WangSwitch mMenuFFire = new WangSwitch("Hurt teammate", app.getFont(1), 35, pos += 10, 240, this.mFFire == 1, (handler, pItem13) -> {
            MenuSwitch sw = (MenuSwitch)pItem13;
            this.mFFire = sw.value ? 1 : 0;
        }){

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(MenuNetwork.this.mGameType == 2 || MenuNetwork.this.TeamPlay);
                super.draw(handler);
            }
        };
        WangSwitch mMenuNuke = new WangSwitch("Play with Nuke", app.getFont(1), 35, pos += 10, 240, this.NetNuke, (handler, pItem12) -> {
            MenuSwitch sw = (MenuSwitch)pItem12;
            this.NetNuke = sw.value;
        });
        MenuButton mStart = this.getMenuStartButton(app, pos);
        this.addItem(pItem, true);
        this.addItem(mMenuGame, false);
        this.addItem(this.mMenuEpisode, false);
        this.addItem(this.mMenuLevel, false);
        this.addItem(this.mMenuDifficulty, false);
        this.addItem(mMenuMarkers, false);
        this.addItem(mMenuKills, false);
        this.addItem(mMenuTime, false);
        this.addItem(mMenuTeam, false);
        this.addItem(mMenuFFire, false);
        this.addItem(mMenuNuke, false);
        this.addItem(mStart, false);
    }

    @NotNull
    private MenuButton getMenuStartButton(Main app, int pos) {
        MenuProc mNetStart = (handler, pItem1) -> {
            Game.pNetInfo.nGameType = this.mGameType;
            Game.pNetInfo.nEpisode = this.currentFile instanceof Entry ? this.mEpisodeId : this.netEpisodeInfo[this.mEpisodeId];
            Game.pNetInfo.nLevel = this.mLevelId;
            Game.pNetInfo.nDifficulty = this.mDifficulty;
            Game.pNetInfo.nMonsters = this.mMonsters;
            Game.pNetInfo.nFriendlyFire = this.mFFire;
            Game.pNetInfo.SpawnMarkers = this.mMarkers == 1;
            Game.pNetInfo.TeamPlay = this.TeamPlay;
            Game.pNetInfo.NetNuke = this.NetNuke;
            Game.pNetInfo.TimeLimit = this.NetTimeLimit;
            Game.pNetInfo.KillLimit = this.NetKillLimit;
            if (Mmulti.numplayers >= 2) {
                byte[] packbuf = app.net.packbuf;
                int len = WangNetwork.PacketType.LevelStart.Send(packbuf);
                app.net.sendtoall(packbuf, len);
            }
            if (app.net.WaitForAllPlayers(0)) {
                Main.gGameScreen.newgame(true, this.currentFile, this.netEpisodeInfo[this.mEpisodeId], this.mLevelId, this.mDifficulty);
            }
        };
        return new MenuButton("Start Game", app.getFont(1), 35, pos + 10, 240, 0, 0, null, -1, mNetStart, 0){

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(Mmulti.myconnectindex == Mmulti.connecthead && MenuNetwork.this.currentFile != null);
                super.draw(handler);
            }
        };
    }

    private void updateUserEpisodeList(GameInfo gInfo) {
        int i;
        Arrays.fill(this.netEpisodeInfo, -1);
        int nEpisodes = 0;
        for (i = 0; i < gInfo.episode.length; ++i) {
            if (gInfo.episode[i] == null || gInfo.episode[i].nMaps == 0) continue;
            this.netEpisodeInfo[nEpisodes++] = i;
        }
        if (this.mMenuEpisode.list == null || this.mMenuEpisode.list.length != nEpisodes) {
            this.mMenuEpisode.list = new char[nEpisodes][];
        }
        for (i = 0; i < nEpisodes; ++i) {
            this.mMenuEpisode.list[i] = gInfo.episode[this.netEpisodeInfo[i]].Title.toCharArray();
        }
        if (this.mMenuDifficulty.list == null) {
            this.mMenuDifficulty.list = new char[5][];
        }
        this.mMenuDifficulty.list[0] = "None".toCharArray();
        for (i = 0; i < 4; ++i) {
            this.mMenuDifficulty.list[1 + i] = gInfo.skills[i].toCharArray();
        }
    }

    public Object getFile() {
        return this.currentFile;
    }

    public void setEpisode(GameInfo ini) {
        if (ini == null || this.currentFile == ini) {
            return;
        }
        if (Mmulti.myconnectindex == Mmulti.connecthead && !this.app.net.WaitForContentCheck(this.getEpisodeContentData(ini.getEpisodeEntry()), 0)) {
            StringBuilder msg = new StringBuilder();
            short i = Mmulti.connecthead;
            while (i >= 0) {
                if (this.app.net.gContentFound[i] != 1) {
                    if (this.app.net.gContentFound[i] == 2) {
                        msg.append(Game.Player[i].getName()).append("(wrong checksum)").append(", ");
                    } else {
                        msg.append(Game.Player[i].getName()).append(", ");
                    }
                }
                i = Mmulti.connectpoint2[i];
            }
            msg = new StringBuilder(msg.substring(0, msg.length() - 2));
            msg.append("  is missing content: ").append(ini.Title);
            Console.out.println(msg.toString(), OsdColor.RED);
            if (!Console.out.isShowing()) {
                Console.out.onToggle();
            }
            this.currentFile = null;
            return;
        }
        this.currentFile = ini;
        this.mContent = ini.Title;
        this.mEpisodeId = 0;
        this.mMenuEpisode.num = 0;
        this.updateUserEpisodeList(ini);
        this.mLevelsUpdate.run(this.app.pMenu, this.mMenuLevel);
    }

    public void setMap(FileEntry map) {
        if (map == null || this.currentFile == map) {
            return;
        }
        if (Mmulti.myconnectindex == Mmulti.connecthead && !this.app.net.WaitForContentCheck(this.getUserMapContentData(map), 0)) {
            StringBuilder msg = new StringBuilder();
            short i = Mmulti.connecthead;
            while (i >= 0) {
                if (this.app.net.gContentFound[i] != 1) {
                    if (this.app.net.gContentFound[i] == 2) {
                        msg.append(Game.Player[i].getName()).append("(wrong checksum)").append(", ");
                    } else {
                        msg.append(Game.Player[i].getName()).append(", ");
                    }
                }
                i = Mmulti.connectpoint2[i];
            }
            msg = new StringBuilder(msg.substring(0, msg.length() - 2));
            msg.append(" haven't content: ").append(map.getName());
            Console.out.println(msg.toString(), OsdColor.RED);
            if (!Console.out.isShowing()) {
                Console.out.onToggle();
            }
            this.currentFile = null;
            return;
        }
        this.currentFile = map;
        this.mContent = map.getName();
        if (this.mMenuEpisode.list != null) {
            this.mMenuEpisode.list[0] = "None".toCharArray();
        }
        this.mMenuEpisode.num = 0;
        this.mEpisodeId = 0;
        if (this.mMenuLevel.list != null) {
            this.mMenuLevel.list[0] = "Usermap".toCharArray();
        }
        this.mMenuLevel.num = 0;
        this.mLevelId = 0;
        if (this.mMenuDifficulty.list == null) {
            this.mMenuDifficulty.list = new char[5][];
        }
        this.mMenuDifficulty.list[0] = "None".toCharArray();
        for (int i = 0; i < 4; ++i) {
            this.mMenuDifficulty.list[1 + i] = Game.defGame.skills[i].toCharArray();
        }
    }

    private byte[] getEpisodeContentData(EpisodeEntry episodeEntry) {
        byte[] byArray;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            StreamUtils.writeBoolean(os, true);
            StreamUtils.writeDataString(os, episodeEntry.getFileEntry().getRelativePath().toString());
            StreamUtils.writeLong(os, Mmulti.numplayers > 1 ? episodeEntry.getFileEntry().getChecksum() : 0L);
            byArray = os.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                Console.out.println(e.toString(), OsdColor.RED);
                return new byte[0];
            }
        }
        os.close();
        return byArray;
    }

    private byte[] getUserMapContentData(FileEntry entry) {
        byte[] byArray;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            StreamUtils.writeBoolean(os, false);
            StreamUtils.writeDataString(os, entry.getRelativePath().toString());
            StreamUtils.writeLong(os, Mmulti.numplayers > 1 ? entry.getChecksum() : 0L);
            byArray = os.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                Console.out.println(e.toString(), OsdColor.RED);
                return new byte[0];
            }
        }
        os.close();
        return byArray;
    }
}

