/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Screens;

import com.badlogic.gdx.Gdx;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.settings.GameKeys;
import ru.m210projects.Wang.Border;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.LoadSave;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Screens.GameScreen;
import ru.m210projects.Wang.Type.CompareService.CompareService;
import ru.m210projects.Wang.Type.DemoFile;
import ru.m210projects.Wang.Type.PlayerStr;

public class DemoScreen
extends GameScreen {
    protected Entry lastDemoFile = Directory.DUMMY_ENTRY;
    public int nDemonum = -1;
    public final Map<Group, List<Entry>> demofiles = new HashMap<Group, List<Entry>>();
    public DemoFile demfile;

    public DemoScreen(Main game) {
        super(game);
    }

    @Override
    public void show() {
        LoadSave.lastload = null;
    }

    public boolean showDemo(Entry entry, Entry ignoredIni) {
        this.onStopRecord();
        this.demfile = null;
        try (InputStream is = entry.getInputStream();){
            this.demfile = new DemoFile(is);
        }
        catch (Exception e) {
            Console.out.println("Can't play the demo file: " + entry.getName(), OsdColor.RED);
            return false;
        }
        boolean bl = Main.gNet.FakeMultiplayer = this.demfile.numplayers > 1;
        if (Main.gNet.FakeMultiplayer) {
            Main.gNet.FakeMultiNumPlayers = this.demfile.numplayers;
        }
        if (Mmulti.numplayers > 1) {
            Main.game.pNet.NetDisconnect(Mmulti.myconnectindex);
        }
        if (this.demfile.nVersion != 1) {
            Main.gNet.KillLimit = this.demfile.KillLimit;
            Main.gNet.TimeLimit = this.demfile.TimeLimit;
            Main.gNet.TimeLimitClock = this.demfile.TimeLimitClock;
            Main.gNet.MultiGameType = this.demfile.MultiGameType;
            Main.gNet.TeamPlay = this.demfile.TeamPlay;
            Main.gNet.HurtTeammate = this.demfile.HurtTeammate;
            Main.gNet.SpawnMarkers = this.demfile.SpawnMarkers;
            Main.gNet.NoRespawn = this.demfile.NoRespawn;
            Main.gNet.Nuke = this.demfile.Nuke;
        }
        Game.GodMode = false;
        Object item = null;
        Main.UserFlag userFlag = this.demfile.userFlag;
        if (userFlag == Main.UserFlag.Addon) {
            item = this.demfile.addon;
        } else if (userFlag == Main.UserFlag.UserMap) {
            item = Main.game.getCache().getEntry(FileUtils.getPath(this.demfile.mapname, new String[0]), true);
        }
        this.lastDemoFile = entry;
        Main.gDemoScreen.newgame(Main.gNet.FakeMultiplayer, item, this.demfile.Episode, this.demfile.Level - 1, this.demfile.Skill);
        Console.out.println("Playing demo " + entry.getName());
        return true;
    }

    @Override
    protected void startboard(Runnable startboard) {
        Main.game.doPrecache(() -> {
            startboard.run();
            this.pNet.ResetTimers();
            Game.totalsynctics = 0;
            this.pNet.ready2send = false;
        });
    }

    @Override
    public void render(float delta) {
        if (Mmulti.numplayers > 1) {
            this.pNet.GetPackets();
        }
        this.DemoRender();
        float smoothratio = 65536.0f;
        if (!Main.game.gPaused && ((smoothratio = (float)this.pEngine.getTimer().getsmoothratio(delta)) < 0.0f || smoothratio > 65536.0f)) {
            smoothratio = Gameutils.BClipRange(smoothratio, 0.0f, 65536.0f);
        }
        Main.game.pInt.dointerpolations(smoothratio);
        this.DrawWorld(smoothratio);
        this.DrawHud(smoothratio);
        Main.game.pInt.restoreinterpolations();
        if (this.pMenu.gShowMenu) {
            this.pMenu.mDrawMenu();
        }
        this.PostFrame(this.pNet);
        this.pEngine.nextpage(delta);
    }

    private void DemoRender() {
        this.pNet.ready2send = false;
        if (!Main.game.isCurrentScreen(this)) {
            return;
        }
        if (!Main.game.gPaused && this.demfile != null) {
            while (Main.engine.getTotalClock() >= Game.totalsynctics + 3) {
                CompareService.update(this.demfile.rcnt);
                short j = Mmulti.connecthead;
                while (j >= 0) {
                    this.pNet.gFifoInput[this.pNet.gNetFifoHead[j] & 0xFF][j].Copy(this.demfile.recsync[j][this.demfile.rcnt]);
                    short s = j;
                    this.pNet.gNetFifoHead[s] = this.pNet.gNetFifoHead[s] + 1;
                    j = Mmulti.connectpoint2[j];
                }
                --this.demfile.reccnt;
                if (this.demfile.reccnt <= 0) {
                    this.demfile = null;
                    Gdx.app.postRunnable(Game::TerminateLevel);
                    Group group = this.lastDemoFile.getParent();
                    if (!this.showDemo(group)) {
                        Main.game.changeScreen(Main.gMenuScreen);
                    }
                    return;
                }
                ++this.demfile.rcnt;
                Main.game.pInt.clearinterpolations();
                Main.game.pIntSkip2.clearinterpolations();
                Main.game.pIntSkip4.clearinterpolations();
                this.ProcessFrame(this.pNet);
            }
        } else {
            Game.totalsynctics = Main.engine.getTotalClock();
        }
    }

    @Override
    public boolean gameKeyDown(GameKey gameKey) {
        if (this.gameKeyDownCommon(gameKey, false)) {
            return true;
        }
        PlayerStr pp = Game.Player[Mmulti.myconnectindex];
        if (GameKeys.Enlarge_Screen.equals(gameKey)) {
            Border.SetBorder(pp, Main.cfg.BorderNum + 1);
        }
        if (GameKeys.Shrink_Screen.equals(gameKey)) {
            Border.SetBorder(pp, Main.cfg.BorderNum - 1);
        }
        return false;
    }

    public boolean showDemo(Group group) {
        List<Entry> list = this.checkDemoEntry(group);
        switch (Main.cfg.gDemoSeq) {
            case 0: {
                return false;
            }
            case 1: {
                if (this.nDemonum < list.size() - 1) {
                    ++this.nDemonum;
                    break;
                }
                this.nDemonum = 0;
                break;
            }
            case 2: {
                int nextnum = this.nDemonum;
                if (list.size() > 1) {
                    while (nextnum == this.nDemonum) {
                        nextnum = (int)(Math.random() * (double)list.size());
                    }
                }
                this.nDemonum = Gameutils.BClipRange(nextnum, 0, list.size() - 1);
            }
        }
        if (!list.isEmpty()) {
            return this.showDemo(list.get(this.nDemonum), null);
        }
        return false;
    }

    public static boolean checkDemoEntry(Entry file) {
        return file.exists() && file.isExtension("dmo");
    }

    public List<Entry> checkDemoEntry(Group group) {
        if (this.demofiles.containsKey(group)) {
            return this.demofiles.get(group);
        }
        this.nDemonum = -1;
        List<Entry> demos = group.stream().filter(DemoScreen::checkDemoEntry).sorted(Entry::compareTo).collect(Collectors.toList());
        this.demofiles.put(group, demos);
        Console.out.println("There are " + demos.size() + " demo(s) in the loop", OsdColor.YELLOW);
        if (Main.cfg.gDemoSeq == 2) {
            int nextnum = this.nDemonum;
            if (demos.size() > 1) {
                while (nextnum == this.nDemonum) {
                    nextnum = (int)(Math.random() * (double)demos.size());
                }
            }
            this.nDemonum = nextnum;
        }
        return demos;
    }

    public void onStopRecord() {
        if (Game.rec == null) {
            return;
        }
        CompareService.close();
        Game.rec.close();
        Game.rec = null;
    }

    public static boolean isDemoPlaying() {
        return false;
    }
}

