/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Text;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.RotatorStr;
import ru.m210projects.Wang.Type.Sect_User;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Vator;

public class Slidor {
    public static final Animator DoSlidor = new Animator(Slidor::DoSlidor);

    public static void ReverseSlidor(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        RotatorStr r = u.getRotator();
        if (u.Tics != 0) {
            u.Tics = 0;
            Slidor.SetSlidorActive(SpriteNum);
            return;
        }
        if (r.tgt == 0) {
            r.tgt = r.open_dest;
        } else if (r.tgt == r.open_dest) {
            r.tgt = 0;
        }
        r.vel = -r.vel;
    }

    public static void SetSlidorActive(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        RotatorStr r = u.getRotator();
        Sector.DoSoundSpotMatch(Gameutils.SP_TAG2(sp), 1, Sound.SoundType.SOUND_OBJECT_TYPE);
        u.Flags |= Gameutils.SPR_ACTIVE;
        u.Tics = 0;
        if (r.tgt == 0) {
            Vator.VatorSwitch(Gameutils.SP_TAG2(sp), 0);
        } else {
            Vator.VatorSwitch(Gameutils.SP_TAG2(sp), 1);
        }
    }

    public static void SetSlidorInactive(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        Sector.DoSoundSpotMatch(Gameutils.SP_TAG2(sp), 2, Sound.SoundType.SOUND_OBJECT_TYPE);
        u.Flags &= ~Gameutils.SPR_ACTIVE;
    }

    public static void DoSlidorOperate(PlayerStr pp, int sectnum) {
        short match;
        ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(sectnum);
        if (sec != null && (match = sec.getHitag()) > 0 && !Slidor.TestSlidorMatchActive(match)) {
            Slidor.DoSlidorMatch(pp, match, true);
        }
    }

    public static void DoSlidorMatch(PlayerStr pp, int match, boolean manual) {
        ListNode<Sprite> node = Main.boardService.getStatNode(73);
        while (node != null) {
            int i = node.getIndex();
            ListNode<Sprite> nexti = node.getNext();
            Sprite fsp = node.get();
            if (Gameutils.SP_TAG1(fsp) == 145 && Gameutils.SP_TAG2(fsp) == match) {
                USER fu = Gameutils.getUser(i);
                if (Gameutils.TEST_BOOL4(fsp) && (Main.gNet.MultiGameType == WangNetwork.MultiGameTypes.MULTI_GAME_COMMBAT || Main.gNet.MultiGameType == WangNetwork.MultiGameTypes.MULTI_GAME_AI_BOTS)) {
                    if (pp != null && Gameutils.TEST_BOOL11(fsp)) {
                        Text.PutStringInfo(pp, "This only opens in single play.");
                    }
                } else if (Gameutils.SP_TAG3(fsp) != 1 || !manual) {
                    short sectnum = fsp.getSectnum();
                    Sect_User su = Sector.getSectUser(sectnum);
                    if (pp != null && su != null && su.stag == 29 && su.number != 0) {
                        int key_num = su.number;
                        Text.PutStringInfo(pp, Text.KeyDoorMessage[key_num - 1]);
                        return;
                    }
                    if (fu != null && MyTypes.TEST(fu.Flags, Gameutils.SPR_ACTIVE)) {
                        Slidor.ReverseSlidor(i);
                    } else {
                        Slidor.SetSlidorActive(i);
                    }
                }
            }
            node = nexti;
        }
    }

    public static boolean TestSlidorMatchActive(int match) {
        ListNode<Sprite> node = Main.boardService.getStatNode(73);
        while (node != null) {
            int i = node.getIndex();
            ListNode<Sprite> nexti = node.getNext();
            Sprite fsp = node.get();
            if (Gameutils.SP_TAG1(fsp) == 145 && Gameutils.SP_TAG2(fsp) == match) {
                USER fu = Gameutils.getUser(i);
                if (!Gameutils.TEST_BOOL6(fsp) && fu != null && (MyTypes.TEST(fu.Flags, Gameutils.SPR_ACTIVE) || fu.Tics != 0)) {
                    return true;
                }
            }
            node = nexti;
        }
        return false;
    }

    public static void DoSlidorMoveWalls(int SpriteNum, int amt) {
        Wall wall;
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return;
        }
        ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(sp.getSectnum());
        if (sec == null) {
            return;
        }
        short startwall = sec.getWallptr();
        int endwall = startwall + sec.getWallnum() - 1;
        short w = startwall;
        do {
            if ((wall = Main.boardService.getWall(w)) == null) {
                return;
            }
            int pw = w - 1;
            if (w < startwall) {
                pw = endwall;
            }
            Wall pwall = Main.boardService.getWall(pw);
            switch (wall.getLotag()) {
                case 220: {
                    if (pwall != null && wall.getNextwall() == -1) {
                        Main.engine.dragpoint(w, wall.getX() - amt, wall.getY());
                        Main.engine.dragpoint(pw, pwall.getX() - amt, pwall.getY());
                        Main.engine.dragpoint(wall.getPoint2(), wall.getWall2().getX() - amt, wall.getWall2().getY());
                        Main.engine.dragpoint(wall.getWall2().getPoint2(), wall.getWall2().getWall2().getX() - amt, wall.getWall2().getWall2().getY());
                        break;
                    }
                    Main.engine.dragpoint(w, wall.getX() - amt, wall.getY());
                    Main.engine.dragpoint(wall.getPoint2(), wall.getWall2().getX() - amt, wall.getWall2().getY());
                    break;
                }
                case 221: {
                    if (pwall != null && wall.getNextwall() == -1) {
                        Main.engine.dragpoint(w, wall.getX() + amt, wall.getY());
                        Main.engine.dragpoint(pw, pwall.getX() + amt, pwall.getY());
                        Main.engine.dragpoint(wall.getPoint2(), wall.getWall2().getX() + amt, wall.getWall2().getY());
                        Main.engine.dragpoint(wall.getWall2().getPoint2(), wall.getWall2().getWall2().getX() + amt, wall.getWall2().getWall2().getY());
                        break;
                    }
                    Main.engine.dragpoint(w, wall.getX() + amt, wall.getY());
                    Main.engine.dragpoint(wall.getPoint2(), wall.getWall2().getX() + amt, wall.getWall2().getY());
                    break;
                }
                case 222: {
                    if (pwall != null && wall.getNextwall() == -1) {
                        Main.engine.dragpoint(w, wall.getX(), wall.getY() - amt);
                        Main.engine.dragpoint(pw, pwall.getX(), pwall.getY() - amt);
                        Main.engine.dragpoint(wall.getPoint2(), wall.getWall2().getX(), wall.getWall2().getY() - amt);
                        Main.engine.dragpoint(wall.getWall2().getPoint2(), wall.getWall2().getWall2().getX(), wall.getWall2().getWall2().getY() - amt);
                        break;
                    }
                    Main.engine.dragpoint(w, wall.getX(), wall.getY() - amt);
                    Main.engine.dragpoint(wall.getPoint2(), wall.getWall2().getX(), wall.getWall2().getY() - amt);
                    break;
                }
                case 223: {
                    if (pwall != null && wall.getNextwall() == -1) {
                        Main.engine.dragpoint(w, wall.getX(), wall.getY() + amt);
                        Main.engine.dragpoint(pw, pwall.getX(), pwall.getY() + amt);
                        Main.engine.dragpoint(wall.getPoint2(), wall.getWall2().getX(), wall.getWall2().getY() + amt);
                        Main.engine.dragpoint(wall.getWall2().getPoint2(), wall.getWall2().getWall2().getX(), wall.getWall2().getWall2().getY() + amt);
                        break;
                    }
                    Main.engine.dragpoint(w, wall.getX(), wall.getY() + amt);
                    Main.engine.dragpoint(wall.getPoint2(), wall.getWall2().getX(), wall.getWall2().getY() + amt);
                }
            }
        } while ((w = wall.getPoint2()) != startwall);
    }

    public static void DoSlidorInstantClose(int SpriteNum) {
        Wall wall;
        short w;
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return;
        }
        ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(sp.getSectnum());
        if (sec == null) {
            return;
        }
        short startwall = w = sec.getWallptr();
        do {
            if ((wall = Main.boardService.getWall(w)) == null) {
                return;
            }
            switch (wall.getLotag()) {
                case 220: {
                    int diff = wall.getX() - sp.getX();
                    Slidor.DoSlidorMoveWalls(SpriteNum, diff);
                    break;
                }
                case 221: {
                    int diff = wall.getX() - sp.getX();
                    Slidor.DoSlidorMoveWalls(SpriteNum, -diff);
                    break;
                }
                case 222: {
                    int diff = wall.getY() - sp.getY();
                    Slidor.DoSlidorMoveWalls(SpriteNum, diff);
                    break;
                }
                case 223: {
                    int diff = wall.getY() - sp.getY();
                    Slidor.DoSlidorMoveWalls(SpriteNum, -diff);
                }
            }
        } while ((w = wall.getPoint2()) != startwall);
    }

    public static void DoSlidorMove(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        RotatorStr r = u.getRotator();
        boolean kill = false;
        int old_pos = r.pos;
        if (r.pos < r.tgt) {
            r.pos += r.speed;
            r.speed += r.vel;
            if (r.pos > r.tgt) {
                r.pos = r.tgt;
            }
        }
        if (r.pos > r.tgt) {
            r.pos -= r.speed;
            r.speed += r.vel;
            if (r.pos < r.tgt) {
                r.pos = r.tgt;
            }
        }
        if (r.pos == r.tgt) {
            if (r.pos == r.open_dest) {
                r.tgt = 0;
                r.vel = -r.vel;
                Slidor.SetSlidorInactive(SpriteNum);
                if (Gameutils.SP_TAG6(sp) != 0 && !Gameutils.TEST_BOOL8(sp)) {
                    Sector.DoMatchEverything(null, Gameutils.SP_TAG6(sp), -1);
                }
                if (u.WaitTics != 0) {
                    u.Tics = u.WaitTics;
                }
            } else if (r.pos == 0) {
                r.speed = r.orig_speed;
                r.vel = Pragmas.klabs(r.vel);
                r.tgt = r.open_dest;
                Slidor.SetSlidorInactive(SpriteNum);
                Gameutils.RESET_BOOL8(sp);
                if (Gameutils.SP_TAG6(sp) != 0 && Gameutils.TEST_BOOL8(sp)) {
                    Sector.DoMatchEverything(null, Gameutils.SP_TAG6(sp), -1);
                }
            }
            if (Gameutils.TEST_BOOL2(sp)) {
                kill = true;
            }
        } else if (Gameutils.TEST_BOOL3(sp) && r.tgt == 0) {
            boolean found = false;
            ListNode<Sprite> node = Main.boardService.getSectNode(sp.getSectnum());
            while (node != null) {
                int i = node.getIndex();
                ListNode<Sprite> nexti = node.getNext();
                Sprite bsp = node.get();
                USER bu = Gameutils.getUser(i);
                if (bu != null && MyTypes.TEST(bsp.getCstat(), Gameutils.CSTAT_SPRITE_BLOCK) && MyTypes.TEST(bsp.getExtra(), Gameutils.SPRX_PLAYER_OR_ENEMY)) {
                    Slidor.ReverseSlidor(SpriteNum);
                    Gameutils.SET_BOOL8(sp);
                    found = true;
                    break;
                }
                node = nexti;
            }
            if (!found) {
                short pnum = Mmulti.connecthead;
                while (pnum != -1) {
                    PlayerStr pp = Game.Player[pnum];
                    if (Main.boardService.getSector(pp.lo_sectp) != null && pp.lo_sectp == sp.getSectnum() || pp.hi_sectp != -1 && pp.hi_sectp == sp.getSectnum()) {
                        Slidor.ReverseSlidor(SpriteNum);
                        u.vel_rate = -u.vel_rate;
                    }
                    pnum = Mmulti.connectpoint2[pnum];
                }
            }
        }
        Slidor.DoSlidorMoveWalls(SpriteNum, r.pos - old_pos);
        if (kill) {
            Slidor.SetSlidorInactive(SpriteNum);
            Sprites.KillSprite(SpriteNum);
        }
    }

    public static void DoSlidor(int SpriteNum) {
        Slidor.DoSlidorMove(SpriteNum);
    }
}

