/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.utils.Pool;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import ru.m210projects.Build.Architecture.common.audio.BuildAudio;
import ru.m210projects.Build.Architecture.common.audio.SoundData;
import ru.m210projects.Build.Architecture.common.audio.Source;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Script.CueScript;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Digi;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Text;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Type.VOC3D;
import ru.m210projects.Wang.Type.VOCDecoder;
import ru.m210projects.Wang.Type.VOC_INFO;
import ru.m210projects.Wang.Type.Vector3i;

public class Sound {
    public static final int[] TauntAIVocs = new int[]{246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 331, 332, 333, 334, 335, 336, 440, 337, 338, 339, 340, 341, 342, 343, 441, 344, 345, 346, 347, 348, 349, 350, 351};
    public static final int[] PlayerPainVocs = new int[]{256, 257, 258, 259, 260};
    public static final int v3df_none = 0;
    public static final int v3df_follow = 1;
    public static final int v3df_kill = 2;
    public static final int v3df_doppler = 4;
    public static final int v3df_dontpan = 8;
    public static final int v3df_ambient = 16;
    public static final int v3df_intermit = 32;
    public static final int v3df_init = 64;
    public static final int v3df_nolookup = 128;
    public static final int MAXLEVLDIST = 19000;
    public static final int DECAY_CONST = 4000;
    public static final int MAX_AMBIENT_SOUNDS = 82;
    public static final int[] PlayerLowHealthPainVocs = new int[]{383, 384, 385, 386, 387};
    public static final int[] PlayerGetItemVocs = new int[]{267, 439, 438, 331, 333};
    public static final int[] PlayerYellVocs = new int[]{261, 262, 263};
    public static final int[] RedBookSong = new int[]{2, 4, 9, 12, 10, 5, 6, 8, 11, 12, 5, 10, 4, 6, 9, 7, 10, 8, 7, 9, 10, 11, 5, 11, 8, 7, 13, 5, 6, 13};
    public static final String[] cdtracks = new String[]{"", "track02.ogg", "track03.ogg", "track04.ogg", "track05.ogg", "track06.ogg", "track07.ogg", "track08.ogg", "track09.ogg", "track10.ogg", "track11.ogg", "track12.ogg", "track13.ogg", "track14.ogg", "track15.ogg"};
    private static final Map<Integer, Entry> cdTrackEntryMap = new HashMap<Integer, Entry>();
    private static final Pool<VOC3D> vocList = new Pool<VOC3D>(){

        @Override
        protected VOC3D newObject() {
            return new VOC3D();
        }
    };
    private static final TVOC_Info[] TmpVocArray = new TVOC_Info[32];
    private static final int[] ambrand = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67};
    public static char rtsplaying;
    public static Vector3i sndCoords;
    public static int playTrack;
    public static Music currMusic;
    public static BuildAudio audio;
    private static boolean Use_SoundSpriteNum;
    private static int SoundSpriteNum;
    private static VOC3D voc3dstart;
    private static VOC3D voc3dend;

    public static void SoundStartup() {
        Console.out.println("Initializing sound system");
        Main.cfg.setAudioDriver(Main.cfg.getAudioDriver());
        Main.cfg.setMidiDevice(Main.cfg.getMidiDevice());
        audio = Main.cfg.getAudio();
        audio.registerDecoder("VOC", new VOCDecoder());
        for (int i = 0; i < 32; ++i) {
            Sound.TmpVocArray[i] = new TVOC_Info();
        }
        vocList.clear();
        Sound.Terminate3DSounds();
        sndCoords = new Vector3i();
    }

    private static int SoundDist(int x, int y, int z, int basedist) {
        double tx = Pragmas.klabs(Game.Player[Game.screenpeek].posx - x);
        double ty = Pragmas.klabs(Game.Player[Game.screenpeek].posy - y);
        double tz = Pragmas.klabs(Game.Player[Game.screenpeek].posz - z >> 4);
        double sqrdist = Math.abs(tx * tx + ty * ty + tz * tz);
        double retval = Math.sqrt(sqrdist);
        if (basedist < 0) {
            double decayshift = 2.0;
            double decay = (double)Pragmas.klabs(basedist) / 4000.0;
            int i = 0;
            while ((double)i < decay) {
                decayshift *= 2.0;
                ++i;
            }
            retval = Math.abs((double)basedist / decayshift) >= retval ? 0.0 : (retval *= decay);
        } else {
            retval = (double)basedist > retval ? 0.0 : (retval -= (double)basedist);
        }
        retval = retval * 256.0 / 19000.0;
        if (retval < 0.0) {
            retval = 0.0;
        }
        if (retval > 255.0) {
            retval = 255.0;
        }
        return (int)retval;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean CacheSound(int num) {
        if (num < 0 || num >= Digi.voc.length || Main.cfg.isNoSound()) {
            return false;
        }
        vp = Digi.voc[num];
        if (vp.data == null) {
            fp = Main.game.cache.getEntry(vp.name, true);
            extension = fp.getExtension();
            try {
                is = fp.getInputStream();
                try {
                    var5_6 = StreamUtils.readString(is, 3);
                    var6_8 = -1;
                    switch (var5_6.hashCode()) {
                        case 81135: {
                            if (!var5_6.equals("RIF")) break;
                            var6_8 = 0;
                            break;
                        }
                        case 79215: {
                            if (!var5_6.equals("Ogg")) break;
                            var6_8 = 1;
                        }
                    }
                    switch (var6_8) {
                        case 0: {
                            extension = "WAV";
                            ** break;
lbl24:
                            // 1 sources

                            break;
                        }
                        case 1: {
                            extension = "OGG";
                            break;
                        }
                        ** default:
lbl29:
                        // 1 sources

                        break;
                    }
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (Exception is) {
                // empty catch block
            }
            soundData = Sound.audio.getSoundDecoder(extension).decode(fp);
            if (soundData != null) {
                vp.data = soundData;
                return true;
            }
            Console.out.println("Could not open sound " + vp.name + ", num " + num + ", priority " + vp.priority, OsdColor.RED);
            vp.data = new SoundData(8000, 1, 8, ByteBuffer.allocateDirect(0));
            return false;
        }
        return true;
    }

    public static void COVER_SetReverb(int amt) {
        if (amt != 0) {
            Sound.setEcho(true, (float)amt / 255.0f);
        } else {
            Sound.setEcho(false, amt);
        }
    }

    public static void PlayerSound(int num, int flags, PlayerStr pp) {
        if (WangNetwork.Prediction) {
            return;
        }
        if (pp.pnum < 0 || pp.pnum >= 8) {
            throw new AssertException("Player Sound invalid player");
        }
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
            return;
        }
        VOC_INFO vp = Digi.voc[num];
        if (vp == null) {
            Console.out.println("vp == null in PlayerSound, num = " + num, OsdColor.RED);
            return;
        }
        if (vp.priority != 50 && vp.priority != 51) {
            return;
        }
        if (!pp.PlayerTalking) {
            pp.PlayerTalking = true;
            pp.TalkVocnum = num;
            pp.TalkVocHandle = Sound.PlaySound(num, pp, flags);
            if (pp.TalkVocHandle == null) {
                pp.PlayerTalking = false;
                pp.TalkVocnum = -1;
            }
        }
    }

    public static void StartAmbientSound() {
        if (!Main.cfg.Ambient) {
            return;
        }
        ListNode<Sprite> node = Main.boardService.getStatNode(68);
        while (node != null) {
            ListNode<Sprite> nexti = node.getNext();
            Sprite sp = node.get();
            VOC3D voc = Sound.PlaySound(sp.getLotag(), sp, 85);
            Sound.Set3DSoundOwner(node.getIndex(), voc);
            node = nexti;
        }
    }

    public static void StopSound() {
        Sound.CDAudio_Stop();
        Sound.StopFX();
    }

    public static void StopFX() {
        Sound.stopAllSounds();
    }

    public static void sndHandlePause(boolean gPaused) {
        if (gPaused) {
            Sound.CDAudio_Pause();
            Sound.StopFX();
            Sound.StopAmbientSound();
        } else {
            Sound.CDAudio_Continue();
            Sound.StartAmbientSound();
        }
    }

    public static void Set3DSoundOwner(int spritenum, VOC3D p) {
        if (p == null) {
            return;
        }
        if (p.handle != null || MyTypes.TEST(p.flags, 16)) {
            p.owner = spritenum;
        } else {
            p.deleted = true;
            p.flags = 2;
        }
    }

    public static void PlaySpriteSound(int spritenum, Ai.Attrib_Snds attrib_ndx, int flags) {
        WangSprite sp = Main.boardService.getSprite(spritenum);
        USER u = Gameutils.getUser(spritenum);
        if (sp != null && u != null) {
            Sound.PlaySound(u.Attrib.getSound(attrib_ndx), sp, flags);
        }
    }

    public static VOC3D PlaySound(int num, Object obj, int flags) {
        VOC_INFO vp;
        if (WangNetwork.Prediction || Main.cfg.isNoSound() || num < 0 || num >= Digi.voc.length) {
            return null;
        }
        Source voice = null;
        WangSprite sp = null;
        if (Use_SoundSpriteNum && SoundSpriteNum >= 0) {
            sp = Main.boardService.getSprite(SoundSpriteNum);
        }
        if (Main.cfg.Ambient && MyTypes.TEST(flags, 16) && !MyTypes.TEST(flags, 128) && num > 82) {
            Text.PutStringInfo(Game.Player[Game.screenpeek], "Invalid or out of range ambient sound number " + num);
            return null;
        }
        VOC3D v3p = Sound.Insert3DSound();
        v3p.num = num;
        v3p.priority = 0;
        if (Main.cfg.Ambient && MyTypes.TEST(flags, 16) && !MyTypes.TEST(flags, 128)) {
            v3p.maxtics = Gameutils.STD_RANDOM_RANGE(Digi.ambarray[num].maxtics);
            flags |= Digi.ambarray[num].ambient_flags;
            num = Digi.ambarray[num].diginame;
        }
        if ((vp = Digi.voc[num]) == null || vp.lock <= 0) {
            v3p.flags = 2;
            v3p.handle = null;
            v3p.deleted = true;
            return null;
        }
        v3p.vp = vp;
        v3p.obj = obj;
        v3p.fx = v3p.getCoords().x;
        v3p.fy = v3p.getCoords().y;
        v3p.fz = v3p.getCoords().z;
        v3p.flags = flags;
        int tx = v3p.fx;
        int ty = v3p.fy;
        int tz = v3p.fz;
        if ((vp.voc_flags & 1) != 0 && Use_SoundSpriteNum && SoundSpriteNum >= 0 && sp != null) {
            tx = sp.getX();
            ty = sp.getY();
            tz = sp.getZ();
        }
        int sound_dist = 255;
        if (tx != 0 || ty != 0 || tz != 0) {
            sound_dist = Sound.SoundDist(tx, ty, tz, vp.voc_distance);
        }
        v3p.doplr_delta = sound_dist;
        if ((vp.voc_flags & 1) != 0 && Use_SoundSpriteNum && SoundSpriteNum >= 0) {
            PlayerStr pp = Game.Player[Game.screenpeek];
            if (sp != null && !Rooms.FAFcansee(tx, ty, tz, sp.getSectnum(), pp.posx, pp.posy, pp.posz, pp.cursectnum)) {
                if ((sound_dist += sound_dist / 2 + sound_dist / 4) > 255) {
                    sound_dist = 255;
                }
                if (num == 432) {
                    sound_dist = 255;
                }
            }
        }
        int priority = v3p.priority = vp.priority - sound_dist / 26;
        if (Main.game.pMenu.gShowMenu && obj == null) {
            priority = 100;
        }
        if (!Sound.CacheSound(num)) {
            v3p.flags = 2;
            v3p.handle = null;
            v3p.deleted = true;
            return null;
        }
        int pitch = vp.pitch_hi == vp.pitch_lo ? vp.pitch_lo : vp.pitch_lo + Gameutils.STD_RANDOM_RANGE(vp.pitch_hi - vp.pitch_lo);
        float volume = 0.0f;
        if ((vp.voc_flags & 1) != 0) {
            int loopvol = 255 - sound_dist;
            if (loopvol <= 0) {
                loopvol = 0;
            }
            if (sound_dist < 255 || (flags & 0x40) != 0) {
                volume = (float)loopvol / 255.0f;
                voice = Sound.newSound(vp.data.getData(), vp.data.getRate() + pitch, vp.data.getBits(), priority);
                if (voice != null) {
                    voice.setPosition(tx, tz >> 4, ty);
                }
            }
        } else if (tx == 0 && ty == 0 && tz == 0) {
            voice = Sound.newSound(vp.data.getData(), vp.data.getRate() + pitch, vp.data.getBits(), priority);
            volume = 1.0f;
        } else if (sound_dist < 255) {
            volume = (float)(255 - sound_dist) / 255.0f;
            voice = Sound.newSound(vp.data.getData(), vp.data.getRate() + pitch, vp.data.getBits(), priority);
            if (voice != null && (flags & 8) == 0) {
                voice.setPosition(tx, tz >> 4, ty);
            }
        }
        v3p.handle = voice;
        v3p.tics = 0;
        if ((flags & 0x40) != 0) {
            v3p.flags ^= 0x40;
        }
        if (voice != null) {
            if ((vp.voc_flags & 1) != 0) {
                voice.loop(volume);
            } else {
                voice.play(volume);
            }
            voice.setListener(v3p);
            --v3p.vp.lock;
        }
        return v3p;
    }

    private static float calcPitch(int pitch) {
        float fp = 1.0f;
        return fp += (float)pitch / 2000.0f;
    }

    public static void Terminate3DSounds() {
        VOC3D vp = voc3dstart;
        while (vp != null) {
            vp.stop();
            vp.deleted = true;
            vp = vp.next;
        }
        Sound.Delete3DSounds();
    }

    public static void DoUpdateSounds3D() {
        if (Main.game.pMenu.gShowMenu) {
            return;
        }
        int cx = Game.Player[Game.screenpeek].posx;
        int cy = Game.Player[Game.screenpeek].posy;
        int cz = Game.Player[Game.screenpeek].posz;
        int ca = Game.Player[Game.screenpeek].getAnglei();
        audio.setListener(cx, cz >> 4, cy, ca);
        for (int i = 0; i < 32; ++i) {
            Sound.TmpVocArray[i].p = null;
            Sound.TmpVocArray[i].dist = 0;
            Sound.TmpVocArray[i].priority = 0;
        }
        VOC3D p = voc3dstart;
        while (p != null) {
            block25: {
                boolean looping;
                block27: {
                    int z;
                    int y;
                    int x;
                    int dist;
                    block28: {
                        block26: {
                            block24: {
                                boolean bl = looping = p.vp != null && (p.vp.voc_flags & 1) != 0;
                                if (looping && p.owner == -1 && !MyTypes.TEST(p.flags, 16)) {
                                    p.flags |= 2;
                                }
                                if ((p.flags & 2) == 0) break block24;
                                p.stop();
                                p.deleted = true;
                                break block25;
                            }
                            if (p.isActive() || looping) break block26;
                            if ((p.flags & 0x20) != 0) {
                                Sound.DoTimedSound(p);
                            } else {
                                p.deleted = true;
                            }
                            break block25;
                        }
                        if (!p.isActive()) break block27;
                        if ((p.flags & 1) != 0) {
                            Vector3i pos = p.getCoords();
                            dist = Sound.SoundDist(pos.x, pos.y, pos.z, p.vp.voc_distance);
                            x = pos.x;
                            y = pos.y;
                            z = pos.z;
                        } else {
                            dist = p.fx == 0 && p.fy == 0 && p.fz == 0 ? 0 : Sound.SoundDist(p.fx, p.fy, p.fz, p.vp.voc_distance);
                            x = p.fx;
                            y = p.fy;
                            z = p.fz;
                        }
                        if ((p.vp.voc_flags & 1) != 0 && p.owner != -1) {
                            PlayerStr pp = Game.Player[Game.screenpeek];
                            WangSprite sp = Main.boardService.getSprite(p.owner);
                            if (sp != null && !Rooms.FAFcansee(sp.getX(), sp.getY(), sp.getZ(), sp.getSectnum(), pp.posx, pp.posy, pp.posz, pp.cursectnum)) {
                                if ((dist += dist / 2 + dist / 4) > 255) {
                                    dist = 255;
                                }
                                if (p.num == 76 && MyTypes.TEST(p.flags, 16)) {
                                    dist = 255;
                                }
                            }
                        }
                        if (dist < 255 || p.vp.voc_distance != 0) break block28;
                        p.stop();
                        break block25;
                    }
                    if (!p.handle.isGlobal()) {
                        p.handle.setVolume((float)(255 - dist) / 255.0f);
                    }
                    if ((p.flags & 4) == 0 && p.isActive()) {
                        int pitch = Sound.getPitch(dist, p);
                        p.doplr_delta = dist;
                        p.handle.setPitch(Sound.calcPitch(pitch));
                    }
                    if ((p.flags & 8) != 0 || p.handle.isGlobal()) break block25;
                    p.handle.setPosition(x, z >> 4, y);
                    break block25;
                }
                if (!p.isActive() && looping) {
                    int dist;
                    if ((p.flags & 1) != 0) {
                        Vector3i pos = p.getCoords();
                        dist = Sound.SoundDist(pos.x, pos.y, pos.z, p.vp.voc_distance);
                    } else {
                        dist = Sound.SoundDist(p.fx, p.fy, p.fz, p.vp.voc_distance);
                    }
                    if (dist <= 255) {
                        for (int i = 0; i < 32; ++i) {
                            if (p.priority < Sound.TmpVocArray[i].priority || Sound.TmpVocArray[i].p != null && dist >= Sound.TmpVocArray[i].dist) continue;
                            Sound.TmpVocArray[i].p = p;
                            Sound.TmpVocArray[i].dist = dist;
                            Sound.TmpVocArray[i].priority = p.priority;
                            break;
                        }
                    }
                }
            }
            p = p.next;
        }
        for (int i = 0; i < 32 && (p = Sound.TmpVocArray[i].p) != null; ++i) {
            if ((p.flags & 1) != 0) {
                if (p.owner == -1) {
                    throw new AssertException("Owner == -1 on looping sound with follow flag set!\r\n p.num = " + p.num);
                }
                Use_SoundSpriteNum = true;
                SoundSpriteNum = p.owner;
                Sound.PlaySound(p.num, p.obj, p.flags);
            } else {
                if (p.owner == -1) {
                    throw new AssertException("Owner == -1 on looping sound, no follow flag.\r\n p.num = " + p.num);
                }
                Use_SoundSpriteNum = true;
                SoundSpriteNum = p.owner;
                Sound.PlaySound(p.num, p, p.flags);
            }
            Sound.voc3dend.owner = p.owner;
            p.deleted = true;
            Use_SoundSpriteNum = false;
            SoundSpriteNum = -1;
        }
        Sound.Delete3DSounds();
    }

    private static int getPitch(int dist, VOC3D p) {
        int pitch = -(dist - p.doplr_delta);
        int pitchmax = p.vp.pitch_lo != 0 && p.vp.pitch_hi != 0 ? Math.max(Pragmas.klabs(p.vp.pitch_lo), Pragmas.klabs(p.vp.pitch_hi)) : 400;
        if (pitch > pitchmax) {
            pitch = pitchmax;
        }
        if (pitch < -pitchmax) {
            pitch = -pitchmax;
        }
        return pitch;
    }

    private static int RandomizeAmbientSpecials(int handle) {
        for (int j : ambrand) {
            if (handle != j) continue;
            return ambrand[Gameutils.STD_RANDOM_RANGE(ambrand.length - 1)];
        }
        return handle;
    }

    private static void DoTimedSound(VOC3D p) {
        if (Sprites.MoveSkip8 != 0) {
            return;
        }
        p.tics += 3;
        if (p.tics >= p.maxtics) {
            if (!p.isActive()) {
                p.num = Sound.RandomizeAmbientSpecials(p.num);
                if ((p.flags & 1) != 0) {
                    Sound.PlaySound(p.num, p.obj, p.flags);
                } else {
                    Sound.PlaySound(p.num, p, p.flags);
                }
                p.deleted = true;
            }
            p.tics = 0;
        }
    }

    public static void StopAmbientSound() {
        VOC3D p = voc3dstart;
        while (p != null) {
            if (MyTypes.TEST(p.flags, 16)) {
                p.flags |= 2;
            }
            if ((p.flags & 2) != 0) {
                p.stop();
                p.deleted = true;
            }
            p = p.next;
        }
        Sound.Delete3DSounds();
    }

    private static void InitNew3DSound(VOC3D v3p) {
        v3p.handle = null;
        v3p.owner = -1;
        v3p.deleted = false;
    }

    private static VOC3D Insert3DSound() {
        VOC3D vp = vocList.obtain();
        if (voc3dend == null) {
            vp.prev = null;
            vp.next = null;
            voc3dend = vp;
            voc3dstart = vp;
            Sound.InitNew3DSound(vp);
            return vp;
        }
        VOC3D old = voc3dend;
        old.next = vp;
        vp.next = null;
        vp.prev = old;
        voc3dend = vp;
        Sound.InitNew3DSound(vp);
        return vp;
    }

    public static void DeleteNoSoundOwner(int spritenum) {
        VOC3D vp = voc3dstart;
        while (vp != null) {
            VOC3D dp = null;
            if (vp.owner == spritenum && vp.owner >= 0 && (vp.vp.voc_flags & 1) != 0) {
                vp.stop();
                dp = vp;
                if (vp.prev != null) {
                    vp.prev.next = vp.next;
                } else {
                    voc3dstart = vp.next;
                    if (voc3dstart != null) {
                        Sound.voc3dstart.prev = null;
                    }
                }
                if (vp.next != null) {
                    vp.next.prev = vp.prev;
                } else {
                    voc3dend = vp.prev;
                }
            }
            vp = vp.next;
            if (dp == null) continue;
            vocList.free(dp);
        }
    }

    public static void DeleteNoFollowSoundOwner(Sprite sp) {
        VOC3D vp = voc3dstart;
        while (vp != null) {
            VOC3D dp = null;
            Vector3i pos = vp.getCoords();
            if ((vp.flags & 1) != 0 && sp == vp.obj && pos.x == sp.getX() && pos.y == sp.getY()) {
                vp.stop();
                dp = vp;
                if (vp.prev != null) {
                    vp.prev.next = vp.next;
                } else {
                    voc3dstart = vp.next;
                    if (voc3dstart != null) {
                        Sound.voc3dstart.prev = null;
                    }
                }
                if (vp.next != null) {
                    vp.next.prev = vp.prev;
                } else {
                    voc3dend = vp.prev;
                }
            }
            vp = vp.next;
            if (dp == null) continue;
            vocList.free(dp);
        }
    }

    private static void Delete3DSounds() {
        VOC3D vp = voc3dstart;
        while (vp != null) {
            VOC3D dp = null;
            if (vp.deleted) {
                vp.stop();
                if (vp.vp != null && (vp.vp.priority == 50 || vp.vp.priority == 51)) {
                    short pnum = Mmulti.connecthead;
                    while (pnum != -1) {
                        PlayerStr pp = Game.Player[pnum];
                        if (vp.num == pp.TalkVocnum) {
                            pp.PlayerTalking = false;
                            pp.TalkVocnum = -1;
                            pp.TalkVocHandle = null;
                        }
                        pnum = Mmulti.connectpoint2[pnum];
                    }
                }
                dp = vp;
                if (vp.prev != null) {
                    vp.prev.next = vp.next;
                } else {
                    voc3dstart = vp.next;
                    if (voc3dstart != null) {
                        Sound.voc3dstart.prev = null;
                    }
                }
                if (vp.next != null) {
                    vp.next.prev = vp.prev;
                } else {
                    voc3dend = vp.prev;
                }
            }
            vp = vp.next;
            if (dp == null) continue;
            vocList.free(dp);
        }
    }

    public static boolean PlaySoundRTS(int rts_num) {
        Source voice;
        SoundData data;
        if (Main.cfg.isNoSound() || Main.RTS_File == null || Main.RTS_File.getSize() <= 0 || rtsplaying != '\u0000') {
            return false;
        }
        Entry entry = Main.RTS_File.getEntry(rts_num);
        if (entry.exists() && (data = audio.getSoundDecoder("VOC").decode(entry)) != null && (voice = Sound.newSound(data.getData(), data.getRate(), data.getBits(), 255)) != null) {
            voice.play(1.0f);
            rtsplaying = (char)16;
            return true;
        }
        return false;
    }

    public static void InitCDtracks() {
        Entry entry;
        cdTrackEntryMap.clear();
        Directory gameDir = Main.game.getCache().getGameDirectory();
        for (Entry file : gameDir.stream().filter(e -> e.isExtension("cue")).collect(Collectors.toList())) {
            CueScript cueScript = new CueScript(file.getName(), file);
            int trackNum = 0;
            for (String track : cueScript.getTracks()) {
                entry = Main.game.getCache().getEntry(track, true);
                if (entry.exists()) {
                    cdTrackEntryMap.put(trackNum, entry);
                }
                ++trackNum;
            }
            if (cdTrackEntryMap.isEmpty()) continue;
            break;
        }
        if (cdTrackEntryMap.isEmpty()) {
            Entry dirEntry = Main.game.cache.getEntry(FileUtils.getPath("music", new String[0]), true);
            if (!dirEntry.exists()) {
                dirEntry = Main.game.cache.getEntry(FileUtils.getPath("classic", "music"), true);
            }
            int trackNum = 0;
            Group group = Main.game.getCache().newGroup(dirEntry);
            for (String cdTrack : cdtracks) {
                entry = group.getEntry(cdTrack);
                if (entry.exists()) {
                    cdTrackEntryMap.put(trackNum, entry);
                }
                ++trackNum;
            }
        }
        if (!cdTrackEntryMap.isEmpty()) {
            Console.out.println(cdTrackEntryMap.size() + " cd tracks found...", OsdColor.YELLOW);
        } else {
            Console.out.println("Cd tracks not found.", OsdColor.YELLOW);
        }
    }

    public static void StartMusic() {
        if (Main.game.isCurrentScreen(Main.gMenuScreen)) {
            Sound.CDAudio_Play(RedBookSong[0], true);
        } else if (Main.mUserFlag == Main.UserFlag.UserMap) {
            Sound.CDAudio_Play(RedBookSong[4 + Gameutils.STD_RANDOM_RANGE(10)], true);
        } else {
            Sound.CDAudio_Play(RedBookSong[Game.Level], true);
        }
    }

    public static void CDAudio_Pause() {
        if (currMusic != null) {
            currMusic.pause();
        }
    }

    public static void CDAudio_Continue() {
        if (!Main.cfg.isMuteMusic() && currMusic != null) {
            currMusic.play();
        }
    }

    public static boolean CDAudio_Play(int track, boolean looping) {
        Music mus;
        if (track < 0 || Main.cfg.isMuteMusic()) {
            return false;
        }
        if (Sound.CDAudio_Playing() && playTrack == track) {
            return true;
        }
        Sound.CDAudio_Stop();
        if (cdTrackEntryMap.get(track - 1) != null && (mus = Sound.newMusic(cdTrackEntryMap.get(track - 1))) != null) {
            currMusic = mus;
            playTrack = track;
            currMusic.setLooping(looping);
            currMusic.play();
            return true;
        }
        return false;
    }

    public static void CDAudio_Stop() {
        if (currMusic != null) {
            currMusic.stop();
        }
        playTrack = -1;
        currMusic = null;
    }

    public static boolean CDAudio_Playing() {
        return currMusic != null && currMusic.isPlaying();
    }

    @Nullable
    public static Source newSound(ByteBuffer buffer, int rate, int bits, int priority) {
        return (Source)audio.newSound(buffer, rate, bits, priority);
    }

    public static Music newMusic(Entry entry) {
        return audio.newMusic(entry);
    }

    public static void stopAllSounds() {
        audio.stopAllSounds();
        Sound.Terminate3DSounds();
    }

    public static void setEcho(boolean enable, float delay) {
        audio.setEcho(enable, delay);
    }

    static {
        playTrack = -1;
        currMusic = null;
        Use_SoundSpriteNum = false;
        SoundSpriteNum = -1;
        voc3dstart = null;
        voc3dend = null;
    }

    private static class TVOC_Info {
        public VOC3D p;
        public int dist;
        public int priority;

        private TVOC_Info() {
        }

        public boolean equals(Object o) {
            boolean equals;
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TVOC_Info tvocInfo = (TVOC_Info)o;
            boolean bl = equals = this.dist == tvocInfo.dist && this.priority == tvocInfo.priority;
            if (!equals) {
                return false;
            }
            if (this.p != null && tvocInfo.p != null) {
                return this.p.owner == tvocInfo.p.owner && this.p.num == tvocInfo.p.num;
            }
            return Objects.equals(this.p, tvocInfo.p);
        }

        public int hashCode() {
            if (this.p == null) {
                return Objects.hash(this.dist, this.priority);
            }
            return Objects.hash(this.p.owner, this.p.num, this.dist, this.priority);
        }
    }

    public static enum SoundType {
        SOUND_OBJECT_TYPE,
        SOUND_EVERYTHING_TYPE;

    }
}

