/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import java.util.Arrays;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Point;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.exceptions.WarningException;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Ninja;
import ru.m210projects.Wang.Enemies.Ripper;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Morth;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Type.Anim;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.LONGp;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.Sect_User;
import ru.m210projects.Wang.Type.Sector_Object;
import ru.m210projects.Wang.Type.StateGroup;
import ru.m210projects.Wang.Type.TRACK;
import ru.m210projects.Wang.Type.TRACK_POINT;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Type.Vector2i;
import ru.m210projects.Wang.Type.Vector3i;
import ru.m210projects.Wang.Weapon;

public class Track {
    public static final int ACTOR_STD_JUMP = -384;
    public static final int MAX_TRACKS = 100;
    public static final int TOWARD_PLAYER = 1;
    public static final int AWAY_FROM_PLAYER = -1;
    private static final short[] StatList = new short[]{0, 1, 10, 57, 67, 65, 78, 39, 46, 68, 81, 56};
    public static int GlobSpeedSO;
    public static final TRACK[] Track;
    public static final int[] end_point;
    private static final int[] z;

    public static boolean TrackTowardPlayer(int sp, TRACK t, int start_point) {
        int start_dist;
        WangSprite s = Main.boardService.getSprite(sp);
        TRACK_POINT end_point = t.TrackPoint[0];
        if (start_point == 0) {
            end_point = t.TrackPoint[t.NumPoints - 1];
        }
        if (s == null || end_point == null) {
            return false;
        }
        int end_dist = Game.Distance(end_point.x, end_point.y, s.getX(), s.getY());
        return end_dist < (start_dist = Game.Distance(t.TrackPoint[start_point].x, t.TrackPoint[start_point].y, s.getX(), s.getY()));
    }

    public static boolean TrackStartCloserThanEnd(int SpriteNum, TRACK t, int start_point) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return false;
        }
        TRACK_POINT end_point = t.TrackPoint[0];
        if (start_point == 0) {
            end_point = t.TrackPoint[t.NumPoints - 1];
        }
        int end_dist = Game.Distance(end_point.x, end_point.y, sp.getX(), sp.getY());
        int start_dist = Game.Distance(t.TrackPoint[start_point].x, t.TrackPoint[start_point].y, sp.getX(), sp.getY());
        return start_dist < end_dist;
    }

    public static int ActorFindTrack(int SpriteNum, int player_dir, int track_type, LONGp track_point_num, LONGp track_dir) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return 0;
        }
        int near_dist = 999999;
        int near_track = -1;
        TRACK_POINT near_tp = null;
        for (int ti = 0; ti < 100; ++ti) {
            TRACK t = Track[ti];
            if (!MyTypes.TEST(t.ttflags, track_type) || MyTypes.TEST(t.flags, Gameutils.TF_TRACK_OCCUPIED)) continue;
            switch (track_type) {
                case 256: {
                    if (u.ActorActionSet.Duck == null) {
                        return -1;
                    }
                    ru.m210projects.Wang.Track.end_point[1] = 0;
                    break;
                }
                case 32: {
                    if (u.ActorActionSet.Climb == null) {
                        return -1;
                    }
                    ru.m210projects.Wang.Track.end_point[1] = 0;
                    break;
                }
                case 4: 
                case 8: {
                    if (u.ActorActionSet.Jump == null) {
                        return -1;
                    }
                    ru.m210projects.Wang.Track.end_point[1] = 0;
                    break;
                }
                case 128: {
                    if (u.ActorActionSet.Crawl != null && u.ActorActionSet.Jump != null) break;
                    return -1;
                }
                default: {
                    ru.m210projects.Wang.Track.end_point[1] = t.NumPoints - 1;
                }
            }
            int zdiff = Gameutils.Z(16);
            for (int i = 0; i < 2; ++i) {
                int tp = end_point[i];
                int dist = Game.Distance(t.TrackPoint[tp].x, t.TrackPoint[tp].y, sp.getX(), sp.getY());
                if (dist >= 15000 || dist >= near_dist || Pragmas.klabs(sp.getZ() - t.TrackPoint[tp].z) > zdiff || (player_dir != 1 ? player_dir == -1 && ru.m210projects.Wang.Track.TrackTowardPlayer(u.tgt_sp, t, tp) : !ru.m210projects.Wang.Track.TrackTowardPlayer(u.tgt_sp, t, tp))) continue;
                if (!ru.m210projects.Wang.Track.TrackStartCloserThanEnd(SpriteNum, t, tp)) continue;
                near_dist = dist;
                near_track = ti;
                near_tp = t.TrackPoint[tp];
                track_point_num.value = end_point[i];
                track_dir.value = i != 0 ? -1 : 1;
            }
        }
        if (near_dist < 15000 && near_tp != null) {
            int track_sect = Rooms.COVERupdatesector(near_tp.x, near_tp.y, 0);
            ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(track_sect);
            if (sec == null) {
                return -1;
            }
            if (Rooms.FAFcansee(sp.getX(), sp.getY(), sp.getZ() - Gameutils.Z(16), sp.getSectnum(), near_tp.x, near_tp.y, sec.getFloorz() - Gameutils.Z(32), track_sect)) {
                return near_track;
            }
        }
        return -1;
    }

    public static void NextTrackPoint(Sector_Object sop) {
        sop.point += sop.dir;
        if (sop.point > ru.m210projects.Wang.Track.Track[sop.track].NumPoints - 1) {
            sop.point = 0;
        }
        if (sop.point < 0) {
            sop.point = ru.m210projects.Wang.Track.Track[sop.track].NumPoints - 1;
        }
    }

    public static void NextActorTrackPoint(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u != null) {
            u.point += u.track_dir;
            if (u.point > ru.m210projects.Wang.Track.Track[u.track].NumPoints - 1) {
                u.point = 0;
            }
            if (u.point < 0) {
                u.point = ru.m210projects.Wang.Track.Track[u.track].NumPoints - 1;
            }
        }
    }

    public static void TrackAddPoint(TRACK t, TRACK_POINT[] tp, int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return;
        }
        if (tp[t.NumPoints] == null) {
            tp[t.NumPoints] = new TRACK_POINT();
        }
        TRACK_POINT tpoint = tp[t.NumPoints];
        tpoint.x = sp.getX();
        tpoint.y = sp.getY();
        tpoint.z = sp.getZ();
        tpoint.ang = sp.getAng();
        tpoint.tag_low = sp.getLotag();
        tpoint.tag_high = sp.getHitag();
        t.NumPoints = (short)(t.NumPoints + 1);
        Sprites.KillSprite(SpriteNum);
    }

    public static int TrackClonePoint(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return -1;
        }
        int newsp = Rooms.COVERinsertsprite(sp.getSectnum(), sp.getStatnum());
        WangSprite np = Main.boardService.getSprite(newsp);
        if (np == null) {
            return -1;
        }
        np.setCstat(0);
        np.setExtra(0);
        np.setX(sp.getX());
        np.setY(sp.getY());
        np.setZ(sp.getZ());
        np.setAng(sp.getAng());
        np.setLotag(sp.getLotag());
        np.setHitag(sp.getHitag());
        return newsp;
    }

    public static void QuickJumpSetup(int stat, int lotag, int type) {
        ListNode<Sprite> node = Main.boardService.getStatNode(stat);
        while (node != null) {
            int ndx;
            int SpriteNum = node.getIndex();
            ListNode<Sprite> NextSprite = node.getNext();
            for (ndx = 0; ndx < 100 && ru.m210projects.Wang.Track.Track[ndx].NumPoints != 0; ++ndx) {
            }
            ru.m210projects.Wang.Track.Track[ndx].TrackPoint = new TRACK_POINT[4];
            TRACK_POINT[] tp = ru.m210projects.Wang.Track.Track[ndx].TrackPoint;
            TRACK t = Track[ndx];
            t.ttflags |= MyTypes.BIT(type);
            t.flags = 0;
            int end_sprite = ru.m210projects.Wang.Track.TrackClonePoint(SpriteNum);
            int start_sprite = ru.m210projects.Wang.Track.TrackClonePoint(SpriteNum);
            Sprite nsp = Main.boardService.getSprite(start_sprite);
            if (nsp != null) {
                nsp.setLotag(700);
                nsp.setHitag(0);
                ru.m210projects.Wang.Track.TrackAddPoint(t, tp, start_sprite);
            }
            nsp = node.get();
            nsp.setX(nsp.getX() + (64 * EngineUtils.cos(nsp.getAng()) >> 14));
            nsp.setY(nsp.getY() + (64 * EngineUtils.sin(nsp.getAng()) >> 14));
            nsp.setLotag(lotag);
            ru.m210projects.Wang.Track.TrackAddPoint(t, tp, SpriteNum);
            nsp = Main.boardService.getSprite(end_sprite);
            if (nsp != null) {
                nsp.setX(nsp.getX() + (2048 * EngineUtils.cos(nsp.getAng()) >> 14));
                nsp.setY(nsp.getY() + (2048 * EngineUtils.sin(nsp.getAng()) >> 14));
                nsp.setLotag(701);
                nsp.setHitag(0);
                ru.m210projects.Wang.Track.TrackAddPoint(t, tp, end_sprite);
            }
            node = NextSprite;
        }
    }

    public static void QuickScanSetup(int stat, int lotag, int type) {
        ListNode<Sprite> node = Main.boardService.getStatNode(stat);
        while (node != null) {
            int ndx;
            int SpriteNum = node.getIndex();
            ListNode<Sprite> NextSprite = node.getNext();
            for (ndx = 0; ndx < 100 && ru.m210projects.Wang.Track.Track[ndx].NumPoints != 0; ++ndx) {
            }
            ru.m210projects.Wang.Track.Track[ndx].TrackPoint = new TRACK_POINT[4];
            TRACK_POINT[] tp = ru.m210projects.Wang.Track.Track[ndx].TrackPoint;
            TRACK t = Track[ndx];
            t.ttflags |= MyTypes.BIT(type);
            t.flags = 0;
            int end_sprite = ru.m210projects.Wang.Track.TrackClonePoint(SpriteNum);
            int start_sprite = ru.m210projects.Wang.Track.TrackClonePoint(SpriteNum);
            Sprite nsp = Main.boardService.getSprite(start_sprite);
            if (nsp != null) {
                nsp.setLotag(700);
                nsp.setHitag(0);
                nsp.setX(nsp.getX() + (64 * EngineUtils.sin(Gameutils.NORM_ANGLE(nsp.getAng() + 1024 + 512)) >> 14));
                nsp.setY(nsp.getY() + (64 * EngineUtils.sin(Gameutils.NORM_ANGLE(nsp.getAng() + 1024)) >> 14));
                ru.m210projects.Wang.Track.TrackAddPoint(t, tp, start_sprite);
            }
            nsp = node.get();
            nsp.setLotag(lotag);
            ru.m210projects.Wang.Track.TrackAddPoint(t, tp, SpriteNum);
            nsp = Main.boardService.getSprite(end_sprite);
            if (nsp != null) {
                nsp.setX(nsp.getX() + (64 * EngineUtils.sin(Gameutils.NORM_ANGLE(nsp.getAng() + 512)) >> 14));
                nsp.setY(nsp.getY() + (64 * EngineUtils.sin(nsp.getAng()) >> 14));
                nsp.setLotag(701);
                nsp.setHitag(0);
                ru.m210projects.Wang.Track.TrackAddPoint(t, tp, end_sprite);
            }
            node = NextSprite;
        }
    }

    public static void QuickExitSetup(int stat, int type) {
        ListNode<Sprite> node = Main.boardService.getStatNode(stat);
        while (node != null) {
            int ndx;
            int SpriteNum = node.getIndex();
            ListNode<Sprite> NextSprite = node.getNext();
            for (ndx = 0; ndx < 100 && ru.m210projects.Wang.Track.Track[ndx].NumPoints != 0; ++ndx) {
            }
            ru.m210projects.Wang.Track.Track[ndx].TrackPoint = new TRACK_POINT[4];
            TRACK_POINT[] tp = ru.m210projects.Wang.Track.Track[ndx].TrackPoint;
            TRACK t = Track[ndx];
            t.ttflags |= MyTypes.BIT(type);
            t.flags = 0;
            int end_sprite = ru.m210projects.Wang.Track.TrackClonePoint(SpriteNum);
            int start_sprite = ru.m210projects.Wang.Track.TrackClonePoint(SpriteNum);
            WangSprite nsp = Main.boardService.getSprite(start_sprite);
            if (nsp != null) {
                nsp.setLotag(700);
                nsp.setHitag(0);
                ru.m210projects.Wang.Track.TrackAddPoint(t, tp, start_sprite);
            }
            Sprites.KillSprite(SpriteNum);
            nsp = Main.boardService.getSprite(end_sprite);
            if (nsp != null) {
                nsp.setX(nsp.getX() + (1024 * EngineUtils.cos(nsp.getAng()) >> 14));
                nsp.setY(nsp.getY() + (1024 * EngineUtils.sin(nsp.getAng()) >> 14));
                nsp.setLotag(701);
                nsp.setHitag(0);
                ru.m210projects.Wang.Track.TrackAddPoint(t, tp, end_sprite);
            }
            node = NextSprite;
        }
    }

    public static void QuickLadderSetup(int stat, int lotag, int type) {
        ListNode<Sprite> node = Main.boardService.getStatNode(stat);
        while (node != null) {
            int ndx;
            int SpriteNum = node.getIndex();
            ListNode<Sprite> NextSprite = node.getNext();
            for (ndx = 0; ndx < 100 && ru.m210projects.Wang.Track.Track[ndx].NumPoints != 0; ++ndx) {
            }
            if (ndx != 100) {
                ru.m210projects.Wang.Track.Track[ndx].TrackPoint = new TRACK_POINT[4];
                TRACK_POINT[] tp = ru.m210projects.Wang.Track.Track[ndx].TrackPoint;
                TRACK t = Track[ndx];
                t.ttflags |= MyTypes.BIT(type);
                t.flags = 0;
                int end_sprite = ru.m210projects.Wang.Track.TrackClonePoint(SpriteNum);
                int start_sprite = ru.m210projects.Wang.Track.TrackClonePoint(SpriteNum);
                Sprite nsp = Main.boardService.getSprite(start_sprite);
                if (nsp != null) {
                    nsp.setLotag(700);
                    nsp.setHitag(0);
                    nsp.setX(nsp.getX() + Gameutils.MOVEx(256, nsp.getAng() + 1024));
                    nsp.setY(nsp.getY() + Gameutils.MOVEy(256, nsp.getAng() + 1024));
                    ru.m210projects.Wang.Track.TrackAddPoint(t, tp, start_sprite);
                }
                nsp = node.get();
                nsp.setLotag(lotag);
                ru.m210projects.Wang.Track.TrackAddPoint(t, tp, SpriteNum);
                nsp = Main.boardService.getSprite(end_sprite);
                if (nsp != null) {
                    nsp.setX(nsp.getX() + Gameutils.MOVEx(512, nsp.getAng()));
                    nsp.setY(nsp.getY() + Gameutils.MOVEy(512, nsp.getAng()));
                    nsp.setLotag(701);
                    nsp.setHitag(0);
                    ru.m210projects.Wang.Track.TrackAddPoint(t, tp, end_sprite);
                }
            }
            node = NextSprite;
        }
    }

    public static void TrackSetup() {
        for (int ndx = 0; ndx < 100; ++ndx) {
            ListNode<Sprite> NextSprite;
            if (Main.boardService.getStatNode(200 + ndx) == null) {
                if (Track[ndx] == null) {
                    ru.m210projects.Wang.Track.Track[ndx] = new TRACK();
                } else {
                    Track[ndx].reset();
                }
                ru.m210projects.Wang.Track.Track[ndx].TrackPoint = new TRACK_POINT[1];
                continue;
            }
            if (Track[ndx] == null) {
                ru.m210projects.Wang.Track.Track[ndx] = new TRACK();
            } else {
                Track[ndx].reset();
            }
            ru.m210projects.Wang.Track.Track[ndx].TrackPoint = new TRACK_POINT[500];
            TRACK_POINT[] tp = ru.m210projects.Wang.Track.Track[ndx].TrackPoint;
            TRACK t = Track[ndx];
            ListNode<Sprite> node = Main.boardService.getStatNode(200 + ndx);
            while (node != null) {
                int SpriteNum = node.getIndex();
                NextSprite = node.getNext();
                if (Gameutils.LOW_TAG_SPRITE(SpriteNum) == 700) {
                    ru.m210projects.Wang.Track.TrackAddPoint(t, tp, SpriteNum);
                    break;
                }
                node = NextSprite;
            }
            if (t.NumPoints <= 0) continue;
            if (tp[0].tag_low == 700 && tp[0].tag_high != 0) {
                t.ttflags |= MyTypes.BIT(tp[0].tag_high);
            }
            while (Main.boardService.getStatNode(200 + ndx) != null) {
                int next_sprite = -1;
                int low_dist = 999999;
                ListNode<Sprite> node2 = Main.boardService.getStatNode(200 + ndx);
                while (node2 != null) {
                    int SpriteNum = node2.getIndex();
                    NextSprite = node2.getNext();
                    Sprite sp = node2.get();
                    int dist = Game.Distance(tp[t.NumPoints - 1].x, tp[t.NumPoints - 1].y, sp.getX(), sp.getY());
                    if (dist < low_dist) {
                        next_sprite = SpriteNum;
                        low_dist = dist;
                    }
                    node2 = NextSprite;
                }
                if (next_sprite == -1) continue;
                ru.m210projects.Wang.Track.TrackAddPoint(t, tp, next_sprite);
            }
            int size = ru.m210projects.Wang.Track.Track[ndx].NumPoints + 1;
            TRACK_POINT[] newp = new TRACK_POINT[size];
            if (ru.m210projects.Wang.Track.Track[ndx].NumPoints >= 0) {
                System.arraycopy(ru.m210projects.Wang.Track.Track[ndx].TrackPoint, 0, newp, 0, ru.m210projects.Wang.Track.Track[ndx].NumPoints);
            }
            ru.m210projects.Wang.Track.Track[ndx].TrackPoint = newp;
        }
        ru.m210projects.Wang.Track.QuickJumpSetup(501, 801, 2);
        ru.m210projects.Wang.Track.QuickJumpSetup(502, 802, 3);
        ru.m210projects.Wang.Track.QuickJumpSetup(503, 803, 13);
        ru.m210projects.Wang.Track.QuickScanSetup(504, 804, 12);
        ru.m210projects.Wang.Track.QuickLadderSetup(506, 792, 5);
        ru.m210projects.Wang.Track.QuickExitSetup(505, 10);
        ru.m210projects.Wang.Track.QuickJumpSetup(507, 807, 14);
        ru.m210projects.Wang.Track.QuickJumpSetup(508, 808, 8);
        ru.m210projects.Wang.Track.QuickJumpSetup(509, 809, 9);
    }

    public static int FindBoundSprite(int tag) {
        ListNode<Sprite> node = Main.boardService.getStatNode(500);
        while (node != null) {
            int sn = node.getIndex();
            ListNode<Sprite> next_sn = node.getNext();
            if (node.get().getHitag() == tag) {
                return sn;
            }
            node = next_sn;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean SectorObjectSetupBounds(int sopi) {
        sop = Sprites.SectorObject[sopi];
        u = Gameutils.getUser(sop.sp_child);
        BoundSpritei = ru.m210projects.Wang.Track.FindBoundSprite(500 + sopi * 5);
        BoundSprite = Main.boardService.getSprite(BoundSpritei);
        if (BoundSprite == null) {
            return false;
        }
        xlow = BoundSprite.getX();
        ylow = BoundSprite.getY();
        Sprites.KillSprite(BoundSpritei);
        BoundSpritei = ru.m210projects.Wang.Track.FindBoundSprite(501 + sopi * 5);
        BoundSprite = Main.boardService.getSprite(BoundSpritei);
        if (BoundSprite == null) {
            return false;
        }
        xhigh = BoundSprite.getX();
        yhigh = BoundSprite.getY();
        Sprites.KillSprite(BoundSpritei);
        if (u != null) {
            u.Radius = MyTypes.DIV4(xhigh - xlow + (yhigh - ylow));
            u.Radius -= MyTypes.DIV4(u.Radius);
        }
        if ((BoundSprite = Main.boardService.getSprite(BoundSpritei = ru.m210projects.Wang.Track.FindBoundSprite(27))) != null) {
            sop.xmid = BoundSprite.getX();
            sop.ymid = BoundSprite.getY();
            sop.zmid = BoundSprite.getZ();
            Sprites.KillSprite(BoundSpritei);
        }
        for (k = 0; k < Main.boardService.getSectorCount(); ++k) {
            sec = Main.boardService.getSector(k);
            if (sec == null) continue;
            SectorInBounds = true;
            for (wn = sec.getWallNode(); wn != null; wn = wn.getNext()) {
                wall = wn.get();
                if (wall.getX() > xlow && wall.getX() < xhigh && wall.getY() > ylow && wall.getY() < yhigh) continue;
                SectorInBounds = false;
                break;
            }
            if (!SectorInBounds) continue;
            sop.sector[sop.num_sectors] = k;
            sec.setExtra(sec.getExtra() | Gameutils.SECTFX_SECTOR_OBJECT);
            sop.zorig_floor[sop.num_sectors] = sec.getFloorz();
            sop.zorig_ceiling[sop.num_sectors] = sec.getCeilingz();
            if (MyTypes.TEST(sec.getExtra(), Gameutils.SECTFX_SINK) && (su = Sector.getSectUser(k)) != null) {
                v0 = sop.num_sectors;
                sop.zorig_floor[v0] = sop.zorig_floor[v0] + Gameutils.Z(su.depth);
            }
            if (sec.getFloorz() > sop.floor_loz) {
                sop.floor_loz = sec.getFloorz();
            }
            if (sec.getFloorz() < sop.floor_hiz) {
                sop.floor_hiz = sec.getFloorz();
            }
            ++sop.num_sectors;
        }
        FoundOutsideLoop = false;
        j = 0;
        while (sop.sector[j] != -1) {
            sectp = Main.boardService.getSector(sop.sector[j]);
            if (sectp != null) {
                for (wn = sectp.getWallNode(); wn != null; wn = wn.getNext()) {
                    wall = wn.get();
                    if (wall.getLotag() == 550) {
                        sop.morph_wall_point = wn.getIndex();
                    }
                    if (wall.getExtra() != 0 && MyTypes.TEST(wall.getExtra(), Gameutils.WALLFX_LOOP_OUTER)) {
                        FoundOutsideLoop = true;
                    }
                    wall.setExtra(wall.getExtra() | (Gameutils.WALLFX_SECTOR_OBJECT | Gameutils.WALLFX_DONT_STICK));
                    nwall = Main.boardService.getWall(wall.getNextwall());
                    if (nwall == null) continue;
                    nwall.setExtra(nwall.getExtra() | (Gameutils.WALLFX_SECTOR_OBJECT | Gameutils.WALLFX_DONT_STICK));
                }
            }
            ++j;
        }
        if (!FoundOutsideLoop) {
            throw new WarningException("Forgot to tag outer loop for Sector Object #" + sopi);
        }
        for (short value : ru.m210projects.Wang.Track.StatList) {
            node = Main.boardService.getStatNode(value);
            while (node != null) {
                block33: {
                    sp_num = node.getIndex();
                    next_sp_num = node.getNext();
                    sp = node.get();
                    if (sp.getX() <= xlow || sp.getX() >= xhigh || sp.getY() <= ylow || sp.getY() >= yhigh || sp.getStatnum() == 81 && !Gameutils.TEST_BOOL2(sp) || (u = Gameutils.getUser(sp_num) == null ? Sprites.SpawnUser(sp_num, 0, null) : Gameutils.getUser(sp_num)) == null) break block33;
                    u.RotNum = 0;
                    u.ox = sp.getX();
                    u.oy = sp.getY();
                    u.oz = sp.getZ();
                    block0 : switch (sp.getStatnum()) {
                        case 78: {
                            ** GOTO lbl100
                        }
                        case 0: {
                            switch (sp.getHitag()) {
                                case 78: {
                                    sop.clipdist = 0;
                                    sop.clipbox_dist[sop.clipbox_num] = sp.getLotag();
                                    sop.clipbox_xoff[sop.clipbox_num] = sop.xmid - sp.getX();
                                    sop.clipbox_yoff[sop.clipbox_num] = sop.ymid - sp.getY();
                                    sop.clipbox_vdist[sop.clipbox_num] = EngineUtils.sqrt(Gameutils.SQ(sop.xmid - sp.getX()) + Gameutils.SQ(sop.ymid - sp.getY()));
                                    ang2 = EngineUtils.getAngle(sp.getX() - sop.xmid, sp.getY() - sop.ymid);
                                    sop.clipbox_ang[sop.clipbox_num] = Player.GetDeltaAngle(sop.ang, ang2);
                                    ++sop.clipbox_num;
                                    Sprites.KillSprite(sp_num);
                                    break block0;
                                }
                                case 62: {
                                    sp.setOwner(-1);
                                    Sprites.change_sprite_stat(sp_num, 55);
                                    sp.setCstat(sp.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
                                    break;
                                }
                            }
                        }
lbl100:
                        // 4 sources

                        default: {
                            u.sx = sop.xmid - sp.getX();
                            u.sy = sop.ymid - sp.getY();
                            sec = Main.boardService.getSector(sop.mid_sector);
                            if (sec != null) {
                                u.sz = sec.getFloorz() - sp.getZ();
                            }
                            u.Flags |= Gameutils.SPR_SO_ATTACHED;
                            u.sang = sp.getAng();
                            u.spal = (byte)sp.getPal();
                            for (sn = 0; sn < sop.sp_num.length && sop.sp_num[sn] != -1; ++sn) {
                            }
                            sop.sp_num[sn] = sp_num;
                            if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_SPRITE_OBJ)) break;
                            for (j = 0; j < sop.num_sectors; ++j) {
                                if (sop.sector[j] != sp.getSectnum()) continue;
                                u.Flags |= Gameutils.SPR_ON_SO_SECTOR;
                                spsec = Main.boardService.getSector(sp.getSectnum());
                                if (spsec == null) break block0;
                                u.sz = spsec.getFloorz() - sp.getZ();
                                break block0;
                            }
                        }
                    }
                }
                node = next_sp_num;
            }
        }
        if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_SPRITE_OBJ)) {
            zmid = -9999999;
            i = 0;
            while (sop.sp_num[i] != -1) {
                sp = Main.boardService.getSprite(sop.sp_num[i]);
                if (sp != null && sp.getZ() > zmid) {
                    zmid = sp.getZ();
                }
                ++i;
            }
            sop.zmid = zmid;
            i = 0;
            while (sop.sp_num[i] != -1) {
                sp = Main.boardService.getSprite(sop.sp_num[i]);
                uo = Gameutils.getUser(sop.sp_num[i]);
                if (sp != null && uo != null) {
                    uo.sz = sop.zmid - sp.getZ();
                }
                ++i;
            }
        }
        return true;
    }

    public static boolean SetupSectorObject(int sectnum, int tag) {
        int object_num = (tag -= 500) / 5;
        Sector_Object sop = Sprites.SectorObject[object_num];
        if (sop.num_sectors == -1) {
            Arrays.fill(sop.sector, -1);
            sop.crush_z = 0;
            sop.drive_angspeed = 0;
            sop.drive_angslide = 0;
            sop.drive_slide = 0;
            sop.drive_speed = 0;
            sop.num_sectors = 0;
            sop.update = 15000;
            sop.flags = 0;
            sop.clipbox_num = 0;
            sop.bob_amt = 0;
            sop.vel_rate = 6;
            sop.z_rate = 256;
            sop.z_tgt = 0;
            sop.zdelta = 0;
            sop.wait_tics = 0;
            sop.spin_speed = 0;
            sop.spin_ang = 0;
            sop.ang_orig = 0;
            sop.clipdist = 1024;
            sop.target_dist = 0;
            sop.turn_speed = 4;
            sop.floor_loz = -9999999;
            sop.floor_hiz = 9999999;
            sop.player_yoff = 0;
            sop.player_xoff = 0;
            sop.ang_moving = 0;
            sop.ang = 0;
            sop.ang_tgt = 0;
            sop.op_main_sector = -1;
            sop.ram_damage = 0;
            sop.max_damage = (short)-9999;
            sop.scale_type = 0;
            sop.scale_dist = 0;
            sop.scale_speed = 20;
            sop.scale_dist_min = -1024;
            sop.scale_dist_max = 1024;
            sop.scale_rand_freq = 8;
            sop.scale_x_mult = 256;
            sop.scale_y_mult = 256;
            sop.morph_ang = Gameutils.RANDOM_P2(2048);
            sop.morph_z_speed = 20;
            sop.morph_speed = 32;
            sop.morph_dist_max = 1024;
            sop.morph_rand_freq = 64;
            sop.morph_dist = 0;
            sop.morph_xoff = 0;
            sop.morph_yoff = 0;
            sop.PreMoveAnimator = null;
            sop.PostMoveAnimator = null;
            sop.Animator = null;
        }
        if (tag % 5 == 1) {
            ru.m210projects.Build.Types.Sector sec;
            int new1;
            sop.mid_sector = sectnum;
            Vector3i p = Sector.SectorMidPoint(sectnum);
            sop.xmid = p.x;
            sop.ymid = p.y;
            sop.zmid = p.z;
            sop.dir = 1;
            sop.track = Gameutils.HIGH_TAG(sectnum);
            sop.sp_child = new1 = Sprites.SpawnSprite(61, 0, null, sectnum, sop.xmid, sop.ymid, sop.zmid, 0, 0);
            USER u = Gameutils.getUser(new1);
            if (u == null) {
                return false;
            }
            u.sop_parent = object_num;
            u.Flags2 |= Gameutils.SPR2_SPRITE_FAKE_BLOCK;
            ListNode<Sprite> node = Main.boardService.getSectNode(sectnum);
            while (node != null) {
                int SpriteNum = node.getIndex();
                ListNode<Sprite> NextSprite = node.getNext();
                Sprite sp = node.get();
                if (sp.getStatnum() == 500) {
                    switch (sp.getHitag()) {
                        case 102: {
                            if (Gameutils.SP_TAG5(sp) != 0) {
                                sop.scale_x_mult = Gameutils.SP_TAG5(sp);
                            }
                            if (Gameutils.SP_TAG6(sp) != 0) {
                                sop.scale_y_mult = Gameutils.SP_TAG6(sp);
                            }
                            Sprites.KillSprite(SpriteNum);
                            break;
                        }
                        case 101: {
                            Arrays.fill(sop.scale_point_dist, 0);
                            sop.scale_point_base_speed = Gameutils.SP_TAG2(sp);
                            for (int j = 0; j < sop.scale_point_speed.length; ++j) {
                                sop.scale_point_speed[j] = Gameutils.SP_TAG2(sp);
                            }
                            sop.scale_point_rand_freq = Gameutils.SP_TAG4(sp) != 0 ? Gameutils.SP_TAG4(sp) : 64;
                            sop.scale_point_dist_min = -Gameutils.SP_TAG5(sp);
                            sop.scale_point_dist_max = Gameutils.SP_TAG6(sp);
                            Sprites.KillSprite(SpriteNum);
                            break;
                        }
                        case 100: {
                            sop.flags |= Gameutils.SOBJ_DYNAMIC;
                            sop.scale_speed = Gameutils.SP_TAG2(sp);
                            sop.scale_dist_min = -Gameutils.SP_TAG5(sp);
                            sop.scale_dist_max = Gameutils.SP_TAG6(sp);
                            sop.scale_type = Gameutils.SP_TAG4(sp);
                            sop.scale_active_type = Gameutils.SP_TAG7(sp);
                            sop.scale_rand_freq = Gameutils.SP_TAG8(sp) != 0 ? Gameutils.SP_TAG8(sp) : 8;
                            if (Gameutils.SP_TAG3(sp) == 0) {
                                sop.scale_dist = sop.scale_dist_min;
                            } else if (Gameutils.SP_TAG3(sp) == 1) {
                                sop.scale_dist = sop.scale_dist_max;
                            }
                            Sprites.KillSprite(SpriteNum);
                            break;
                        }
                        case 69: {
                            if (sp.getClipdist() != 3) break;
                            Sprites.change_sprite_stat(SpriteNum, 41);
                            u = Sprites.SpawnUser(SpriteNum, 0, null);
                            u.ActorActionFunc = null;
                            break;
                        }
                        case 81: {
                            sop.Animator = Sector_Object.SOAnimator.DoAutoTurretObject;
                            Sprites.KillSprite(SpriteNum);
                            break;
                        }
                        case 73: {
                            sop.vel = 120;
                            sop.flags |= Gameutils.SOBJ_DYNAMIC;
                            sop.scale_type = 4;
                            sop.spin_speed = 16;
                            sop.last_ang = sop.ang;
                            sop.Animator = Sector_Object.SOAnimator.DoTornadoObject;
                            sop.PreMoveAnimator = Sector_Object.SOAnimator.ScaleSectorObject;
                            sop.PostMoveAnimator = Sector_Object.SOAnimator.MorphTornado;
                            sop.clipdist = 2500;
                            sop.morph_speed = 16;
                            sop.morph_z_speed = 6;
                            sop.morph_dist_max = 1024;
                            sop.morph_rand_freq = 8;
                            sop.scale_dist_min = -768;
                            Sprites.KillSprite(SpriteNum);
                            break;
                        }
                        case 74: {
                            sop.flags |= Gameutils.SOBJ_DYNAMIC;
                            sop.scale_type = 0;
                            sop.morph_speed = 120;
                            sop.morph_z_speed = 7;
                            sop.PostMoveAnimator = Sector_Object.SOAnimator.MorphFloor;
                            sop.morph_dist_max = 4000;
                            sop.morph_rand_freq = 8;
                            Sprites.KillSprite(SpriteNum);
                            break;
                        }
                        case 75: {
                            sop.flags |= Gameutils.SOBJ_DYNAMIC;
                            sop.scale_type = 5;
                            sop.PreMoveAnimator = Sector_Object.SOAnimator.ScaleSectorObject;
                            Arrays.fill(sop.scale_point_dist, 0);
                            sop.scale_point_base_speed = Sector.SCALE_POINT_SPEED;
                            Arrays.fill(sop.scale_point_speed, Sector.SCALE_POINT_SPEED);
                            sop.scale_point_dist_min = -256;
                            sop.scale_point_dist_max = 256;
                            sop.scale_point_rand_freq = 32;
                            Sprites.KillSprite(SpriteNum);
                            break;
                        }
                        case 76: {
                            u.MaxHealth = Gameutils.SP_TAG2(sp);
                            sop.max_damage = Gameutils.SP_TAG5(sp) != 0 ? (short)Gameutils.SP_TAG5(sp) : (short)u.MaxHealth;
                            switch (sp.getClipdist()) {
                                case 0: {
                                    break;
                                }
                                case 1: {
                                    sop.flags |= Gameutils.SOBJ_DIE_HARD;
                                }
                            }
                            Sprites.KillSprite(SpriteNum);
                            break;
                        }
                        case 147: {
                            sop.drive_angspeed = Gameutils.SP_TAG2(sp);
                            sop.drive_angspeed <<= 5;
                            sop.drive_angslide = Gameutils.SP_TAG3(sp);
                            if (sop.drive_angslide <= 0 || sop.drive_angslide == 32) {
                                sop.drive_angslide = 1;
                            }
                            sop.drive_speed = Gameutils.SP_TAG6(sp);
                            sop.drive_speed <<= 5;
                            sop.drive_slide = Gameutils.SP_TAG7(sp);
                            if (sop.drive_slide <= 0) {
                                sop.drive_slide = 1;
                            }
                            if (Gameutils.TEST_BOOL1(sp)) {
                                sop.flags |= Gameutils.SOBJ_NO_QUAKE;
                            }
                            if (Gameutils.TEST_BOOL3(sp)) {
                                sop.flags |= Gameutils.SOBJ_REMOTE_ONLY;
                            }
                            if (!Gameutils.TEST_BOOL4(sp)) break;
                            sop.crush_z = sp.getZ();
                            sop.flags |= Gameutils.SOBJ_RECT_CLIP;
                            break;
                        }
                        case 77: {
                            sop.ram_damage = sp.getLotag();
                            Sprites.KillSprite(SpriteNum);
                            break;
                        }
                        case 39: {
                            sop.clipdist = sp.getLotag();
                            Sprites.KillSprite(SpriteNum);
                            break;
                        }
                        case 31: {
                            sop.flags |= Gameutils.SOBJ_SPRITE_OBJ;
                            Sprites.KillSprite(SpriteNum);
                            break;
                        }
                        case 45: {
                            sop.flags |= Gameutils.SOBJ_DONT_ROTATE;
                            Sprites.KillSprite(SpriteNum);
                            break;
                        }
                        case 68: {
                            sop.limit_ang_center = sp.getAng();
                            sop.limit_ang_delta = sp.getLotag();
                            Sprites.KillSprite(SpriteNum);
                            break;
                        }
                        case 70: {
                            sop.match_event = sp.getLotag();
                            sop.match_event_sprite = SpriteNum;
                            break;
                        }
                        case 49: {
                            sop.vel_tgt = sop.vel = sp.getLotag() * 256;
                            Sprites.KillSprite(SpriteNum);
                            break;
                        }
                        case 50: {
                            if (sop.spin_speed != 0) break;
                            sop.spin_speed = sp.getLotag();
                            sop.last_ang = sop.ang;
                            Sprites.KillSprite(SpriteNum);
                            break;
                        }
                        case 16: {
                            short s = sp.getAng();
                            sop.ang_moving = s;
                            sop.last_ang = sop.ang_orig = (sop.ang = (int)s);
                            sop.spin_ang = 0;
                            Sprites.KillSprite(SpriteNum);
                            break;
                        }
                        case 51: {
                            sop.spin_speed = sp.getLotag();
                            sop.last_ang = sop.ang;
                            if (sop.spin_speed >= 0) {
                                sop.spin_speed = -sop.spin_speed;
                            }
                            Sprites.KillSprite(SpriteNum);
                            break;
                        }
                        case 52: {
                            sop.bob_amt = Gameutils.Z(sp.getLotag());
                            sop.bob_sine_ndx = 0;
                            sop.bob_speed = 4;
                            Sprites.KillSprite(SpriteNum);
                            break;
                        }
                        case 55: {
                            sop.turn_speed = sp.getLotag();
                            Sprites.KillSprite(SpriteNum);
                            break;
                        }
                        case 64: {
                            sop.flags |= Gameutils.SOBJ_SYNC1;
                            Sprites.KillSprite(SpriteNum);
                            break;
                        }
                        case 65: {
                            sop.flags |= Gameutils.SOBJ_SYNC2;
                            Sprites.KillSprite(SpriteNum);
                            break;
                        }
                        case 80: {
                            sop.flags |= Gameutils.SOBJ_KILLABLE;
                            Sprites.KillSprite(SpriteNum);
                        }
                    }
                }
                node = NextSprite;
            }
            if (sop.vel == -1) {
                sop.vel_tgt = 2048;
                sop.vel = 2048;
            }
            if (!ru.m210projects.Wang.Track.SectorObjectSetupBounds(object_num)) {
                return false;
            }
            if (sop.track >= 90) {
                switch (sop.track) {
                    case 96: 
                    case 97: 
                    case 98: {
                        sop.vel = 0;
                        sop.flags |= Gameutils.SOBJ_OPERATIONAL;
                        break;
                    }
                    case 99: {
                        sop.vel = 0;
                        sop.bob_amt = Gameutils.Z(2);
                        sop.bob_speed = 4;
                        sop.flags |= Gameutils.SOBJ_OPERATIONAL;
                        break;
                    }
                    default: {
                        sop.flags |= Gameutils.SOBJ_OPERATIONAL;
                    }
                }
            }
            if ((sec = Main.boardService.getSector(sectnum)) != null) {
                sec.setLotag(0);
                sec.setHitag(0);
            }
            if (sop.max_damage <= 0) {
                ru.m210projects.Wang.Track.VehicleSetSmoke(sop, Weapon.SpawnVehicleSmoke);
            }
        }
        return true;
    }

    public static void PostSetupSectorObject() {
        for (int s = 0; s < 25; ++s) {
            Sector_Object sop = Sprites.SectorObject[s];
            if (sop.xmid == Integer.MAX_VALUE) continue;
            Player.FindMainSector(s);
        }
    }

    public static int PlayerOnObject(int sectnum_match) {
        for (int i = 0; i < 25; ++i) {
            Sector_Object sop = Sprites.SectorObject[i];
            if (sop.track < 90) continue;
            for (int j = 0; j < sop.num_sectors; ++j) {
                ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(sectnum_match);
                if (sop.sector[j] != sectnum_match || sec == null || !MyTypes.TEST(sec.getExtra(), Gameutils.SECTFX_OPERATIONAL)) continue;
                return i;
            }
        }
        return -1;
    }

    public static void PlaceSectorObjectsOnTracks() {
        for (int i = 0; i < 25; ++i) {
            int low_dist = 999999;
            Sector_Object sop = Sprites.SectorObject[i];
            if (sop.xmid == Integer.MAX_VALUE) continue;
            sop.num_walls = 0;
            int j = 0;
            while (sop.sector[j] != -1) {
                ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(sop.sector[j]);
                if (sec != null) {
                    for (ListNode<Wall> wn = sec.getWallNode(); wn != null; wn = wn.getNext()) {
                        Wall wall = wn.get();
                        sop.xorig[sop.num_walls] = sop.xmid - wall.getX();
                        sop.yorig[sop.num_walls] = sop.ymid - wall.getY();
                        ++sop.num_walls;
                    }
                }
                ++j;
            }
            if (sop.track <= -1 || sop.track >= 90) continue;
            boolean found = false;
            TRACK_POINT[] tpoint = null;
            for (int j2 = 0; j2 < ru.m210projects.Wang.Track.Track[sop.track].NumPoints; ++j2) {
                tpoint = ru.m210projects.Wang.Track.Track[sop.track].TrackPoint;
                int dist = Game.Distance(tpoint[j2].x, tpoint[j2].y, sop.xmid, sop.ymid);
                if (dist >= low_dist) continue;
                low_dist = dist;
                sop.point = j2;
                found = true;
            }
            if (!found) {
                sop.track = -1;
                continue;
            }
            ru.m210projects.Wang.Track.NextTrackPoint(sop);
            sop.ang_moving = sop.ang_tgt = (sop.ang = EngineUtils.getAngle(tpoint[sop.point].x - sop.xmid, tpoint[sop.point].y - sop.ymid));
        }
    }

    public static void PlaceActorsOnTracks() {
        ListNode<Sprite> node = Main.boardService.getStatNode(2);
        while (node != null) {
            int tag;
            int i = node.getIndex();
            ListNode<Sprite> nexti = node.getNext();
            int low_dist = 999999;
            Sprite sp = node.get();
            USER u = Gameutils.getUser(i);
            if (u != null && (tag = Gameutils.LOW_TAG_SPRITE(i)) >= 30000 && tag <= 30099) {
                u.track = tag - 30000;
                u.track_dir = MyTypes.BETWEEN(sp.getAng(), 513, 1535) ? -1 : 1;
                u.vel_tgt = u.track_vel = sp.getXvel() * 256;
                u.vel_rate = 6;
                TRACK_POINT[] tpoint = null;
                for (int j = 0; j < ru.m210projects.Wang.Track.Track[u.track].NumPoints; ++j) {
                    tpoint = ru.m210projects.Wang.Track.Track[u.track].TrackPoint;
                    int dist = Game.Distance(tpoint[j].x, tpoint[j].y, sp.getX(), sp.getY());
                    if (dist >= low_dist) continue;
                    low_dist = dist;
                    u.point = j;
                }
                ru.m210projects.Wang.Track.NextActorTrackPoint(i);
                if (tpoint != null) {
                    sp.setAng(EngineUtils.getAngle(tpoint[u.point].x - sp.getX(), tpoint[u.point].y - sp.getY()));
                }
            }
            node = nexti;
        }
    }

    public static void MovePlayer(PlayerStr pp, int sopi, int nx, int ny) {
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_JUMPING | Gameutils.PF_FALLING | Gameutils.PF_FLYING)) {
            return;
        }
        Sector_Object sop = Sprites.SectorObject[sopi];
        pp.sop_riding = sopi;
        if (!MyTypes.TEST(pp.Flags, Gameutils.PF_PLAYER_MOVED) && !MyTypes.TEST(pp.Flags, Gameutils.PF_PLAYER_RIDING)) {
            pp.Flags |= Gameutils.PF_PLAYER_RIDING;
            pp.RevolveAng = pp.getAnglei();
            pp.RevolveX = pp.posx;
            pp.RevolveY = pp.posy;
            pp.RevolveDeltaAng = 0;
        }
        pp.posx += nx;
        pp.posy += ny;
        if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_DONT_ROTATE)) {
            Player.UpdatePlayerSprite(pp);
            return;
        }
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_PLAYER_MOVED)) {
            pp.RevolveAng = pp.getAnglei();
            pp.RevolveX = pp.posx;
            pp.RevolveY = pp.posy;
            pp.RevolveDeltaAng = 0;
        } else {
            pp.RevolveX += nx;
            pp.RevolveY += ny;
            pp.RevolveAng = Gameutils.NORM_ANGLE(pp.getAnglei() - pp.RevolveDeltaAng);
        }
        pp.RevolveDeltaAng = Gameutils.NORM_ANGLE(pp.RevolveDeltaAng + GlobSpeedSO);
        Point p = EngineUtils.rotatepoint(sop.xmid, sop.ymid, pp.RevolveX, pp.RevolveY, pp.RevolveDeltaAng);
        pp.posx = p.getX();
        pp.posy = p.getY();
        pp.pang = Gameutils.NORM_ANGLE(pp.RevolveAng + pp.RevolveDeltaAng);
        Player.UpdatePlayerSprite(pp);
    }

    public static void MovePoints(int sopi, int delta_ang, int nx, int ny, int skip) {
        WangSprite childSp;
        boolean PlayerMove = true;
        Sector_Object sop = Sprites.SectorObject[sopi];
        if (sop.xmid == Integer.MAX_VALUE) {
            PlayerMove = false;
        }
        sop.xmid += nx;
        sop.ymid += ny;
        if (sop.xmid == Integer.MAX_VALUE) {
            PlayerMove = false;
        }
        if ((childSp = Main.boardService.getSprite(sop.sp_child)) == null) {
            return;
        }
        childSp.setX(sop.xmid);
        childSp.setY(sop.ymid);
        ru.m210projects.Build.Types.Sector midSec = Main.boardService.getSector(sop.mid_sector);
        if (midSec != null && MyTypes.TEST(sop.flags, Gameutils.SOBJ_ZMID_FLOOR)) {
            sop.zmid = midSec.getFloorz();
        }
        int j = 0;
        while (sop.sector[j] != -1) {
            ru.m210projects.Build.Types.Sector sectp = Main.boardService.getSector(sop.sector[j]);
            if (sectp != null && !MyTypes.TEST(sop.flags, Gameutils.SOBJ_SPRITE_OBJ | Gameutils.SOBJ_DONT_ROTATE)) {
                for (ListNode<Wall> wn = sectp.getWallNode(); wn != null; wn = wn.getNext()) {
                    Wall wp = wn.get();
                    if (MyTypes.TEST(wp.getExtra(), Gameutils.WALLFX_LOOP_DONT_SPIN | Gameutils.WALLFX_DONT_MOVE)) continue;
                    if (wp.getExtra() != 0 && MyTypes.TEST(wp.getExtra(), Gameutils.WALLFX_LOOP_OUTER)) {
                        int x = wp.getX() + nx;
                        int y = wp.getY() + ny;
                        wp.setX(x);
                        wp.setY(y);
                        Main.engine.dragpoint(skip, wn.getIndex(), x, y);
                    } else {
                        Main.engine.getInterpolation(skip).setwallinterpolate(wn.getIndex(), wp);
                        wp.setX(wp.getX() + nx);
                        wp.setY(wp.getY() + ny);
                    }
                    int rot_ang = delta_ang;
                    if (MyTypes.TEST(wp.getExtra(), Gameutils.WALLFX_LOOP_REVERSE_SPIN)) {
                        rot_ang = -delta_ang;
                    }
                    if (MyTypes.TEST(wp.getExtra(), Gameutils.WALLFX_LOOP_SPIN_2X)) {
                        rot_ang = Gameutils.NORM_ANGLE(rot_ang * 2);
                    }
                    if (MyTypes.TEST(wp.getExtra(), Gameutils.WALLFX_LOOP_SPIN_4X)) {
                        rot_ang = Gameutils.NORM_ANGLE(rot_ang * 4);
                    }
                    Point p = EngineUtils.rotatepoint(sop.xmid, sop.ymid, wp.getX(), wp.getY(), rot_ang);
                    int rx = p.getX();
                    int ry = p.getY();
                    if (wp.getExtra() != 0 && MyTypes.TEST(wp.getExtra(), Gameutils.WALLFX_LOOP_OUTER)) {
                        Main.engine.dragpoint(skip, wn.getIndex(), rx, ry);
                        continue;
                    }
                    Main.engine.getInterpolation(skip).setwallinterpolate(wn.getIndex(), wp);
                    wp.setX(rx);
                    wp.setY(ry);
                }
            }
            short pnum = Mmulti.connecthead;
            while (pnum != -1) {
                ru.m210projects.Build.Types.Sector loSect;
                PlayerStr pp = Game.Player[pnum];
                if (pp.sop == -1 && (loSect = Main.boardService.getSector(pp.lo_sectp)) != null && !MyTypes.TEST(loSect.getExtra(), Gameutils.SECTFX_NO_RIDE) && pp.lo_sectp == sop.sector[j] && PlayerMove) {
                    ru.m210projects.Wang.Track.MovePlayer(pp, sopi, nx, ny);
                }
                pnum = Mmulti.connectpoint2[pnum];
            }
            ++j;
        }
        int i = 0;
        while (sop.sp_num[i] != -1) {
            block33: {
                WangSprite sp;
                block35: {
                    block34: {
                        Point p;
                        ru.m210projects.Build.Types.Sector sec;
                        sp = Main.boardService.getSprite(sop.sp_num[i]);
                        USER u = Gameutils.getUser(sop.sp_num[i]);
                        if (sp == null || u == null) break block33;
                        Main.engine.getInterpolation(skip).setsprinterpolate(sop.sp_num[i], sp);
                        if (u.PlayerP != -1 || !MyTypes.TEST(u.Flags, Gameutils.SPR_SO_ATTACHED)) break block33;
                        short pnum = Mmulti.connecthead;
                        while (pnum != -1) {
                            PlayerStr pp = Game.Player[pnum];
                            if (pp.lo_sp != -1 && pp.lo_sp == sop.sp_num[i] && PlayerMove) {
                                ru.m210projects.Wang.Track.MovePlayer(pp, sopi, nx, ny);
                            }
                            pnum = Mmulti.connectpoint2[pnum];
                        }
                        sp.setX(sop.xmid - u.sx);
                        sp.setY(sop.ymid - u.sy);
                        if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_SPRITE_OBJ)) {
                            sp.setZ(sop.zmid - u.sz);
                        } else {
                            ru.m210projects.Build.Types.Sector sec2 = MyTypes.TEST(u.Flags, Gameutils.SPR_ON_SO_SECTOR) ? Main.boardService.getSector(sp.getSectnum()) : Main.boardService.getSector(sop.mid_sector);
                            if (sec2 != null) {
                                sp.setZ(sec2.getFloorz() - u.sz);
                            }
                        }
                        sp.setAng(u.sang);
                        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_ON_SO_SECTOR)) break block34;
                        if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_DONT_ROTATE) || (sec = Main.boardService.getSector(sp.getSectnum())) == null || sec.getWallNode() == null || MyTypes.TEST(sec.getWallNode().get().getExtra(), Gameutils.WALLFX_LOOP_DONT_SPIN)) break block33;
                        if (MyTypes.TEST(sec.getWallNode().get().getExtra(), Gameutils.WALLFX_LOOP_REVERSE_SPIN)) {
                            p = EngineUtils.rotatepoint(sop.xmid, sop.ymid, sp.getX(), sp.getY(), -delta_ang);
                            sp.setX(p.getX());
                            sp.setY(p.getY());
                            sp.setAng(Gameutils.NORM_ANGLE(sp.getAng() - delta_ang));
                        } else {
                            p = EngineUtils.rotatepoint(sop.xmid, sop.ymid, sp.getX(), sp.getY(), delta_ang);
                            sp.setX(p.getX());
                            sp.setY(p.getY());
                            sp.setAng(Gameutils.NORM_ANGLE(sp.getAng() + delta_ang));
                        }
                        break block35;
                    }
                    if (!MyTypes.TEST(sop.flags, Gameutils.SOBJ_DONT_ROTATE)) {
                        Point p = EngineUtils.rotatepoint(sop.xmid, sop.ymid, sp.getX(), sp.getY(), delta_ang);
                        sp.setX(p.getX());
                        sp.setY(p.getY());
                        sp.setAng(Gameutils.NORM_ANGLE(sp.getAng() + delta_ang));
                    }
                    if ((long)sop.xmid < Integer.MAX_VALUE) {
                        Main.engine.setspritez(sop.sp_num[i], sp.getX(), sp.getY(), sp.getZ());
                    }
                }
                if (MyTypes.TEST(sp.getExtra(), Gameutils.SPRX_BLADE)) {
                    Weapon.DoBladeDamage(sop.sp_num[i]);
                }
            }
            ++i;
        }
        short pnum = Mmulti.connecthead;
        while (pnum != -1) {
            PlayerStr pp = Game.Player[pnum];
            if (pp.sop_riding != -1) {
                pp.cursectnum = Rooms.COVERupdatesector(pp.posx, pp.posy, pp.cursectnum);
                Sprite psp = pp.getSprite();
                if (psp != null) {
                    if (MyTypes.TEST(pp.Flags, Gameutils.PF_CRAWLING)) {
                        Player.DoPlayerZrange(pp);
                        pp.posz = pp.loz - Player.PLAYER_CRAWL_HEIGHT;
                        psp.setZ(pp.loz);
                    } else {
                        Player.DoPlayerZrange(pp);
                        if (!MyTypes.TEST(pp.Flags, Gameutils.PF_JUMPING | Gameutils.PF_FALLING | Gameutils.PF_FLYING)) {
                            pp.posz = pp.loz - Player.PLAYER_HEIGHT;
                            psp.setZ(pp.loz);
                        }
                    }
                }
            } else {
                pp.Flags &= ~Gameutils.PF_PLAYER_RIDING;
            }
            pnum = Mmulti.connectpoint2[pnum];
        }
    }

    public static void RefreshPoints(int sopi, int nx, int ny, boolean dynamic, int skip) {
        int wallcount = 0;
        Sector_Object sop = Sprites.SectorObject[sopi];
        if (dynamic && sop.PreMoveAnimator != null) {
            sop.PreMoveAnimator.invoke(sopi);
        }
        int j = 0;
        while (sop.sector[j] != -1) {
            ru.m210projects.Build.Types.Sector sectp = Main.boardService.getSector(sop.sector[j]);
            if (sectp != null && !MyTypes.TEST(sop.flags, Gameutils.SOBJ_SPRITE_OBJ)) {
                for (ListNode<Wall> wn = sectp.getWallNode(); wn != null; wn = wn.getNext()) {
                    Wall wp = wn.get();
                    if (wp.getExtra() == 0 || !MyTypes.TEST(wp.getExtra(), Gameutils.WALLFX_DONT_MOVE)) {
                        int x = sop.xmid - sop.xorig[wallcount];
                        int y = sop.ymid - sop.yorig[wallcount];
                        int dx = x;
                        int dy = y;
                        if (dynamic && sop.scale_type != 0 && !MyTypes.TEST(wp.getExtra(), Gameutils.WALLFX_DONT_SCALE)) {
                            int ang = Gameutils.NORM_ANGLE(EngineUtils.getAngle(x - sop.xmid, y - sop.ymid));
                            if (sop.scale_type == 5) {
                                Vector2i d = Morth.ScaleRandomPoint(sop, wallcount, ang, x, y);
                                dx = d.x;
                                dy = d.y;
                            } else {
                                int xmul = sop.scale_dist * sop.scale_x_mult >> 8;
                                int ymul = sop.scale_dist * sop.scale_y_mult >> 8;
                                dx = x + (xmul * EngineUtils.sin(Gameutils.NORM_ANGLE(ang + 512)) >> 14);
                                dy = y + (ymul * EngineUtils.sin(ang) >> 14);
                            }
                        }
                        if (wp.getExtra() != 0 && MyTypes.TEST(wp.getExtra(), Gameutils.WALLFX_LOOP_OUTER)) {
                            Main.engine.dragpoint(skip, wn.getIndex(), dx, dy);
                        } else {
                            Main.engine.getInterpolation(skip).setwallinterpolate(wn.getIndex(), wp);
                            wp.setX(dx);
                            wp.setY(dy);
                        }
                    }
                    ++wallcount;
                }
            }
            ++j;
        }
        int delta_ang_from_orig = sop.spin_speed != 0 ? Gameutils.NORM_ANGLE(sop.last_ang + sop.spin_ang - sop.ang_orig) : Gameutils.NORM_ANGLE(sop.ang + sop.spin_ang - sop.ang_orig);
        ru.m210projects.Wang.Track.MovePoints(sopi, delta_ang_from_orig, nx, ny, skip);
        if (dynamic && sop.PostMoveAnimator != null) {
            sop.PostMoveAnimator.invoke(sopi);
        }
    }

    public static void KillSectorObjectSprites(Sector_Object sop) {
        int i = 0;
        while (sop.sp_num[i] != -1) {
            WangSprite sp = Main.boardService.getSprite(sop.sp_num[i]);
            USER u = Gameutils.getUser(sop.sp_num[i]);
            if (sp != null && u != null) {
                u.Flags &= ~Gameutils.SPR_SO_ATTACHED;
                if (sp.getPicnum() != 2307 || sp.getHitag() != 69) {
                    Sprites.KillSprite(sop.sp_num[i]);
                }
            }
            ++i;
        }
        sop.sp_num[0] = -1;
    }

    public static int DetectSectorObject(ru.m210projects.Build.Types.Sector sectph) {
        for (int s = 0; s < 25; ++s) {
            Sector_Object sop = Sprites.SectorObject[s];
            if (sop.xmid == Integer.MAX_VALUE) continue;
            int j = 0;
            while (sop.sector[j] != -1) {
                ru.m210projects.Build.Types.Sector sectp = Main.boardService.getSector(sop.sector[j]);
                if (sectph == sectp) {
                    return s;
                }
                ++j;
            }
        }
        return -1;
    }

    public static Sector_Object DetectSectorObjectByWall(Wall wph) {
        for (int s = 0; s < 25; ++s) {
            Sector_Object sop = Sprites.SectorObject[s];
            if (sop.xmid == Integer.MAX_VALUE) continue;
            int j = 0;
            while (sop.sector[j] != -1) {
                ru.m210projects.Build.Types.Sector sectp = Main.boardService.getSector(sop.sector[j]);
                if (sectp != null) {
                    for (ListNode<Wall> wn = sectp.getWallNode(); wn != null; wn = wn.getNext()) {
                        Wall wp = wn.get();
                        if (MyTypes.TEST(wp.getExtra(), Gameutils.WALLFX_LOOP_OUTER) && wph == Main.boardService.getWall(wp.getNextwall())) {
                            return sop;
                        }
                        if (wph != wp) continue;
                        return sop;
                    }
                }
                ++j;
            }
        }
        return null;
    }

    public static void CollapseSectorObject(Sector_Object sop, int nx, int ny) {
        int j = 0;
        while (sop.sector[j] != -1) {
            ru.m210projects.Build.Types.Sector sectp = Main.boardService.getSector(sop.sector[j]);
            if (sectp != null && !MyTypes.TEST(sop.flags, Gameutils.SOBJ_SPRITE_OBJ)) {
                for (ListNode<Wall> wn = sectp.getWallNode(); wn != null; wn = wn.getNext()) {
                    Wall wp = wn.get();
                    if (MyTypes.TEST(wp.getExtra(), Gameutils.WALLFX_DONT_MOVE)) continue;
                    if (wp.getExtra() != 0 && MyTypes.TEST(wp.getExtra(), Gameutils.WALLFX_LOOP_OUTER)) {
                        Main.engine.dragpoint(wn.getIndex(), nx, ny);
                        continue;
                    }
                    wp.setX(nx);
                    wp.setY(ny);
                }
            }
            ++j;
        }
    }

    public static void MoveZ(Sector_Object sop) {
        int i;
        if (sop.bob_amt != 0) {
            sop.bob_sine_ndx = Game.totalsynctics << sop.bob_speed & 0x7FF;
            sop.bob_diff = sop.bob_amt * EngineUtils.sin(sop.bob_sine_ndx) >> 14;
            i = 0;
            while (sop.sector[i] != -1) {
                Sect_User su;
                ru.m210projects.Build.Types.Sector sectp = Main.boardService.getSector(sop.sector[i]);
                if (!(sectp == null || (su = Sector.getSectUser(sop.sector[i])) != null && MyTypes.TEST(su.flags, Gameutils.SECTFU_SO_DONT_BOB))) {
                    sectp.setFloorz(sop.zorig_floor[i] + sop.bob_diff);
                }
                ++i;
            }
        }
        if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_MOVE_VERTICAL) && (i = Sector.AnimGetGoal(sop, Anim.AnimType.SectorObjectZ)) < 0) {
            sop.flags &= ~Gameutils.SOBJ_MOVE_VERTICAL;
        }
        if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_ZDIFF_MODE)) {
            return;
        }
        if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_ZDOWN)) {
            i = 0;
            while (sop.sector[i] != -1) {
                Sector.AnimSet(sop.sector[i], sop.zorig_floor[i] + sop.z_tgt, sop.z_rate, Anim.AnimType.FloorZ);
                ++i;
            }
            sop.flags &= ~Gameutils.SOBJ_ZDOWN;
        } else if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_ZUP)) {
            i = 0;
            while (sop.sector[i] != -1) {
                Sector.AnimSet(sop.sector[i], sop.zorig_floor[i] + sop.z_tgt, sop.z_rate, Anim.AnimType.FloorZ);
                ++i;
            }
            sop.flags &= ~Gameutils.SOBJ_ZUP;
        }
    }

    public static void CallbackSOsink(Anim ap, Sector_Object data) {
        int dest_sector = -1;
        int src_sector = -1;
        int i = 0;
        while (data.sector[i] != -1) {
            Sect_User su = Sector.getSectUser(data.sector[i]);
            if (su != null && MyTypes.TEST(su.flags, Gameutils.SECTFU_SO_SINK_DEST)) {
                src_sector = data.sector[i];
                break;
            }
            ++i;
        }
        i = 0;
        while (data.sector[i] != -1) {
            if (ap.ptr == Main.boardService.getSector(data.sector[i]) && ap.index == data.sector[i] && ap.type == Anim.AnimType.FloorZ) {
                dest_sector = data.sector[i];
                break;
            }
            ++i;
        }
        ru.m210projects.Build.Types.Sector dest = Main.boardService.getSector(dest_sector);
        ru.m210projects.Build.Types.Sector src = Main.boardService.getSector(src_sector);
        if (dest == null || src == null) {
            return;
        }
        dest.setFloorpicnum(src.getFloorpicnum());
        dest.setFloorshade(src.getFloorshade());
        dest.setFloorstat(dest.getFloorstat() & ~Gameutils.FLOOR_STAT_RELATIVE);
        int tgt_depth = Sprites.SetupSectUser((int)src_sector).depth;
        for (int sectnum = 0; sectnum < Main.boardService.getSectorCount(); ++sectnum) {
            if (sectnum != dest_sector) continue;
            int ndx = Sector.AnimSet(sectnum, tgt_depth << 16, ap.vel << 8 >> 8, Anim.AnimType.SectUserDepth);
            Sector.AnimSetVelAdj(ndx, ap.vel_adj);
            break;
        }
        ListNode<Sprite> node = Main.boardService.getSectNode(dest_sector);
        while (node != null) {
            int i2 = node.getIndex();
            ListNode<Sprite> nexti = node.getNext();
            Sprite sp = node.get();
            USER u = Gameutils.getUser(i2);
            if (u != null && u.PlayerP == -1 && MyTypes.TEST(u.Flags, Gameutils.SPR_SO_ATTACHED)) {
                int ndx = Sector.AnimSet(i2, -u.sz - Gameutils.SPRITEp_SIZE_Z(sp) - Gameutils.Z(100), ap.vel >> 8, Anim.AnimType.UserZ);
                Sector.AnimSetVelAdj(ndx, ap.vel_adj);
            }
            node = nexti;
        }
        for (ListNode<Wall> wn = dest.getWallNode(); wn != null; wn = wn.getNext()) {
            Wall wall = wn.get();
            wall.setCstat(wall.getCstat() & ~Gameutils.CSTAT_WALL_BLOCK);
        }
    }

    public static void MoveSectorObjects(int sopi, int locktics, int skip) {
        Sector_Object sop = Sprites.SectorObject[sopi];
        if (sop.track >= 90) {
            if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_UPDATE_ONCE)) {
                sop.flags &= ~Gameutils.SOBJ_UPDATE_ONCE;
                ru.m210projects.Wang.Track.RefreshPoints(sopi, 0, 0, false, skip);
            }
            return;
        }
        int nx = 0;
        int ny = 0;
        if (sop.wait_tics != 0) {
            sop.wait_tics -= locktics;
            if (sop.wait_tics <= 0) {
                sop.wait_tics = 0;
            }
            return;
        }
        if (sop.track > -1) {
            ru.m210projects.Wang.Track.DoTrack(sopi, locktics, Game.tmp_ptr[0].set(0), Game.tmp_ptr[1].set(0));
            nx = Game.tmp_ptr[0].value;
            ny = Game.tmp_ptr[1].value;
        }
        int delta_ang = Player.GetDeltaAngle(sop.ang_tgt, sop.ang);
        sop.ang = Gameutils.NORM_ANGLE(sop.ang + (delta_ang >> sop.turn_speed));
        delta_ang >>= sop.turn_speed;
        ru.m210projects.Wang.Track.MoveZ(sop);
        int speed = sop.spin_speed * locktics;
        sop.spin_ang = Gameutils.NORM_ANGLE(sop.spin_ang + speed);
        if (sop.spin_speed != 0) {
            GlobSpeedSO = speed;
        } else {
            GlobSpeedSO = speed;
            GlobSpeedSO += delta_ang;
        }
        if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_DYNAMIC)) {
            ru.m210projects.Wang.Track.RefreshPoints(sopi, nx, ny, true, skip);
        } else if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_UPDATE | Gameutils.SOBJ_UPDATE_ONCE) || sop.vel != 0 || sop.ang != sop.ang_tgt || GlobSpeedSO != 0) {
            sop.flags &= ~Gameutils.SOBJ_UPDATE_ONCE;
            ru.m210projects.Wang.Track.RefreshPoints(sopi, nx, ny, false, skip);
        }
    }

    public static void DoTrack(int sopi, int locktics, LONGp nx, LONGp ny) {
        Sector_Object sop = Sprites.SectorObject[sopi];
        TRACK_POINT tpoint = ru.m210projects.Wang.Track.Track[sop.track].TrackPoint[sop.point];
        if (sop.vel != 0) {
            sop.ang_moving = sop.ang_tgt = EngineUtils.getAngle(tpoint.x - sop.xmid, tpoint.y - sop.ymid);
        }
        if (sop.target_dist < 100) {
            switch (tpoint.tag_low) {
                case 728: {
                    Sector.DoMatchEverything(null, tpoint.tag_high, -1);
                    break;
                }
                case 729: {
                    Sector.DoMatchEverything(null, tpoint.tag_high, -1);
                    tpoint.tag_low = 0;
                    tpoint.tag_high = 0;
                    break;
                }
                case 715: {
                    if (sop.spin_speed != 0) break;
                    sop.spin_speed = tpoint.tag_high;
                    sop.last_ang = sop.ang;
                    break;
                }
                case 720: {
                    if (sop.spin_speed == 0 || sop.spin_speed < 0) break;
                    sop.spin_speed = -sop.spin_speed;
                    break;
                }
                case 716: {
                    if (sop.spin_speed == 0) break;
                    sop.spin_speed = 0;
                    break;
                }
                case 717: {
                    sop.flags |= Gameutils.SOBJ_ZMID_FLOOR;
                    sop.bob_amt = Gameutils.Z(tpoint.tag_high);
                    sop.bob_sine_ndx = 0;
                    sop.bob_speed = 4;
                    break;
                }
                case 719: {
                    sop.bob_speed = 0;
                    sop.bob_sine_ndx = 0;
                    sop.bob_amt = 0;
                    break;
                }
                case 718: {
                    sop.bob_speed = tpoint.tag_high;
                    break;
                }
                case 704: {
                    sop.dir *= -1;
                    break;
                }
                case 703: {
                    sop.vel = 0;
                    sop.wait_tics = (short)(tpoint.tag_high * 128);
                    break;
                }
                case 702: {
                    sop.vel_tgt = sop.vel = tpoint.tag_high * 256;
                    break;
                }
                case 707: {
                    sop.vel_rate = tpoint.tag_high;
                    break;
                }
                case 705: {
                    sop.flags &= ~(Gameutils.SOBJ_SLOW_DOWN | Gameutils.SOBJ_SPEED_UP);
                    if (sop.dir < 0) {
                        sop.vel_tgt -= tpoint.tag_high * 256;
                        sop.flags |= Gameutils.SOBJ_SLOW_DOWN;
                        break;
                    }
                    sop.vel_tgt += tpoint.tag_high * 256;
                    sop.flags |= Gameutils.SOBJ_SPEED_UP;
                    break;
                }
                case 706: {
                    sop.flags &= ~(Gameutils.SOBJ_SLOW_DOWN | Gameutils.SOBJ_SPEED_UP);
                    if (sop.dir > 0) {
                        sop.vel_tgt -= tpoint.tag_high * 256;
                        sop.flags |= Gameutils.SOBJ_SLOW_DOWN;
                        break;
                    }
                    sop.vel_tgt += tpoint.tag_high * 256;
                    sop.flags |= Gameutils.SOBJ_SPEED_UP;
                    break;
                }
                case 723: {
                    ru.m210projects.Build.Types.Sector dest;
                    int dest_sector = -1;
                    int i = 0;
                    while (sop.sector[i] != -1) {
                        Sect_User su = Sector.getSectUser(sop.sector[i]);
                        if (su != null && MyTypes.TEST(su.flags, Gameutils.SECTFU_SO_SINK_DEST)) {
                            dest_sector = sop.sector[i];
                            break;
                        }
                        ++i;
                    }
                    if ((dest = Main.boardService.getSector(dest_sector)) == null) break;
                    sop.bob_speed = 0;
                    sop.bob_sine_ndx = 0;
                    sop.bob_amt = 0;
                    int i2 = 0;
                    while (sop.sector[i2] != -1) {
                        Sect_User su = Sector.getSectUser(sop.sector[i2]);
                        if (su == null || !MyTypes.TEST(su.flags, Gameutils.SECTFU_SO_DONT_SINK)) {
                            int ndx = Sector.AnimSet(sop.sector[i2], dest.getFloorz(), tpoint.tag_high, Anim.AnimType.FloorZ);
                            Sector.AnimSetCallback(ndx, Anim.AnimCallback.SOsink, sopi);
                            Sector.AnimSetVelAdj(ndx, 6);
                        }
                        ++i2;
                    }
                    break;
                }
                case 724: {
                    int i = 0;
                    while (sop.sector[i] != -1) {
                        ru.m210projects.Build.Types.Sector sectp = Main.boardService.getSector(sop.sector[i]);
                        Sect_User sectu = Sector.getSectUser(sop.sector[i]);
                        if (sectp != null && sectu != null && sectu.stag == 37) {
                            Sector.AnimSet(sop.sector[i], sectp.getFloorz() + Gameutils.Z(sectu.height), 128, Anim.AnimType.FloorZ);
                            sectp.setFloorshade(sectp.getFloorshade() + sectu.height / 6);
                            sectp.setExtra(sectp.getExtra() & ~Gameutils.SECTFX_NO_RIDE);
                        }
                        ++i;
                    }
                    break;
                }
                case 725: {
                    sop.flags |= Gameutils.SOBJ_MOVE_VERTICAL;
                    int zr = 256;
                    if (tpoint.tag_high > 0) {
                        zr = tpoint.tag_high;
                    }
                    ru.m210projects.Wang.Track.NextTrackPoint(sop);
                    tpoint = ru.m210projects.Wang.Track.Track[sop.track].TrackPoint[sop.point];
                    Sector.AnimSet(sopi, tpoint.z, zr, Anim.AnimType.SectorObjectZ);
                    sop.dir *= -1;
                    ru.m210projects.Wang.Track.NextTrackPoint(sop);
                    sop.dir *= -1;
                    break;
                }
                case 726: {
                    if (tpoint.tag_high == -1) break;
                    sop.flags |= Gameutils.SOBJ_WAIT_FOR_EVENT;
                    sop.save_vel = sop.vel;
                    sop.save_spin_speed = sop.spin_speed;
                    sop.spin_speed = 0;
                    sop.vel = 0;
                    if (tpoint.tag_high != 0) {
                        sop.match_event = tpoint.tag_high;
                    }
                    tpoint.tag_high = (short)-1;
                    break;
                }
                case 712: {
                    sop.flags |= Gameutils.SOBJ_ZDIFF_MODE;
                    sop.zdelta = Gameutils.Z(tpoint.tag_high);
                    break;
                }
                case 711: {
                    sop.z_rate = Gameutils.Z(tpoint.tag_high);
                    break;
                }
                case 709: {
                    sop.flags &= ~(Gameutils.SOBJ_ZDOWN | Gameutils.SOBJ_ZUP);
                    if (sop.dir < 0) {
                        sop.z_tgt += Gameutils.Z(tpoint.tag_high);
                        sop.flags |= Gameutils.SOBJ_ZDOWN;
                        break;
                    }
                    sop.z_tgt -= Gameutils.Z(tpoint.tag_high);
                    sop.flags |= Gameutils.SOBJ_ZUP;
                    break;
                }
                case 710: {
                    sop.flags &= ~(Gameutils.SOBJ_ZDOWN | Gameutils.SOBJ_ZUP);
                    if (sop.dir > 0) {
                        sop.z_tgt += Gameutils.Z(tpoint.tag_high);
                        sop.flags |= Gameutils.SOBJ_ZDOWN;
                        break;
                    }
                    sop.z_tgt -= Gameutils.Z(tpoint.tag_high);
                    sop.flags |= Gameutils.SOBJ_ZUP;
                }
            }
            ru.m210projects.Wang.Track.NextTrackPoint(sop);
            tpoint = ru.m210projects.Wang.Track.Track[sop.track].TrackPoint[sop.point];
            sop.target_dist = Game.Distance(sop.xmid, sop.ymid, tpoint.x, tpoint.y);
            sop.ang_moving = sop.ang_tgt = EngineUtils.getAngle(tpoint.x - sop.xmid, tpoint.y - sop.ymid);
            if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_ZDIFF_MODE)) {
                int dx = tpoint.x;
                int dy = tpoint.y;
                int dz = tpoint.z - sop.zdelta;
                int dist = Gameutils.DIST(dx, dy, sop.xmid, sop.ymid);
                sop.z_rate = sop.vel * (sop.zmid - dz) / dist;
                sop.z_rate = Gameutils.PIXZ(Pragmas.klabs(sop.z_rate));
                if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_SPRITE_OBJ)) {
                    Sector.AnimSet(sopi, dz, sop.z_rate, Anim.AnimType.SectorObjectZ);
                } else {
                    int i = 0;
                    while (sop.sector[i] != -1) {
                        ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(sop.mid_sector);
                        ru.m210projects.Build.Types.Sector sec2 = Main.boardService.getSector(sop.sector[i]);
                        if (sec != null && sec2 != null) {
                            Sector.AnimSet(sop.sector[i], dz - (sec.getFloorz() - sec2.getFloorz()), sop.z_rate, Anim.AnimType.FloorZ);
                        }
                        ++i;
                    }
                }
            }
        } else if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_SPEED_UP)) {
            if ((sop.vel += locktics << sop.vel_rate) >= sop.vel_tgt) {
                sop.vel = sop.vel_tgt;
                sop.flags &= ~Gameutils.SOBJ_SPEED_UP;
            }
        } else if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_SLOW_DOWN) && (sop.vel -= locktics << sop.vel_rate) <= sop.vel_tgt) {
            sop.vel = sop.vel_tgt;
            sop.flags &= ~Gameutils.SOBJ_SLOW_DOWN;
        }
        if (sop.vel != 0 && !MyTypes.TEST(sop.flags, Gameutils.SOBJ_MOVE_VERTICAL)) {
            nx.value = MyTypes.DIV256(sop.vel) * locktics * EngineUtils.sin(Gameutils.NORM_ANGLE(sop.ang_moving + 512)) >> 14;
            ny.value = MyTypes.DIV256(sop.vel) * locktics * EngineUtils.sin(sop.ang_moving) >> 14;
            int dist = Game.Distance(sop.xmid, sop.ymid, sop.xmid + nx.value, sop.ymid + ny.value);
            sop.target_dist -= dist;
        }
    }

    public static void OperateSectorObject(int sopi, float newang, int newx, int newy, int skip) {
        if (WangNetwork.Prediction) {
            return;
        }
        Sector_Object sop = Sprites.SectorObject[sopi];
        if (sop.track < 90) {
            return;
        }
        if (sop.bob_amt != 0) {
            sop.bob_sine_ndx = Game.totalsynctics << sop.bob_speed & 0x7FF;
            sop.bob_diff = sop.bob_amt * EngineUtils.sin(sop.bob_sine_ndx) >> 14;
            int i = 0;
            while (sop.sector[i] != -1) {
                Sect_User su;
                ru.m210projects.Build.Types.Sector sectp = Main.boardService.getSector(sop.sector[i]);
                if (!(sectp == null || (su = Sector.getSectUser(sop.sector[i])) != null && MyTypes.TEST(su.flags, Gameutils.SECTFU_SO_DONT_BOB))) {
                    sectp.setFloorz(sop.zorig_floor[i] + sop.bob_diff);
                }
                ++i;
            }
        }
        GlobSpeedSO = 0;
        sop.ang_moving = (int)newang;
        sop.spin_ang = 0;
        sop.ang = (int)newang;
        ru.m210projects.Wang.Track.RefreshPoints(sopi, newx - sop.xmid, newy - sop.ymid, false, skip);
    }

    public static void PlaceSectorObject(int sopi, int ignored, int newx, int newy) {
        Sector_Object sop = Sprites.SectorObject[sopi];
        ru.m210projects.Wang.Track.RefreshPoints(sopi, newx - sop.xmid, newy - sop.ymid, false, 1);
    }

    public static void VehicleSetSmoke(Sector_Object sop, Animator animator) {
        int j = 0;
        while (sop.sector[j] != -1) {
            ListNode<Sprite> node = Main.boardService.getSectNode(sop.sector[j]);
            while (node != null) {
                ListNode<Sprite> NextSprite;
                block2: {
                    block4: {
                        Sprite sp;
                        int SpriteNum;
                        block3: {
                            SpriteNum = node.getIndex();
                            NextSprite = node.getNext();
                            sp = node.get();
                            USER u = Gameutils.getUser(SpriteNum);
                            if (u == null || sp.getHitag() != 69 || sp.getClipdist() != 3) break block2;
                            if (animator == null) break block3;
                            if (sp.getStatnum() == 41) break block2;
                            Sprites.change_sprite_stat(SpriteNum, 41);
                            Sector.DoSoundSpotMatch(sp.getLotag(), 1, Sound.SoundType.SOUND_OBJECT_TYPE);
                            Sector.DoSpawnSpotsForDamage(sp.getLotag());
                            break block4;
                        }
                        Sprites.change_sprite_stat(SpriteNum, 67);
                        Sector.DoSoundSpotStopSound(sp.getLotag());
                    }
                    u.ActorActionFunc = animator;
                }
                node = NextSprite;
            }
            ++j;
        }
    }

    public static void TornadoSpin(Sector_Object sop) {
        int delta_ang = Player.GetDeltaAngle(sop.ang_tgt, sop.ang);
        sop.ang = Gameutils.NORM_ANGLE(sop.ang + (delta_ang >> sop.turn_speed));
        delta_ang >>= sop.turn_speed;
        ru.m210projects.Wang.Track.MoveZ(sop);
        int speed = sop.spin_speed * 3;
        sop.spin_ang = Gameutils.NORM_ANGLE(sop.spin_ang + speed);
        if (sop.spin_speed != 0) {
            GlobSpeedSO = speed;
        } else {
            GlobSpeedSO = speed;
            GlobSpeedSO += delta_ang;
        }
    }

    public static void DoTornadoObject(int sopi) {
        Sector_Object sop = Sprites.SectorObject[sopi];
        int xvect = sop.vel * EngineUtils.sin(Gameutils.NORM_ANGLE(sop.ang_moving + 512));
        int yvect = sop.vel * EngineUtils.sin(Gameutils.NORM_ANGLE(sop.ang_moving));
        int cursect = sop.op_main_sector;
        ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(cursect);
        if (sec == null) {
            return;
        }
        int floor_dist = MyTypes.DIV4(Pragmas.klabs(sec.getCeilingz() - sec.getFloorz()));
        int x = sop.xmid;
        int y = sop.ymid;
        ru.m210projects.Wang.Track.PlaceSectorObject(sopi, sop.ang_moving, Integer.MAX_VALUE, Integer.MAX_VALUE);
        int ret = Main.engine.clipmove(x, y, floor_dist, cursect, xvect, yvect, sop.clipdist, Gameutils.Z(0), floor_dist, Gameutils.CLIPMASK_ACTOR);
        x = Engine.clipmove_x;
        y = Engine.clipmove_y;
        if (ret != 0) {
            sop.ang_moving = Gameutils.NORM_ANGLE(sop.ang_moving + 1024 + Gameutils.RANDOM_P2(512) - 256);
        }
        ru.m210projects.Wang.Track.TornadoSpin(sop);
        ru.m210projects.Wang.Track.RefreshPoints(sopi, x - sop.xmid, y - sop.ymid, true, 1);
    }

    public static void DoAutoTurretObject(int sopi) {
        Sector_Object sop = Sprites.SectorObject[sopi];
        int SpriteNum = sop.sp_child;
        USER u = Gameutils.getUser(SpriteNum);
        if (sop.max_damage != -9999 && sop.max_damage <= 0) {
            return;
        }
        if (u == null) {
            return;
        }
        u.WaitTics -= 3;
        if (u.tgt_sp == -1 || u.WaitTics < 0) {
            u.WaitTics = 480;
            Ai.DoActorPickClosePlayer(SpriteNum);
        }
        if (!Sprites.MoveSkip2) {
            int diff;
            WangSprite shootp;
            WangSprite tspr = Main.boardService.getSprite(u.tgt_sp);
            int i = 0;
            while (sop.sp_num[i] != -1) {
                shootp = Main.boardService.getSprite(sop.sp_num[i]);
                if (shootp != null && shootp.getStatnum() == 55 && tspr != null && !Rooms.FAFcansee(shootp.getX(), shootp.getY(), shootp.getZ() - Gameutils.Z(4), shootp.getSectnum(), tspr.getX(), tspr.getY(), Gameutils.SPRITEp_UPPER(tspr), tspr.getSectnum())) {
                    return;
                }
                ++i;
            }
            if (u.Counter > 0) {
                u.Counter -= 6;
                if (u.Counter <= 0) {
                    u.Counter = 0;
                }
            }
            if (u.Counter == 0) {
                i = 0;
                while (sop.sp_num[i] != -1) {
                    shootp = Main.boardService.getSprite(sop.sp_num[i]);
                    if (shootp != null && shootp.getStatnum() == 55) {
                        u.Counter = Gameutils.SP_TAG5(shootp) != 0 ? Gameutils.SP_TAG5(shootp) : 12;
                        Weapon.InitTurretMgun(sop);
                    }
                    ++i;
                }
            }
            if (tspr != null) {
                sop.ang_tgt = EngineUtils.getAngle(tspr.getX() - sop.xmid, tspr.getY() - sop.ymid);
            }
            int delta_ang = Player.GetDeltaAngle(sop.ang_tgt, sop.ang);
            sop.ang = Gameutils.NORM_ANGLE(sop.ang + (delta_ang >> 3));
            if (sop.limit_ang_center >= 0 && Pragmas.klabs(diff = Player.GetDeltaAngle(sop.ang, sop.limit_ang_center)) >= sop.limit_ang_delta) {
                sop.ang = diff < 0 ? sop.limit_ang_center - sop.limit_ang_delta : sop.limit_ang_center + sop.limit_ang_delta;
            }
            ru.m210projects.Wang.Track.OperateSectorObject(sopi, sop.ang, sop.xmid, sop.ymid, 2);
        }
    }

    public static void DoActorHitTrackEndPoint(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        ru.m210projects.Wang.Track.Track[u.track].flags &= ~Gameutils.TF_TRACK_OCCUPIED;
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_RUN_AWAY)) {
            u.track = Ai.FindTrackAwayFromPlayer(SpriteNum);
            if (u.track >= 0) {
                sp.setAng(Gameutils.NORM_ANGLE(EngineUtils.getAngle(ru.m210projects.Wang.Track.Track[u.track].TrackPoint[u.point].x - sp.getX(), ru.m210projects.Wang.Track.Track[u.track].TrackPoint[u.point].y - sp.getY())));
            } else {
                u.Flags &= ~Gameutils.SPR_RUN_AWAY;
                Ai.DoActorSetSpeed(SpriteNum, 1);
                u.track = -1;
            }
        } else if (MyTypes.TEST(u.Flags, Gameutils.SPR_FIND_PLAYER)) {
            u.track = Ai.FindTrackToPlayer(SpriteNum);
            if (u.track >= 0) {
                sp.setAng(Gameutils.NORM_ANGLE(EngineUtils.getAngle(ru.m210projects.Wang.Track.Track[u.track].TrackPoint[u.point].x - sp.getX(), ru.m210projects.Wang.Track.Track[u.track].TrackPoint[u.point].y - sp.getY())));
            } else {
                u.Flags &= ~Gameutils.SPR_FIND_PLAYER;
                Ai.DoActorSetSpeed(SpriteNum, 1);
                u.track = -1;
            }
        } else {
            u.track = -1;
        }
    }

    public static void ActorLeaveTrack(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null || u.track == -1) {
            return;
        }
        u.Flags &= ~(Gameutils.SPR_FIND_PLAYER | Gameutils.SPR_RUN_AWAY | Gameutils.SPR_CLIMBING);
        ru.m210projects.Wang.Track.Track[u.track].flags &= ~Gameutils.TF_TRACK_OCCUPIED;
        u.track = -1;
    }

    public static boolean ActorTrackDecide(TRACK_POINT tpoint, int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return false;
        }
        switch (tpoint.tag_low) {
            case 700: {
                if (ru.m210projects.Wang.Track.Track[u.track].ttflags == 0 || u.track_dir != -1) break;
                ru.m210projects.Wang.Track.DoActorHitTrackEndPoint(SpriteNum);
                return false;
            }
            case 701: {
                if (ru.m210projects.Wang.Track.Track[u.track].ttflags == 0 || u.track_dir != 1) break;
                ru.m210projects.Wang.Track.DoActorHitTrackEndPoint(SpriteNum);
                return false;
            }
            case 799: {
                u.Flags |= Gameutils.SPR_WAIT_FOR_PLAYER;
                u.Dist = tpoint.tag_high;
                break;
            }
            case 800: {
                u.Flags |= Gameutils.SPR_WAIT_FOR_TRIGGER;
                u.Dist = tpoint.tag_high;
                break;
            }
            case 755: {
                u.vel_rate = tpoint.tag_high;
                break;
            }
            case 753: {
                u.Flags &= ~(Gameutils.SPR_SLOW_DOWN | Gameutils.SPR_SPEED_UP);
                if (u.track_dir < 0) {
                    u.vel_tgt -= tpoint.tag_high * 256;
                    u.Flags |= Gameutils.SPR_SLOW_DOWN;
                    break;
                }
                u.vel_tgt += tpoint.tag_high * 256;
                u.Flags |= Gameutils.SPR_SPEED_UP;
                break;
            }
            case 754: {
                u.Flags &= ~(Gameutils.SPR_SLOW_DOWN | Gameutils.SPR_SPEED_UP);
                if (u.track_dir > 0) {
                    u.vel_tgt -= tpoint.tag_high * 256;
                    u.Flags |= Gameutils.SPR_SLOW_DOWN;
                    break;
                }
                u.vel_tgt += tpoint.tag_high * 256;
                u.Flags |= Gameutils.SPR_SPEED_UP;
                break;
            }
            case 752: {
                u.track_dir *= -1;
                break;
            }
            case 770: {
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Stand);
                break;
            }
            case 771: {
                if (u.ActorActionSet.Jump == null) break;
                sp.setAng(tpoint.ang);
                u.jump_speed = tpoint.tag_high == 0 ? -384 : (int)(-tpoint.tag_high);
                Actor.DoActorBeginJump(SpriteNum);
                u.ActorActionFunc = Ai.DoActorMoveJump;
                break;
            }
            case 801: 
            case 803: {
                if (u.ActorActionSet.Jump == null) break;
                sp.setAng(tpoint.ang);
                ru.m210projects.Wang.Track.ActorLeaveTrack(SpriteNum);
                if (tpoint.tag_high != 0) {
                    u.jump_speed = -tpoint.tag_high;
                } else {
                    sp.setCstat(sp.getCstat() & ~Gameutils.CSTAT_SPRITE_BLOCK);
                    Rooms.FAFhitscan(sp.getX(), sp.getY(), sp.getZ() - Gameutils.Z(24), sp.getSectnum(), EngineUtils.sin(Gameutils.NORM_ANGLE(sp.getAng() + 512)), EngineUtils.sin(sp.getAng()), 0, Engine.pHitInfo, Gameutils.CLIPMASK_MISSILE);
                    int hitwall = Engine.pHitInfo.hitwall;
                    int hitsprite = Engine.pHitInfo.hitsprite;
                    sp.setCstat(sp.getCstat() | Gameutils.CSTAT_SPRITE_BLOCK);
                    if (hitsprite != -1) {
                        return false;
                    }
                    Wall hwall = Main.boardService.getWall(hitwall);
                    if (hwall == null || hwall.getNextsector() < 0) {
                        return false;
                    }
                    ru.m210projects.Build.Types.Sector nsec = Main.boardService.getSector(hwall.getNextsector());
                    if (nsec != null) {
                        int zdiff = Pragmas.klabs(sp.getZ() - nsec.getFloorz()) >> 8;
                        u.jump_speed = Ripper.PickJumpSpeed(SpriteNum, zdiff);
                    }
                }
                Actor.DoActorBeginJump(SpriteNum);
                u.ActorActionFunc = Ai.DoActorMoveJump;
                return false;
            }
            case 802: {
                if (u.ActorActionSet.Jump == null) break;
                sp.setAng(tpoint.ang);
                ru.m210projects.Wang.Track.ActorLeaveTrack(SpriteNum);
                u.jump_speed = tpoint.tag_high != 0 ? (int)(-tpoint.tag_high) : -350;
                Actor.DoActorBeginJump(SpriteNum);
                u.ActorActionFunc = Ai.DoActorMoveJump;
                return false;
            }
            case 804: {
                if (u.ActorActionSet.Jump == null) break;
                ru.m210projects.Wang.Track.ActorLeaveTrack(SpriteNum);
                return false;
            }
            case 808: {
                if (u.getRot() == u.ActorActionSet.Duck) break;
                sp.setAng(tpoint.ang);
                ru.m210projects.Wang.Track.ActorLeaveTrack(SpriteNum);
                u.WaitTics = tpoint.tag_high == 0 ? 480 : tpoint.tag_high * 128;
                Ai.InitActorDuck.animatorInvoke(SpriteNum);
                u.ActorActionFunc = Ai.DoActorDuck;
                return false;
            }
            case 791: 
            case 807: {
                int nearsector = -1;
                int nearhitdist = -1;
                if (u.getRot() == u.ActorActionSet.Sit || u.getRot() == u.ActorActionSet.Stand) {
                    return false;
                }
                sp.setAng(tpoint.ang);
                ru.m210projects.Wang.Track.z[0] = sp.getZ() - Gameutils.SPRITEp_SIZE_Z(sp) + Gameutils.Z(5);
                ru.m210projects.Wang.Track.z[1] = sp.getZ() - MyTypes.DIV2(Gameutils.SPRITEp_SIZE_Z(sp));
                for (int j : z) {
                    Main.engine.neartag(sp.getX(), sp.getY(), j, sp.getSectnum(), sp.getAng(), Engine.neartag, 1024, 3);
                    nearsector = Engine.neartag.tagsector;
                    short nearsprite = Engine.neartag.tagsprite;
                    nearhitdist = Engine.neartag.taghitdist;
                    if (nearsprite < 0 || nearhitdist >= 1024 || !Sector.OperateSprite(nearsprite, false)) continue;
                    u.WaitTics = tpoint.tag_high == 0 ? 240 : tpoint.tag_high * 128;
                    Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Stand);
                }
                if (nearsector < 0 || nearhitdist >= 1024 || !Sector.OperateSector(nearsector, false)) break;
                u.WaitTics = tpoint.tag_high == 0 ? 240 : tpoint.tag_high * 128;
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Sit);
                break;
            }
            case 797: {
                if (u.ActorActionSet.Jump == null || u.track_dir != 1) break;
                u.jump_speed = tpoint.tag_high == 0 ? -384 : (int)(-tpoint.tag_high);
                Actor.DoActorBeginJump(SpriteNum);
                break;
            }
            case 798: {
                if (u.ActorActionSet.Jump == null || u.track_dir != -1) break;
                u.jump_speed = tpoint.tag_high == 0 ? -384 : (int)(-tpoint.tag_high);
                Actor.DoActorBeginJump(SpriteNum);
                break;
            }
            case 772: {
                if (u.getRot() != u.ActorActionSet.Crawl) {
                    Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Crawl);
                    break;
                }
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Rise);
                break;
            }
            case 773: {
                if (u.getRot() != u.ActorActionSet.Swim) {
                    Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Swim);
                    break;
                }
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Rise);
                break;
            }
            case 774: {
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Fly);
                break;
            }
            case 776: {
                if (u.ActorActionSet.Sit == null) break;
                u.WaitTics = tpoint.tag_high == 0 ? 360 : tpoint.tag_high * 128;
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Sit);
                break;
            }
            case 777: {
                if (u.ActorActionSet.Death2 == null) break;
                u.WaitTics = 480;
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Death1);
                break;
            }
            case 778: {
                if (u.ActorActionSet.Death2 == null) break;
                u.WaitTics = 480;
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Death2);
                break;
            }
            case 779: {
                if (u.ActorActionSet.DeathJump == null) break;
                u.Flags |= Gameutils.SPR_DEAD;
                sp.setXvel(sp.getXvel() << 1);
                u.jump_speed = -495;
                Actor.DoActorBeginJump(SpriteNum);
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.DeathJump);
                break;
            }
            case 780: {
                if (u.ActorActionSet.CloseAttack[0] == null) break;
                u.WaitTics = tpoint.tag_high == 0 ? 240 : tpoint.tag_high * 128;
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.CloseAttack[0]);
                break;
            }
            case 781: {
                if (u.ActorActionSet.CloseAttack[1] == null) break;
                u.WaitTics = tpoint.tag_high == 0 ? 480 : tpoint.tag_high * 128;
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.CloseAttack[1]);
                break;
            }
            case 782: 
            case 783: 
            case 784: 
            case 785: 
            case 786: 
            case 787: {
                StateGroup ap = u.ActorActionSet.Attack[tpoint.tag_low - 782];
                if (ap == null) break;
                u.WaitTics = tpoint.tag_high == 0 ? 480 : tpoint.tag_high * 128;
                Sprites.NewStateGroup(SpriteNum, ap);
                break;
            }
            case 759: {
                if (MyTypes.TEST(u.Flags, Gameutils.SPR_ZDIFF_MODE)) {
                    u.Flags &= ~Gameutils.SPR_ZDIFF_MODE;
                    ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(sp.getSectnum());
                    if (sec == null) break;
                    sp.setZ(sec.getFloorz());
                    sp.setZvel(0);
                    break;
                }
                u.Flags |= Gameutils.SPR_ZDIFF_MODE;
                break;
            }
            case 792: {
                if (u.ActorActionSet.Jump == null) break;
                int lspi = Player.FindNearSprite(sp, 53);
                WangSprite lsp = Main.boardService.getSprite(lspi);
                if (lsp == null) {
                    ru.m210projects.Wang.Track.ActorLeaveTrack(SpriteNum);
                    return false;
                }
                int nx = Gameutils.MOVEx(100, lsp.getAng());
                int ny = Gameutils.MOVEy(100, lsp.getAng());
                sp.setX(lsp.getX() + nx);
                sp.setY(lsp.getY() + ny);
                sp.setAng(Gameutils.NORM_ANGLE(lsp.getAng() + 1024));
                Main.engine.neartag(sp.getX(), sp.getY(), Gameutils.SPRITEp_TOS(sp) - MyTypes.DIV2(Gameutils.SPRITEp_SIZE_Z(sp)), sp.getSectnum(), sp.getAng(), Engine.neartag, 600, 3);
                short hitwall = Engine.neartag.tagwall;
                Wall hwall = Main.boardService.getWall(hitwall);
                if (hwall == null) {
                    ru.m210projects.Wang.Track.ActorLeaveTrack(SpriteNum);
                    return false;
                }
                ru.m210projects.Build.Types.Sector nsec = Main.boardService.getSector(hwall.getNextsector());
                if (nsec != null) {
                    u.sz = nsec.getFloorz();
                }
                Sprites.DoActorZrange(SpriteNum);
                sp.setCstat(sp.getCstat() | Gameutils.CSTAT_SPRITE_YCENTER);
                int bos_z = Gameutils.SPRITEp_BOS(sp);
                if (bos_z > u.loz) {
                    u.sy = bos_z - sp.getZ();
                    sp.setZ(sp.getZ() - u.sy);
                }
                u.Flags |= Gameutils.SPR_CLIMBING;
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Climb);
                sp.setZvel(-Gameutils.Z(1));
                break;
            }
            case 793: {
                u.jump_speed = -tpoint.tag_high;
            }
        }
        return true;
    }

    public static void ActorFollowTrack(int SpriteNum, int locktics) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        if (u.track == -1) {
            return;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_WAIT_FOR_PLAYER | Gameutils.SPR_WAIT_FOR_TRIGGER)) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_WAIT_FOR_PLAYER)) {
                short pnum = Mmulti.connecthead;
                while (pnum != -1) {
                    PlayerStr pp = Game.Player[pnum];
                    if (Game.Distance(sp.getX(), sp.getY(), pp.posx, pp.posy) < u.Dist) {
                        u.tgt_sp = pp.PlayerSprite;
                        u.Flags &= ~Gameutils.SPR_WAIT_FOR_PLAYER;
                        return;
                    }
                    pnum = Mmulti.connectpoint2[pnum];
                }
            }
            u.Tics = 0;
            return;
        }
        if (u.WaitTics != 0) {
            u.WaitTics -= locktics;
            if (u.WaitTics <= 0) {
                u.Flags &= ~Gameutils.SPR_DONT_UPDATE_ANG;
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Run);
                u.WaitTics = 0;
            }
            return;
        }
        TRACK_POINT tpoint = ru.m210projects.Wang.Track.Track[u.track].TrackPoint[u.point];
        if (tpoint == null) {
            return;
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_CLIMBING | Gameutils.SPR_DONT_UPDATE_ANG)) {
            sp.setAng(EngineUtils.getAngle(tpoint.x - sp.getX(), tpoint.y - sp.getY()));
        }
        int nx = 0;
        int ny = 0;
        int nz = 0;
        if (Game.Distance(sp.getX(), sp.getY(), tpoint.x, tpoint.y) < 200) {
            if (!ru.m210projects.Wang.Track.ActorTrackDecide(tpoint, SpriteNum)) {
                return;
            }
            ru.m210projects.Wang.Track.NextActorTrackPoint(SpriteNum);
            tpoint = ru.m210projects.Wang.Track.Track[u.track].TrackPoint[u.point];
            if (!MyTypes.TEST(u.Flags, Gameutils.SPR_CLIMBING | Gameutils.SPR_DONT_UPDATE_ANG)) {
                sp.setAng(EngineUtils.getAngle(tpoint.x - sp.getX(), tpoint.y - sp.getY()));
            }
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_ZDIFF_MODE)) {
                int dx = tpoint.x;
                int dy = tpoint.y;
                int dz = tpoint.z;
                int dist = Gameutils.DIST(dx, dy, sp.getX(), sp.getY());
                sp.setZvel(-(sp.getXvel() * (sp.getZ() - dz) / dist));
            }
        } else {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_SPEED_UP)) {
                if ((u.track_vel += locktics << u.vel_rate) >= u.vel_tgt) {
                    u.track_vel = u.vel_tgt;
                    u.Flags &= ~Gameutils.SPR_SPEED_UP;
                }
                sp.setXvel(MyTypes.DIV256(u.track_vel));
            } else if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLOW_DOWN)) {
                if ((u.track_vel -= locktics << u.vel_rate) <= u.vel_tgt) {
                    u.track_vel = u.vel_tgt;
                    u.Flags &= ~Gameutils.SOBJ_SLOW_DOWN;
                }
                sp.setXvel(MyTypes.DIV256(u.track_vel));
            }
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_CLIMBING)) {
                if (Gameutils.SPRITEp_TOS(sp) + MyTypes.DIV4(Gameutils.SPRITEp_SIZE_Z(sp)) < u.sz) {
                    u.Flags &= ~Gameutils.SPR_CLIMBING;
                    sp.setZvel(0);
                    sp.setAng(EngineUtils.getAngle(tpoint.x - sp.getX(), tpoint.y - sp.getY()));
                    ru.m210projects.Wang.Track.ActorLeaveTrack(SpriteNum);
                    sp.setCstat(sp.getCstat() & ~Gameutils.CSTAT_SPRITE_YCENTER);
                    sp.setZ(sp.getZ() + u.sy);
                    Ai.DoActorSetSpeed(SpriteNum, 0);
                    u.ActorActionFunc = Ninja.NinjaJumpActionFunc;
                    u.jump_speed = -650;
                    Actor.DoActorBeginJump(SpriteNum);
                    return;
                }
            } else {
                nx = sp.getXvel() * EngineUtils.sin(Gameutils.NORM_ANGLE(sp.getAng() + 512)) >> 14;
                ny = sp.getXvel() * EngineUtils.sin(sp.getAng()) >> 14;
            }
            if (sp.getZvel() != 0) {
                nz = sp.getZvel() * locktics;
            }
        }
        u.moveSpriteReturn = Sprites.move_sprite(SpriteNum, nx, ny, nz, u.ceiling_dist, u.floor_dist, 0, locktics);
        if (u.moveSpriteReturn != 0 && !MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            ru.m210projects.Wang.Track.ActorLeaveTrack(SpriteNum);
        }
    }

    static {
        Track = new TRACK[100];
        end_point = new int[]{0, 0};
        z = new int[2];
    }
}

