/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Type.CompareService;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Type.CompareService.CompareItem;
import ru.m210projects.Wang.Type.CompareService.IntegerItem;

public class CompareService {
    private static OutputStream writer;
    private static InputStream reader;
    private static Type type;

    public static void prepare(Path path, Type t) {
        type = t;
        try {
            if (type == Type.Write) {
                if (writer != null) {
                    writer.close();
                }
                writer = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));
            } else {
                if (reader != null) {
                    reader.close();
                }
                reader = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
            }
        }
        catch (FileNotFoundException | NoSuchFileException fnf) {
            reader = null;
            writer = null;
            Console.out.println(path + " is not found!", OsdColor.RED);
        }
        catch (IOException e) {
            reader = null;
            writer = null;
            e.printStackTrace();
        }
    }

    @Deprecated
    public static boolean conditionCheck() {
        return Main.gDemoScreen.demfile.rcnt >= 11377 && Main.gDemoScreen.demfile.rcnt <= 11500;
    }

    @Deprecated
    public static boolean conditionUpdate() {
        if (CompareService.conditionCheck()) {
            CompareService.update(Main.gDemoScreen.demfile.rcnt);
            return true;
        }
        return false;
    }

    public static void update(int cnt) {
        if (type == null) {
            return;
        }
        switch (type.ordinal()) {
            case 0: {
                if (reader == null) break;
                try {
                    Packet packet = new Packet(cnt);
                    if (!packet.read(reader)) {
                        System.err.println("Unsync at " + packet.rcnt + " in map " + Game.boardfilename);
                        break;
                    }
                    System.out.println("\u001b[32mDemo file " + Game.boardfilename + " at " + packet.rcnt + " is OK\u001b[0m");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    reader = null;
                }
                break;
            }
            case 1: {
                if (writer == null) break;
                try {
                    Packet packet = new Packet(cnt);
                    packet.write(writer);
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    writer = null;
                }
            }
        }
    }

    public static void close() {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static enum Type {
        Read,
        Write;

    }

    public static class Packet {
        private final int rcnt;
        private final CompareItem[] items;

        public Packet(int rcnt) {
            this.rcnt = rcnt;
            ArrayList<IntegerItem> list = new ArrayList<IntegerItem>();
            list.add(new IntegerItem(Main.engine.getrand(), "bseed"));
            this.items = new CompareItem[list.size()];
            list.toArray(this.items);
        }

        public boolean read(InputStream is) throws IOException {
            boolean[] equals = new boolean[this.items.length + 1];
            equals[0] = this.rcnt == StreamUtils.readInt(is);
            for (int i = 0; i < this.items.length; ++i) {
                equals[i + 1] = this.items[i].compare(is);
            }
            for (boolean equal : equals) {
                if (equal) continue;
                return false;
            }
            return true;
        }

        public void write(OutputStream os) throws IOException {
            StreamUtils.writeInt(os, this.rcnt);
            for (CompareItem item : this.items) {
                item.write(os);
            }
        }
    }
}

