/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Type.CompareService;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.m210projects.Wang.Type.CompareService.StructItem;
import ru.m210projects.Wang.Type.StateGroup;
import ru.m210projects.Wang.Type.USER;

public class UserItem
extends StructItem<USER> {
    public UserItem(USER objectStruct, int index) {
        super(objectStruct, index);
        objectStruct.moveSpriteReturn = UserItem.CONVERT_HIT(objectStruct.moveSpriteReturn);
        StateGroup stateGroup = objectStruct.getRot();
        if (stateGroup != null && stateGroup.index() == -1) {
            objectStruct.setRot(null);
        }
    }

    @Override
    public boolean compare(InputStream is) throws IOException {
        USER readObject = this.readObject(is);
        if (!this.isEquals(readObject, this.objectStruct)) {
            System.out.println("Unsync in " + this.getName());
            return false;
        }
        return true;
    }

    @Override
    protected USER readObject(InputStream is) throws IOException {
        USER u = new USER();
        u.readObject(is);
        return u;
    }

    @Override
    public void write(OutputStream os) throws IOException {
        ((USER)this.objectStruct).writeObject(os);
    }

    public static int CONVERT_HIT(int hit) {
        if (hit == -1) {
            return -1;
        }
        int type = hit & 0xE0000000;
        int index = hit & 0x1FFFFFFF;
        if (hit != 0) {
            switch (type) {
                case -1073741824: {
                    return index | 0xC000;
                }
                case -2147483648: {
                    return index | 0x8000;
                }
                case 0x40000000: {
                    return index | 0x4000;
                }
            }
            return 0;
        }
        return 0;
    }
}

