/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Type;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import ru.m210projects.Build.Script.Scriptfile;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Wang.Type.EpisodeInfo;
import ru.m210projects.Wang.Type.GameInfo;
import ru.m210projects.Wang.Type.LevelInfo;

public class CustomScript
extends Scriptfile {
    private final Map<String, Token> cm_tokens = new HashMap<String, Token>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("map", Token.CM_MAP);
            this.put("level", Token.CM_MAP);
            this.put("episode", Token.CM_EPISODE);
        }
    };
    private final Map<String, Token> cm_map_tokens = new HashMap<String, Token>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("title", Token.CM_TITLE);
            this.put("name", Token.CM_TITLE);
            this.put("description", Token.CM_TITLE);
            this.put("filename", Token.CM_FILENAME);
            this.put("file", Token.CM_FILENAME);
            this.put("fn", Token.CM_FILENAME);
            this.put("levelname", Token.CM_FILENAME);
            this.put("song", Token.CM_SONG);
            this.put("music", Token.CM_SONG);
            this.put("songname", Token.CM_SONG);
            this.put("cdatrack", Token.CM_CDATRACK);
            this.put("cdtrack", Token.CM_CDATRACK);
            this.put("besttime", Token.CM_BESTTIME);
            this.put("partime", Token.CM_PARTIME);
        }
    };
    private final Map<String, Token> cm_episode_tokens = new HashMap<String, Token>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("title", Token.CM_TITLE);
            this.put("name", Token.CM_TITLE);
            this.put("description", Token.CM_TITLE);
            this.put("subtitle", Token.CM_SUBTITLE);
        }
    };
    private final LevelInfo[] custommaps = new LevelInfo[29];
    private final EpisodeInfo[] customepisodes = new EpisodeInfo[2];

    public CustomScript(Entry entry) {
        super("", entry);
        LevelInfo map;
        EpisodeInfo ep;
        int i;
        this.parse();
        for (i = 1; i < 5; ++i) {
            ep = this.customepisodes[0];
            map = this.custommaps[i];
            if (map == null) continue;
            ep.gMapInfo[i - 1] = map;
            ++ep.nMaps;
        }
        for (i = 5; i < 29; ++i) {
            ep = this.customepisodes[1];
            map = this.custommaps[i];
            if (map == null) continue;
            ep.gMapInfo[i - 5] = map;
            ++ep.nMaps;
        }
    }

    public void apply(GameInfo game) {
        String title = null;
        for (int i = 0; i < 2; ++i) {
            if (this.customepisodes[i] == null || this.customepisodes[i].Title == null || this.customepisodes[i].Title.isEmpty()) continue;
            title = this.customepisodes[i].Title;
            break;
        }
        game.episode = this.customepisodes;
        if (title != null) {
            game.Title = title;
        }
    }

    private Token gettoken(Map<String, Token> list) {
        int tok = this.gettoken();
        if (tok == -2) {
            return Token.T_EOF;
        }
        Token out = list.get(Strhandler.toLowerCase(this.textbuf.substring(tok, this.textptr)));
        if (out != null) {
            return out;
        }
        this.errorptr = this.textptr;
        return Token.T_ERROR;
    }

    private int getnumber() {
        String txt = this.getstring();
        if (txt == null) {
            return -1;
        }
        txt = txt.replaceAll("[^0-9]", "");
        try {
            return Integer.parseInt(txt);
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Override
    public String getstring() {
        int out = this.gettoken();
        if (out == -1 || out == -2) {
            return null;
        }
        String txt = this.textbuf.substring(out, this.textptr);
        txt = txt.replaceAll("\"", "");
        return txt.replace("/", File.separator);
    }

    private void parse() {
        char[] buf = new char[10];
        block16: while (!this.eof()) {
            Token tokn = this.gettoken(this.cm_tokens);
            int line = this.getlinum(this.textptr);
            switch (tokn.ordinal()) {
                case 0: {
                    int braceend;
                    Arrays.fill(buf, '\u0000');
                    int curmap = this.getnumber();
                    if (curmap == -1 || (braceend = this.getbraces()) == -1) break;
                    if (curmap < 1 || curmap > 29) {
                        Console.out.println("Error: map number " + curmap + " not in range 1-" + 29 + " on line " + this.filename + ":" + line);
                        this.textptr = braceend;
                        break;
                    }
                    LevelInfo ptrmap = this.custommaps[curmap] = new LevelInfo("", "", "", "", "");
                    block17: while (this.textptr <= braceend) {
                        switch (this.gettoken(this.cm_map_tokens).ordinal()) {
                            case 3: {
                                ptrmap.LevelName = Strhandler.toLowerCase(this.getstring());
                                continue block17;
                            }
                            case 4: {
                                ptrmap.SongName = Strhandler.toLowerCase(this.getstring());
                                continue block17;
                            }
                            case 2: {
                                ptrmap.Description = this.getstring();
                                continue block17;
                            }
                            case 6: {
                                int best = this.getnumber();
                                Strhandler.buildString(buf, Strhandler.Bitoa(best / 60, buf), ":", best % 60, 2);
                                ptrmap.BestTime = new String(buf).trim();
                                continue block17;
                            }
                            case 7: {
                                int par = this.getnumber();
                                Strhandler.buildString(buf, Strhandler.Bitoa(par / 60, buf), ":", par % 60, 2);
                                ptrmap.ParTime = new String(buf).trim();
                                continue block17;
                            }
                            case 5: {
                                ptrmap.CDtrack = this.getnumber();
                                continue block17;
                            }
                        }
                        if (this.ltextptr == braceend + 1) continue;
                        Console.out.println("Error on line " + this.filename + ":" + this.getlinum(this.textptr));
                    }
                    continue block16;
                }
                case 1: {
                    int braceend;
                    int curep = this.getnumber();
                    if (curep == -1 || (braceend = this.getbraces()) == -1) break;
                    if (curep < 1 || curep > 2) {
                        Console.out.println("Error: episode number " + curep + " not in range 1-2 on line " + this.filename + ":" + line);
                        this.textptr = braceend;
                        break;
                    }
                    EpisodeInfo ep = this.customepisodes[--curep] = new EpisodeInfo();
                    block18: while (this.textptr <= braceend) {
                        switch (this.gettoken(this.cm_episode_tokens).ordinal()) {
                            case 2: {
                                ep.Title = this.getstring();
                                continue block18;
                            }
                            case 8: {
                                ep.Description = this.getstring();
                                continue block18;
                            }
                        }
                        if (this.ltextptr == braceend + 1) continue;
                        Console.out.println("Error on line " + this.filename + ":" + this.getlinum(this.textptr));
                    }
                    continue block16;
                }
                default: {
                    Console.out.println("Error on line " + this.filename + ":" + this.getlinum(this.textptr));
                }
            }
        }
    }

    private static enum Token {
        CM_MAP,
        CM_EPISODE,
        CM_TITLE,
        CM_FILENAME,
        CM_SONG,
        CM_CDATRACK,
        CM_BESTTIME,
        CM_PARTIME,
        CM_SUBTITLE,
        T_EOF,
        T_ERROR;

    }
}

