/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Type;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import ru.m210projects.Build.filehandle.StreamUtils;

public class MirrorType {
    public int mirrorwall;
    public int mirrorsector;
    public int camera;
    public int camsprite;
    public int campic;
    public int numspawnspots;
    public final short[] spawnspots = new short[4];
    public boolean ismagic;
    public MirrorState mstate;
    public int maxtics;
    public int tics;

    public void reset() {
        this.mirrorwall = -1;
        this.mirrorsector = -1;
        this.camera = -1;
        this.camsprite = -1;
        this.campic = -1;
        this.numspawnspots = -1;
        Arrays.fill(this.spawnspots, (short)-1);
        this.ismagic = false;
        this.mstate = null;
        this.maxtics = -1;
        this.tics = -1;
    }

    public void save(OutputStream os) throws IOException {
        StreamUtils.writeShort(os, this.mirrorwall);
        StreamUtils.writeShort(os, this.mirrorsector);
        StreamUtils.writeShort(os, this.camera);
        StreamUtils.writeShort(os, this.camsprite);
        StreamUtils.writeShort(os, this.campic);
        StreamUtils.writeShort(os, this.numspawnspots);
        for (short v : this.spawnspots) {
            StreamUtils.writeShort(os, v);
        }
        StreamUtils.writeBoolean(os, this.ismagic);
        StreamUtils.writeByte(os, this.mstate != null ? this.mstate.ordinal() : -1);
        StreamUtils.writeInt(os, this.maxtics);
        StreamUtils.writeInt(os, this.tics);
    }

    public void load(InputStream is) throws IOException {
        int i;
        this.mirrorwall = StreamUtils.readShort(is);
        this.mirrorsector = StreamUtils.readShort(is);
        this.camera = StreamUtils.readShort(is);
        this.camsprite = StreamUtils.readShort(is);
        this.campic = StreamUtils.readShort(is);
        this.numspawnspots = StreamUtils.readShort(is);
        for (i = 0; i < 4; ++i) {
            this.spawnspots[i] = StreamUtils.readShort(is);
        }
        this.ismagic = StreamUtils.readBoolean(is);
        i = StreamUtils.readByte(is);
        this.mstate = i != -1 ? MirrorState.values()[i] : null;
        this.maxtics = StreamUtils.readInt(is);
        this.tics = StreamUtils.readInt(is);
    }

    public void copy(MirrorType src) {
        this.mirrorwall = src.mirrorwall;
        this.mirrorsector = src.mirrorsector;
        this.camera = src.camera;
        this.camsprite = src.camsprite;
        this.campic = src.campic;
        this.numspawnspots = src.numspawnspots;
        System.arraycopy(src.spawnspots, 0, this.spawnspots, 0, 4);
        this.ismagic = src.ismagic;
        this.mstate = src.mstate;
        this.maxtics = src.maxtics;
        this.tics = src.tics;
    }

    public static enum MirrorState {
        m_normal,
        m_viewon,
        m_pissed;

    }
}

