/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Type;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Render.ModelHandle.Voxel.VoxelData;
import ru.m210projects.Build.Render.ModelHandle.VoxelInfo;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Script.Scriptfile;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Wang.Main;

public class VoxelScript
extends Scriptfile {
    private final String[] aVoxelArray = new String[Engine.MAXTILES];

    public VoxelScript(Entry res) {
        super("", res);
        this.parse();
    }

    private void parse() {
        while (!this.eof()) {
            int lTile = this.getnumber();
            this.getnumber();
            String filename = this.getstring();
            if (filename == null || !Gameutils.isValidTile(lTile)) continue;
            this.aVoxelArray[lTile] = filename;
        }
    }

    public void apply(DefScript def) {
        for (int i = 0; i < Engine.MAXTILES; ++i) {
            Entry entry;
            if (this.aVoxelArray[i] == null || !(entry = Main.game.getCache().getEntry(this.aVoxelArray[i], true)).exists()) continue;
            try {
                VoxelData vox = new VoxelData(entry);
                def.mdInfo.addVoxelInfo(new VoxelInfo(vox), i);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private int getnumber() {
        String txt = this.getstring();
        if (txt == null) {
            return -1;
        }
        if ((txt = txt.replaceAll("[^0-9]", "")).isEmpty()) {
            return -1;
        }
        try {
            return Integer.parseInt(txt);
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Override
    protected void preparse(byte[] data, int flen) {
        int numcr = 1;
        for (int i = 0; i < flen; ++i) {
            boolean cr = false;
            if (data[i] == 13) {
                i += data[i + 1] == 10 ? 1 : 0;
                cr = true;
            } else if (data[i] == 10) {
                i += data[i + 1] == 13 ? 1 : 0;
                cr = true;
            }
            if (!cr) continue;
            ++numcr;
        }
        this.linenum = numcr;
        this.lineoffs = new int[numcr];
        int nflen = 0;
        boolean space = false;
        int cs = 0;
        boolean inquote = false;
        numcr = 0;
        for (int i = 0; i < flen; ++i) {
            boolean cr = false;
            if (data[i] == 13) {
                i += data[i + 1] == 10 ? 1 : 0;
                cr = true;
            } else if (data[i] == 10) {
                i += data[i + 1] == 13 ? 1 : 0;
                cr = true;
            }
            if (cr) {
                this.lineoffs[numcr++] = nflen;
                if (cs == 1) {
                    cs = 0;
                }
                space = true;
                continue;
            }
            if (!(inquote || data[i] != 32 && data[i] != 9)) {
                space = true;
                continue;
            }
            if (data[i] == 35 && cs == 0) {
                cs = 1;
            }
            if (data[i] == 47 && data[i + 1] == 47 && cs == 0) {
                cs = 1;
            }
            if (data[i] == 92 && data[i + 1] == 92 && cs == 0) {
                cs = 1;
            }
            if (data[i] == 47 && data[i + 1] == 42 && cs == 0) {
                space = true;
                cs = 2;
            }
            if (data[i] == 42 && data[i + 1] == 47 && cs == 2) {
                cs = 0;
                ++i;
                continue;
            }
            if (cs != 0) continue;
            if (space) {
                data[nflen++] = 0;
                space = false;
            }
            if (data[i] == 92 && data[i + 1] == 34) {
                ++i;
                data[nflen++] = 34;
                continue;
            }
            if (data[i] == 34) {
                inquote ^= true;
                continue;
            }
            data[nflen++] = data[i];
        }
        data[nflen++] = 0;
        this.lineoffs[numcr] = nflen;
        data[nflen++] = 0;
        this.textbuf = new String(data);
        this.textptr = 0;
        this.eof = nflen - 1;
    }
}

