/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.LONGp;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Sector_Object;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class WallMove {
    private static final LONGp nx = new LONGp();
    private static final LONGp ny = new LONGp();

    public static void SOwallmove(Sector_Object sop, int sp, Wall find_WALL, int dist, LONGp nx, LONGp ny) {
        USER u = Gameutils.getUser(sp);
        if (u == null || MyTypes.TEST(sop.flags, Gameutils.SOBJ_SPRITE_OBJ)) {
            return;
        }
        int wallcount = 0;
        int j = 0;
        while (sop.sector[j] != -1) {
            Sector sectp = Main.boardService.getSector(sop.sector[j]);
            if (sectp != null) {
                for (ListNode<Wall> wn = sectp.getWallNode(); wn != null; wn = wn.getNext()) {
                    Wall wp = wn.get();
                    if (wp == find_WALL) {
                        int ang = u.sang;
                        nx.value = dist * EngineUtils.sin(Gameutils.NORM_ANGLE(ang + 512)) >> 14;
                        ny.value = dist * EngineUtils.sin(ang) >> 14;
                        int n = wallcount;
                        sop.xorig[n] = sop.xorig[n] - nx.value;
                        int n2 = wallcount;
                        sop.yorig[n2] = sop.yorig[n2] - ny.value;
                        sop.flags |= Gameutils.SOBJ_UPDATE_ONCE;
                        return;
                    }
                    ++wallcount;
                }
            }
            ++j;
        }
    }

    public static void DoWallMove(int spnum) {
        WangSprite sp = Main.boardService.getSprite(spnum);
        if (sp == null) {
            return;
        }
        int dist = Gameutils.SP_TAG13(sp);
        int ang = Gameutils.SP_TAG4(sp);
        int picnum1 = Gameutils.SP_TAG5(sp);
        int picnum2 = Gameutils.SP_TAG6(sp);
        int shade1 = Gameutils.SP_TAG7(sp);
        int shade2 = Gameutils.SP_TAG8(sp);
        int dang = Gameutils.SP_TAG10(sp) << 3;
        if (dang != 0) {
            ang = Gameutils.NORM_ANGLE(ang + (Gameutils.RANDOM_RANGE(dang) - dang / 2));
        }
        WallMove.nx.value = dist * EngineUtils.sin(Gameutils.NORM_ANGLE(ang + 512)) >> 14;
        WallMove.ny.value = dist * EngineUtils.sin(ang) >> 14;
        boolean SOsprite = false;
        Wall[] walls = Main.boardService.getBoard().getWalls();
        for (int w = 0; w < walls.length; ++w) {
            int prev_wall;
            Wall pw;
            Wall WALL = walls[w];
            if (WALL.getX() != sp.getX() || WALL.getY() != sp.getY()) continue;
            if (MyTypes.TEST(WALL.getExtra(), Gameutils.WALLFX_SECTOR_OBJECT)) {
                Sector_Object sop = Track.DetectSectorObjectByWall(WALL);
                WallMove.SOwallmove(sop, spnum, WALL, dist, nx, ny);
                SOsprite = true;
            } else {
                WALL.setX(sp.getX() + WallMove.nx.value);
                WALL.setY(sp.getY() + WallMove.ny.value);
            }
            if (shade1 != 0) {
                WALL.setShade((byte)shade1);
            }
            if (picnum1 != 0) {
                WALL.setPicnum(picnum1);
            }
            if ((pw = Main.boardService.getWall(prev_wall = Weapon.PrevWall(w))) == null) continue;
            if (shade2 != 0) {
                pw.setShade((byte)shade2);
            }
            if (picnum2 == 0) continue;
            pw.setPicnum(picnum2);
        }
        Gameutils.SET_SP_TAG9(sp, Gameutils.SP_TAG9(sp) - 1);
        if ((byte)Gameutils.SP_TAG9(sp) <= 0) {
            Sprites.KillSprite(spnum);
        } else {
            USER u = Gameutils.getUser(spnum);
            if (u != null && SOsprite) {
                u.sx -= WallMove.nx.value;
                u.sy -= WallMove.ny.value;
            } else {
                sp.setX(sp.getX() + WallMove.nx.value);
                sp.setY(sp.getY() + WallMove.ny.value);
            }
        }
    }

    public static boolean CanSeeWallMove(Sprite wp, int match) {
        boolean found = false;
        ListNode<Sprite> node = Main.boardService.getStatNode(79);
        while (node != null) {
            ListNode<Sprite> nexti = node.getNext();
            Sprite sp = node.get();
            if (Gameutils.SP_TAG2(sp) == match) {
                found = true;
                if (Main.engine.cansee(wp.getX(), wp.getY(), wp.getZ(), wp.getSectnum(), sp.getX(), sp.getY(), sp.getZ(), sp.getSectnum())) {
                    return true;
                }
            }
            node = nexti;
        }
        return !found;
    }

    public static boolean DoWallMoveMatch(int match) {
        boolean found = false;
        ListNode<Sprite> node = Main.boardService.getStatNode(78);
        while (node != null) {
            int i = node.getIndex();
            ListNode<Sprite> nexti = node.getNext();
            Sprite sp = node.get();
            if (Gameutils.SP_TAG2(sp) == match) {
                found = true;
                WallMove.DoWallMove(i);
            }
            node = nexti;
        }
        return found;
    }
}

