/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import java.util.Arrays;
import ru.m210projects.Build.Types.BuildPos;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Type.MyTypes;

public class Warp {
    private static final int[] match_rand = new int[16];
    public static final BuildPos warp = new BuildPos();
    private static Sprite WarpPlaneSectorInfo_fl;
    private static Sprite WarpPlaneSectorInfo_ceil;

    private static boolean WarpPlaneSectorInfo(int sectnum) {
        WarpPlaneSectorInfo_fl = null;
        WarpPlaneSectorInfo_ceil = null;
        if (WangNetwork.Prediction) {
            return false;
        }
        Sector sec = Main.boardService.getSector(sectnum);
        if (sec != null && !MyTypes.TEST(sec.getExtra(), Gameutils.SECTFX_WARP_SECTOR)) {
            return false;
        }
        for (ListNode<Sprite> node = Main.boardService.getStatNode(62); node != null; node = node.getNext()) {
            Sprite sp = node.get();
            if (sp.getSectnum() != sectnum || Gameutils.SP_TAG10(sp) == 1) continue;
            if (sp.getHitag() == 85) {
                WarpPlaneSectorInfo_ceil = sp;
                continue;
            }
            if (sp.getHitag() != 86) continue;
            WarpPlaneSectorInfo_fl = sp;
        }
        return true;
    }

    public static Sprite WarpPlane(int x, int y, int z, int sectnum) {
        if (WangNetwork.Prediction) {
            return null;
        }
        if (!Warp.WarpPlaneSectorInfo(sectnum)) {
            return null;
        }
        if (WarpPlaneSectorInfo_ceil != null && z <= WarpPlaneSectorInfo_ceil.getZ()) {
            return Warp.WarpToArea(WarpPlaneSectorInfo_ceil, x, y, z);
        }
        if (WarpPlaneSectorInfo_fl != null && z >= WarpPlaneSectorInfo_fl.getZ()) {
            return Warp.WarpToArea(WarpPlaneSectorInfo_fl, x, y, z);
        }
        return null;
    }

    private static Sprite WarpToArea(Sprite sp_from, int x, int y, int z) {
        Sprite sp = sp_from;
        short to_tag = 0;
        int z_adj = 0;
        int xoff = x - sp.getX();
        int yoff = y - sp.getY();
        int zoff = z - sp.getZ();
        int match = sp.getLotag();
        Arrays.fill(match_rand, 0);
        switch (sp.getHitag()) {
            case 84: {
                to_tag = 84;
                if (Gameutils.SP_TAG5(sp) == 0) break;
                int ndx = 0;
                Warp.match_rand[ndx++] = Gameutils.SP_TAG2(sp);
                Warp.match_rand[ndx++] = Gameutils.SP_TAG5(sp);
                if (Gameutils.SP_TAG6(sp) != 0) {
                    Warp.match_rand[ndx++] = Gameutils.SP_TAG6(sp);
                }
                if (Gameutils.SP_TAG7(sp) != 0) {
                    Warp.match_rand[ndx++] = Gameutils.SP_TAG7(sp);
                }
                if (Gameutils.SP_TAG8(sp) != 0) {
                    Warp.match_rand[ndx++] = Gameutils.SP_TAG8(sp);
                }
                match = match_rand[Gameutils.RANDOM_RANGE(ndx)];
                break;
            }
            case 85: {
                to_tag = 86;
                z_adj = -Gameutils.Z(2);
                break;
            }
            case 86: {
                to_tag = 85;
                z_adj = Gameutils.Z(2);
            }
        }
        for (ListNode<Sprite> node = Main.boardService.getStatNode(62); node != null; node = node.getNext()) {
            sp = node.get();
            if (sp.getLotag() != match || sp == sp_from || sp.getHitag() != to_tag) continue;
            x = Warp.warp.x = sp.getX() + xoff;
            y = Warp.warp.y = sp.getY() + yoff;
            z = sp.getZ() + zoff;
            Warp.warp.z = z += z_adj;
            Warp.warp.sectnum = Main.engine.updatesector(x, y, sp.getSectnum());
            int sectnum = Warp.warp.sectnum;
            if (sectnum < 0) continue;
            return sp;
        }
        return null;
    }

    public static Sprite WarpSectorInfo(int sectnum) {
        Sector sec = Main.boardService.getSector(sectnum);
        Sprite sp_warp = null;
        if (sec != null && !MyTypes.TEST(sec.getExtra(), Gameutils.SECTFX_WARP_SECTOR)) {
            return null;
        }
        for (ListNode<Sprite> node = Main.boardService.getStatNode(62); node != null; node = node.getNext()) {
            Sprite sp = node.get();
            if (sp.getSectnum() != sectnum || Gameutils.SP_TAG10(sp) == 1 || sp.getHitag() != 84) continue;
            sp_warp = sp;
        }
        return sp_warp;
    }

    public static Sprite WarpM(int x, int y, int z, int sectnum) {
        if (WangNetwork.Prediction) {
            return null;
        }
        Sprite sp_warp = Warp.WarpSectorInfo(sectnum);
        if (sp_warp != null) {
            return Warp.WarpToArea(sp_warp, x, y, z);
        }
        return null;
    }
}

