/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Weapons;

import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Panel;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Type.List;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Panel_Sprite;
import ru.m210projects.Wang.Type.Panel_Sprite_Func;
import ru.m210projects.Wang.Type.Panel_State;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Weapon;
import ru.m210projects.Wang.Weapons.Sword;

public class Fist {
    public static final int FIST_REST = 4070;
    public static final int FIST_SWING0 = 4071;
    public static final int FIST_SWING1 = 4072;
    public static final int FIST_SWING2 = 4073;
    public static final int FIST2_REST = 4050;
    private static final int FIST_SWAY_AMT = 12;
    private static final int FIST_XOFF = 302;
    private static final int FIST_YOFF = 200;
    private static final int FISTR_XOFF = -80;
    private static final int Fist_BEAT_RATE = 16;
    private static final int ID_FistPresent0 = 4070;
    private static final int ID_Fist2Present0 = 4050;
    private static final int ID_FistSwing0 = 4071;
    private static final int ID_FistSwing1 = 4072;
    private static final int ID_FistSwing2 = 4073;
    private static final Panel_State ps_FistSwing_9 = new Panel_State(9, 4073, 2, null);
    private static final int ID_Kick0 = 4080;
    private static final int ID_Kick1 = 4081;
    private static final Panel_Sprite_Func pFistHide = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            int picnum = psp.picndx;
            psp.y += 9;
            if (psp.y >= 200 + Main.engine.getTile(picnum).getHeight()) {
                psp.y = 200 + Main.engine.getTile(picnum).getHeight();
                Panel.pWeaponUnHideKeys(psp, psp.PresentState);
            }
        }
    };
    private static final Panel_State[] ps_FistHide = new Panel_State[]{new Panel_State(4070, 16, pFistHide).setNext()};
    private static final Panel_Sprite_Func pFistRetract = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            int picnum = psp.picndx;
            psp.y += 9;
            if (psp.y >= 200 + Main.engine.getTile(picnum).getHeight()) {
                PlayerStr pp = Game.Player[psp.PlayerP];
                pp.Flags &= ~Gameutils.PF_WEAPON_RETRACT;
                pp.Wpn[0] = null;
                Panel.pKillSprite(psp);
            }
        }
    };
    private static final Panel_State[] ps_RetractFist = new Panel_State[]{new Panel_State(4070, 16, pFistRetract).setNext()};
    private static final int FIST_PAUSE_TICS = 6;
    private static final Panel_State ps_FistSwing_0 = new Panel_State(0, 4071, 6, null);
    private static final Panel_Sprite_Func pFistRest = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            if (Panel.pWeaponHideKeys(psp, ps_FistHide[0])) {
                return;
            }
            psp.yorig += 3;
            if (psp.yorig > 200) {
                psp.yorig = 200;
            }
            psp.y = psp.yorig;
            PlayerStr pp = Game.Player[psp.PlayerP];
            Fist.pFistBobSetup(psp);
            Panel.pWeaponBob(psp, Gameutils.PLAYER_MOVING(pp) != 0);
            boolean force = MyTypes.TEST(psp.flags, Panel.PANF_UNHIDE_SHOOT);
            if (psp.ActionState == ps_Kick[0]) {
                psp.ActionState = ps_FistSwing[0];
            }
            pp.WpnKungFuMove = 0;
            if ((Gameutils.TEST_SYNC_KEY(pp, 17) || force) && (Gameutils.FLAG_KEY_PRESSED(pp, 17) || force)) {
                psp.flags &= ~Panel.PANF_UNHIDE_SHOOT;
                psp.ActionState = ps_FistSwing[0];
                Panel.pSetState(psp, psp.ActionState);
                psp.vel = 5500;
                psp.ang = 1024;
                pp.FistAng = FistAngTable[Gameutils.RANDOM_RANGE(FistAngTable.length)];
                Player.DoPlayerSpriteThrow(pp);
            }
        }
    };
    private static final int FIST_SLIDE_TICS = 6;
    private static final Panel_State ps_FistSwing_1 = new Panel_State(1, 4072, 6, null);
    private static final int FIST_MID_SLIDE_TICS = 16;
    private static final Panel_Sprite_Func pFistAttack = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            Weapon.InitFistAttack(psp.PlayerP());
        }
    };
    private static final Panel_State ps_FistSwing_2 = new Panel_State(2, 4073, 0, pFistAttack);
    private static final Panel_State ps_FistSwing_6 = new Panel_State(6, 4073, 0, pFistAttack);
    private static final Panel_State[] ps_FistRest = new Panel_State[]{new Panel_State(4070, 16, pFistRest).setNext()};
    private static final int KICK_PAUSE_TICS = 40;
    private static final int KICK_SLIDE_TICS = 30;
    private static final int KICK_MID_SLIDE_TICS = 20;
    private static final Panel_State ps_Kick_0 = new Panel_State(0, 4080, 40, null);
    private static final Panel_State ps_Kick_1 = new Panel_State(1, 4081, 0, pFistAttack);
    private static final Panel_State ps_Kick_2 = new Panel_State(2, 4081, 30, null);
    private static final Panel_Sprite_Func pFistPresent = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            if (MyTypes.TEST(Game.Player[psp.PlayerP].Flags, Gameutils.PF_WEAPON_RETRACT)) {
                return;
            }
            psp.y -= 9;
            if (psp.y < 200) {
                psp.yorig = psp.y = 200;
                int rnd = Gameutils.RANDOM_RANGE(1000);
                if (rnd > 500) {
                    psp.PresentState = ps_PresentFist[0];
                    psp.RestState = ps_FistRest[0];
                } else {
                    psp.PresentState = ps_PresentFist2[0];
                    psp.RestState = ps_Fist2Rest[0];
                }
                Panel.pSetState(psp, psp.RestState);
            }
        }
    };
    private static final Panel_State ps_Kick_5 = new Panel_State(5, 4080, 30, null);
    private static final Panel_State ps_Kick_6 = new Panel_State(6, 4081, 0, pFistAttack);
    private static final Panel_State ps_Kick_9 = new Panel_State(9, 4081, 30, null);
    private static final Panel_Sprite_Func FistBlur = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            psp.kill_tics -= 3;
            if (psp.kill_tics <= 0) {
                Panel.pKillSprite(psp);
                return;
            }
            if (psp.kill_tics <= 6) {
                psp.flags |= Panel.PANF_TRANS_FLIP;
            }
            psp.shade += 10;
            List.Delete(psp);
            --psp.priority;
            Panel.InsertPanelSprite(psp.PlayerP(), psp);
        }
    };
    private static final Panel_Sprite_Func pFistSlideR = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            int x = Panel.castLongX(psp);
            int y = Panel.castLongY(psp);
            Fist.SpawnFistBlur(psp);
            int vel_adj = 68;
            Panel.setLong(psp, x, y += psp.vel * 3 * -EngineUtils.sin(Gameutils.NORM_ANGLE(psp.ang + 1024)) >> 6);
            psp.vel += vel_adj * 3;
        }
    };
    private static final Panel_State ps_FistSwing_5 = new Panel_State(5, 4072, 6, pFistSlideR);
    private static final Panel_State[] ps_PresentFist = new Panel_State[]{new Panel_State(4070, 16, pFistPresent).setNext()};
    private static final short[] FistAngTable = new short[]{82, 168, 320};
    private static final Panel_State[] ps_PresentFist2 = new Panel_State[]{new Panel_State(4050, 16, pFistPresent).setNext()};
    private static final Panel_State[] ps_Fist2Rest = new Panel_State[]{new Panel_State(4050, 16, pFistRest).setNext()};
    private static final Panel_Sprite_Func pFistSlideDown = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            int x = Panel.castLongX(psp);
            int y = Panel.castLongY(psp);
            Fist.SpawnFistBlur(psp);
            int vel_adj = 48;
            int vel = 3500;
            if (psp.ActionState == ps_Kick[0] || psp.PlayerP().WpnKungFuMove == 3) {
                y += psp.vel * 3 * -EngineUtils.sin(Gameutils.NORM_ANGLE(psp.ang + psp.PlayerP().FistAng)) >> 6;
            } else {
                x -= psp.vel * 3 * EngineUtils.sin(Gameutils.NORM_ANGLE(psp.ang + psp.PlayerP().FistAng)) >> 6;
                y += 3 * (psp.vel * 3 * -EngineUtils.sin(Gameutils.NORM_ANGLE(psp.ang + psp.PlayerP().FistAng)) >> 6);
            }
            Panel.setLong(psp, x, y);
            psp.vel += vel_adj * 3;
            if (psp.y > 440) {
                if (Gameutils.TEST_SYNC_KEY(psp.PlayerP(), 17) && Gameutils.FLAG_KEY_PRESSED(psp.PlayerP(), 17)) {
                    Panel.DoPlayerChooseYell(psp.PlayerP());
                    if (Gameutils.RANDOM_RANGE(1000) > 500) {
                        psp.ActionState = ps_FistSwing[0];
                        psp.PlayerP().WpnKungFuMove = 0;
                        Panel.pSetState(psp, psp.ActionState);
                        psp.x = 302;
                        psp.yorig = psp.y = 200;
                        psp.PlayerP().FistAng = FistAngTable[Gameutils.RANDOM_RANGE(FistAngTable.length)];
                        psp.ang = 1024;
                        psp.vel = vel;
                        Player.DoPlayerSpriteThrow(psp.PlayerP());
                        return;
                    }
                    Panel.pSetState(psp, ps_FistSwing[(psp.State.id - psp.ActionState.id + 2) % ps_FistSwing.length]);
                    psp.ActionState = ps_FistSwing[0];
                    psp.PlayerP().WpnKungFuMove = 0;
                    psp.x = 20;
                    psp.yorig = psp.y = 200;
                    psp.ang = 1024;
                    psp.PlayerP().FistAng = FistAngTable[Gameutils.RANDOM_RANGE(FistAngTable.length)];
                    psp.vel = vel;
                    Player.DoPlayerSpriteThrow(psp.PlayerP());
                    return;
                }
                Panel.pSetState(psp, psp.PresentState);
                psp.x = 302;
                psp.y = 200;
                psp.y += Main.engine.getTile(psp.picndx).getHeight();
                psp.yorig = psp.y;
            }
        }
    };
    private static final Panel_Sprite_Func pFistSlideDownR = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            int x = Panel.castLongX(psp);
            int y = Panel.castLongY(psp);
            Fist.SpawnFistBlur(psp);
            int vel_adj = 48;
            int vel = 3500;
            if (psp.ActionState == ps_Kick[0] || psp.PlayerP().WpnKungFuMove == 3) {
                y += psp.vel * 3 * -EngineUtils.sin(Gameutils.NORM_ANGLE(psp.ang + psp.PlayerP().FistAng)) >> 6;
            } else {
                x -= psp.vel * 3 * EngineUtils.sin(Gameutils.NORM_ANGLE(psp.ang + psp.PlayerP().FistAng)) >> 6;
                y += 3 * (psp.vel * 3 * -EngineUtils.sin(Gameutils.NORM_ANGLE(psp.ang + psp.PlayerP().FistAng)) >> 6);
            }
            Panel.setLong(psp, x, y);
            psp.vel += vel_adj * 3;
            if (psp.y > 440) {
                if (Gameutils.TEST_SYNC_KEY(psp.PlayerP(), 17) && Gameutils.FLAG_KEY_PRESSED(psp.PlayerP(), 17)) {
                    Panel.DoPlayerChooseYell(psp.PlayerP());
                    if (Gameutils.RANDOM_RANGE(1000) > 500) {
                        psp.ActionState = ps_FistSwing[5];
                        psp.PlayerP().WpnKungFuMove = 0;
                        Panel.pSetState(psp, psp.ActionState);
                        psp.x = 20;
                        psp.yorig = psp.y = 200;
                        psp.ang = 1024;
                        psp.PlayerP().FistAng = FistAngTable[Gameutils.RANDOM_RANGE(FistAngTable.length)];
                        psp.vel = vel;
                        Player.DoPlayerSpriteThrow(psp.PlayerP());
                        return;
                    }
                    Panel.pSetState(psp, ps_FistSwing[(psp.State.id - psp.ActionState.id + 2) % ps_FistSwing.length / 2]);
                    psp.ActionState = ps_FistSwing[0];
                    psp.PlayerP().WpnKungFuMove = 0;
                    psp.x = 302;
                    psp.yorig = psp.y = 200;
                    psp.PlayerP().FistAng = FistAngTable[Gameutils.RANDOM_RANGE(FistAngTable.length)];
                    psp.ang = 1024;
                    psp.vel = vel;
                    Player.DoPlayerSpriteThrow(psp.PlayerP());
                    return;
                }
                Panel.pSetState(psp, psp.PresentState);
                psp.x = 302;
                psp.y = 200;
                psp.y += Main.engine.getTile(psp.picndx).getHeight();
                psp.yorig = psp.y;
            }
        }
    };
    private static final Panel_State ps_FistSwing_3 = new Panel_State(3, 4073, 16, pFistSlideDown);
    private static final Panel_State ps_FistSwing_4 = new Panel_State(4, 4073, 2, pFistSlideDown);
    private static final Panel_State ps_FistSwing_7 = new Panel_State(7, 4073, 16, pFistSlideDownR);
    private static final Panel_State ps_FistSwing_8 = new Panel_State(8, 4073, 2, pFistSlideDownR);
    private static final Panel_State[] ps_FistSwing = new Panel_State[]{ps_FistSwing_0.setNext(ps_FistSwing_1), ps_FistSwing_1.setNext(ps_FistSwing_2), ps_FistSwing_2.setNext(ps_FistSwing_3).setFlags(Panel.psf_QuickCall), ps_FistSwing_3.setNext(ps_FistSwing_4), ps_FistSwing_4.setNext(), ps_FistSwing_5.setNext(ps_FistSwing_6).setFlags(Panel.psf_Xflip), ps_FistSwing_6.setNext(ps_FistSwing_7).setFlags(Panel.psf_QuickCall | Panel.psf_Xflip), ps_FistSwing_7.setNext(ps_FistSwing_8).setFlags(Panel.psf_Xflip), ps_FistSwing_8.setNext().setFlags(Panel.psf_Xflip), ps_FistSwing_9.setNext(ps_FistSwing_1).setFlags(Panel.psf_Xflip)};
    private static final Panel_State ps_Kick_3 = new Panel_State(3, 4081, 20, pFistSlideDown);
    private static final Panel_State ps_Kick_4 = new Panel_State(4, 4081, 30, pFistSlideDown);
    private static final Panel_State ps_Kick_7 = new Panel_State(7, 4081, 20, pFistSlideDownR);
    private static final Panel_State ps_Kick_8 = new Panel_State(8, 4081, 30, pFistSlideDownR);
    private static final Panel_State[] ps_Kick = new Panel_State[]{ps_Kick_0.setNext(ps_Kick_1), ps_Kick_1.setNext(ps_Kick_2).setFlags(Panel.psf_QuickCall), ps_Kick_2.setNext(ps_Kick_3), ps_Kick_3.setNext(ps_Kick_4), ps_Kick_4.setNext(), ps_Kick_5.setNext(ps_Kick_6).setFlags(Panel.psf_Xflip), ps_Kick_6.setNext(ps_Kick_7).setFlags(Panel.psf_QuickCall | Panel.psf_Xflip), ps_Kick_7.setNext(ps_Kick_8).setFlags(Panel.psf_Xflip), ps_Kick_8.setNext().setFlags(Panel.psf_Xflip), ps_Kick_9.setNext(ps_Kick_1).setFlags(Panel.psf_Xflip)};

    public static void InitWeaponFist(PlayerStr pp) {
        Panel_Sprite psp;
        if (WangNetwork.Prediction) {
            return;
        }
        if (!MyTypes.TEST(pp.WpnFlags, MyTypes.BIT(0)) || MyTypes.TEST(pp.Flags, Gameutils.PF_WEAPON_RETRACT)) {
            pp.WpnFirstType = (byte)13;
            Sword.InitWeaponSword(pp);
            return;
        }
        if (pp.Wpn[0] == null) {
            psp = pp.Wpn[0] = Panel.pSpawnSprite(pp, ps_PresentFist[0], 128, 302, 200);
            psp.y += Main.engine.getTile(psp.picndx).getHeight();
        }
        if (pp.CurWpn == pp.Wpn[0]) {
            return;
        }
        Panel.PlayerUpdateWeapon(pp, 0);
        pp.WpnUziType = (byte)2;
        Panel.RetractCurWpn(pp);
        psp = pp.CurWpn = pp.Wpn[0];
        psp.flags |= Panel.PANF_WEAPON_SPRITE;
        psp.ActionState = ps_FistSwing[0];
        psp.RetractState = ps_RetractFist[0];
        psp.PresentState = ps_PresentFist[0];
        psp.RestState = ps_FistRest[0];
        Panel.pSetState(psp, psp.PresentState);
        pp.WpnKungFuMove = 0;
        int rnd_num = Gameutils.RANDOM_P2(1024);
        if (rnd_num > 900) {
            Sound.PlaySound(247, pp, 9);
        } else if (rnd_num > 800) {
            Sound.PlaySound(261, pp, 9);
        } else if (rnd_num > 700) {
            Sound.PlaySound(262, pp, 9);
        }
        Gameutils.FLAG_KEY_RELEASE(psp.PlayerP(), 17);
        Gameutils.FLAG_KEY_RESET(psp.PlayerP(), 17);
    }

    private static void pFistBobSetup(Panel_Sprite psp) {
        if (MyTypes.TEST(psp.flags, Panel.PANF_BOB)) {
            return;
        }
        psp.xorig = psp.x;
        psp.yorig = psp.y;
        psp.sin_amt = 12;
        psp.sin_ndx = 0;
        psp.bob_height_shift = 3;
    }

    private static void SpawnFistBlur(Panel_Sprite psp) {
        if (psp.PlayerP().FistAng > 200) {
            return;
        }
        Panel_Sprite nsp = Panel.pSpawnSprite(psp.PlayerP(), null, 64, psp.x, psp.y);
        nsp.flags |= Panel.PANF_WEAPON_SPRITE;
        nsp.xfract = psp.xfract;
        nsp.yfract = psp.yfract;
        nsp.ang = psp.ang;
        nsp.vel = psp.vel;
        nsp.PanelSpriteFunc = FistBlur;
        nsp.kill_tics = 9;
        nsp.shade = psp.shade + 10;
        nsp.picndx = -1;
        nsp.picnum = psp.picndx;
        if (psp.State.testFlag(Panel.psf_Xflip)) {
            nsp.flags |= Panel.PANF_XFLIP;
        }
        nsp.rotate_ang = psp.rotate_ang;
        nsp.scale = psp.scale;
        nsp.flags |= Panel.PANF_TRANSLUCENT;
    }

    public static void FistSaveable() {
        Saveable.SaveData(ps_PresentFist);
        Saveable.SaveData(ps_FistRest);
        Saveable.SaveData(ps_FistHide);
        Saveable.SaveData(ps_PresentFist2);
        Saveable.SaveData(ps_Fist2Rest);
        Saveable.SaveData(ps_FistSwing);
        Saveable.SaveData(ps_Kick);
        Saveable.SaveData(ps_RetractFist);
        Saveable.SaveData(pFistRest);
        Saveable.SaveData(pFistPresent);
        Saveable.SaveData(pFistHide);
        Saveable.SaveData(pFistRetract);
        Saveable.SaveData(pFistAttack);
        Saveable.SaveData(pFistSlideDown);
        Saveable.SaveData(pFistSlideR);
        Saveable.SaveData(pFistSlideDownR);
        Saveable.SaveData(FistBlur);
    }
}

