/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Weapons;

import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Panel;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Panel_Sprite;
import ru.m210projects.Wang.Type.Panel_Sprite_Func;
import ru.m210projects.Wang.Type.Panel_State;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Vis;
import ru.m210projects.Wang.Weapon;

public class Grenade {
    private static final int GRENADE_YOFF = 200;
    private static final int GRENADE_XOFF = 180;
    private static final int Grenade_REST_RATE = 24;
    private static final int Grenade_ACTION_RATE = 6;
    private static final int GRENADE_REST = 2121;
    private static final int GRENADE_FIRE = 2122;
    private static final int GRENADE_RELOAD = 2125;
    private static final int ID_GrenadePresent0 = 2121;
    private static final Panel_State ps_GrenadeRecoil_4 = new Panel_State(2121, 3, null);
    private static final int ID_GrenadeFire0 = 2122;
    private static final int ID_GrenadeFire1 = 2123;
    private static final int ID_GrenadeFire2 = 2124;
    private static final int ID_GrenadeReload0 = 2125;
    private static final Panel_State ps_GrenadeRecoil_2 = new Panel_State(2125, 12, null);
    private static final int ID_GrenadeReload1 = 2126;
    private static final Panel_State ps_GrenadeRecoil_3 = new Panel_State(2126, 12, null);
    private static final Panel_Sprite_Func pGrenadeAction = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            Grenade.pGrenadeBobSetup(psp);
            Panel.pWeaponBob(psp, Gameutils.PLAYER_MOVING(psp.PlayerP()) != 0);
        }
    };
    private static final Panel_State ps_GrenadeFire_4 = new Panel_State(2121, 3, pGrenadeAction);
    private static final Panel_State ps_GrenadeFire_0 = new Panel_State(2122, 6, pGrenadeAction);
    private static final Panel_State ps_GrenadeFire_1 = new Panel_State(2123, 6, pGrenadeAction);
    private static final Panel_State ps_GrenadeFire_2 = new Panel_State(2124, 6, pGrenadeAction);
    private static final Panel_Sprite_Func pGrenadeFire = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            Vis.SpawnVis(psp.PlayerP().PlayerSprite, -1, -1, -1, -1, 32);
            Weapon.InitGrenade(psp.PlayerP());
        }
    };
    private static final Panel_State ps_GrenadeFire_3 = new Panel_State(2121, 0, pGrenadeFire);
    private static final Panel_Sprite_Func pGrenadeRecoilDown = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            int x = Panel.castLongX(psp);
            int y = Panel.castLongY(psp);
            Panel.setLong(psp, x += psp.vel * 3 * EngineUtils.cos(psp.ang) >> 6, y += psp.vel * 3 * -EngineUtils.sin(psp.ang) >> 6);
            psp.vel -= 72;
            if (psp.vel < 400) {
                psp.vel = 400;
                psp.ang = Gameutils.NORM_ANGLE(psp.ang + 1024);
                Panel.pStatePlusOne(psp);
            }
        }
    };
    private static final Panel_State ps_GrenadeRecoil_0 = new Panel_State(2121, 24, pGrenadeRecoilDown);
    private static final Panel_Sprite_Func pGrenadeRecoilUp = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            int x = Panel.castLongX(psp);
            int y = Panel.castLongY(psp);
            Panel.setLong(psp, x += psp.vel * 3 * EngineUtils.cos(psp.ang) >> 6, y += psp.vel * 3 * -EngineUtils.sin(psp.ang) >> 6);
            psp.vel += 45;
            if (psp.y < 200) {
                psp.y = 200;
                psp.x = 180;
                Grenade.pGrenadeSetRecoil(psp);
                Panel.pStatePlusOne(psp);
                psp.flags &= ~Panel.PANF_BOB;
            }
        }
    };
    private static final Panel_State ps_GrenadeRecoil_1 = new Panel_State(2121, 24, pGrenadeRecoilUp);
    private static final Panel_Sprite_Func pGrenadePresent = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            int x = Panel.castLongX(psp);
            int y = Panel.castLongY(psp);
            if (MyTypes.TEST(psp.PlayerP().Flags, Gameutils.PF_WEAPON_RETRACT)) {
                return;
            }
            Panel.setLong(psp, x += psp.vel * 3 * EngineUtils.cos(psp.ang) >> 6, y += psp.vel * 3 * -EngineUtils.sin(psp.ang) >> 6);
            psp.rotate_ang = Gameutils.NORM_ANGLE(psp.rotate_ang + 18);
            if (psp.rotate_ang < 1024) {
                psp.rotate_ang = 0;
            }
            if (psp.y < 200) {
                Grenade.pGrenadeSetRecoil(psp);
                psp.x = 180;
                psp.y = 200;
                psp.rotate_ang = 0;
                psp.yorig = psp.y;
                Panel.pSetState(psp, psp.RestState);
            }
        }
    };
    private static final Panel_State[] ps_PresentGrenade = new Panel_State[]{new Panel_State(2121, 24, pGrenadePresent).setNext()};
    private static final Panel_Sprite_Func pGrenadeHide = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            int picnum = psp.picndx;
            psp.y += 9;
            if (psp.y >= 200 + Main.engine.getTile(picnum).getHeight()) {
                psp.y = 200 + Main.engine.getTile(picnum).getHeight();
                psp.x = 180;
                Grenade.pGrenadePresentSetup(psp);
                Panel.pWeaponUnHideKeys(psp, psp.PresentState);
            }
        }
    };
    private static final Panel_State[] ps_GrenadeHide = new Panel_State[]{new Panel_State(2121, 24, pGrenadeHide).setNext()};
    private static final Panel_Sprite_Func pGrenadeRest = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            boolean force = MyTypes.TEST(psp.flags, Panel.PANF_UNHIDE_SHOOT);
            if (Panel.pWeaponHideKeys(psp, ps_GrenadeHide[0])) {
                return;
            }
            Grenade.pGrenadeBobSetup(psp);
            Panel.pWeaponBob(psp, Gameutils.PLAYER_MOVING(psp.PlayerP()) != 0);
            if (Gameutils.TEST_SYNC_KEY(psp.PlayerP(), 17) || force) {
                if (Gameutils.FLAG_KEY_PRESSED(psp.PlayerP(), 17) || force) {
                    psp.flags &= ~Panel.PANF_UNHIDE_SHOOT;
                    if (!Panel.WeaponOK(psp.PlayerP())) {
                        return;
                    }
                    Panel.DoPlayerChooseYell(psp.PlayerP());
                    Panel.pSetState(psp, psp.ActionState);
                }
            } else {
                Panel.WeaponOK(psp.PlayerP());
            }
        }
    };
    private static final Panel_State[] ps_GrenadeRest = new Panel_State[]{new Panel_State(2121, 24, pGrenadeRest).setNext()};
    private static final Panel_State[] ps_GrenadeRecoil = new Panel_State[]{ps_GrenadeRecoil_0.setNext().setPlusOne(ps_GrenadeRecoil_1), ps_GrenadeRecoil_1.setNext().setPlusOne(ps_GrenadeRecoil_2), ps_GrenadeRecoil_2.setNext(ps_GrenadeRecoil_3), ps_GrenadeRecoil_3.setNext(ps_GrenadeRecoil_4), ps_GrenadeRecoil_4.setNext(ps_GrenadeRest[0])};
    private static final Panel_State[] ps_GrenadeFire = new Panel_State[]{ps_GrenadeFire_0.setNext(ps_GrenadeFire_1).setFlags(Panel.psf_ShadeHalf), ps_GrenadeFire_1.setNext(ps_GrenadeFire_2).setFlags(Panel.psf_ShadeNone), ps_GrenadeFire_2.setNext(ps_GrenadeFire_3).setFlags(Panel.psf_ShadeNone), ps_GrenadeFire_3.setNext(ps_GrenadeFire_4).setFlags(Panel.psf_QuickCall), ps_GrenadeFire_4.setNext(ps_GrenadeRecoil[0])};
    private static final Panel_Sprite_Func pGrenadeRetract = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            psp.y += 9;
            if (psp.y >= 200 + Main.engine.getTile(psp.picndx).getHeight()) {
                psp.PlayerP().Flags &= ~Gameutils.PF_WEAPON_RETRACT;
                psp.PlayerP().Wpn[5] = null;
                Panel.pKillSprite(psp);
            }
        }
    };
    private static final Panel_State[] ps_RetractGrenade = new Panel_State[]{new Panel_State(2121, 24, pGrenadeRetract).setNext()};

    public static void InitWeaponGrenade(PlayerStr pp) {
        Panel_Sprite psp;
        if (WangNetwork.Prediction) {
            return;
        }
        if (!MyTypes.TEST(pp.WpnFlags, MyTypes.BIT(5)) || MyTypes.TEST(pp.Flags, Gameutils.PF_WEAPON_RETRACT)) {
            return;
        }
        if (pp.Wpn[5] == null) {
            psp = pp.Wpn[5] = Panel.pSpawnSprite(pp, ps_PresentGrenade[0], 128, 180, 200);
            psp.y += Main.engine.getTile(psp.picndx).getHeight();
        }
        if (pp.CurWpn == pp.Wpn[5]) {
            return;
        }
        Panel.PlayerUpdateWeapon(pp, 5);
        pp.WpnUziType = (byte)2;
        Panel.RetractCurWpn(pp);
        psp = pp.CurWpn = pp.Wpn[5];
        psp.flags |= Panel.PANF_WEAPON_SPRITE;
        psp.ActionState = ps_GrenadeFire[0];
        psp.RetractState = ps_RetractGrenade[0];
        psp.PresentState = ps_PresentGrenade[0];
        psp.RestState = ps_GrenadeRest[0];
        Panel.pSetState(psp, psp.PresentState);
        Grenade.pGrenadePresentSetup(psp);
        Sound.PlaySound(242, pp, 1);
        Gameutils.FLAG_KEY_RELEASE(psp.PlayerP(), 17);
        Gameutils.FLAG_KEY_RESET(psp.PlayerP(), 17);
    }

    private static void pGrenadePresentSetup(Panel_Sprite psp) {
        psp.rotate_ang = 1800;
        psp.y += 34;
        psp.x -= 45;
        psp.ang = 384;
        psp.vel = 680;
    }

    private static void pGrenadeSetRecoil(Panel_Sprite psp) {
        psp.vel = 900;
        psp.ang = Gameutils.NORM_ANGLE(-256);
    }

    private static void pGrenadeBobSetup(Panel_Sprite psp) {
        if (MyTypes.TEST(psp.flags, Panel.PANF_BOB)) {
            return;
        }
        psp.xorig = psp.x;
        psp.yorig = psp.y;
        psp.sin_amt = 12;
        psp.sin_ndx = 0;
        psp.bob_height_shift = 3;
    }

    public static void GrenadeSaveable() {
        Saveable.SaveData(ps_PresentGrenade);
        Saveable.SaveData(ps_GrenadeRest);
        Saveable.SaveData(ps_GrenadeHide);
        Saveable.SaveData(ps_GrenadeFire);
        Saveable.SaveData(ps_GrenadeRecoil);
        Saveable.SaveData(ps_RetractGrenade);
        Saveable.SaveData(pGrenadeAction);
        Saveable.SaveData(pGrenadeFire);
        Saveable.SaveData(pGrenadeRest);
        Saveable.SaveData(pGrenadeRecoilDown);
        Saveable.SaveData(pGrenadeRecoilUp);
        Saveable.SaveData(pGrenadePresent);
        Saveable.SaveData(pGrenadeHide);
        Saveable.SaveData(pGrenadeRetract);
    }
}

