/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Weapons;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Wang.Break;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.MiscActr;
import ru.m210projects.Wang.Panel;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Type.List;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Panel_Sprite;
import ru.m210projects.Wang.Type.Panel_Sprite_Func;
import ru.m210projects.Wang.Type.Panel_State;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class Sword {
    public static final int SWORD_REST = 2080;
    public static final int SWORD_SWING0 = 2081;
    public static final int SWORD_SWING1 = 2082;
    public static final int SWORD_SWING2 = 2083;
    public static final int BLOODYSWORD_REST = 4090;
    public static final int BLOODYSWORD_SWING0 = 4091;
    public static final int BLOODYSWORD_SWING1 = 4092;
    public static final int BLOODYSWORD_SWING2 = 4093;
    private static final int SWORD_PAUSE_TICS = 10;
    private static final int SWORD_SLIDE_TICS = 10;
    private static final int SWORD_MID_SLIDE_TICS = 14;
    private static final int Sword_BEAT_RATE = 24;
    private static final int SWORD_SWAY_AMT = 12;
    private static final int SWORD_XOFF = 332;
    private static final Panel_Sprite_Func pSwordHide = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            int picnum = psp.picndx;
            psp.y += 9;
            if (psp.y >= 200 + Main.engine.getTile(picnum).getHeight()) {
                psp.y = 200 + Main.engine.getTile(picnum).getHeight();
                psp.x = 332;
                Panel.pWeaponUnHideKeys(psp, psp.PresentState);
            }
        }
    };
    private static final Panel_State[] ps_SwordHide = new Panel_State[]{new Panel_State(2080, 24, pSwordHide).setNext()};
    private static final Panel_Sprite_Func pSwordRest = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            if (Panel.pWeaponHideKeys(psp, ps_SwordHide[0])) {
                return;
            }
            psp.yorig += 3;
            if (psp.yorig > 200) {
                psp.yorig = 200;
            }
            psp.y = psp.yorig;
            Sword.pSwordBobSetup(psp);
            Panel.pWeaponBob(psp, Gameutils.PLAYER_MOVING(psp.PlayerP()) != 0);
            boolean force = MyTypes.TEST(psp.flags, Panel.PANF_UNHIDE_SHOOT);
            if ((Gameutils.TEST_SYNC_KEY(psp.PlayerP(), 17) || force) && (Gameutils.FLAG_KEY_PRESSED(psp.PlayerP(), 17) || force)) {
                psp.flags &= ~Panel.PANF_UNHIDE_SHOOT;
                Panel.pSetState(psp, psp.ActionState);
                psp.vel = 2500;
                psp.ang = 1024;
                psp.PlayerP().SwordAng = SwordAngTable[Gameutils.RANDOM_RANGE(SwordAngTable.length)];
                Player.DoPlayerSpriteThrow(psp.PlayerP());
            }
        }
    };
    private static final Panel_State[] ps_SwordRest = new Panel_State[]{new Panel_State(2080, 24, pSwordRest).setNext()};
    private static final int SWORD_YOFF = 200;
    private static final int SWORDR_XOFF = -80;
    private static final short[] SwordAngTable = new short[]{82, 168, 320};
    private static final Panel_Sprite_Func pSwordPresent = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            if (MyTypes.TEST(psp.PlayerP().Flags, Gameutils.PF_WEAPON_RETRACT)) {
                return;
            }
            psp.y -= 9;
            if (psp.y < 200) {
                psp.yorig = psp.y = 200;
                Panel.pSetState(psp, psp.RestState);
            }
        }
    };
    private static final Panel_State[] ps_PresentSword = new Panel_State[]{new Panel_State(2080, 24, pSwordPresent).setNext()};
    private static final Panel_Sprite_Func pSwordRetract = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            int picnum = psp.picndx;
            psp.y += 9;
            if (psp.y >= 200 + Main.engine.getTile(picnum).getHeight()) {
                psp.PlayerP().Flags &= ~Gameutils.PF_WEAPON_RETRACT;
                psp.PlayerP().Wpn[13] = null;
                Panel.pKillSprite(psp);
            }
        }
    };
    private static final Panel_State[] ps_RetractSword = new Panel_State[]{new Panel_State(2080, 24, pSwordRetract).setNext()};
    private static final Panel_Sprite_Func SwordBlur = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            psp.kill_tics -= 3;
            if (psp.kill_tics <= 0) {
                Panel.pKillSprite(psp);
                return;
            }
            if (psp.kill_tics <= 6) {
                psp.flags |= Panel.PANF_TRANS_FLIP;
            }
            psp.shade += 10;
            List.Delete(psp);
            --psp.priority;
            Panel.InsertPanelSprite(psp.PlayerP(), psp);
        }
    };
    private static final Panel_Sprite_Func pSwordSlide = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            int vel_adj = 24;
            int x = Panel.castLongX(psp);
            int y = Panel.castLongY(psp);
            Sword.SpawnSwordBlur(psp);
            Panel.setLong(psp, x += psp.vel * 3 * EngineUtils.cos(psp.ang) >> 6, y += psp.vel * 3 * -EngineUtils.sin(psp.ang) >> 6);
            psp.vel += vel_adj * 3;
        }
    };
    private static final Panel_State ID_SwordSwing1 = new Panel_State(2082, 10, pSwordSlide);
    private static final Panel_Sprite_Func pSwordSlideR = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            Sword.SpawnSwordBlur(psp);
            int vel_adj = 24;
            int x = Panel.castLongX(psp);
            int y = Panel.castLongY(psp);
            Panel.setLong(psp, x += psp.vel * 3 * EngineUtils.cos(psp.ang + 1024) >> 6, y += psp.vel * 3 * -EngineUtils.sin(psp.ang + 1024) >> 6);
            psp.vel += vel_adj * 3;
        }
    };
    private static final Panel_State ID_SwordSwing5 = new Panel_State(2082, 10, pSwordSlideR);
    private static final Panel_State ID_SwordSwing0 = new Panel_State(2081, 10, null);
    private static final Panel_State ID_SwordSwing9 = new Panel_State(2083, 2, null);
    private static final short SwordAng = 0;
    private static final Panel_Sprite_Func pSwordSlideDown = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            int x = Panel.castLongX(psp);
            int y = Panel.castLongY(psp);
            Sword.SpawnSwordBlur(psp);
            int vel_adj = 20;
            int vel = 2500;
            Panel.setLong(psp, x += psp.vel * 3 * EngineUtils.cos(0 + psp.ang + psp.PlayerP().SwordAng) >> 6, y += psp.vel * 3 * -EngineUtils.sin(0 + psp.ang + psp.PlayerP().SwordAng) >> 6);
            psp.vel += vel_adj * 3;
            if (psp.x < -40) {
                if (Gameutils.TEST_SYNC_KEY(psp.PlayerP(), 17) && Gameutils.FLAG_KEY_PRESSED(psp.PlayerP(), 17)) {
                    Panel.DoPlayerChooseYell(psp.PlayerP());
                    Panel.pStatePlusOne(psp);
                    psp.x = -80;
                    psp.yorig = psp.y = 200;
                    psp.ang = 1024;
                    psp.PlayerP().SwordAng = SwordAngTable[Gameutils.RANDOM_RANGE(SwordAngTable.length)];
                    psp.vel = vel;
                    Player.DoPlayerSpriteThrow(psp.PlayerP());
                    return;
                }
                Panel.pSetState(psp, psp.PresentState);
                psp.x = 332;
                psp.y = 200;
                psp.y += Main.engine.getTile(psp.picndx).getHeight();
                psp.yorig = psp.y;
            }
        }
    };
    private static final Panel_State ID_SwordSwing3 = new Panel_State(2083, 14, pSwordSlideDown);
    private static final Panel_State ID_SwordSwing4 = new Panel_State(2083, 99, pSwordSlideDown);
    private static final Panel_Sprite_Func pSwordSlideDownR = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            int x = Panel.castLongX(psp);
            int y = Panel.castLongY(psp);
            Sword.SpawnSwordBlur(psp);
            int vel_adj = 24;
            int vel = 2500;
            Panel.setLong(psp, x += psp.vel * 3 * EngineUtils.cos(0 + psp.ang - psp.PlayerP().SwordAng + 1024) >> 6, y += psp.vel * 3 * -EngineUtils.sin(0 + psp.ang - psp.PlayerP().SwordAng + 1024) >> 6);
            psp.vel += vel_adj * 3;
            if (psp.x > 350) {
                if (Gameutils.TEST_SYNC_KEY(psp.PlayerP(), 17) && Gameutils.FLAG_KEY_PRESSED(psp.PlayerP(), 17)) {
                    Panel.DoPlayerChooseYell(psp.PlayerP());
                    Panel.pStatePlusOne(psp);
                    psp.x = 412;
                    psp.yorig = psp.y = 200;
                    psp.PlayerP().SwordAng = SwordAngTable[Gameutils.RANDOM_RANGE(SwordAngTable.length)];
                    psp.ang = 1024;
                    psp.vel = vel;
                    Player.DoPlayerSpriteThrow(psp.PlayerP());
                    return;
                }
                Panel.pSetState(psp, psp.PresentState);
                psp.x = 332;
                psp.y = 200;
                psp.y += Main.engine.getTile(psp.picndx).getHeight();
                psp.yorig = psp.y;
            }
        }
    };
    private static final Panel_State ID_SwordSwing7 = new Panel_State(2083, 14, pSwordSlideDownR);
    private static final Panel_State ID_SwordSwing8 = new Panel_State(2083, 99, pSwordSlideDownR);
    private static final short[] dangs = new short[]{-256, -128, 0, 128, 256};
    private static final Panel_Sprite_Func pSwordAttack = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            Sword.InitSwordAttack(psp.PlayerP());
        }
    };
    private static final Panel_State ID_SwordSwing2 = new Panel_State(2082, 0, pSwordAttack);
    private static final Panel_State ID_SwordSwing6 = new Panel_State(2083, 0, pSwordAttack);
    private static final Panel_State[] ps_SwordSwing = new Panel_State[]{ID_SwordSwing0.setNext(ID_SwordSwing1), ID_SwordSwing1.setNext(ID_SwordSwing2), ID_SwordSwing2.setNext(ID_SwordSwing3).setFlags(Panel.psf_QuickCall), ID_SwordSwing3.setNext(ID_SwordSwing4), ID_SwordSwing4.setNext().setPlusOne(ID_SwordSwing5), ID_SwordSwing5.setNext(ID_SwordSwing6).setFlags(Panel.psf_Xflip), ID_SwordSwing6.setNext(ID_SwordSwing7).setFlags(Panel.psf_QuickCall | Panel.psf_Xflip), ID_SwordSwing7.setNext(ID_SwordSwing8).setFlags(Panel.psf_Xflip), ID_SwordSwing8.setNext().setPlusOne(ID_SwordSwing9).setFlags(Panel.psf_Xflip), ID_SwordSwing9.setNext(ID_SwordSwing1).setPlusOne(ID_SwordSwing0).setFlags(Panel.psf_Xflip)};

    public static void InitWeaponSword(PlayerStr pp) {
        Panel_Sprite psp;
        if (WangNetwork.Prediction) {
            return;
        }
        if (!MyTypes.TEST(pp.WpnFlags, MyTypes.BIT(13)) || MyTypes.TEST(pp.Flags, Gameutils.PF_WEAPON_RETRACT)) {
            return;
        }
        if (pp.Wpn[13] != null && MyTypes.TEST(pp.Wpn[13].flags, Panel.PANF_DEATH_HIDE)) {
            pp.Wpn[13].flags &= ~Panel.PANF_DEATH_HIDE;
            pp.Flags &= ~(Gameutils.PF_WEAPON_RETRACT | Gameutils.PF_WEAPON_DOWN);
            Panel.pSetState(pp.CurWpn, pp.CurWpn.PresentState);
            return;
        }
        if (pp.Wpn[13] == null) {
            psp = pp.Wpn[13] = Panel.pSpawnSprite(pp, ps_PresentSword[0], 128, 332, 200);
            psp.y += Main.engine.getTile(psp.picndx).getHeight();
        }
        if (pp.CurWpn == pp.Wpn[13]) {
            return;
        }
        Panel.PlayerUpdateWeapon(pp, 13);
        pp.WpnUziType = (byte)2;
        Panel.RetractCurWpn(pp);
        psp = pp.CurWpn = pp.Wpn[13];
        psp.flags |= Panel.PANF_WEAPON_SPRITE;
        psp.ActionState = ps_SwordSwing[0];
        psp.RetractState = ps_RetractSword[0];
        psp.PresentState = ps_PresentSword[0];
        psp.RestState = ps_SwordRest[0];
        Panel.pSetState(psp, psp.PresentState);
        Sound.PlaySound(238, pp, 9);
        if (pp == Game.Player[Mmulti.myconnectindex]) {
            int rnd_num = Gameutils.STD_RANDOM_RANGE(1024);
            if (rnd_num > 900) {
                Sound.PlaySound(247, pp, 9);
            } else if (rnd_num > 800) {
                Sound.PlaySound(261, pp, 9);
            } else if (rnd_num > 700) {
                Sound.PlaySound(262, pp, 9);
            } else if (rnd_num > 600) {
                Sound.PlayerSound(361, 9, pp);
            }
        }
        Gameutils.FLAG_KEY_RELEASE(psp.PlayerP(), 17);
        Gameutils.FLAG_KEY_RESET(psp.PlayerP(), 17);
    }

    private static void InitSwordAttack(PlayerStr pp) {
        USER u = Gameutils.getUser(pp.PlayerSprite);
        Sprite sp = null;
        Sound.PlaySound(1, pp, 12);
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_DIVING)) {
            for (short dang : dangs) {
                WangSprite bp;
                int bubble;
                if (Gameutils.RANDOM_RANGE(1000) < 500 || (bubble = Weapon.SpawnBubble(pp.PlayerSprite)) < 0 || (bp = Main.boardService.getSprite(bubble)) == null || u == null) continue;
                bp.setAng(pp.getAnglei());
                int random_amt = (Gameutils.RANDOM_P2(8192) >> 8) - 16;
                int nx = Gameutils.MOVEx(3840, Gameutils.NORM_ANGLE(bp.getAng() + dang + random_amt));
                int ny = Gameutils.MOVEy(3840, Gameutils.NORM_ANGLE(bp.getAng() + dang + random_amt));
                Sprites.move_missile(bubble, nx, ny, 0, u.ceiling_dist, u.floor_dist, Gameutils.CLIPMASK_PLAYER, 1);
            }
        }
        block5: for (int stat = 0; stat < Weapon.StatDamageList.length; ++stat) {
            ListNode<Sprite> node = Main.boardService.getStatNode(Weapon.StatDamageList[stat]);
            while (node != null) {
                int i = node.getIndex();
                ListNode<Sprite> nexti = node.getNext();
                sp = node.get();
                USER ui = Gameutils.getUser(i);
                if (ui != null && ui.PlayerP == pp.pnum) continue block5;
                if (MyTypes.TEST(sp.getExtra(), Gameutils.SPRX_PLAYER_OR_ENEMY)) {
                    long dist = Game.Distance(pp.posx, pp.posy, sp.getX(), sp.getY());
                    int reach = 1000;
                    int face = 200;
                    Sprite psp = pp.getSprite();
                    if (psp != null && dist < (long)Weapon.CLOSE_RANGE_DIST_FUDGE(sp, psp, reach) && Gameutils.PLAYER_FACING_RANGE(pp, sp, face) && Sprites.SpriteOverlapZ(pp.PlayerSprite, i, Gameutils.Z(20)) && Rooms.FAFcansee(sp.getX(), sp.getY(), Gameutils.SPRITEp_MID(sp), sp.getSectnum(), psp.getX(), psp.getY(), Gameutils.SPRITEp_MID(psp), psp.getSectnum())) {
                        Weapon.DoDamage(i, pp.PlayerSprite);
                    }
                }
                node = nexti;
            }
        }
        int daang = pp.getAnglei();
        int daz = (100 - pp.getHorizi()) * 2000 + (Gameutils.RANDOM_RANGE(24000) - 12000);
        Rooms.FAFhitscan(pp.posx, pp.posy, pp.posz, pp.cursectnum, EngineUtils.cos(daang), EngineUtils.sin(daang), daz, Engine.pHitInfo, Gameutils.CLIPMASK_MISSILE);
        int hitsect = Engine.pHitInfo.hitsect;
        int hitwall = Engine.pHitInfo.hitwall;
        int hitsprite = Engine.pHitInfo.hitsprite;
        int hitx = Engine.pHitInfo.hitx;
        int hity = Engine.pHitInfo.hity;
        int hitz = Engine.pHitInfo.hitz;
        if (hitsect == -1) {
            return;
        }
        if (Gameutils.FindDistance3D(pp.posx - hitx, pp.posy - hity, pp.posz - hitz >> 4) < 700) {
            Wall hw;
            WangSprite hsp = Main.boardService.getSprite(hitsprite);
            if (hsp != null) {
                USER tu = Gameutils.getUser(hitsprite);
                if (tu != null) {
                    switch (tu.ID) {
                        case 623: 
                        case 4768: 
                        case 4792: 
                        case 4816: 
                        case 4840: 
                        case 5426: {
                            Sword.SpawnSwordSparks(pp, hitsect, -1, hitx, hity, hitz, daang);
                            Sound.PlaySound(312, Sound.sndCoords.set(hitx, hity, hitz), 0);
                            break;
                        }
                        case 2540: {
                            if (tu.WaitTics <= 0) {
                                tu.WaitTics = Gameutils.SEC(2);
                                Sprites.ChangeState(hitsprite, MiscActr.s_TrashCanPain[0]);
                            }
                            Sword.SpawnSwordSparks(pp, hitsect, -1, hitx, hity, hitz, daang);
                            Sound.PlaySound(312, Sound.sndCoords.set(hitx, hity, hitz), 0);
                            Sound.PlaySound(416, sp, 0);
                        }
                    }
                }
                if (hsp.getLotag() == 257 && Weapon.MissileHitMatch(-1, 1, hitsprite)) {
                    return;
                }
                if (MyTypes.TEST(hsp.getExtra(), Gameutils.SPRX_BREAKABLE)) {
                    Break.HitBreakSprite(hitsprite, 0);
                }
                if (MyTypes.TEST(hsp.getCstat(), Gameutils.CSTAT_SPRITE_WALL) && (hsp.getLotag() != 0 || hsp.getHitag() != 0)) {
                    Sector.ShootableSwitch(hitsprite, -1);
                }
            }
            if ((hw = Main.boardService.getWall(hitwall)) != null) {
                ru.m210projects.Build.Types.Sector nexts;
                if (hw.getNextsector() >= 0 && (nexts = Main.boardService.getSector(hw.getNextsector())) != null && MyTypes.TEST(nexts.getCeilingstat(), Gameutils.CEILING_STAT_PLAX) && hitz < nexts.getCeilingz()) {
                    return;
                }
                if (u != null && hw.getLotag() == 307) {
                    Break.HitBreakWall(hitwall, hitx, hity, hitz, daang, u.ID);
                } else {
                    Sword.SpawnSwordSparks(pp, hitsect, hitwall, hitx, hity, hitz, daang);
                    Sound.PlaySound(312, Sound.sndCoords.set(hitx, hity, hitz), 0);
                }
            }
        }
    }

    public static void SpawnSwordSparks(PlayerStr pp, int hitsect, int hitwall, int hitx, int hity, int hitz, int hitang) {
        USER u = Gameutils.getUser(pp.PlayerSprite);
        int j = Sprites.SpawnSprite(4, 2146, Weapon.s_UziSmoke[0], hitsect, hitx, hity, hitz, hitang, 0);
        WangSprite wp = Main.boardService.getSprite(j);
        if (wp == null) {
            return;
        }
        wp.setShade(-40);
        wp.setXrepeat(20);
        wp.setYrepeat(20);
        Sprites.SetOwner(pp.PlayerSprite, j);
        wp.setCstat(wp.getCstat() | (Gameutils.CSTAT_SPRITE_TRANSLUCENT | Gameutils.CSTAT_SPRITE_YCENTER));
        wp.setHitag(9999);
        wp.setClipdist(8);
        if (hitwall != -1) {
            Weapon.HitscanSpriteAdjust(j, hitwall);
        }
        j = Sprites.SpawnSprite(4, 2140, Weapon.s_UziSpark[0], hitsect, hitx, hity, hitz, hitang, 0);
        wp = Main.boardService.getSprite(j);
        USER wu = Gameutils.getUser(j);
        if (wp == null || wu == null) {
            return;
        }
        wp.setShade(-40);
        wp.setXrepeat(20);
        wp.setYrepeat(20);
        Sprites.SetOwner(pp.PlayerSprite, j);
        wu.spal = 0;
        wp.setPal(wu.spal);
        wp.setCstat(wp.getCstat() | Gameutils.CSTAT_SPRITE_YCENTER);
        if (u != null && u.WeaponNum == 0) {
            wp.setCstat(wp.getCstat() | Gameutils.CSTAT_SPRITE_INVISIBLE);
        }
        wp.setClipdist(8);
        if (hitwall != -1) {
            Weapon.HitscanSpriteAdjust(j, hitwall);
        }
    }

    private static void pSwordBobSetup(Panel_Sprite psp) {
        if (MyTypes.TEST(psp.flags, Panel.PANF_BOB)) {
            return;
        }
        psp.xorig = psp.x;
        psp.yorig = psp.y;
        psp.sin_amt = 12;
        psp.sin_ndx = 0;
        psp.bob_height_shift = 3;
    }

    private static void SpawnSwordBlur(Panel_Sprite psp) {
        if (psp.PlayerP().SwordAng > 200) {
            return;
        }
        Panel_Sprite nsp = Panel.pSpawnSprite(psp.PlayerP(), null, 64, psp.x, psp.y);
        nsp.flags |= Panel.PANF_WEAPON_SPRITE;
        nsp.xfract = psp.xfract;
        nsp.yfract = psp.yfract;
        nsp.ang = psp.ang;
        nsp.vel = psp.vel;
        nsp.PanelSpriteFunc = SwordBlur;
        nsp.kill_tics = 9;
        nsp.shade = psp.shade + 10;
        nsp.picndx = -1;
        nsp.picnum = psp.picndx;
        if (psp.State.testFlag(Panel.psf_Xflip)) {
            nsp.flags |= Panel.PANF_XFLIP;
        }
        nsp.rotate_ang = psp.rotate_ang;
        nsp.scale = psp.scale;
        nsp.flags |= Panel.PANF_TRANSLUCENT;
    }

    public static void SwordSaveable() {
        Saveable.SaveData(ps_PresentSword);
        Saveable.SaveData(ps_SwordRest);
        Saveable.SaveData(ps_SwordHide);
        Saveable.SaveData(ps_SwordSwing);
        Saveable.SaveData(ps_RetractSword);
        Saveable.SaveData(pSwordPresent);
        Saveable.SaveData(pSwordSlide);
        Saveable.SaveData(pSwordAttack);
        Saveable.SaveData(pSwordSlideDown);
        Saveable.SaveData(pSwordSlideR);
        Saveable.SaveData(pSwordSlideDownR);
        Saveable.SaveData(pSwordRest);
        Saveable.SaveData(pSwordHide);
        Saveable.SaveData(pSwordRetract);
        Saveable.SaveData(SwordBlur);
    }
}

