/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven.AI;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Witchaven.AI.AIState;
import ru.m210projects.Witchaven.AI.Ai;
import ru.m210projects.Witchaven.AI.Enemy;
import ru.m210projects.Witchaven.AI.EnemyInfo;
import ru.m210projects.Witchaven.Globals;
import ru.m210projects.Witchaven.Main;
import ru.m210projects.Witchaven.Types.PLAYER;
import ru.m210projects.Witchaven.WHFX;
import ru.m210projects.Witchaven.WHOBJ;
import ru.m210projects.Witchaven.WHSND;

public class AIDragon {
    public static final AIState dragonAttack2 = new AIState(){

        @Override
        public void process(PLAYER plr, int i) {
            Sprite spr = Main.boardService.getSprite(i);
            if (spr == null) {
                Main.engine.deletesprite(i);
                return;
            }
            spr.setLotag(spr.getLotag() - 3);
            if (spr.getLotag() < 0) {
                if (Main.engine.cansee(plr.getX(), plr.getY(), plr.getZ(), plr.getSector(), spr.getX(), spr.getY(), spr.getZ() - (Main.engine.getTile(spr.getPicnum()).getHeight() << 7), spr.getSectnum()) && plr.getInvisibletime() < 0) {
                    WHOBJ.newstatus(i, 104);
                } else {
                    WHOBJ.newstatus(i, 2);
                }
                return;
            }
            spr.setAng(EngineUtils.getAngle(plr.getX() - spr.getX(), plr.getY() - spr.getY()));
            Ai.checksector6(i);
        }
    };

    public static void create() {
        Ai.enemy[3] = new Enemy();
        Ai.enemy[3].info = new EnemyInfo(54, 54, 512, 120, 0, 128, false, 900, 0){

            @Override
            public int getAttackDist(Sprite spr) {
                int out = this.attackdist;
                if (spr.getPicnum() > 1166 && spr.getPicnum() < 1181 || spr.getPicnum() > 1207 && spr.getPicnum() < 1212) {
                    out *= 4;
                }
                return out;
            }
        };
        Ai.enemy[3].chase = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                short osectnum;
                Sector osec;
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setLotag(spr.getLotag() - 3);
                if (spr.getLotag() < 0) {
                    spr.setLotag(250);
                }
                if ((osec = Main.boardService.getSector(osectnum = spr.getSectnum())) == null) {
                    return;
                }
                if (Main.engine.krand() % 16 == 0) {
                    if (Main.engine.cansee(plr.getX(), plr.getY(), plr.getZ(), plr.getSector(), spr.getX(), spr.getY(), spr.getZ() - (Main.engine.getTile(spr.getPicnum()).getHeight() << 7), spr.getSectnum()) && plr.getInvisibletime() < 0) {
                        if (plr.getZ() < spr.getZ()) {
                            WHOBJ.newstatus(i, 125);
                        } else {
                            WHOBJ.newstatus(i, 6);
                        }
                    }
                    return;
                }
                int dax = EngineUtils.sin(spr.getAng() + 512 & 0x7FF) * 3 << 3;
                int day = EngineUtils.sin(spr.getAng() & 0x7FF) * 3 << 3;
                Ai.checksight(plr, i);
                if (!Ai.checkdist(plr, i)) {
                    Ai.checkmove(i, dax, day);
                } else if (plr.getInvisibletime() < 0) {
                    if (Main.engine.krand() % 8 == 0) {
                        if (plr.getZ() < spr.getZ()) {
                            WHOBJ.newstatus(i, 125);
                        } else {
                            WHOBJ.newstatus(i, 6);
                        }
                    } else {
                        WHOBJ.newstatus(i, 109);
                    }
                }
                Main.engine.getzrange(spr.getX(), spr.getY(), spr.getZ() - 1, spr.getSectnum(), spr.getClipdist() << 2, 65537);
                spr.setZ(Engine.zr_florz);
                Sector sec = Main.boardService.getSector(spr.getSectnum());
                if (sec == null) {
                    return;
                }
                if (spr.getSectnum() != osectnum && sec.getLotag() == 10) {
                    WHFX.warpsprite(i);
                }
                if (Ai.checksector6(i)) {
                    return;
                }
                Ai.processfluid(i, Engine.zr_florhit, false);
                if (osec.getLotag() == 4444) {
                    spr.setHitag(spr.getHitag() - 1);
                    if (spr.getHitag() < 0) {
                        WHOBJ.newstatus(i, 107);
                    }
                }
                Main.engine.setsprite(i, spr.getX(), spr.getY(), spr.getZ());
            }
        };
        Ai.enemy[3].flee = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sector sec;
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setLotag(spr.getLotag() - 3);
                short osectnum = spr.getSectnum();
                int movestat = Ai.aimove(i);
                if ((movestat & 0xE0000000) != 0x40000000 && movestat != 0) {
                    if ((movestat & 0xE0000000) == Integer.MIN_VALUE) {
                        Wall wal = Main.boardService.getWall(movestat & 0x1FFFFFFF);
                        if (wal != null) {
                            int nx = -(wal.getWall2().getY() - wal.getY()) >> 4;
                            int ny = wal.getWall2().getX() - wal.getX() >> 4;
                            spr.setAng(EngineUtils.getAngle(nx, ny));
                        }
                    } else {
                        spr.setAng(EngineUtils.getAngle(plr.getX() - spr.getX(), plr.getY() - spr.getY()));
                        WHOBJ.newstatus(i, 109);
                    }
                }
                if (spr.getLotag() < 0) {
                    WHOBJ.newstatus(i, 109);
                }
                if ((sec = Main.boardService.getSector(spr.getSectnum())) == null) {
                    return;
                }
                if (spr.getSectnum() != osectnum && sec.getLotag() == 10) {
                    WHFX.warpsprite(i);
                }
                if (Ai.checksector6(i)) {
                    return;
                }
                Ai.processfluid(i, Engine.zr_florhit, false);
                Main.engine.setsprite(i, spr.getX(), spr.getY(), spr.getZ());
            }
        };
        Ai.enemy[3].die = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setLotag(spr.getLotag() - 3);
                if (spr.getLotag() <= 0) {
                    spr.setPicnum(spr.getPicnum() + 1);
                    spr.setLotag(20);
                    if (spr.getPicnum() == 1200) {
                        if (Globals.difficulty == 4) {
                            WHOBJ.newstatus(i, 116);
                        } else {
                            ++Globals.kills;
                            WHOBJ.newstatus(i, 108);
                        }
                    }
                }
            }
        };
        Ai.enemy[3].cast = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setLotag(spr.getLotag() - 3);
                if (spr.getLotag() < 0) {
                    spr.setPicnum(spr.getPicnum() + 1);
                    spr.setLotag(12);
                }
                switch (spr.getPicnum()) {
                    case 1168: 
                    case 1181: {
                        if (Main.engine.krand() % 2 != 0) {
                            WHSND.playsound_loc(WHSND.S_FLAME1, spr.getX(), spr.getY());
                        } else {
                            WHSND.playsound_loc(WHSND.S_FIREBALL, spr.getX(), spr.getY());
                        }
                        AIDragon.firebreath(plr, i, 1, 2, 1);
                        break;
                    }
                    case 1169: 
                    case 1182: {
                        if (Main.engine.krand() % 2 != 0) {
                            WHSND.playsound_loc(WHSND.S_FLAME1, spr.getX(), spr.getY());
                        } else {
                            WHSND.playsound_loc(WHSND.S_FIREBALL, spr.getX(), spr.getY());
                        }
                        AIDragon.firebreath(plr, i, 2, 1, 1);
                        break;
                    }
                    case 1170: 
                    case 1183: {
                        if (Main.engine.krand() % 2 != 0) {
                            WHSND.playsound_loc(WHSND.S_FLAME1, spr.getX(), spr.getY());
                        } else {
                            WHSND.playsound_loc(WHSND.S_FIREBALL, spr.getX(), spr.getY());
                        }
                        AIDragon.firebreath(plr, i, 4, 0, 1);
                        break;
                    }
                    case 1171: 
                    case 1184: {
                        AIDragon.firebreath(plr, i, 2, -1, 1);
                        break;
                    }
                    case 1172: 
                    case 1185: {
                        AIDragon.firebreath(plr, i, 1, -2, 1);
                        break;
                    }
                    case 1209: {
                        if (Main.engine.krand() % 2 != 0) {
                            WHSND.playsound_loc(WHSND.S_FLAME1, spr.getX(), spr.getY());
                        } else {
                            WHSND.playsound_loc(WHSND.S_FIREBALL, spr.getX(), spr.getY());
                        }
                        AIDragon.firebreath(plr, i, 1, -1, 2);
                        break;
                    }
                    case 1210: {
                        AIDragon.firebreath(plr, i, 2, 0, 2);
                        break;
                    }
                    case 1212: {
                        spr.setPicnum(1201);
                        WHOBJ.newstatus(i, 2);
                        break;
                    }
                    case 1186: {
                        spr.setPicnum(1164);
                        WHOBJ.newstatus(i, 2);
                    }
                }
                Ai.checksector6(i);
            }
        };
        Ai.enemy[3].attack = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setLotag(spr.getLotag() - 3);
                if (spr.getLotag() < 0) {
                    if (Main.engine.cansee(plr.getX(), plr.getY(), plr.getZ(), plr.getSector(), spr.getX(), spr.getY(), spr.getZ() - (Main.engine.getTile(spr.getPicnum()).getHeight() << 7), spr.getSectnum())) {
                        WHOBJ.newstatus(i, 104);
                    } else {
                        WHOBJ.newstatus(i, 2);
                    }
                } else {
                    spr.setAng(EngineUtils.getAngle(plr.getX() - spr.getX(), plr.getY() - spr.getY()));
                }
            }
        };
        Ai.enemy[3].resurrect = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setLotag(spr.getLotag() - 3);
                if (spr.getLotag() < 0) {
                    WHOBJ.newstatus(i, 109);
                    spr.setPicnum(1201);
                    spr.setHitag(WHOBJ.adjusthp(900));
                    spr.setLotag(100);
                    spr.setCstat(spr.getCstat() | 1);
                }
            }
        };
        Ai.enemy[3].search = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Ai.aisearch(plr, i, true);
                Ai.checksector6(i);
            }
        };
        Ai.enemy[3].frozen = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setLotag(spr.getLotag() - 3);
                if (spr.getLotag() < 0) {
                    spr.setPal(0);
                    spr.setPicnum(1201);
                    WHOBJ.newstatus(i, 109);
                }
            }
        };
        Ai.enemy[3].nuked = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setLotag(spr.getLotag() - 3);
                if (spr.getLotag() < 0) {
                    spr.setPicnum(spr.getPicnum() + 1);
                    spr.setLotag(24);
                    if (spr.getPicnum() == 2447) {
                        WHOBJ.trailingsmoke(i, false);
                        Main.engine.deletesprite(i);
                    }
                }
            }
        };
        Ai.enemy[3].pain = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setLotag(spr.getLotag() - 3);
                Ai.aimove(i);
                Ai.processfluid(i, Engine.zr_florhit, false);
                Main.engine.setsprite(i, spr.getX(), spr.getY(), spr.getZ());
            }
        };
        Ai.enemy[3].face = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                boolean cansee = Main.engine.cansee(plr.getX(), plr.getY(), plr.getZ(), plr.getSector(), spr.getX(), spr.getY(), spr.getZ() - (Main.engine.getTile(spr.getPicnum()).getHeight() << 7), spr.getSectnum());
                if (cansee && plr.getInvisibletime() < 0) {
                    spr.setAng(EngineUtils.getAngle(plr.getX() - spr.getX(), plr.getY() - spr.getY()));
                    if (plr.getShadowtime() > 0) {
                        spr.setAng((short)((Main.engine.krand() & 0x100) + spr.getAng() + 1024 & 0x7FF));
                        WHOBJ.newstatus(i, 122);
                    } else {
                        spr.setOwner(plr.getSpritenum());
                        WHOBJ.newstatus(i, 2);
                    }
                } else if (spr.getOwner() == plr.getSpritenum()) {
                    spr.setAng((short)((Main.engine.krand() & 0x100) + spr.getAng() & 0x7FF));
                    WHOBJ.newstatus(i, 142);
                } else if (cansee) {
                    WHOBJ.newstatus(i, 122);
                }
                if (Ai.checkdist(plr, i)) {
                    WHOBJ.newstatus(i, 6);
                }
            }
        };
    }

    public static void dragonProcess(PLAYER plr) {
        ListNode<Sprite> node = Main.boardService.getStatNode(125);
        while (node != null) {
            ListNode<Sprite> next = node.getNext();
            Sprite spr = node.get();
            if (spr.getDetail() == 1201) {
                dragonAttack2.process(plr, node.getIndex());
            }
            node = next;
        }
    }

    public static void firebreath(PLAYER plr, int i, int a, int b, int c) {
        Sprite spr = Main.boardService.getSprite(i);
        if (spr == null) {
            Main.engine.deletesprite(i);
            return;
        }
        Sector sec = Main.boardService.getSector(spr.getSectnum());
        if (sec == null) {
            return;
        }
        for (int k = 0; k <= a; ++k) {
            int j = Main.engine.insertsprite(spr.getSectnum(), 100);
            Sprite spr2 = Main.boardService.getSprite(j);
            if (spr2 == null) {
                return;
            }
            spr2.setX(spr.getX());
            spr2.setY(spr.getY());
            if (c == 1) {
                spr2.setZ(sec.getFloorz() - 8192);
            } else {
                spr2.setZ(sec.getFloorz() - (Main.engine.getTile(spr.getPicnum()).getHeight() << 7));
            }
            spr2.setCstat(0);
            spr2.setPicnum(660);
            spr2.setShade(-15);
            spr2.setXrepeat(128);
            spr2.setYrepeat(128);
            spr2.setAng((short)(EngineUtils.getAngle(plr.getX() - spr2.getX(), plr.getY() - spr2.getY()) + (Main.engine.krand() & 0xF) - 8 + 2048 + (b * 22 + k * 10) & 0x7FF));
            spr2.setXvel((short)(EngineUtils.sin(spr2.getAng() + 2560 & 0x7FF) >> 6));
            spr2.setYvel((short)(EngineUtils.sin(spr2.getAng() + 2048 & 0x7FF) >> 6));
            long discrim = EngineUtils.sqrt((plr.getX() - spr2.getX()) * (plr.getX() - spr2.getX()) + (plr.getY() - spr2.getY()) * (plr.getY() - spr2.getY()));
            if (discrim == 0L) {
                discrim = 1L;
            }
            if (c == 2) {
                spr2.setZvel((short)((long)(plr.getZ() + 8192 - spr2.getZ() << 7) / discrim));
            } else {
                spr2.setZvel((short)((long)(plr.getZ() + 2048 - spr2.getZ() << 7) / discrim));
            }
            spr2.setOwner((short)i);
            spr2.setClipdist(16);
            spr2.setLotag(512);
            spr2.setHitag(0);
        }
    }

    public static void premap(int i) {
        Sprite spr = Main.boardService.getSprite(i);
        if (spr == null) {
            Main.engine.deletesprite(i);
            return;
        }
        spr.setDetail(3);
        Main.engine.changespritestat(i, 109);
        Ai.enemy[3].info.set(spr);
    }
}

