/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven.AI;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Witchaven.AI.AIState;
import ru.m210projects.Witchaven.AI.Ai;
import ru.m210projects.Witchaven.AI.Enemy;
import ru.m210projects.Witchaven.AI.EnemyInfo;
import ru.m210projects.Witchaven.Globals;
import ru.m210projects.Witchaven.Main;
import ru.m210projects.Witchaven.Types.PLAYER;
import ru.m210projects.Witchaven.WHFX;
import ru.m210projects.Witchaven.WHOBJ;
import ru.m210projects.Witchaven.WHSND;

public class AIFatwitch {
    public static void create() {
        Ai.enemy[4] = new Enemy();
        Ai.enemy[4].info = new EnemyInfo(32, 32, 2048, 120, 0, 64, false, 280, 0);
        Ai.enemy[4].chase = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                short osectnum;
                Sector osec;
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setLotag(spr.getLotag() - 3);
                if (spr.getLotag() < 0) {
                    spr.setLotag(250);
                }
                if ((osec = Main.boardService.getSector(osectnum = spr.getSectnum())) == null) {
                    return;
                }
                if (Main.engine.krand() % 63 == 0) {
                    if (Main.engine.cansee(plr.getX(), plr.getY(), plr.getZ(), plr.getSector(), spr.getX(), spr.getY(), spr.getZ() - (Main.engine.getTile(spr.getPicnum()).getHeight() << 7), spr.getSectnum())) {
                        WHOBJ.newstatus(i, 6);
                    }
                } else {
                    Ai.checksight(plr, i);
                    if (!Ai.checkdist(i, plr.getX(), plr.getY(), plr.getZ())) {
                        int movestat = Ai.aimove(i);
                        if ((movestat & 0xE0000000) == 0x40000000) {
                            spr.setAng((short)(spr.getAng() + 1024 & 0x7FF));
                            WHOBJ.newstatus(i, 122);
                            return;
                        }
                    } else if (Main.engine.krand() % 8 == 0) {
                        WHOBJ.newstatus(i, 6);
                    } else {
                        spr.setAng((short)((Main.engine.krand() & 0x100) + spr.getAng() + 1024 & 0x7FF));
                        WHOBJ.newstatus(i, 122);
                    }
                }
                Main.engine.getzrange(spr.getX(), spr.getY(), spr.getZ() - 1, spr.getSectnum(), spr.getClipdist() << 2, 65537);
                spr.setZ(Engine.zr_florz);
                Sector sec = Main.boardService.getSector(spr.getSectnum());
                if (sec == null) {
                    return;
                }
                if (spr.getSectnum() != osectnum && sec.getLotag() == 10) {
                    WHFX.warpsprite(i);
                }
                if (Ai.checksector6(i)) {
                    return;
                }
                Ai.processfluid(i, Engine.zr_florhit, false);
                if (osec.getLotag() == 4444) {
                    spr.setHitag(spr.getHitag() - 1);
                    if (spr.getHitag() < 0) {
                        WHOBJ.newstatus(i, 107);
                    }
                }
                Main.engine.setsprite(i, spr.getX(), spr.getY(), spr.getZ());
            }
        };
        Ai.enemy[4].resurrect = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setLotag(spr.getLotag() - 3);
                if (spr.getLotag() < 0) {
                    WHOBJ.newstatus(i, 109);
                    spr.setPicnum(821);
                    spr.setHitag(WHOBJ.adjusthp(90));
                    spr.setLotag(100);
                    spr.setCstat(spr.getCstat() | 1);
                }
            }
        };
        Ai.enemy[4].search = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Ai.aisearch(plr, i, false);
                Ai.checksector6(i);
            }
        };
        Ai.enemy[4].nuked = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setLotag(spr.getLotag() - 3);
                if (spr.getLotag() < 0) {
                    spr.setPicnum(spr.getPicnum() + 1);
                    spr.setLotag(24);
                    if (spr.getPicnum() == 2452) {
                        WHOBJ.trailingsmoke(i, false);
                        Main.engine.deletesprite(i);
                    }
                }
            }
        };
        Ai.enemy[4].pain = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setLotag(spr.getLotag() - 3);
                if (spr.getLotag() < 0) {
                    spr.setPicnum(821);
                    spr.setAng((short)plr.getAng());
                    WHOBJ.newstatus(i, 122);
                }
                Ai.aimove(i);
                Ai.processfluid(i, Engine.zr_florhit, false);
                Main.engine.setsprite(i, spr.getX(), spr.getY(), spr.getZ());
            }
        };
        Ai.enemy[4].face = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                boolean cansee = Main.engine.cansee(plr.getX(), plr.getY(), plr.getZ(), plr.getSector(), spr.getX(), spr.getY(), spr.getZ() - (Main.engine.getTile(spr.getPicnum()).getHeight() << 7), spr.getSectnum());
                if (cansee && plr.getInvisibletime() < 0) {
                    spr.setAng(EngineUtils.getAngle(plr.getX() - spr.getX(), plr.getY() - spr.getY()));
                    if (plr.getShadowtime() > 0) {
                        spr.setAng((short)((Main.engine.krand() & 0x100) + spr.getAng() + 1024 & 0x7FF));
                        WHOBJ.newstatus(i, 122);
                    } else {
                        spr.setOwner(plr.getSpritenum());
                        WHOBJ.newstatus(i, 2);
                    }
                } else if (spr.getOwner() == plr.getSpritenum()) {
                    spr.setAng((short)((Main.engine.krand() & 0x100) + spr.getAng() & 0x7FF));
                    WHOBJ.newstatus(i, 142);
                } else if (cansee) {
                    WHOBJ.newstatus(i, 122);
                }
                if (Ai.checkdist(i, plr.getX(), plr.getY(), plr.getZ())) {
                    WHOBJ.newstatus(i, 6);
                }
            }
        };
        Ai.enemy[4].attack = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                Main.engine.getzrange(spr.getX(), spr.getY(), spr.getZ() - 1, spr.getSectnum(), spr.getClipdist() << 2, 65537);
                spr.setZ(Engine.zr_florz);
                switch (Ai.checkfluid(i, Engine.zr_florhit)) {
                    case 1: 
                    case 2: {
                        spr.setZ(spr.getZ() + (Main.engine.getTile(spr.getPicnum()).getHeight() << 5));
                    }
                }
                Main.engine.setsprite(i, spr.getX(), spr.getY(), spr.getZ());
                spr.setLotag(spr.getLotag() - 3);
                if (spr.getLotag() < 0) {
                    if (Main.engine.cansee(plr.getX(), plr.getY(), plr.getZ(), plr.getSector(), spr.getX(), spr.getY(), spr.getZ() - (Main.engine.getTile(spr.getPicnum()).getHeight() << 7), spr.getSectnum())) {
                        WHOBJ.newstatus(i, 104);
                    } else {
                        WHOBJ.newstatus(i, 2);
                    }
                } else {
                    spr.setAng(EngineUtils.getAngle(plr.getX() - spr.getX(), plr.getY() - spr.getY()));
                }
            }
        };
        Ai.enemy[4].flee = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sector sec;
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setLotag(spr.getLotag() - 3);
                short osectnum = spr.getSectnum();
                Sector osec = Main.boardService.getSector(osectnum);
                if (osec == null) {
                    return;
                }
                int movestat = Ai.aimove(i);
                if ((movestat & 0xE0000000) != 0x40000000 && movestat != 0) {
                    if ((movestat & 0xE0000000) == Integer.MIN_VALUE) {
                        Wall wal = Main.boardService.getWall(movestat & 0x1FFFFFFF);
                        if (wal != null) {
                            int nx = -(wal.getWall2().getY() - wal.getY()) >> 4;
                            int ny = wal.getWall2().getX() - wal.getX() >> 4;
                            spr.setAng(EngineUtils.getAngle(nx, ny));
                        }
                    } else {
                        spr.setAng(EngineUtils.getAngle(plr.getX() - spr.getX(), plr.getY() - spr.getY()));
                        WHOBJ.newstatus(i, 109);
                    }
                }
                if (spr.getLotag() < 0) {
                    WHOBJ.newstatus(i, 109);
                }
                if ((sec = Main.boardService.getSector(spr.getSectnum())) == null) {
                    return;
                }
                if (spr.getSectnum() != osectnum && sec.getLotag() == 10) {
                    WHFX.warpsprite(i);
                }
                if (Ai.checksector6(i)) {
                    return;
                }
                Ai.processfluid(i, Engine.zr_florhit, false);
                Main.engine.setsprite(i, spr.getX(), spr.getY(), spr.getZ());
            }
        };
        Ai.enemy[4].cast = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setLotag(spr.getLotag() - 3);
                if (spr.getLotag() < 0) {
                    spr.setPicnum(spr.getPicnum() + 1);
                    spr.setLotag(12);
                }
                if (spr.getPicnum() == 844) {
                    spr.setPicnum(821);
                    AIFatwitch.throwspank(plr, i);
                    WHOBJ.newstatus(i, 2);
                }
                Ai.checksector6(i);
            }
        };
        Ai.enemy[4].die = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setLotag(spr.getLotag() - 3);
                if (spr.getLotag() <= 0) {
                    spr.setPicnum(spr.getPicnum() + 1);
                    spr.setLotag(20);
                    if (spr.getPicnum() == 852) {
                        if (Globals.difficulty == 4) {
                            WHOBJ.newstatus(i, 116);
                        } else {
                            ++Globals.kills;
                            WHOBJ.newstatus(i, 108);
                        }
                    }
                }
            }
        };
    }

    public static void throwspank(PLAYER plr, int i) {
        Sprite spr = Main.boardService.getSprite(i);
        if (spr == null) {
            Main.engine.deletesprite(i);
            return;
        }
        Sector sec = Main.boardService.getSector(spr.getSectnum());
        if (sec == null) {
            return;
        }
        int j = Main.engine.insertsprite(spr.getSectnum(), 100);
        Sprite spr2 = Main.boardService.getSprite(j);
        if (spr2 == null) {
            return;
        }
        WHSND.playsound_loc(87, spr.getX(), spr.getY());
        spr2.setX(spr.getX());
        spr2.setY(spr.getY());
        spr2.setZ(sec.getFloorz() - (Main.engine.getTile(spr.getPicnum()).getHeight() >> 1 << 8));
        spr2.setCstat(0);
        spr2.setPicnum(658);
        spr2.setShade(-15);
        spr2.setXrepeat(64);
        spr2.setYrepeat(64);
        spr2.setAng((short)(EngineUtils.getAngle(plr.getX() - spr2.getX(), plr.getY() - spr2.getY()) + (Main.engine.krand() & 0xF) - 8 + 2048 & 0x7FF));
        spr2.setXvel((short)(EngineUtils.sin(spr2.getAng() + 2560 & 0x7FF) >> 6));
        spr2.setYvel((short)(EngineUtils.sin(spr2.getAng() + 2048 & 0x7FF) >> 6));
        long discrim = EngineUtils.sqrt((plr.getX() - spr2.getX()) * (plr.getX() - spr2.getX()) + (plr.getY() - spr2.getY()) * (plr.getY() - spr2.getY()));
        if (discrim == 0L) {
            discrim = 1L;
        }
        spr2.setZvel((short)((long)(plr.getZ() + 12288 - spr2.getZ() << 7) / discrim));
        spr2.setOwner((short)i);
        spr2.setClipdist(16);
        spr2.setLotag(512);
        spr2.setHitag(0);
        spr2.setPal(0);
    }

    public static void premap(int i) {
        Sprite spr = Main.boardService.getSprite(i);
        if (spr == null) {
            Main.engine.deletesprite(i);
            return;
        }
        spr.setDetail(4);
        Main.engine.changespritestat(i, 109);
        Ai.enemy[4].info.set(spr);
        if (spr.getPal() == 7) {
            spr.setHitag(WHOBJ.adjusthp(290));
        }
        if (Main.engine.krand() % 100 > 50) {
            spr.setExtra(1);
        }
    }
}

