/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven.AI;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Witchaven.AI.AIState;
import ru.m210projects.Witchaven.AI.Ai;
import ru.m210projects.Witchaven.AI.Enemy;
import ru.m210projects.Witchaven.AI.EnemyInfo;
import ru.m210projects.Witchaven.Globals;
import ru.m210projects.Witchaven.Main;
import ru.m210projects.Witchaven.Names;
import ru.m210projects.Witchaven.Types.PLAYER;
import ru.m210projects.Witchaven.WHFX;
import ru.m210projects.Witchaven.WHOBJ;
import ru.m210projects.Witchaven.WHPLR;
import ru.m210projects.Witchaven.WHSND;
import ru.m210projects.Witchaven.WHScreen;

public class AIWillow {
    public static final AIState willowDrain = new AIState(){

        @Override
        public void process(PLAYER plr, int i) {
            Sprite spr = Main.boardService.getSprite(i);
            if (spr == null) {
                Main.engine.deletesprite(i);
                return;
            }
            spr.setLotag(spr.getLotag() - 3);
            if (spr.getLotag() < 0) {
                WHSND.playsound_loc(WHSND.S_FIREBALL, spr.getX(), spr.getY());
                int oldz = spr.getZ();
                spr.setZ(spr.getZ() + 6144);
                Ai.castspell(plr, i);
                spr.setZ(oldz);
                WHOBJ.newstatus(i, 2);
            }
        }
    };

    public static void create() {
        Ai.enemy[22] = new Enemy();
        Ai.enemy[22].info = new EnemyInfo(32, 32, 512, 120, 0, 64, true, Main.game.WH2 ? 5 : 400, 0);
        Ai.enemy[22].chase = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                short osectnum;
                Sector osec;
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setLotag(spr.getLotag() - 3);
                if (spr.getLotag() < 0) {
                    spr.setLotag(250);
                }
                if ((osec = Main.boardService.getSector(osectnum = spr.getSectnum())) == null) {
                    return;
                }
                if (Main.engine.krand() % 63 == 0) {
                    if (Main.engine.cansee(plr.getX(), plr.getY(), plr.getZ(), plr.getSector(), spr.getX(), spr.getY(), spr.getZ() - (Main.engine.getTile(spr.getPicnum()).getHeight() << 7), spr.getSectnum()) && plr.getInvisibletime() < 0) {
                        WHOBJ.newstatus(i, 6);
                    }
                    return;
                }
                int dax = EngineUtils.sin(spr.getAng() + 512 & 0x7FF) * 3 << 3;
                int day = EngineUtils.sin(spr.getAng() & 0x7FF) * 3 << 3;
                Ai.checksight(plr, i);
                if (!Ai.checkdist(plr, i)) {
                    Ai.checkmove(i, dax, day);
                } else if (Main.engine.krand() % 8 == 0) {
                    WHOBJ.newstatus(i, 6);
                } else {
                    spr.setAng((short)((Main.engine.krand() & 0x100) + spr.getAng() + 1024 & 0x7FF));
                    WHOBJ.newstatus(i, 2);
                }
                Main.engine.getzrange(spr.getX(), spr.getY(), spr.getZ() - 1, spr.getSectnum(), spr.getClipdist() << 2, 65537);
                Sector sec = Main.boardService.getSector(spr.getSectnum());
                if (sec != null && spr.getSectnum() != osectnum && sec.getLotag() == 10) {
                    WHFX.warpsprite(i);
                }
                if (spr.getZ() > Engine.zr_florz) {
                    spr.setZ(Engine.zr_florz);
                }
                if (spr.getZ() < Engine.zr_ceilz - 8192) {
                    spr.setZ(Engine.zr_ceilz - 8192);
                }
                if (Ai.checksector6(i)) {
                    return;
                }
                Ai.processfluid(i, Engine.zr_florhit, true);
                if (osec.getLotag() == 4444) {
                    spr.setHitag(spr.getHitag() - 1);
                    if (spr.getHitag() < 0) {
                        WHOBJ.newstatus(i, 107);
                    }
                }
                Main.engine.setsprite(i, spr.getX(), spr.getY(), spr.getZ());
                sec = Main.boardService.getSector(spr.getSectnum());
                if (sec != null && (Engine.zr_florhit & 0xE0000000) == 0x40000000 && (sec.getFloorpicnum() == 79 || sec.getFloorpicnum() == 62 || sec.getFloorpicnum() == 61)) {
                    spr.setHitag(spr.getHitag() - 1);
                    if (spr.getHitag() < 0) {
                        WHOBJ.newstatus(i, 107);
                    }
                }
            }
        };
        Ai.enemy[22].attack = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setLotag(spr.getLotag() - 3);
                if (plr.getZ() < spr.getZ()) {
                    spr.setZ(spr.getZ() - 768);
                }
                if (plr.getZ() > spr.getZ()) {
                    spr.setZ(spr.getZ() + 768);
                }
                if (spr.getLotag() < 0) {
                    if (Main.engine.cansee(plr.getX(), plr.getY(), plr.getZ(), plr.getSector(), spr.getX(), spr.getY(), spr.getZ() - (Main.engine.getTile(spr.getPicnum()).getHeight() << 7), spr.getSectnum())) {
                        if (Ai.checkdist(plr, i)) {
                            if (plr.getShockme() < 0 && (Main.engine.krand() & 1) != 0) {
                                plr.setShockme(120);
                                if (!Main.game.WH2) {
                                    plr.setLvl(plr.getLvl() - 1);
                                    switch (plr.getLvl()) {
                                        case 1: {
                                            plr.setScore(0);
                                            plr.setMaxhealth(100);
                                            break;
                                        }
                                        case 2: {
                                            plr.setScore(2350);
                                            plr.setMaxhealth(120);
                                            break;
                                        }
                                        case 3: {
                                            plr.setScore(4550);
                                            plr.setMaxhealth(140);
                                            break;
                                        }
                                        case 4: {
                                            plr.setScore(9300);
                                            plr.setMaxhealth(160);
                                            break;
                                        }
                                        case 5: {
                                            plr.setScore(18400);
                                            plr.setMaxhealth(180);
                                            break;
                                        }
                                        case 6: {
                                            plr.setScore(36700);
                                            plr.setMaxhealth(200);
                                            break;
                                        }
                                        case 7: {
                                            plr.setScore(75400);
                                            plr.setMaxhealth(200);
                                        }
                                    }
                                    if (plr.getLvl() < 1) {
                                        plr.setLvl(1);
                                        plr.setHealth(-1);
                                    }
                                    WHScreen.showmessage("Level Drained", 360);
                                } else {
                                    WHScreen.showmessage("Shocked", 360);
                                }
                            }
                        } else {
                            WHOBJ.newstatus(i, 143);
                        }
                    } else {
                        WHOBJ.newstatus(i, 2);
                    }
                }
                int floorz = Main.engine.getflorzofslope(spr.getSectnum(), spr.getX(), spr.getY()) - 4096;
                if (spr.getZ() > floorz) {
                    spr.setZ(floorz);
                }
            }
        };
        Ai.enemy[22].face = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                if (Main.engine.cansee(plr.getX(), plr.getY(), plr.getZ(), plr.getSector(), spr.getX(), spr.getY(), spr.getZ() - (Main.engine.getTile(spr.getPicnum()).getHeight() << 7), spr.getSectnum()) && plr.getInvisibletime() < 0) {
                    spr.setAng((short)(EngineUtils.getAngle(plr.getX() - spr.getX(), plr.getY() - spr.getY()) & 0x7FF));
                    if (plr.getShadowtime() > 0) {
                        spr.setAng((short)((Main.engine.krand() & 0x100) + spr.getAng() + 1024 & 0x7FF));
                        WHOBJ.newstatus(i, 122);
                    } else {
                        spr.setOwner(plr.getSpritenum());
                        WHOBJ.newstatus(i, 2);
                    }
                } else if (spr.getOwner() == plr.getSpritenum()) {
                    spr.setAng((short)((Main.engine.krand() & 0x100) + spr.getAng() & 0x7FF));
                    WHOBJ.newstatus(i, 142);
                } else {
                    WHOBJ.newstatus(i, 122);
                }
                if (Ai.checkdist(plr, i)) {
                    WHOBJ.newstatus(i, 6);
                }
            }
        };
        Ai.enemy[22].search = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Ai.aisearch(plr, i, true);
                Ai.checksector6(i);
            }
        };
        Ai.enemy[22].flee = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sector sec;
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setLotag(spr.getLotag() - 3);
                short osectnum = spr.getSectnum();
                Sector osec = Main.boardService.getSector(osectnum);
                if (osec == null) {
                    return;
                }
                int movestat = Ai.aifly(i);
                if (movestat != 0) {
                    if ((movestat & 0xE0000000) == Integer.MIN_VALUE) {
                        Wall wal = Main.boardService.getWall(movestat & 0x1FFFFFFF);
                        if (wal != null) {
                            int nx = -(wal.getWall2().getY() - wal.getY()) >> 4;
                            int ny = wal.getWall2().getX() - wal.getX() >> 4;
                            spr.setAng(EngineUtils.getAngle(nx, ny));
                        }
                    } else {
                        spr.setAng(EngineUtils.getAngle(plr.getX() - spr.getX(), plr.getY() - spr.getY()));
                        WHOBJ.newstatus(i, 109);
                    }
                }
                if (spr.getLotag() < 0) {
                    WHOBJ.newstatus(i, 109);
                }
                if ((sec = Main.boardService.getSector(spr.getSectnum())) != null && spr.getSectnum() != osectnum && sec.getLotag() == 10) {
                    WHFX.warpsprite(i);
                }
                if (Ai.checksector6(i)) {
                    return;
                }
                Ai.processfluid(i, Engine.zr_florhit, true);
                Main.engine.setsprite(i, spr.getX(), spr.getY(), spr.getZ());
            }
        };
        Ai.enemy[22].die = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setLotag(spr.getLotag() - 3);
                if (spr.getLotag() <= 0) {
                    spr.setPicnum(spr.getPicnum() + 1);
                    spr.setLotag(20);
                    if (spr.getPicnum() == 653 || spr.getPicnum() == 654 || spr.getPicnum() == 655) {
                        spr.setYrepeat(spr.getYrepeat() << 1);
                        spr.setXrepeat(spr.getYrepeat());
                    }
                    if (spr.getPicnum() == 655) {
                        if (Globals.difficulty == 4) {
                            WHOBJ.newstatus(i, 116);
                        } else {
                            ++Globals.kills;
                            WHOBJ.newstatus(i, 108);
                        }
                    }
                }
            }
        };
        Ai.enemy[22].nuked = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                if (Main.game.WH2) {
                    WHPLR.chunksofmeat(plr, i, spr.getX(), spr.getY(), spr.getZ(), spr.getSectnum(), spr.getAng());
                    WHOBJ.trailingsmoke(i, false);
                    WHOBJ.newstatus(i, 107);
                }
            }
        };
    }

    public static void willowProcess(PLAYER plr) {
        ListNode<Sprite> node = Main.boardService.getStatNode(143);
        while (node != null) {
            ListNode<Sprite> next = node.getNext();
            int i = node.getIndex();
            Sprite spr = Main.boardService.getSprite(i);
            if (spr == null) {
                Main.engine.deletesprite(i);
                return;
            }
            if (spr.getDetail() == 22) {
                willowDrain.process(plr, i);
            }
            node = next;
        }
    }

    public static void premap(int i) {
        Sprite spr = Main.boardService.getSprite(i);
        if (spr == null) {
            Main.engine.deletesprite(i);
            return;
        }
        spr.setDetail(22);
        Ai.enemy[22].info.set(spr);
        spr.setCstat(spr.getCstat() | 0x80);
        spr.setZ(spr.getZ() - (Main.engine.getTile(Names.WILLOW).getHeight() << 8));
        Main.engine.changespritestat(i, 109);
    }
}

