/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.stream.IntStream;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.settings.ConfigContext;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.Build.settings.GameKeys;
import ru.m210projects.Build.settings.InputContext;
import ru.m210projects.Build.settings.Properties;

public class Config
extends GameConfig {
    public static final int[] defkeys = new int[]{51, 47, 21, 22, 67, 57, 29, 32, 62, 129, 59, 33, 0, 0, 0, 0, 0, 61, 70, 69, 48, 49, 111, 68, 115, 92, 93, 3, 8, 9, 10, 11, 12, 13, 14, 15, 16, 7, 45, 145, 146, 147, 148, 149, 150, 151, 152, 75, 74, 66, 71, 72, 124, 112, 123, 0, 0, 0, 0, 0, 34, 37, 39, 139, 136, 132, 133, 134, 135, 140, 141, 142};
    public static final int[] defclassickeys = new int[]{19, 20, 21, 22, 0, 57, 55, 56, 52, 31, 59, 62, 129, 0, 0, 0, 0, 61, 70, 69, 0, 0, 111, 0, 0, 92, 93, 3, 8, 9, 10, 11, 12, 13, 14, 15, 16, 7, 68, 131, 132, 133, 134, 135, 136, 137, 138, 0, 0, 66, 71, 72, 124, 112, 123, 0, 0, 0, 0, 0, 34, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public int weaponIndex = -1;
    public int spellIndex = -1;
    public int gViewSize = 1;
    public boolean MessageState = true;
    public boolean gCrosshair = true;
    public boolean gAutoRun = false;
    public int gStatSize = 32768;
    public int gCrossSize = 65536;
    public int gShowStat = 1;
    public int gHudScale = 65536;
    public boolean showCutscenes = true;
    public boolean gGameGore = true;
    public boolean showMapInfo = true;
    public int gDemoSeq = 1;

    public Config(Path path) {
        super(path);
    }

    public GameKey[] getKeyMap() {
        return new GameKey[]{GameKeys.Move_Forward, GameKeys.Move_Backward, GameKeys.Turn_Left, GameKeys.Turn_Right, GameKeys.Turn_Around, GameKeys.Strafe, GameKeys.Strafe_Left, GameKeys.Strafe_Right, GameKeys.Jump, GameKeys.Crouch, GameKeys.Run, WhKeys.AutoRun, GameKeys.Open, GameKeys.Weapon_Fire, WhKeys.Cast_spell, WhKeys.Aim_Up, WhKeys.Aim_Down, WhKeys.Aim_Center, WhKeys.Weapon_1, WhKeys.Weapon_2, WhKeys.Weapon_3, WhKeys.Weapon_4, WhKeys.Weapon_5, WhKeys.Weapon_6, WhKeys.Weapon_7, WhKeys.Weapon_8, WhKeys.Weapon_9, WhKeys.Weapon_10, GameKeys.Next_Weapon, GameKeys.Previous_Weapon, WhKeys.Scare_Spell, WhKeys.Nightvision_Spell, WhKeys.Freeze_Spell, WhKeys.Arrow_Spell, WhKeys.Opendoor_Spell, WhKeys.Fly_Spell, WhKeys.Fire_Spell, WhKeys.Nuke_Spell, WhKeys.Spell_next, WhKeys.Spell_prev, WhKeys.Health_potion, WhKeys.Strength_potion, WhKeys.Curepoison_potion, WhKeys.Fireresist_potion, WhKeys.Invisibility_potion, WhKeys.Inventory_Use, WhKeys.Inventory_Left, WhKeys.Inventory_Right, GameKeys.Map_Toggle, WhKeys.Map_Follow_Mode, GameKeys.Shrink_Screen, GameKeys.Enlarge_Screen, GameKeys.Mouse_Aiming, WhKeys.Toggle_Crosshair, WhKeys.Fly_up, WhKeys.Fly_down, WhKeys.End_flying, GameKeys.Send_Message, WhKeys.See_Coop_View, GameKeys.Show_Console, WhKeys.Quickload, WhKeys.Quicksave, WhKeys.Show_Savemenu, WhKeys.Show_Loadmenu, WhKeys.Show_Sounds, WhKeys.Show_Options, WhKeys.Quit, WhKeys.Gamma, WhKeys.Make_Screenshot, GameKeys.Menu_Toggle};
    }

    @Override
    protected InputContext createDefaultInputContext() {
        GameKey[] keymap = this.getKeyMap();
        return new InputContext(keymap, defkeys, defclassickeys){

            @Override
            protected void clearInput() {
                super.clearInput();
                Config.this.weaponIndex = IntStream.range(0, this.keymap.length).filter(i -> this.keymap[i].equals(WhKeys.Weapon_1)).findFirst().orElse(-1);
                Config.this.spellIndex = IntStream.range(0, this.keymap.length).filter(i -> this.keymap[i].equals(WhKeys.Scare_Spell)).findFirst().orElse(-1);
            }
        };
    }

    @Override
    protected ConfigContext createDefaultGameContext() {
        return new ConfigContext(){

            @Override
            public void load(Properties prop) {
                if (prop.setContext("Options")) {
                    Config.this.gViewSize = prop.getIntValue("ViewSize", Config.this.gViewSize);
                    Config.this.gCrosshair = prop.getBooleanValue("Crosshair", Config.this.gCrosshair);
                    Config.this.MessageState = prop.getBooleanValue("MessageState", Config.this.MessageState);
                    Config.this.gAutoRun = prop.getBooleanValue("AutoRun", Config.this.gAutoRun);
                    Config.this.gStatSize = Math.max(prop.getIntValue("StatSize", Config.this.gStatSize), 16384);
                    Config.this.gCrossSize = Math.max(prop.getIntValue("CrossSize", Config.this.gCrossSize), 16384);
                    Config.this.gHudScale = Math.max(prop.getIntValue("HUDScale", Config.this.gHudScale), 32768);
                    Config.this.gShowStat = prop.getIntValue("ShowStat", Config.this.gShowStat);
                    Config.this.showCutscenes = prop.getBooleanValue("showCutscenes", Config.this.showCutscenes);
                    Config.this.gGameGore = prop.getBooleanValue("Gore", Config.this.gGameGore);
                    Config.this.showMapInfo = prop.getBooleanValue("ShowMapInfo", Config.this.showMapInfo);
                    Config.this.gDemoSeq = prop.getIntValue("DemoSequence", Config.this.gDemoSeq);
                }
            }

            @Override
            public void save(OutputStream os) throws IOException {
                this.putString(os, "[Options]\r\n");
                this.putInteger(os, "ViewSize", Config.this.gViewSize);
                this.putBoolean(os, "Crosshair", Config.this.gCrosshair);
                this.putBoolean(os, "MessageState", Config.this.MessageState);
                this.putBoolean(os, "AutoRun", Config.this.gAutoRun);
                this.putInteger(os, "StatSize", Config.this.gStatSize);
                this.putInteger(os, "CrossSize", Config.this.gCrossSize);
                this.putInteger(os, "HUDScale", Config.this.gHudScale);
                this.putInteger(os, "ShowStat", Config.this.gShowStat);
                this.putBoolean(os, "showCutscenes", Config.this.showCutscenes);
                this.putBoolean(os, "Gore", Config.this.gGameGore);
                this.putBoolean(os, "ShowMapInfo", Config.this.showMapInfo);
                this.putInteger(os, "DemoSequence", Config.this.gDemoSeq);
            }
        };
    }

    public static enum WhKeys implements GameKey
    {
        AutoRun,
        Aim_Up,
        Aim_Down,
        Aim_Center,
        Weapon_1,
        Weapon_2,
        Weapon_3,
        Weapon_4,
        Weapon_5,
        Weapon_6,
        Weapon_7,
        Weapon_8,
        Weapon_9,
        Weapon_10,
        Cast_spell,
        Scare_Spell,
        Nightvision_Spell,
        Freeze_Spell,
        Arrow_Spell,
        Opendoor_Spell,
        Fly_Spell,
        Fire_Spell,
        Nuke_Spell,
        Spell_next,
        Spell_prev,
        Inventory_Use,
        Inventory_Left,
        Inventory_Right,
        Fly_up,
        Fly_down,
        End_flying,
        Health_potion,
        Strength_potion,
        Curepoison_potion,
        Fireresist_potion,
        Invisibility_potion,
        Map_Follow_Mode,
        Toggle_Crosshair,
        See_Coop_View,
        Quickload,
        Quicksave,
        Show_Savemenu,
        Show_Loadmenu,
        Show_Sounds,
        Show_Options,
        Quit,
        Gamma,
        Make_Screenshot;


        @Override
        public int getNum() {
            return GameKeys.values().length + this.ordinal();
        }

        @Override
        public String getName() {
            return this.name();
        }
    }
}

