/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven.Factory;

import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenuList;
import ru.m210projects.Build.Pattern.MenuItems.MenuButton;
import ru.m210projects.Build.Pattern.MenuItems.MenuConteiner;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuJoyList;
import ru.m210projects.Build.Pattern.MenuItems.MenuKeyboardList;
import ru.m210projects.Build.Pattern.MenuItems.MenuList;
import ru.m210projects.Build.Pattern.MenuItems.MenuResolutionList;
import ru.m210projects.Build.Pattern.MenuItems.MenuSlider;
import ru.m210projects.Build.Pattern.MenuItems.MenuSwitch;
import ru.m210projects.Build.Pattern.MenuItems.MenuTextField;
import ru.m210projects.Build.Pattern.MenuItems.MenuVariants;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Witchaven.Factory.WHMenuHandler;
import ru.m210projects.Witchaven.Fonts.MenuFont;
import ru.m210projects.Witchaven.Menu.MenuInterfaceSet;
import ru.m210projects.Witchaven.Names;
import ru.m210projects.Witchaven.Screens.MenuScreen;
import ru.m210projects.Witchaven.WHSND;

public class WH2MenuHandler
extends WHMenuHandler {
    public WH2MenuHandler(BuildGame app) {
        super(app);
    }

    @Override
    public void mDrawMenu() {
        Renderer renderer = this.game.getRenderer();
        if (!(this.app.getScreen() instanceof MenuScreen || this.app.pMenu.getCurrentMenu() instanceof BuildMenuList || this.app.pMenu.getCurrentMenu() instanceof MenuInterfaceSet)) {
            int xdim = renderer.getWidth();
            int ydim = renderer.getHeight();
            int tile = 500;
            ArtEntry pic = this.engine.getTile(tile);
            float kt = (float)xdim / (float)ydim;
            float kv = (float)pic.getWidth() / (float)pic.getHeight();
            float scale = kv >= kt ? (float)(ydim + 1) / (float)pic.getHeight() : (float)(xdim + 1) / (float)pic.getWidth();
            renderer.rotatesprite(0, 0, (int)(scale * 65536.0f), 0, tile, 127, 0, 25);
        }
        if (this.mMenuHistory[0] != null) {
            int px;
            int scale;
            MenuItem item = this.mMenuHistory[0].m_pItems[this.mMenuHistory[0].m_nFocus];
            if (item instanceof MenuButton) {
                if (item.align == 1) {
                    scale = 32768;
                    int py = item.y;
                    int yoff = 5;
                    int posx = 160;
                    renderer.rotatesprite(posx << 16, py + yoff << 16, scale, 0, 9336, 0, 0, 10);
                } else {
                    scale = 8192;
                    px = item.x;
                    int py = item.y;
                    int xoff = -10;
                    int yoff = 3;
                    renderer.rotatesprite(px + xoff << 16, py + yoff << 16, scale, 0, Names.HELMET, 0, 0, 10);
                }
            } else if (item instanceof MenuSwitch || item instanceof MenuSlider || item instanceof MenuConteiner || item instanceof MenuTextField) {
                scale = 8192;
                px = item.x;
                int py = item.y;
                int xoff = -10;
                int yoff = 3;
                renderer.rotatesprite(px + xoff << 16, py + yoff << 16, scale, 0, Names.HELMET, 0, 0, 10);
            } else if (item instanceof MenuVariants) {
                scale = 16384;
                px = item.x;
                int py = item.y;
                int xoff = 0;
                int yoff = 16;
                renderer.rotatesprite(px + xoff << 16, py + yoff << 16, scale, 0, Names.HELMET, 0, 0, 10);
            } else if (item instanceof MenuList) {
                if (item instanceof MenuJoyList) {
                    MenuList list = (MenuList)item;
                    px = list.x;
                    int focus = list.l_nFocus;
                    if (focus != -1 && focus >= list.l_nMin && focus < list.l_nMin + list.rowCount) {
                        int py = list.y + (focus - list.l_nMin) * list.mFontOffset();
                        int scale2 = 8192;
                        int xoff = -11;
                        int yoff = 2;
                        renderer.rotatesprite(px + xoff << 16, py + yoff << 16, scale2, 0, Names.HELMET, 0, 0, 10);
                    }
                } else if (item instanceof MenuKeyboardList) {
                    MenuList list = (MenuList)item;
                    px = list.x;
                    int focus = list.l_nFocus;
                    if (focus != -1 && focus >= list.l_nMin && focus < list.l_nMin + list.rowCount) {
                        int py = list.y + (focus - list.l_nMin) * list.mFontOffset();
                        int scale3 = 8192;
                        int xoff = -11;
                        int yoff = 2;
                        renderer.rotatesprite(px + xoff << 16, py + yoff << 16, scale3, 0, Names.HELMET, 0, 0, 10);
                    }
                } else if (item instanceof MenuResolutionList) {
                    MenuList list = (MenuList)item;
                    px = list.x;
                    int focus = list.l_nFocus;
                    if (focus != -1 && focus >= list.l_nMin && focus < list.l_nMin + list.rowCount) {
                        int py = list.y + (focus - list.l_nMin) * list.mFontOffset();
                        int scale4 = 8192;
                        int xoff = 0;
                        int yoff = 2;
                        renderer.rotatesprite(px + xoff << 16, py + yoff << 16, scale4, 0, Names.HELMET, 0, 0, 10);
                    }
                }
            }
        }
        this.mMenuDraw();
    }

    @Override
    public int getPal(Font font, MenuItem item) {
        if (item != null) {
            if (item.isFocused()) {
                if (item instanceof MenuButton && item.align == 1) {
                    if (!item.isEnabled()) {
                        return 6;
                    }
                    return 8;
                }
                return 7;
            }
            if (!item.isEnabled()) {
                return 6;
            }
            if (font != null && font.getClass().equals(MenuFont.class)) {
                return item.pal;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public void mDrawMouse(int x, int y) {
        if (!this.app.pCfg.isMenuMouse()) {
            return;
        }
        Renderer renderer = this.game.getRenderer();
        int zoom = Pragmas.scale(65536L, renderer.getHeight(), 200L);
        int czoom = Pragmas.mulscale(32768L, Pragmas.mulscale(zoom, this.app.pCfg.getgMouseCursorSize(), 16), 16);
        int xoffset = 0;
        int yoffset = 0;
        int ang = 0;
        renderer.rotatesprite(x + xoffset << 16, y + yoffset << 16, czoom, ang, 9217, 0, 0, 8);
    }

    @Override
    public boolean mCheckBackButton(int mx, int my) {
        Renderer renderer = this.game.getRenderer();
        int ydim = renderer.getHeight();
        int zoom = Pragmas.scale(16384L, ydim, 200L);
        ArtEntry pic = renderer.getTile(9216);
        int size = Pragmas.mulscale(pic.getWidth(), zoom, 16);
        int bx = 0;
        int by = ydim - Pragmas.mulscale(pic.getHeight(), zoom, 16);
        if (mx >= bx && mx < bx + size) {
            return my >= by && my < by + size;
        }
        return false;
    }

    @Override
    public void mSound(MenuItem item, MenuHandler.MenuOpt opt) {
        switch (opt) {
            case Open: 
            case Close: 
            case UP: 
            case DW: 
            case LEFT: 
            case RIGHT: 
            case ENTER: 
            case MCHANGE: {
                WHSND.SND_Sound(59);
                break;
            }
        }
    }
}

