/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven.Factory;

import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Tables;
import ru.m210projects.Build.Types.DefaultPaletteLoader;
import ru.m210projects.Build.Types.DefaultPaletteManager;
import ru.m210projects.Build.Types.PaletteManager;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.osd.CommandResponse;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.commands.OsdCommand;
import ru.m210projects.Witchaven.Factory.WHBoardService;
import ru.m210projects.Witchaven.Factory.WHPaletteLoader;
import ru.m210projects.Witchaven.Factory.WHTables;
import ru.m210projects.Witchaven.Main;

public class WHEngine
extends Engine {
    public static String randomStack = "";

    public WHEngine(BuildGame game) throws Exception {
        super(game);
        this.inittimer(game.pCfg.isLegacyTimer(), 120, 3);
        Console.out.registerCommand(new OsdCommand("fastdemo", "fastdemo \"demo speed\""){

            @Override
            public CommandResponse execute(String[] argv) {
                if (argv.length != 1) {
                    return CommandResponse.DESCRIPTION_RESPONSE;
                }
                try {
                    WHEngine.this.getTimer().setSkipTicks(Math.max(0, Integer.parseInt(argv[0])));
                }
                catch (Exception e) {
                    return CommandResponse.BAD_ARGUMENT_RESPONSE;
                }
                return CommandResponse.OK_RESPONSE;
            }
        });
    }

    @Override
    public int krand() {
        return super.krand();
    }

    @Override
    protected BoardService createBoardService() {
        return new WHBoardService();
    }

    @Override
    protected Tables loadtables() throws Exception {
        return new WHTables(this.game.getCache().getEntry("tables.dat", true));
    }

    @Override
    public PaletteManager loadpalette() throws Exception {
        Entry paletteEntry = this.game.getCache().getEntry("palette.dat", true);
        return new DefaultPaletteManager(this, Main.game.WH2 ? new DefaultPaletteLoader(paletteEntry) : new WHPaletteLoader(paletteEntry));
    }
}

