/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven.Factory;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenuList;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuSlider;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Witchaven.Fonts.MenuFont;
import ru.m210projects.Witchaven.Menu.MenuInterfaceSet;
import ru.m210projects.Witchaven.Screens.MenuScreen;
import ru.m210projects.Witchaven.WHSND;

public class WHMenuHandler
extends MenuHandler {
    public static final int MAIN = 0;
    public static final int GAME = 1;
    public static final int LOADGAME = 3;
    public static final int SAVEGAME = 4;
    public static final int QUIT = 6;
    public static final int AUDIOSET = 8;
    public static final int OPTIONS = 10;
    public static final int COLORCORR = 11;
    public static final int DIFFICULTY = 12;
    public static final int CORRUPTLOAD = 13;
    protected final Engine engine;
    protected final BuildGame app;

    public WHMenuHandler(BuildGame app) {
        super(app);
        this.mMenus = new BuildMenu[15];
        this.engine = app.pEngine;
        this.app = app;
    }

    @Override
    public void mDrawMenu() {
        if (!(this.app.getScreen() instanceof MenuScreen || this.app.pMenu.getCurrentMenu() instanceof BuildMenuList || this.app.pMenu.getCurrentMenu() instanceof MenuInterfaceSet)) {
            int tile = 500;
            Renderer renderer = this.game.getRenderer();
            ArtEntry pic = renderer.getTile(tile);
            int xdim = renderer.getWidth();
            int ydim = renderer.getHeight();
            float kt = (float)xdim / (float)ydim;
            float kv = (float)pic.getWidth() / (float)pic.getHeight();
            float scale = kv >= kt ? (float)(ydim + 1) / (float)pic.getHeight() : (float)(xdim + 1) / (float)pic.getWidth();
            renderer.rotatesprite(0, 0, (int)(scale * 65536.0f), 0, tile, 127, 0, 25);
        }
        this.mMenuDraw();
    }

    protected void mMenuDraw() {
        super.mDrawMenu();
    }

    @Override
    public int getShade(MenuItem item) {
        if (item != null && item.getClass().getSuperclass().equals(MenuSlider.class) && !item.isEnabled()) {
            return -127;
        }
        if (item != null && item.isFocused()) {
            return 16 - (this.engine.getTotalClock() & 0x3F);
        }
        return 0;
    }

    @Override
    public int getPal(Font font, MenuItem item) {
        if (item != null) {
            if (item.isFocused()) {
                if (font != null && font.getClass().equals(MenuFont.class)) {
                    return 20;
                }
                return 9;
            }
            if (!item.isEnabled()) {
                if (font != null && font.getClass().equals(MenuFont.class)) {
                    return 9;
                }
                return 20;
            }
            if (font != null && font.getClass().equals(MenuFont.class)) {
                return item.pal;
            }
            return 9;
        }
        return 0;
    }

    @Override
    public void mDrawMouse(int x, int y) {
        if (!this.app.pCfg.isMenuMouse()) {
            return;
        }
        Renderer renderer = this.game.getRenderer();
        int ydim = renderer.getHeight();
        int zoom = Pragmas.scale(65536L, ydim, 200L);
        int czoom = Pragmas.mulscale(32768L, Pragmas.mulscale(zoom, this.app.pCfg.getgMouseCursorSize(), 16), 16);
        int xoffset = 0;
        int yoffset = 0;
        int ang = 0;
        renderer.rotatesprite(x + xoffset << 16, y + yoffset << 16, czoom, ang, 9217, 0, 0, 8);
    }

    @Override
    public void mDrawBackButton() {
        if (!this.app.pCfg.isMenuMouse()) {
            return;
        }
        Renderer renderer = this.game.getRenderer();
        int ydim = renderer.getHeight();
        int zoom = Pragmas.scale(16384L, ydim, 200L);
        if (this.mCount > 1) {
            ArtEntry pic = renderer.getTile(9216);
            int shade = 4 + Pragmas.mulscale(16L, EngineUtils.sin(20 * this.engine.getTotalClock() & 0x7FF), 16);
            renderer.rotatesprite(0, ydim - Pragmas.mulscale(pic.getHeight(), zoom, 16) << 16, zoom, 0, 9216, shade, 0, 24, 0, 0, Pragmas.mulscale(zoom, pic.getWidth() - 1, 16), ydim - 1);
        }
    }

    @Override
    public boolean mCheckBackButton(int mx, int my) {
        Renderer renderer = this.game.getRenderer();
        int ydim = renderer.getHeight();
        int zoom = Pragmas.scale(16384L, ydim, 200L);
        ArtEntry pic = this.engine.getTile(9216);
        int size = Pragmas.mulscale(pic.getWidth(), zoom, 16);
        int bx = 0;
        int by = ydim - Pragmas.mulscale(pic.getHeight(), zoom, 16);
        if (mx >= bx && mx < bx + size) {
            return my >= by && my < by + size;
        }
        return false;
    }

    @Override
    public void mSound(MenuItem item, MenuHandler.MenuOpt opt) {
        switch (opt) {
            case Open: 
            case Close: 
            case UP: 
            case DW: 
            case LEFT: 
            case RIGHT: 
            case ENTER: 
            case MCHANGE: {
                WHSND.SND_Sound(85);
                break;
            }
        }
    }

    @Override
    public void mPostDraw(MenuItem item) {
    }
}

