/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven.Menu;

import java.util.List;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuFileBrowser;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.exceptions.WarningException;
import ru.m210projects.Build.filehandle.CacheResourceMap;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.filehandle.grp.GrpFile;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Witchaven.Globals;
import ru.m210projects.Witchaven.Main;
import ru.m210projects.Witchaven.Menu.WHTitle;
import ru.m210projects.Witchaven.Types.EpisodeEntry;
import ru.m210projects.Witchaven.Types.EpisodeInfo;
import ru.m210projects.Witchaven.Types.EpisodeManager;

public class WHMenuUserContent
extends BuildMenu {
    public static final EpisodeManager episodeManager = new EpisodeManager();
    public static boolean usecustomarts;
    private static GrpFile usergroup;
    public int skills;

    public WHMenuUserContent(Main app) {
        super(app.pMenu);
        WHTitle title = new WHTitle("User content", 90, 0);
        int width = 240;
        MenuFileBrowser list = new MenuFileBrowser(app, app.WH2 ? app.getFont(0) : app.getFont(1), app.getFont(0), app.WH2 ? app.getFont(0) : app.getFont(1), 40, 55, width, 1, app.WH2 ? 8 : 10, 500){

            @Override
            public void init() {
                this.registerExtension("map", 0, 0);
                this.registerExtension("zip", 5, 1);
                this.registerExtension("pk3", 5, 1);
                this.registerClass(EpisodeEntry.Addon.class, 5, 2);
                this.registerExtension("dmo", 1, -1);
            }

            @Override
            public void handleDirectory(Directory dir) {
                EpisodeInfo ep = episodeManager.getEpisode(dir.getDirectoryEntry());
                if (ep != null) {
                    if (ep.equals(Globals.gOriginalEpisode)) {
                        return;
                    }
                    this.addFile(ep.getEpisodeEntry());
                }
            }

            @Override
            public void handleFile(FileEntry file) {
                switch (file.getExtension()) {
                    case "MAP": {
                        Directory dir = file.getParent();
                        EpisodeInfo addon = episodeManager.getEpisode(dir.getDirectoryEntry());
                        if (addon != null) {
                            for (int j = 0; j < addon.maps(); ++j) {
                                if (!file.getName().equalsIgnoreCase(addon.gMapInfo.get((int)j).path)) continue;
                                return;
                            }
                        }
                        this.addFile(file);
                        break;
                    }
                    case "DMO": {
                        if (!Main.gDemoScreen.isDemoFile(file)) break;
                        this.addFile(file);
                        break;
                    }
                    case "PK3": 
                    case "ZIP": {
                        EpisodeInfo ep = episodeManager.getEpisode(file);
                        if (ep == null) break;
                        this.addFile(ep.getEpisodeEntry());
                    }
                }
            }

            @Override
            public void invoke(FileEntry fil) {
                switch (fil.getExtension()) {
                    case "MAP": {
                        WHMenuUserContent.this.launchMap(fil, WHMenuUserContent.this.skills);
                        this.app.pMenu.mClose();
                        break;
                    }
                    case "GRP": 
                    case "ZIP": 
                    case "PK3": {
                        WHMenuUserContent.this.launchEpisode(episodeManager.getEpisode(fil), WHMenuUserContent.this.skills);
                        break;
                    }
                    case "DMO": {
                        Directory parent = fil.getParent();
                        List<Entry> demoList = Main.gDemoScreen.checkDemoEntry(parent);
                        Main.gDemoScreen.nDemonum = demoList.indexOf(fil);
                        Main.gDemoScreen.showDemo(fil);
                        this.app.pMenu.mClose();
                        break;
                    }
                    default: {
                        if (!(fil instanceof EpisodeEntry)) break;
                        WHMenuUserContent.this.launchEpisode(episodeManager.getEpisode(fil), WHMenuUserContent.this.skills);
                    }
                }
            }
        };
        list.pathPal = 7;
        this.addItem(title, false);
        this.addItem(list, true);
    }

    public static void resetEpisodeResources(EpisodeInfo def) {
        Console.out.println("Resetting custom resources", OsdColor.GREEN);
        if (usergroup != null) {
            Main.game.getCache().removeGroup(usergroup);
        }
        usergroup = null;
        Globals.gCurrentEpisode = def;
        if (!usecustomarts) {
            Main.game.setDefs(Main.game.baseDef);
            return;
        }
        System.err.println("Reset to default resources");
        if (Main.engine.loadpics() == 0) {
            throw new AssertException("ART files not found " + Main.game.getCache().getGameDirectory().getPath().resolve(Main.engine.getTileManager().getTilesPath()));
        }
        if (!Main.game.setDefs(Main.game.baseDef)) {
            Main.game.baseDef.apply();
        }
        usecustomarts = false;
    }

    public static boolean checkEpisodeResources(EpisodeInfo addon) {
        WHMenuUserContent.resetEpisodeResources(Globals.gOriginalEpisode);
        usergroup = new GrpFile("RemovableGroup");
        EpisodeEntry.Addon addonEntry = addon.getEpisodeEntry();
        Group parent = addonEntry.getGroup();
        DefScript addonScript = new DefScript(Main.game.baseDef, addonEntry.getFileEntry());
        if (!(parent instanceof Directory)) {
            try {
                Entry res = parent.getEntry(Main.game.getGameDef());
                if (res.exists()) {
                    addonScript.loadScript(parent.getName() + " script", res);
                }
                WHMenuUserContent.searchEpisodeResources(parent, usergroup);
            }
            catch (Exception e) {
                throw new WarningException("Error found in " + addonEntry.getName() + "\r\n" + e.getMessage());
            }
        } else if (!Main.game.getCache().isGameDirectory(parent)) {
            WHMenuUserContent.searchEpisodeResources(parent, usergroup);
            Entry def = parent.getEntry(Main.game.getGameDef());
            if (def.exists()) {
                addonScript.loadScript(def);
            }
        }
        Main.game.getCache().addGroup(usergroup, CacheResourceMap.CachePriority.HIGHEST);
        WHMenuUserContent.InitGroupResources(addonScript, usergroup.getEntries());
        Globals.gCurrentEpisode = addon;
        Main.game.setDefs(addonScript);
        return true;
    }

    private static void searchEpisodeResources(Group container, GrpFile resourceHolder) {
        for (Entry file : container.getEntries()) {
            Group subContainer = Directory.DUMMY_DIRECTORY;
            if (file.isDirectory() && file instanceof FileEntry) {
                subContainer = ((FileEntry)file).getDirectory();
            } else if (file.isExtension("pk3") || file.isExtension("zip") || file.isExtension("grp") || file.isExtension("rff")) {
                subContainer = Main.game.getCache().newGroup(file);
            }
            if (!((Object)subContainer).equals(Directory.DUMMY_DIRECTORY)) {
                WHMenuUserContent.searchEpisodeResources(subContainer, resourceHolder);
                continue;
            }
            resourceHolder.addEntry(file);
        }
    }

    public static void InitGroupResources(DefScript addonScript, List<Entry> list) {
        for (Entry res : list) {
            switch (res.getExtension()) {
                case "ART": {
                    Main.engine.loadpic(res);
                    usecustomarts = true;
                    break;
                }
                case "DEF": {
                    if (res.getName().equalsIgnoreCase(Main.game.getGameDef())) break;
                    addonScript.loadScript(res.getName() + " script", res);
                    Console.out.println("Found def-script. Loading " + res.getName());
                }
            }
        }
    }

    private void launchEpisode(EpisodeInfo ep, int skill) {
        if (ep == null) {
            return;
        }
        Main.gGameScreen.newgame(ep, 1, skill);
    }

    private void launchMap(FileEntry fil, int skill) {
        if (fil == null) {
            return;
        }
        Main.gGameScreen.newgame(fil, 0, skill);
    }
}

