/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven.Screens;

import com.badlogic.gdx.Screen;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Witchaven.Globals;
import ru.m210projects.Witchaven.Main;
import ru.m210projects.Witchaven.Screens.GameScreen;
import ru.m210projects.Witchaven.Types.CompareService.CompareService;
import ru.m210projects.Witchaven.Types.DemoFile;
import ru.m210projects.Witchaven.Types.DemoRecorder;
import ru.m210projects.Witchaven.Types.EpisodeInfo;
import ru.m210projects.Witchaven.WHPLR;
import ru.m210projects.Witchaven.Whldsv;

public class DemoScreen
extends GameScreen {
    public static final String header = "WHDEM";
    public static DemoFile demfile;
    public final Map<Group, List<Entry>> demofiles = new HashMap<Group, List<Entry>>();
    public int nDemonum = -1;
    protected Entry lastDemoEntry = Directory.DUMMY_ENTRY;
    private int ototalclock;

    public DemoScreen(Main game) {
        super(game);
    }

    public static boolean isDemoPlaying() {
        return Globals.recstat == 2;
    }

    public static boolean isDemoScreen(Screen screen) {
        return screen == Main.gDemoScreen;
    }

    public static boolean checkCodeVersion(Screen screen, int version) {
        return screen == Main.gGameScreen || DemoScreen.isDemoPlaying() && demfile != null && DemoScreen.demfile.version >= version;
    }

    @Override
    public void show() {
        Whldsv.lastload = null;
    }

    public boolean showDemo(Entry entry) {
        this.onStopRecord();
        demfile = null;
        try (InputStream is = entry.getInputStream();){
            demfile = new DemoFile(is);
        }
        catch (Exception e) {
            Console.out.println("Can't play the demo file: " + entry.getName(), OsdColor.RED);
            return false;
        }
        if (Mmulti.numplayers > 1) {
            Main.game.pNet.NetDisconnect(Mmulti.myconnectindex);
        }
        Globals.recstat = 2;
        this.lastDemoEntry = entry;
        EpisodeInfo episodeInfo = Globals.gOriginalEpisode;
        if (DemoScreen.demfile.addon != null) {
            episodeInfo = DemoScreen.demfile.addon;
        }
        this.newgame(episodeInfo, DemoScreen.demfile.map, DemoScreen.demfile.skill);
        Console.out.println("Playing demo " + entry.getName());
        return true;
    }

    @Override
    public boolean gameKeyDown(GameKey gameKey) {
        return this.gameKeyDownCommon(gameKey, false);
    }

    @Override
    public void resume() {
        super.resume();
    }

    @Override
    public void pause() {
        this.ototalclock = Main.engine.getTimer().getTotalClock();
        super.pause();
    }

    public void onPrepareboard(GameScreen screen) {
        if (screen != this && DemoScreen.isDemoPlaying()) {
            Main.gDemoScreen.onStopPlaying();
        }
        if (demfile != null && DemoScreen.demfile.version >= 100 && DemoScreen.isDemoPlaying()) {
            short i = Mmulti.connecthead;
            while (i >= 0) {
                DemoScreen.demfile.playerData.applyTo(WHPLR.player[i]);
                i = Mmulti.connectpoint2[i];
            }
        }
        if (screen != this && this.isRecordEnabled()) {
            Globals.m_recstat = 0;
            int democount = 0;
            do {
                int a = democount / 1000 % 10;
                int b = democount / 100 % 10;
                int c = democount / 10 % 10;
                int d = democount % 10;
                String fn = "demo" + a + b + c + d + ".dmo";
                if (Main.game.getCache().getGameDirectory().getEntry(fn).exists()) continue;
                try {
                    Path path = Main.game.getCache().getGameDirectory().getPath().resolve(fn);
                    Globals.rec = new DemoRecorder(new FileOutputStream(path.toFile()), path, 101);
                    Console.out.println("Start recording to " + fn);
                    Globals.recstat = 1;
                }
                catch (Exception e) {
                    Console.out.println("Can't start demo record: " + e, OsdColor.RED);
                }
                break;
            } while (++democount < 9999);
        }
    }

    public boolean isRecordEnabled() {
        return Globals.m_recstat == 1;
    }

    public void onStopPlaying() {
        demfile = null;
        Globals.recstat = 0;
    }

    public void onStopRecord() {
        if (Globals.rec == null) {
            return;
        }
        CompareService.close();
        Globals.rec.close();
        Globals.rec = null;
        Globals.recstat = 0;
    }

    public void onRecord() {
        if (Globals.rec != null) {
            Globals.rec.record();
        }
    }

    public void onLoad() {
        this.onStopRecord();
        demfile = null;
        Globals.recstat = 0;
    }

    @Override
    protected void startboard(Runnable startboard) {
        Main.game.doPrecache(() -> {
            startboard.run();
            this.pNet.ResetTimers();
            Globals.lockclock = 0;
            this.pNet.ready2send = false;
        });
    }

    @Override
    public void render(float delta) {
        if (Mmulti.numplayers > 1) {
            this.pNet.GetPackets();
        }
        this.DemoRender();
        float smoothratio = 65536.0f;
        if (!Main.game.gPaused && ((smoothratio = (float)this.pEngine.getTimer().getsmoothratio(delta)) < 0.0f || smoothratio > 65536.0f)) {
            smoothratio = Gameutils.BClipRange(smoothratio, 0.0f, 65536.0f);
        }
        Main.game.pInt.dointerpolations(smoothratio);
        this.DrawWorld(smoothratio);
        this.DrawHud(smoothratio);
        Main.game.pInt.restoreinterpolations();
        if (this.pMenu.gShowMenu) {
            this.pMenu.mDrawMenu();
        }
        this.PostFrame(this.pNet);
        this.pEngine.nextpage(delta);
    }

    private void DemoRender() {
        this.pNet.ready2send = false;
        if (!Main.game.isCurrentScreen(this)) {
            return;
        }
        if (!Main.game.gPaused && demfile != null) {
            while (Main.engine.getTotalClock() >= Globals.lockclock + 3) {
                CompareService.update(DemoScreen.demfile.rcnt);
                short j = Mmulti.connecthead;
                while (j >= 0) {
                    this.pNet.gFifoInput[this.pNet.gNetFifoHead[j] & 0xFF][j].Copy(DemoScreen.demfile.recsync[DemoScreen.demfile.rcnt][j]);
                    short s = j;
                    this.pNet.gNetFifoHead[s] = this.pNet.gNetFifoHead[s] + 1;
                    --DemoScreen.demfile.reccnt;
                    j = Mmulti.connectpoint2[j];
                }
                if (DemoScreen.demfile.reccnt <= 0) {
                    demfile = null;
                    Group group = this.lastDemoEntry.getParent();
                    if (!this.showDemo(group)) {
                        Main.game.changeScreen(Main.gMenuScreen);
                    }
                    return;
                }
                ++DemoScreen.demfile.rcnt;
                Main.game.pInt.clearinterpolations();
                this.ProcessFrame(this.pNet);
            }
        } else {
            Main.engine.getTimer().setTotalClock(this.ototalclock);
        }
    }

    public boolean showDemo(Group group) {
        List<Entry> list = this.checkDemoEntry(group);
        switch (Main.cfg.gDemoSeq) {
            case 0: {
                return false;
            }
            case 1: {
                if (this.nDemonum < list.size() - 1) {
                    ++this.nDemonum;
                    break;
                }
                this.nDemonum = 0;
                break;
            }
            case 2: {
                int nextnum = this.nDemonum;
                if (list.size() > 1) {
                    while (nextnum == this.nDemonum) {
                        nextnum = (int)(Math.random() * (double)list.size());
                    }
                }
                this.nDemonum = Gameutils.BClipRange(nextnum, 0, list.size() - 1);
            }
        }
        if (!list.isEmpty()) {
            boolean result = this.showDemo(list.get(this.nDemonum));
            if (!result) {
                list.remove(this.nDemonum);
                return this.showDemo(group);
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isDemoFile(Entry file) {
        if (!file.exists()) return false;
        if (!file.isExtension("dmo")) return false;
        try (InputStream is = file.getInputStream();){
            String header = StreamUtils.readString(is, header.length());
            StreamUtils.skip(is, 4);
            int version = StreamUtils.readUnsignedByte(is);
            if (!header.equals(header)) return false;
            if (version < 100) return false;
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public List<Entry> checkDemoEntry(Group group) {
        if (this.demofiles.containsKey(group)) {
            return this.demofiles.get(group);
        }
        this.nDemonum = -1;
        List<Entry> demos = group.stream().filter(this::isDemoFile).sorted(Entry::compareTo).collect(Collectors.toList());
        if (demos.isEmpty()) {
            int k;
            int which_demo = 1;
            do {
                k = which_demo;
                char[] d = "demo_.dmo".toCharArray();
                d[4] = which_demo == 10 ? 120 : (char)(48 + which_demo);
                String name = String.copyValueOf(d);
                Entry entry = Main.game.getCache().getEntry(name, true);
                if (!this.isDemoFile(entry)) break;
                demos.add(entry);
            } while (k != ++which_demo);
        }
        this.demofiles.put(group, demos);
        Console.out.println("There are " + demos.size() + " demo(s) in the loop", OsdColor.YELLOW);
        return demos;
    }
}

