/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven.Screens;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.ScreenAdapters.DefaultPrecacheScreen;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.listeners.PrecacheListener;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Witchaven.Main;
import ru.m210projects.Witchaven.Names;
import ru.m210projects.Witchaven.Spellbooks;
import ru.m210projects.Witchaven.Weapons;

public class PrecacheScreen
extends DefaultPrecacheScreen {
    public PrecacheScreen(Runnable toLoad, PrecacheListener listener) {
        super(Main.game, toLoad, listener);
        this.addQueue("Preload floor and ceiling tiles...", () -> {
            Sector[] sectors;
            for (Sector sec : sectors = Main.boardService.getBoard().getSectors()) {
                this.addTile(sec.getFloorpicnum());
                this.addTile(sec.getCeilingpicnum());
            }
            this.doprecache(0);
        });
        this.addQueue("Preload wall tiles...", () -> {
            for (Wall wall : Main.boardService.getBoard().getWalls()) {
                this.addTile(wall.getPicnum());
                if (wall.getOverpicnum() < 0) continue;
                this.addTile(wall.getOverpicnum());
            }
            this.doprecache(0);
        });
        this.addQueue("Preload sprite tiles...", () -> {
            for (int i = 0; i < Engine.MAXSPRITES; ++i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null || spr.getStatnum() >= 1024) continue;
                this.cachespritenum(spr);
            }
            this.addTile(330);
            this.addTile(952);
            this.addTile(1001);
            this.addTile(762);
            this.addTile(891);
            this.addTile(797);
            this.doprecache(1);
        });
        this.addQueue("Preload hud tiles...", () -> {
            int i;
            for (i = Names.KNIFEREADY; i <= Names.BIGAXEDRAW10; ++i) {
                this.addTile(i);
            }
            for (i = Names.THEFONT; i < Names.CRYSTALSTAFF; ++i) {
                this.addTile(i);
            }
            this.addTile(Names.SSTATUSBAR);
            for (i = 0; i < 8; ++i) {
                this.addTile(Spellbooks.sspellbookanim[i][0].daweaponframe);
            }
            this.addTile(650);
            this.addTile(Names.HELMET);
            this.addTile(Names.SSCOREBACKPIC);
            this.addTile(Names.SHEALTHBACK);
            for (i = 0; i < 4; ++i) {
                this.addTile(Names.SKEYBLANK + i);
                this.addTile(Names.SCARY + i);
            }
            this.addTile(Names.SPOTIONBACKPIC);
            for (i = 0; i < 5; ++i) {
                this.addTile(Names.SPOTIONARROW + i);
                this.addTile(Names.SFLASKBLUE + i);
            }
            this.addTile(Names.SFLASKBLACK);
            for (i = 0; i < 5; ++i) {
                this.addTile(Weapons.spikeanimtics[i].daweaponframe);
            }
            this.doprecache(1);
        });
    }

    @Override
    protected void draw(String title, int index) {
        Renderer renderer = this.game.getRenderer();
        renderer.clearview(77);
        renderer.rotatesprite(0xA00000, 0x640000, 65536, 0, 500, -128, 0, 74);
        this.game.getFont(1).drawTextScaled(renderer, 160, 100, "Loading", 1.0f, 0, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, true);
        this.game.getFont(1).drawTextScaled(renderer, 160, 114, "please wait...", 1.0f, 0, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, true);
        this.game.getFont(1).drawTextScaled(renderer, 160, 130, title, 1.0f, 0, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, true);
    }

    private void cachespritenum(Sprite sp) {
        int maxc = 1;
        if (sp.getPicnum() == Names.RAT || sp.getPicnum() == Names.GUARDIAN) {
            maxc = 15;
        }
        if (sp.getPicnum() == Names.HANGMAN) {
            maxc = 40;
        }
        if (sp.getPicnum() == Names.GRONHAL || sp.getPicnum() == Names.GRONMU || sp.getPicnum() == Names.GRONSW) {
            maxc = 19;
        }
        switch (sp.getPicnum()) {
            case 917: 
            case 922: {
                maxc = 21;
                break;
            }
            case 737: {
                maxc = 24;
                break;
            }
            case 772: 
            case 777: {
                maxc = 25;
                break;
            }
            case 1201: {
                maxc = 11;
                break;
            }
            case 1070: {
                maxc = 39;
                break;
            }
            case 981: {
                maxc = 35;
                break;
            }
            case 821: {
                maxc = 19;
                break;
            }
            case 1028: {
                maxc = 20;
                break;
            }
            case 1118: 
            case 1123: {
                maxc = 18;
            }
        }
        for (int j = sp.getPicnum(); j < sp.getPicnum() + maxc; ++j) {
            this.addTile(j);
        }
    }
}

