/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven.Types.CompareService;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Witchaven.Main;
import ru.m210projects.Witchaven.Screens.DemoScreen;
import ru.m210projects.Witchaven.Types.CompareService.CompareItem;
import ru.m210projects.Witchaven.Types.CompareService.IntegerItem;

public class CompareService {
    private static OutputStream writer;
    private static InputStream reader;
    private static Type type;
    private static Path path;

    public static void prepare(Path path, Type t) {
        type = t;
        CompareService.path = path;
        try {
            if (type == Type.Memory) {
                if (writer != null) {
                    writer.close();
                }
                writer = new ByteArrayOutputStream();
            } else if (type == Type.Write) {
                if (writer != null) {
                    writer.close();
                }
                writer = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));
            } else {
                if (reader != null) {
                    reader.close();
                }
                reader = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
            }
        }
        catch (FileNotFoundException | NoSuchFileException fnf) {
            reader = null;
            writer = null;
            System.err.println(path + " is not found!");
        }
        catch (IOException e) {
            reader = null;
            writer = null;
            e.printStackTrace();
        }
    }

    @Deprecated
    public static boolean conditionCheck() {
        return DemoScreen.demfile.rcnt >= 944;
    }

    @Deprecated
    public static boolean conditionUpdate() {
        if (CompareService.conditionCheck()) {
            CompareService.update(DemoScreen.demfile.rcnt);
            return true;
        }
        return false;
    }

    public static void update(int cnt) {
        if (type == null) {
            return;
        }
        switch (type.ordinal()) {
            case 0: {
                if (reader == null) break;
                try {
                    Packet packet = new Packet(cnt);
                    if (!packet.compareRead(reader)) {
                        System.err.println("Unsync at " + packet.rcnt + " in map");
                        break;
                    }
                    System.out.println("\u001b[32mDemo file " + packet.rcnt + " is OK\u001b[0m");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    reader = null;
                }
                break;
            }
            case 1: 
            case 2: {
                if (writer == null) break;
                try {
                    Packet packet = new Packet(cnt);
                    packet.write(writer);
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    writer = null;
                }
            }
        }
    }

    public static void close() {
        if (type == null) {
            return;
        }
        if (writer != null) {
            try {
                if (type == Type.Memory) {
                    BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));
                    StreamUtils.writeBytes(os, ((ByteArrayOutputStream)writer).toByteArray());
                    os.close();
                }
                writer.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static enum Type {
        Read,
        Write,
        Memory;

    }

    public static class Packet {
        private final int rcnt;
        private final CompareItem[] items;

        public Packet(int rcnt) {
            this.rcnt = rcnt;
            ArrayList<IntegerItem> list = new ArrayList<IntegerItem>();
            list.add(new IntegerItem(Main.engine.getrand(), "bseed"));
            this.items = new CompareItem[list.size()];
            list.toArray(this.items);
        }

        public boolean compareRead(InputStream is) throws IOException {
            boolean[] equals = new boolean[this.items.length + 1];
            int file_rcnt = StreamUtils.readInt(is);
            equals[0] = this.rcnt == file_rcnt;
            for (int i = 0; i < this.items.length; ++i) {
                equals[i + 1] = this.items[i].compare(is);
            }
            for (boolean equal : equals) {
                if (equal) continue;
                return false;
            }
            return true;
        }

        public void write(OutputStream os) throws IOException {
            StreamUtils.writeInt(os, this.rcnt);
            for (CompareItem item : this.items) {
                item.write(os);
            }
        }
    }
}

