/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven.Types.CompareService;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Witchaven.Main;
import ru.m210projects.Witchaven.Types.CompareService.CompareItem;
import ru.m210projects.Witchaven.Types.CompareService.SpriteItem;

public class SpriteListItem
implements CompareItem {
    private final List<SpriteItem> list = new ArrayList<SpriteItem>();

    public SpriteListItem() {
        int size = -1;
        for (int i = 0; i < Main.boardService.getSectorCount(); ++i) {
            for (ListNode<Sprite> node = Main.boardService.getSectNode(i); node != null; node = node.getNext()) {
                if (size >= node.getIndex()) continue;
                size = node.getIndex();
            }
        }
        List<Sprite> spriteList = Main.boardService.getBoard().getSprites();
        for (int i = 0; i < size; ++i) {
            Sprite sprite = new Sprite();
            sprite.set(spriteList.get(i));
            this.list.add(new SpriteItem(sprite, i));
        }
    }

    @Override
    public boolean compare(InputStream is) throws IOException {
        boolean result;
        int spriteNum = StreamUtils.readInt(is);
        boolean bl = result = spriteNum == this.list.size();
        while (this.list.size() < spriteNum) {
            this.list.add(new SpriteItem(new Sprite(), -1));
        }
        for (int i = 0; i < spriteNum; ++i) {
            if (this.list.get(i).compare(is)) continue;
            result = false;
        }
        return result;
    }

    @Override
    public void write(OutputStream os) throws IOException {
        StreamUtils.writeInt(os, this.list.size());
        for (SpriteItem item : this.list) {
            item.write(os);
        }
    }

    @Override
    public String getName() {
        return "SpriteList";
    }
}

