/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven.Types;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Witchaven.Main;
import ru.m210projects.Witchaven.Menu.WHMenuUserContent;
import ru.m210projects.Witchaven.Types.EpisodeInfo;
import ru.m210projects.Witchaven.Types.Input;
import ru.m210projects.Witchaven.Types.PLAYER;

public class DemoFile {
    public int rcnt = 0;
    public Input[][] recsync;
    public int reccnt;
    public int version;
    public int map;
    public int skill;
    public PlayerDemoData playerData;
    public Main.UserFlag userFlag;
    public EpisodeInfo addon = null;

    public DemoFile(InputStream is) throws Exception {
        String header = StreamUtils.readString(is, "WHDEM".length());
        if (!header.equalsIgnoreCase("WHDEM")) {
            throw new Exception("Wrong header: " + header);
        }
        this.reccnt = StreamUtils.readInt(is);
        this.version = StreamUtils.readUnsignedByte(is);
        if (this.version != 100 && this.version != 101) {
            throw new Exception("Wrong version!");
        }
        if (this.reccnt == 0) {
            throw new Exception("reccnt == 0");
        }
        this.userFlag = Main.UserFlag.parseValue(StreamUtils.readByte(is));
        if (this.userFlag == Main.UserFlag.Addon) {
            String addonFileName = StreamUtils.readDataString(is).toLowerCase();
            this.addon = WHMenuUserContent.episodeManager.getEpisode(Main.game.getCache().getGameDirectory().getEntry(FileUtils.getPath(addonFileName, new String[0])));
        }
        this.map = StreamUtils.readUnsignedByte(is);
        this.skill = StreamUtils.readUnsignedByte(is);
        this.playerData = new PlayerDemoData();
        this.playerData.readObject(is);
        this.recsync = new Input[this.reccnt][16];
        int rccnt = 0;
        for (int c = 0; c <= this.reccnt / 2520; ++c) {
            int l = Math.min(this.reccnt - rccnt, 2520);
            for (int rcnt = rccnt; rcnt < rccnt + l; ++rcnt) {
                for (int i = 0; i < 1; ++i) {
                    this.recsync[rcnt][i] = new Input().readObject(is);
                }
            }
            rccnt += 2520;
        }
    }

    public static class PlayerDemoData {
        private final int[] weapon = new int[10];
        private final int[] ammo = new int[10];
        private final int[] preenchantedweapon = new int[10];
        private final int[] preenchantedammo = new int[10];
        private final int[] potion = new int[5];
        private final int[] treasure = new int[18];
        private final int[] orb = new int[8];
        private final int[] orbammo = new int[8];
        private int lvl;
        private int score;
        private int health;
        private int maxhealth;
        private int armor;
        private int armortype;
        private int shieldpoints;
        private int shieldtype;
        private int poisoned;

        public void readObject(InputStream is) throws IOException {
            int i;
            for (i = 0; i < 10; ++i) {
                this.weapon[i] = StreamUtils.readInt(is);
                this.ammo[i] = StreamUtils.readInt(is);
                this.preenchantedweapon[i] = StreamUtils.readInt(is);
                this.preenchantedammo[i] = StreamUtils.readInt(is);
            }
            for (i = 0; i < 5; ++i) {
                this.potion[i] = StreamUtils.readInt(is);
            }
            for (i = 0; i < 18; ++i) {
                this.treasure[i] = StreamUtils.readInt(is);
            }
            for (i = 0; i < 8; ++i) {
                this.orb[i] = StreamUtils.readInt(is);
                this.orbammo[i] = StreamUtils.readInt(is);
            }
            this.lvl = StreamUtils.readInt(is);
            this.score = StreamUtils.readInt(is);
            this.health = StreamUtils.readInt(is);
            this.maxhealth = StreamUtils.readInt(is);
            this.armor = StreamUtils.readInt(is);
            this.armortype = StreamUtils.readInt(is);
            this.shieldpoints = StreamUtils.readInt(is);
            this.shieldtype = StreamUtils.readInt(is);
            this.poisoned = StreamUtils.readInt(is);
        }

        public void writeObject(OutputStream os) throws IOException {
            int i;
            for (i = 0; i < 10; ++i) {
                StreamUtils.writeInt(os, this.weapon[i]);
                StreamUtils.writeInt(os, this.ammo[i]);
                StreamUtils.writeInt(os, this.preenchantedweapon[i]);
                StreamUtils.writeInt(os, this.preenchantedammo[i]);
            }
            for (i = 0; i < 5; ++i) {
                StreamUtils.writeInt(os, this.potion[i]);
            }
            for (i = 0; i < 18; ++i) {
                StreamUtils.writeInt(os, this.treasure[i]);
            }
            for (i = 0; i < 8; ++i) {
                StreamUtils.writeInt(os, this.orb[i]);
                StreamUtils.writeInt(os, this.orbammo[i]);
            }
            StreamUtils.writeInt(os, this.lvl);
            StreamUtils.writeInt(os, this.score);
            StreamUtils.writeInt(os, this.health);
            StreamUtils.writeInt(os, this.maxhealth);
            StreamUtils.writeInt(os, this.armor);
            StreamUtils.writeInt(os, this.armortype);
            StreamUtils.writeInt(os, this.shieldpoints);
            StreamUtils.writeInt(os, this.shieldtype);
            StreamUtils.writeInt(os, this.poisoned);
        }

        public PlayerDemoData setFrom(PLAYER plr) {
            System.arraycopy(plr.getWeapon(), 0, this.weapon, 0, 10);
            System.arraycopy(plr.getAmmo(), 0, this.ammo, 0, 10);
            System.arraycopy(plr.getPreenchantedweapon(), 0, this.preenchantedweapon, 0, 10);
            System.arraycopy(plr.getPreenchantedammo(), 0, this.preenchantedammo, 0, 10);
            System.arraycopy(plr.getPotion(), 0, this.potion, 0, 5);
            System.arraycopy(plr.getTreasure(), 0, this.treasure, 0, 18);
            System.arraycopy(plr.getOrb(), 0, this.orb, 0, 8);
            System.arraycopy(plr.getOrbammo(), 0, this.orbammo, 0, 8);
            this.lvl = plr.getLvl();
            this.score = plr.getScore();
            this.health = plr.getHealth();
            this.maxhealth = plr.getMaxhealth();
            this.armor = plr.getArmor();
            this.armortype = plr.getArmortype();
            this.shieldpoints = plr.getShieldpoints();
            this.shieldtype = plr.getShieldtype();
            this.poisoned = plr.getPoisoned();
            return this;
        }

        public void applyTo(PLAYER plr) {
            System.arraycopy(this.weapon, 0, plr.getWeapon(), 0, 10);
            System.arraycopy(this.ammo, 0, plr.getAmmo(), 0, 10);
            System.arraycopy(this.preenchantedweapon, 0, plr.getPreenchantedweapon(), 0, 10);
            System.arraycopy(this.preenchantedammo, 0, plr.getPreenchantedammo(), 0, 10);
            System.arraycopy(this.potion, 0, plr.getPotion(), 0, 5);
            System.arraycopy(this.treasure, 0, plr.getTreasure(), 0, 18);
            System.arraycopy(this.orb, 0, plr.getOrb(), 0, 8);
            System.arraycopy(this.orbammo, 0, plr.getOrbammo(), 0, 8);
            plr.setLvl(this.lvl);
            plr.setScore(this.score);
            plr.setHealth(this.health);
            plr.setMaxhealth(this.maxhealth);
            plr.setArmor(this.armor);
            plr.setArmortype(this.armortype);
            plr.setShieldpoints(this.shieldpoints);
            plr.setShieldtype(this.shieldtype);
            plr.setPoisoned(this.poisoned);
        }
    }
}

