/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven.Types;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.BitMap;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Witchaven.Main;
import ru.m210projects.Witchaven.Menu.WHMenuUserContent;
import ru.m210projects.Witchaven.Types.ANIMATION;
import ru.m210projects.Witchaven.Types.EpisodeInfo;
import ru.m210projects.Witchaven.Types.PLAYER;
import ru.m210projects.Witchaven.Types.SWINGDOOR;

public class SafeLoader {
    public Entry boardfilename;
    public int gAnimationCount = 0;
    public final ANIMATION[] gAnimationData = new ANIMATION[512];
    public final PLAYER[] plr = new PLAYER[16];
    public final short[] pskyoff = new short[256];
    public short pskybits;
    public int parallaxyscale;
    public short connecthead;
    public final short[] connectpoint2 = new short[16];
    public int randomseed;
    public int mapon;
    public int skill;
    public int thunderflash;
    public int thundertime;
    public int kills;
    public int killcnt;
    public int treasurescnt;
    public int treasuresfound;
    public int hours;
    public int minutes;
    public int seconds;
    public int visibility;
    public byte automapping;
    public final BitMap show2dsector = new BitMap(1024);
    public final BitMap show2dwall = new BitMap(8192);
    public final BitMap show2dsprite = new BitMap(4096);
    public Sector[] sector;
    public Wall[] wall;
    public List<Sprite> sprite;
    public final short[] skypanlist = new short[64];
    public short skypancnt;
    public final short[] lavadrylandsector = new short[32];
    public short lavadrylandcnt;
    public final short[] bobbingsectorlist = new short[16];
    public short bobbingsectorcnt;
    public final short[] revolveclip = new short[16];
    public final short[] revolvesector = new short[4];
    public final short[] revolveang = new short[4];
    public short revolvecnt;
    public final int[][] revolvex = new int[4][32];
    public final int[][] revolvey = new int[4][32];
    public final int[] revolvepivotx = new int[4];
    public final int[] revolvepivoty = new int[4];
    public final short[] warpsectorlist = new short[64];
    public short warpsectorcnt;
    public final short[] xpanningsectorlist = new short[16];
    public short xpanningsectorcnt;
    public final short[] ypanningwalllist = new short[128];
    public short ypanningwallcnt;
    public final short[] floorpanninglist = new short[64];
    public short floorpanningcnt;
    public final SWINGDOOR[] swingdoor = new SWINGDOOR[32];
    public short swingcnt;
    public final short[] dragsectorlist = new short[16];
    public final short[] dragxdir = new short[16];
    public final short[] dragydir = new short[16];
    public short dragsectorcnt;
    public final int[] dragx1 = new int[16];
    public final int[] dragy1 = new int[16];
    public final int[] dragx2 = new int[16];
    public final int[] dragy2 = new int[16];
    public final int[] dragfloorz = new int[16];
    public final short[] ironbarsector = new short[16];
    public short ironbarscnt;
    public final int[] ironbarsgoal1 = new int[16];
    public final int[] ironbarsgoal2 = new int[16];
    public final short[] ironbarsdone = new short[16];
    public final short[] ironbarsanim = new short[16];
    public final int[] ironbarsgoal = new int[16];
    public int floormirrorcnt;
    public final short[] floormirrorsector = new short[64];
    public final short[] arrowsprite = new short[100];
    public final short[] throwpikesprite = new short[100];
    public final byte[] ceilingshadearray = new byte[Engine.MAXSECTORS];
    public final byte[] floorshadearray = new byte[Engine.MAXSECTORS];
    public final byte[] wallshadearray = new byte[Engine.MAXWALLS];
    public int dropshieldcnt;
    public boolean droptheshield;
    public int warp_on;
    public EpisodeInfo addon;
    public String addonFileName;
    private String message;

    public SafeLoader() {
        int i;
        for (i = 0; i < 16; ++i) {
            this.plr[i] = new PLAYER();
        }
        for (i = 0; i < 512; ++i) {
            this.gAnimationData[i] = new ANIMATION();
        }
        for (i = 0; i < 32; ++i) {
            this.swingdoor[i] = new SWINGDOOR();
        }
    }

    public boolean load(InputStream is) throws IOException {
        StreamUtils.skip(is, 40);
        this.addon = null;
        this.addonFileName = null;
        this.message = null;
        this.mapon = StreamUtils.readInt(is);
        this.skill = StreamUtils.readInt(is);
        this.LoadGDXBlock(is);
        this.StuffLoad(is);
        this.MapLoad(is);
        this.SectorLoad(is);
        this.AnimationLoad(is);
        if (is.available() != 0) {
            return false;
        }
        if (this.warp_on == 2) {
            this.addon = this.findAddon(this.addonFileName);
            if (this.addon == null) {
                this.message = "Can't find user episode file: " + this.boardfilename;
                this.warp_on = 1;
                this.mapon = 0;
            }
        }
        return true;
    }

    public void SectorLoad(InputStream is) throws IOException {
        int i;
        for (i = 0; i < 64; ++i) {
            this.skypanlist[i] = StreamUtils.readShort(is);
        }
        this.skypancnt = StreamUtils.readShort(is);
        for (i = 0; i < 32; ++i) {
            this.lavadrylandsector[i] = StreamUtils.readShort(is);
        }
        this.lavadrylandcnt = StreamUtils.readShort(is);
        for (i = 0; i < 16; ++i) {
            this.dragsectorlist[i] = StreamUtils.readShort(is);
            this.dragxdir[i] = StreamUtils.readShort(is);
            this.dragydir[i] = StreamUtils.readShort(is);
            this.dragx1[i] = StreamUtils.readInt(is);
            this.dragy1[i] = StreamUtils.readInt(is);
            this.dragx2[i] = StreamUtils.readInt(is);
            this.dragy2[i] = StreamUtils.readInt(is);
            this.dragfloorz[i] = StreamUtils.readInt(is);
        }
        this.dragsectorcnt = StreamUtils.readShort(is);
        for (i = 0; i < 16; ++i) {
            this.bobbingsectorlist[i] = StreamUtils.readShort(is);
        }
        this.bobbingsectorcnt = StreamUtils.readShort(is);
        for (i = 0; i < 16; ++i) {
            this.warpsectorlist[i] = StreamUtils.readShort(is);
        }
        this.warpsectorcnt = StreamUtils.readShort(is);
        for (i = 0; i < 16; ++i) {
            this.xpanningsectorlist[i] = StreamUtils.readShort(is);
        }
        this.xpanningsectorcnt = StreamUtils.readShort(is);
        for (i = 0; i < 128; ++i) {
            this.ypanningwalllist[i] = StreamUtils.readShort(is);
        }
        this.ypanningwallcnt = StreamUtils.readShort(is);
        for (i = 0; i < 64; ++i) {
            this.floorpanninglist[i] = StreamUtils.readShort(is);
        }
        this.floorpanningcnt = StreamUtils.readShort(is);
        this.swingcnt = StreamUtils.readShort(is);
        for (i = 0; i < 32; ++i) {
            this.swingdoor[i].set(is);
        }
        this.revolvecnt = StreamUtils.readShort(is);
        for (i = 0; i < 4; ++i) {
            this.revolvesector[i] = StreamUtils.readShort(is);
            this.revolveang[i] = StreamUtils.readShort(is);
            for (int j = 0; j < 32; ++j) {
                this.revolvex[i][j] = StreamUtils.readInt(is);
                this.revolvey[i][j] = StreamUtils.readInt(is);
            }
            this.revolvepivotx[i] = StreamUtils.readInt(is);
            this.revolvepivoty[i] = StreamUtils.readInt(is);
        }
        for (i = 0; i < 16; ++i) {
            this.revolveclip[i] = StreamUtils.readShort(is);
        }
        this.ironbarscnt = StreamUtils.readShort(is);
        for (i = 0; i < 16; ++i) {
            this.ironbarsector[i] = StreamUtils.readShort(is);
            this.ironbarsgoal[i] = StreamUtils.readInt(is);
            this.ironbarsgoal1[i] = StreamUtils.readInt(is);
            this.ironbarsgoal2[i] = StreamUtils.readInt(is);
            this.ironbarsdone[i] = StreamUtils.readShort(is);
            this.ironbarsanim[i] = StreamUtils.readShort(is);
        }
    }

    public void AnimationLoad(InputStream is) throws IOException {
        for (int i = 0; i < 512; ++i) {
            short index = StreamUtils.readShort(is);
            byte type = StreamUtils.readByte(is);
            this.gAnimationData[i].id = index;
            this.gAnimationData[i].type = type;
            this.gAnimationData[i].ptr = null;
            this.gAnimationData[i].goal = StreamUtils.readInt(is);
            this.gAnimationData[i].vel = StreamUtils.readInt(is);
            this.gAnimationData[i].acc = StreamUtils.readInt(is);
        }
        this.gAnimationCount = StreamUtils.readInt(is);
    }

    public void StuffLoad(InputStream is) throws IOException {
        int i;
        int i2;
        this.kills = StreamUtils.readInt(is);
        this.killcnt = StreamUtils.readInt(is);
        this.treasurescnt = StreamUtils.readInt(is);
        this.treasuresfound = StreamUtils.readInt(is);
        this.hours = StreamUtils.readInt(is);
        this.minutes = StreamUtils.readInt(is);
        this.seconds = StreamUtils.readInt(is);
        this.visibility = StreamUtils.readInt(is);
        this.thunderflash = StreamUtils.readInt(is);
        this.thundertime = StreamUtils.readInt(is);
        this.randomseed = StreamUtils.readInt(is);
        this.show2dsector.readObject(is);
        this.show2dwall.readObject(is);
        this.show2dsprite.readObject(is);
        this.automapping = StreamUtils.readByte(is);
        this.pskybits = StreamUtils.readShort(is);
        this.parallaxyscale = StreamUtils.readInt(is);
        for (i2 = 0; i2 < 256; ++i2) {
            this.pskyoff[i2] = StreamUtils.readShort(is);
        }
        this.connecthead = StreamUtils.readShort(is);
        for (i2 = 0; i2 < 16; ++i2) {
            this.connectpoint2[i2] = StreamUtils.readShort(is);
        }
        for (i2 = 0; i2 < 16; ++i2) {
            this.plr[i2].readObject(is);
        }
        this.dropshieldcnt = StreamUtils.readInt(is);
        this.droptheshield = StreamUtils.readUnsignedByte(is) == 1;
        this.floormirrorcnt = StreamUtils.readInt(is);
        for (i2 = 0; i2 < 64; ++i2) {
            this.floormirrorsector[i2] = StreamUtils.readShort(is);
        }
        for (i2 = 0; i2 < 100; ++i2) {
            this.arrowsprite[i2] = StreamUtils.readShort(is);
        }
        for (i2 = 0; i2 < 100; ++i2) {
            this.throwpikesprite[i2] = StreamUtils.readShort(is);
        }
        int len = StreamUtils.readInt(is);
        for (i = 0; i < len; ++i) {
            this.ceilingshadearray[i] = (byte)StreamUtils.readUnsignedByte(is);
            this.floorshadearray[i] = (byte)StreamUtils.readUnsignedByte(is);
        }
        len = StreamUtils.readInt(is);
        for (i = 0; i < len; ++i) {
            this.wallshadearray[i] = (byte)StreamUtils.readUnsignedByte(is);
        }
    }

    public void MapLoad(InputStream is) throws IOException {
        int i;
        this.sector = new Sector[StreamUtils.readInt(is)];
        for (i = 0; i < this.sector.length; ++i) {
            this.sector[i] = new Sector().readObject(is);
        }
        this.wall = new Wall[StreamUtils.readInt(is)];
        for (i = 0; i < this.wall.length; ++i) {
            this.wall[i] = new Wall().readObject(is);
        }
        int numSprites = StreamUtils.readInt(is);
        this.sprite = new ArrayList<Sprite>(numSprites * 2);
        for (int i2 = 0; i2 < numSprites; ++i2) {
            this.sprite.add(new Sprite().readObject(is));
        }
    }

    public void LoadGDXBlock(InputStream is) throws IOException {
        StreamUtils.skip(is, 16000);
        this.warp_on = StreamUtils.readUnsignedByte(is);
        if (this.warp_on == 2) {
            this.addonFileName = StreamUtils.readDataString(is).toLowerCase();
        }
        this.boardfilename = Main.game.getCache().getEntry(StreamUtils.readDataString(is), true);
    }

    public EpisodeInfo LoadGDXHeader(InputStream is) throws IOException {
        this.warp_on = 0;
        this.addon = null;
        this.addonFileName = null;
        this.boardfilename = Directory.DUMMY_ENTRY;
        StreamUtils.skip(is, 40);
        this.mapon = StreamUtils.readInt(is);
        this.skill = StreamUtils.readInt(is);
        this.message = null;
        this.LoadGDXBlock(is);
        if (this.warp_on == 2) {
            this.addon = this.findAddon(this.addonFileName);
        }
        return this.addon;
    }

    private EpisodeInfo findAddon(String addonFileName) {
        try {
            FileEntry addonEntry = Main.game.getCache().getGameDirectory().getEntry(FileUtils.getPath(addonFileName, new String[0]));
            if (addonEntry.exists()) {
                return WHMenuUserContent.episodeManager.getEpisode(addonEntry);
            }
        }
        catch (Exception e) {
            Console.out.println(e.toString(), OsdColor.RED);
        }
        return null;
    }

    public String getMessage() {
        return this.message;
    }
}

