/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven.Types;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.InputStreamProvider;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Witchaven.Types.WHSoundEntry;

public class WHGroup
implements Group {
    private final String name;
    protected final Map<Integer, Entry> entries;

    public WHGroup(String name, InputStreamProvider provider, Class<? extends WHSoundEntry> entryClass) throws IOException {
        Constructor<? extends WHSoundEntry> entryConstructor;
        int i;
        this.name = name.toUpperCase();
        int numFiles = 341;
        int[] list = new int[1024];
        try (BufferedInputStream is = new BufferedInputStream(provider.newInputStream());){
            StreamUtils.skip(is, ((InputStream)is).available() - 4096);
            this.entries = new LinkedHashMap<Integer, Entry>(numFiles);
            for (i = 0; i < 1024; ++i) {
                list[i] = StreamUtils.readInt(is);
            }
        }
        try {
            entryConstructor = entryClass.getConstructor(InputStreamProvider.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        for (i = 0; i < numFiles; ++i) {
            String fileName = String.format("%s%d", name, i).toUpperCase();
            int offset = list[i * 3] * 4096;
            int size = list[i * 3 + 1];
            int prioritize = list[i * 3 + 2];
            if (offset == 0 && size == 0) continue;
            try {
                Entry entry = entryConstructor.newInstance(provider, fileName, prioritize, offset, size);
                entry.setParent(this);
                this.entries.put(i, entry);
                continue;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getEntry(int index) {
        Entry entry;
        WHGroup wHGroup = this;
        synchronized (wHGroup) {
            entry = this.entries.getOrDefault(index, Directory.DUMMY_ENTRY);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entry getEntry(String name) {
        Entry entry;
        Objects.requireNonNull(name, "name");
        WHGroup wHGroup = this;
        synchronized (wHGroup) {
            entry = this.entries.getOrDefault(Integer.parseInt(name), Directory.DUMMY_ENTRY);
        }
        return entry;
    }

    @Override
    public synchronized int getSize() {
        return this.entries.size();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized List<Entry> getEntries() {
        return new ArrayList<Entry>(this.entries.values());
    }
}

