/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import ru.m210projects.Build.Board;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.Tools.SaveManager;
import ru.m210projects.Build.Types.BuildPos;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.filehandle.art.DynamicArtEntry;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Witchaven.Animate;
import ru.m210projects.Witchaven.Factory.WHRenderer;
import ru.m210projects.Witchaven.Globals;
import ru.m210projects.Witchaven.Main;
import ru.m210projects.Witchaven.Menu.MenuCorruptGame;
import ru.m210projects.Witchaven.Menu.WHMenuUserContent;
import ru.m210projects.Witchaven.Types.ANIMATION;
import ru.m210projects.Witchaven.Types.EpisodeInfo;
import ru.m210projects.Witchaven.Types.LSInfo;
import ru.m210projects.Witchaven.Types.PLAYER;
import ru.m210projects.Witchaven.Types.SafeLoader;
import ru.m210projects.Witchaven.WHFX;
import ru.m210projects.Witchaven.WHPLR;
import ru.m210projects.Witchaven.WHSND;
import ru.m210projects.Witchaven.WHScreen;
import ru.m210projects.Witchaven.WHTAG;

public class Whldsv {
    public static final String savsign = "WHVN";
    public static final int gdxSave = 100;
    public static final int currentGdxSave = 105;
    public static final int SAVETIME = 8;
    public static final int SAVENAME = 32;
    public static final int SAVESCREENSHOTSIZE = 16000;
    public static final char[] filenum = new char[4];
    public static boolean gQuickSaving;
    public static boolean gAutosaveRequest;
    public static final LSInfo lsInf;
    public static FileEntry lastload;
    public static int quickslot;
    public static final SafeLoader loader;

    public static void FindSaves(Directory dir) {
        for (Entry file : dir) {
            if (!file.isExtension("sav") || !(file instanceof FileEntry)) continue;
            try {
                InputStream is = file.getInputStream();
                try {
                    short nVersion;
                    String signature = StreamUtils.readString(is, 4);
                    if (signature.isEmpty() || !signature.equals(savsign) || (nVersion = StreamUtils.readShort(is)) < 100) continue;
                    long time = StreamUtils.readLong(is);
                    String savname = StreamUtils.readString(is, 32);
                    Main.game.pSavemgr.add(savname, time, (FileEntry)file);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        Main.game.pSavemgr.sort();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int lsReadLoadData(FileEntry file) {
        if (file.exists()) {
            ArtEntry pic = Main.engine.getTile(SaveManager.Screenshot);
            if (!(pic instanceof DynamicArtEntry) || !pic.exists()) {
                pic = Main.engine.allocatepermanenttile(SaveManager.Screenshot, 160, 100);
            }
            try (InputStream is = file.getInputStream();){
                int nVersion = Whldsv.checkSave(is) & 0xFFFF;
                lsInf.clear();
                if (nVersion == 105) {
                    String addon;
                    Whldsv.lsInf.date = Main.game.date.getDate(StreamUtils.readLong(is));
                    StreamUtils.skip(is, 32);
                    lsInf.read(is);
                    ((DynamicArtEntry)pic).copyData(StreamUtils.readBytes(is, 16000));
                    Whldsv.lsInf.addonfile = null;
                    if (StreamUtils.readByte(is) == 2 && !(addon = FileUtils.getFullName(StreamUtils.readDataString(is).toLowerCase())).isEmpty()) {
                        Whldsv.lsInf.addonfile = "Addon: " + addon;
                    }
                    int n2 = 1;
                    return n2;
                }
                Whldsv.lsInf.info = "Incompatible ver. " + nVersion + " != " + 105;
                int n = -1;
                return n;
            }
            catch (Exception e) {
                Console.out.println(e.toString(), OsdColor.RED);
            }
        }
        lsInf.clear();
        return -1;
    }

    public static String makeNum(int num) {
        Whldsv.filenum[3] = (char)(num % 10 + 48);
        Whldsv.filenum[2] = (char)(num / 10 % 10 + 48);
        Whldsv.filenum[1] = (char)(num / 100 % 10 + 48);
        Whldsv.filenum[0] = (char)(num / 1000 % 10 + 48);
        return new String(filenum);
    }

    public static int checkSave(InputStream is) throws IOException {
        String signature = StreamUtils.readString(is, 4);
        if (!signature.equals(savsign)) {
            return 0;
        }
        return StreamUtils.readShort(is);
    }

    public static boolean checkfile(InputStream is) throws IOException {
        int nVersion = Whldsv.checkSave(is);
        if (nVersion != 105) {
            return false;
        }
        return loader.load(is);
    }

    public static void load() {
        Main.gDemoScreen.onLoad();
        WHSND.stopallsounds();
        WHPLR.mapon = Whldsv.loader.mapon;
        Globals.difficulty = Whldsv.loader.skill;
        Whldsv.LoadGDXBlock();
        Whldsv.LoadStuff();
        Whldsv.MapLoad();
        Whldsv.SectorLoad();
        Whldsv.AnimationLoad();
        WHPLR.pyrn = Mmulti.myconnectindex;
        Main.game.doPrecache(() -> {
            Main.game.nNetMode = BuildGame.NetMode.Single;
            if (Main.mUserFlag == Main.UserFlag.Addon) {
                Globals.boardfilename = Main.game.getCache().getEntry(Globals.gCurrentEpisode.gMapInfo.get((int)(WHPLR.mapon - 1)).path, true);
            }
            if (Main.mUserFlag != Main.UserFlag.UserMap) {
                WHSND.startmusic(WHPLR.mapon - 1);
            } else {
                WHSND.sndStopMusic();
            }
            Main.game.changeScreen(Main.gGameScreen);
            PLAYER plr = WHPLR.player[WHPLR.pyrn];
            plr.setHvel(0);
            plr.setDamage_angvel(0);
            plr.setDamage_svel(0);
            plr.setDamage_vel(0);
            Main.game.gPaused = false;
            Main.engine.getTimer().setTotalClock(Globals.lockclock);
            Main.game.pNet.ototalclock = Globals.lockclock;
            WHScreen.showmessage("Game loaded", 360);
            System.gc();
            Main.game.pNet.ResetTimers();
            Main.game.pNet.ready2send = true;
        });
    }

    public static boolean loadgame(FileEntry fil) {
        if (fil.exists()) {
            boolean bl;
            block11: {
                InputStream is = fil.getInputStream();
                try {
                    boolean status = Whldsv.checkfile(is);
                    if (status) {
                        Whldsv.load();
                        if (lastload == null || !lastload.exists()) {
                            lastload = fil;
                        }
                    }
                    bl = status;
                    if (is == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        Console.out.println(e.toString(), OsdColor.RED);
                    }
                }
                is.close();
            }
            return bl;
        }
        return false;
    }

    public static void LoadGDXBlock() {
        Globals.boardfilename = Whldsv.loader.boardfilename;
        if (Whldsv.loader.warp_on == 0) {
            Main.mUserFlag = Main.UserFlag.None;
            WHMenuUserContent.resetEpisodeResources(Globals.gOriginalEpisode);
        } else if (Whldsv.loader.warp_on == 1) {
            Main.mUserFlag = Main.UserFlag.UserMap;
            WHMenuUserContent.resetEpisodeResources(null);
        } else if (Whldsv.loader.warp_on == 2) {
            Main.mUserFlag = Main.UserFlag.Addon;
            WHMenuUserContent.checkEpisodeResources(Whldsv.loader.addon);
        }
    }

    public static void SectorLoad() {
        int i;
        System.arraycopy(Whldsv.loader.skypanlist, 0, WHFX.skypanlist, 0, 64);
        WHFX.skypancnt = Whldsv.loader.skypancnt;
        System.arraycopy(Whldsv.loader.lavadrylandsector, 0, WHFX.lavadrylandsector, 0, 32);
        WHFX.lavadrylandcnt = Whldsv.loader.lavadrylandcnt;
        System.arraycopy(Whldsv.loader.dragsectorlist, 0, WHTAG.dragsectorlist, 0, 16);
        System.arraycopy(Whldsv.loader.dragxdir, 0, WHTAG.dragxdir, 0, 16);
        System.arraycopy(Whldsv.loader.dragydir, 0, WHTAG.dragydir, 0, 16);
        System.arraycopy(Whldsv.loader.dragx1, 0, WHTAG.dragx1, 0, 16);
        System.arraycopy(Whldsv.loader.dragy1, 0, WHTAG.dragy1, 0, 16);
        System.arraycopy(Whldsv.loader.dragx2, 0, WHTAG.dragx2, 0, 16);
        System.arraycopy(Whldsv.loader.dragy2, 0, WHTAG.dragy2, 0, 16);
        System.arraycopy(Whldsv.loader.dragfloorz, 0, WHTAG.dragfloorz, 0, 16);
        WHTAG.dragsectorcnt = Whldsv.loader.dragsectorcnt;
        System.arraycopy(Whldsv.loader.bobbingsectorlist, 0, WHFX.bobbingsectorlist, 0, 16);
        WHFX.bobbingsectorcnt = Whldsv.loader.bobbingsectorcnt;
        System.arraycopy(Whldsv.loader.warpsectorlist, 0, WHTAG.warpsectorlist, 0, 16);
        WHTAG.warpsectorcnt = Whldsv.loader.warpsectorcnt;
        System.arraycopy(Whldsv.loader.xpanningsectorlist, 0, WHTAG.xpanningsectorlist, 0, 16);
        WHTAG.xpanningsectorcnt = Whldsv.loader.xpanningsectorcnt;
        System.arraycopy(Whldsv.loader.ypanningwalllist, 0, WHTAG.ypanningwalllist, 0, 128);
        WHTAG.ypanningwallcnt = Whldsv.loader.ypanningwallcnt;
        System.arraycopy(Whldsv.loader.floorpanninglist, 0, WHTAG.floorpanninglist, 0, 64);
        WHTAG.floorpanningcnt = Whldsv.loader.floorpanningcnt;
        WHTAG.swingcnt = Whldsv.loader.swingcnt;
        for (i = 0; i < 32; ++i) {
            WHTAG.swingdoor[i].copy(Whldsv.loader.swingdoor[i]);
        }
        WHFX.revolvecnt = Whldsv.loader.revolvecnt;
        System.arraycopy(Whldsv.loader.revolvesector, 0, WHFX.revolvesector, 0, 4);
        System.arraycopy(Whldsv.loader.revolveang, 0, WHFX.revolveang, 0, 4);
        System.arraycopy(Whldsv.loader.revolvepivotx, 0, WHFX.revolvepivotx, 0, 4);
        System.arraycopy(Whldsv.loader.revolvepivoty, 0, WHFX.revolvepivoty, 0, 4);
        for (i = 0; i < 4; ++i) {
            System.arraycopy(Whldsv.loader.revolvex[i], 0, WHFX.revolvex[i], 0, 32);
            System.arraycopy(Whldsv.loader.revolvey[i], 0, WHFX.revolvey[i], 0, 32);
        }
        System.arraycopy(Whldsv.loader.revolveclip, 0, WHFX.revolveclip, 0, 16);
        WHTAG.ironbarscnt = Whldsv.loader.ironbarscnt;
        System.arraycopy(Whldsv.loader.ironbarsector, 0, WHTAG.ironbarsector, 0, 16);
        System.arraycopy(Whldsv.loader.ironbarsgoal, 0, WHTAG.ironbarsgoal, 0, 16);
        System.arraycopy(Whldsv.loader.ironbarsgoal1, 0, WHTAG.ironbarsgoal1, 0, 16);
        System.arraycopy(Whldsv.loader.ironbarsgoal2, 0, WHTAG.ironbarsgoal2, 0, 16);
        System.arraycopy(Whldsv.loader.ironbarsdone, 0, WHTAG.ironbarsdone, 0, 16);
        System.arraycopy(Whldsv.loader.ironbarsanim, 0, WHTAG.ironbarsanim, 0, 16);
    }

    public static void LoadStuff() {
        Globals.kills = Whldsv.loader.kills;
        Globals.killcnt = Whldsv.loader.killcnt;
        Globals.treasurescnt = Whldsv.loader.treasurescnt;
        Globals.treasuresfound = Whldsv.loader.treasuresfound;
        Globals.hours = Whldsv.loader.hours;
        Globals.minutes = Whldsv.loader.minutes;
        Globals.seconds = Whldsv.loader.seconds;
        Engine.visibility = Whldsv.loader.visibility;
        WHFX.thunderflash = Whldsv.loader.thunderflash;
        WHFX.thundertime = Whldsv.loader.thundertime;
        Main.engine.srand(Whldsv.loader.randomseed);
        Engine.show2dsector.copy(Whldsv.loader.show2dsector);
        Engine.show2dwall.copy(Whldsv.loader.show2dwall);
        Engine.show2dsprite.copy(Whldsv.loader.show2dsprite);
        Engine.automapping = Whldsv.loader.automapping;
        Engine.pskybits = Whldsv.loader.pskybits;
        WHRenderer renderer = Main.game.getRenderer();
        renderer.setParallaxScale(Whldsv.loader.parallaxyscale);
        System.arraycopy(Whldsv.loader.pskyoff, 0, Engine.pskyoff, 0, 256);
        System.arraycopy(Engine.pskyoff, 0, Engine.zeropskyoff, 0, 256);
        Mmulti.connecthead = Whldsv.loader.connecthead;
        System.arraycopy(Whldsv.loader.connectpoint2, 0, Mmulti.connectpoint2, 0, 16);
        for (int i = 0; i < 16; ++i) {
            WHPLR.player[i].copy(Whldsv.loader.plr[i]);
        }
        WHPLR.player[Mmulti.myconnectindex].setDropshieldcnt(Whldsv.loader.dropshieldcnt);
        WHPLR.player[Mmulti.myconnectindex].setDroptheshield(Whldsv.loader.droptheshield);
        Globals.floormirrorcnt = Whldsv.loader.floormirrorcnt;
        System.arraycopy(Whldsv.loader.floormirrorsector, 0, Globals.floormirrorsector, 0, 64);
        System.arraycopy(Whldsv.loader.arrowsprite, 0, Globals.arrowsprite, 0, 100);
        System.arraycopy(Whldsv.loader.throwpikesprite, 0, Globals.throwpikesprite, 0, 100);
        System.arraycopy(Whldsv.loader.ceilingshadearray, 0, Globals.ceilingshadearray, 0, Engine.MAXSECTORS);
        System.arraycopy(Whldsv.loader.floorshadearray, 0, Globals.floorshadearray, 0, Engine.MAXSECTORS);
        System.arraycopy(Whldsv.loader.wallshadearray, 0, Globals.wallshadearray, 0, Engine.MAXWALLS);
    }

    public static void MapLoad() {
        PLAYER plr = WHPLR.player[Mmulti.myconnectindex];
        Main.boardService.setBoard(new Board(new BuildPos(plr.getX(), plr.getY(), plr.getZ(), (int)plr.getAng(), plr.getSector()), Whldsv.loader.sector, Whldsv.loader.wall, Whldsv.loader.sprite));
    }

    public static void AnimationLoad() {
        int i;
        for (i = 0; i < 512; ++i) {
            Animate.gAnimationData[i].id = Whldsv.loader.gAnimationData[i].id;
            Animate.gAnimationData[i].type = Whldsv.loader.gAnimationData[i].type;
            Animate.gAnimationData[i].ptr = Whldsv.loader.gAnimationData[i].ptr;
            Animate.gAnimationData[i].goal = Whldsv.loader.gAnimationData[i].goal;
            Animate.gAnimationData[i].vel = Whldsv.loader.gAnimationData[i].vel;
            Animate.gAnimationData[i].acc = Whldsv.loader.gAnimationData[i].acc;
        }
        Animate.gAnimationCount = Whldsv.loader.gAnimationCount;
        block6: for (i = Animate.gAnimationCount - 1; i >= 0; --i) {
            ANIMATION gAnm = Animate.gAnimationData[i];
            Object object = gAnm.ptr = Animate.getobject(gAnm.id, gAnm.type);
            switch (gAnm.type) {
                case 1: 
                case 2: {
                    Main.game.pInt.setwallinterpolate(gAnm.id, (Wall)object);
                    continue block6;
                }
                case 4: {
                    Main.game.pInt.setfloorinterpolate(gAnm.id, (Sector)object);
                    continue block6;
                }
                case 8: {
                    Main.game.pInt.setceilinterpolate(gAnm.id, (Sector)object);
                }
            }
        }
    }

    public static void quickload() {
        if (Mmulti.numplayers > 1) {
            return;
        }
        System.err.println("load");
        FileEntry loadFile = Main.game.pSavemgr.getLast();
        if (Whldsv.canLoad(loadFile)) {
            Main.game.changeScreen(Main.gLoadScreen);
            Main.gLoadScreen.init(() -> {
                if (!Whldsv.loadgame(loadFile)) {
                    Main.game.setPrevScreen();
                    if (Main.game.isCurrentScreen(Main.gGameScreen)) {
                        WHScreen.showmessage("Incompatible version of saved game found!", 360);
                    }
                }
            });
        }
    }

    public static boolean canLoad(FileEntry fil) {
        return fil.load(is -> {
            int nVersion = Whldsv.checkSave(is) & 0xFFFF;
            if (nVersion != 105) {
                if (nVersion >= 100) {
                    EpisodeInfo ep;
                    EpisodeInfo addon = loader.LoadGDXHeader(is);
                    EpisodeInfo episodeInfo = ep = addon != null ? addon : Globals.gOriginalEpisode;
                    if (ep != null && ep.getMap(Whldsv.loader.mapon) != null && Whldsv.loader.skill >= 0 && Whldsv.loader.skill < 5 && Whldsv.loader.warp_on != 1) {
                        MenuCorruptGame menu = (MenuCorruptGame)Main.game.menu.mMenus[13];
                        menu.setRunnable(() -> Main.gGameScreen.newgame(ep, Whldsv.loader.mapon, Whldsv.loader.skill));
                        Main.game.menu.mOpen(menu, -1);
                    }
                }
                throw new IOException("Wrong file version");
            }
        });
    }

    private static void save(OutputStream os, String savename, long time) throws IOException {
        Whldsv.SaveHeader(os, savename, time);
        Whldsv.SaveGDXBlock(os);
        Whldsv.StuffSave(os);
        Whldsv.MapSave(os);
        Whldsv.SectorSave(os);
        Whldsv.AnimationSave(os);
    }

    public static void savegame(Directory dir, String savename, String filename) {
        block9: {
            FileEntry file = dir.getEntry(filename);
            if (file.exists() && !file.delete()) {
                WHScreen.showmessage("Game not saved. Access denied!", 360);
                return;
            }
            Path path = dir.getPath().resolve(filename);
            try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
                long time = Main.game.date.getCurrentDate();
                Whldsv.save(os, savename, time);
                file = dir.addEntry(path);
                if (file.exists()) {
                    Main.game.pSavemgr.add(savename, time, file);
                    lastload = file;
                    WHScreen.showmessage("GAME SAVED", 360);
                    break block9;
                }
                throw new FileNotFoundException(filename);
            }
            catch (Exception e) {
                WHScreen.showmessage("Game not saved! " + e, 360);
            }
        }
    }

    public static void SaveHeader(OutputStream os, String savename, long time) throws IOException {
        Whldsv.SaveVersion(os, 105);
        StreamUtils.writeLong(os, time);
        StreamUtils.writeString(os, savename, 32);
        StreamUtils.writeInt(os, WHPLR.mapon);
        StreamUtils.writeInt(os, Globals.difficulty);
    }

    public static void SaveGDXBlock(OutputStream os) throws IOException {
        StreamUtils.writeBytes(os, Main.gGameScreen.captBuffer);
        int warp_on = 0;
        if (Main.mUserFlag == Main.UserFlag.UserMap) {
            warp_on = 1;
        }
        if (Main.mUserFlag == Main.UserFlag.Addon) {
            warp_on = 2;
        }
        StreamUtils.writeByte(os, warp_on);
        if (warp_on == 2) {
            StreamUtils.writeDataString(os, Globals.gCurrentEpisode.getPath());
        }
        if (Globals.boardfilename != null && Globals.boardfilename.exists()) {
            if (Globals.boardfilename instanceof FileEntry) {
                StreamUtils.writeDataString(os, ((FileEntry)Globals.boardfilename).getPath().toString());
            } else {
                StreamUtils.writeDataString(os, Globals.boardfilename.getName());
            }
        } else {
            StreamUtils.writeDataString(os, "");
        }
        Main.gGameScreen.captBuffer = null;
    }

    public static void SectorSave(OutputStream os) throws IOException {
        int j;
        int i;
        for (i = 0; i < 64; ++i) {
            StreamUtils.writeShort(os, WHFX.skypanlist[i]);
        }
        StreamUtils.writeShort(os, WHFX.skypancnt);
        for (i = 0; i < 32; ++i) {
            StreamUtils.writeShort(os, WHFX.lavadrylandsector[i]);
        }
        StreamUtils.writeShort(os, WHFX.lavadrylandcnt);
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeShort(os, WHTAG.dragsectorlist[i]);
            StreamUtils.writeShort(os, WHTAG.dragxdir[i]);
            StreamUtils.writeShort(os, WHTAG.dragydir[i]);
            StreamUtils.writeInt(os, WHTAG.dragx1[i]);
            StreamUtils.writeInt(os, WHTAG.dragy1[i]);
            StreamUtils.writeInt(os, WHTAG.dragx2[i]);
            StreamUtils.writeInt(os, WHTAG.dragy2[i]);
            StreamUtils.writeInt(os, WHTAG.dragfloorz[i]);
        }
        StreamUtils.writeShort(os, WHTAG.dragsectorcnt);
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeShort(os, WHFX.bobbingsectorlist[i]);
        }
        StreamUtils.writeShort(os, WHFX.bobbingsectorcnt);
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeShort(os, WHTAG.warpsectorlist[i]);
        }
        StreamUtils.writeShort(os, WHTAG.warpsectorcnt);
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeShort(os, WHTAG.xpanningsectorlist[i]);
        }
        StreamUtils.writeShort(os, WHTAG.xpanningsectorcnt);
        for (i = 0; i < 128; ++i) {
            StreamUtils.writeShort(os, WHTAG.ypanningwalllist[i]);
        }
        StreamUtils.writeShort(os, WHTAG.ypanningwallcnt);
        for (i = 0; i < 64; ++i) {
            StreamUtils.writeShort(os, WHTAG.floorpanninglist[i]);
        }
        StreamUtils.writeShort(os, WHTAG.floorpanningcnt);
        StreamUtils.writeShort(os, WHTAG.swingcnt);
        for (i = 0; i < 32; ++i) {
            for (j = 0; j < 8; ++j) {
                StreamUtils.writeShort(os, (short)WHTAG.swingdoor[i].wall[j]);
            }
            StreamUtils.writeShort(os, (short)WHTAG.swingdoor[i].sector);
            StreamUtils.writeShort(os, (short)WHTAG.swingdoor[i].angopen);
            StreamUtils.writeShort(os, (short)WHTAG.swingdoor[i].angclosed);
            StreamUtils.writeShort(os, (short)WHTAG.swingdoor[i].angopendir);
            StreamUtils.writeShort(os, (short)WHTAG.swingdoor[i].ang);
            StreamUtils.writeShort(os, (short)WHTAG.swingdoor[i].anginc);
            for (j = 0; j < 8; ++j) {
                StreamUtils.writeInt(os, WHTAG.swingdoor[i].x[j]);
            }
            for (j = 0; j < 8; ++j) {
                StreamUtils.writeInt(os, WHTAG.swingdoor[i].y[j]);
            }
        }
        StreamUtils.writeShort(os, WHFX.revolvecnt);
        for (i = 0; i < 4; ++i) {
            StreamUtils.writeShort(os, WHFX.revolvesector[i]);
            StreamUtils.writeShort(os, WHFX.revolveang[i]);
            for (j = 0; j < 32; ++j) {
                StreamUtils.writeInt(os, WHFX.revolvex[i][j]);
                StreamUtils.writeInt(os, WHFX.revolvey[i][j]);
            }
            StreamUtils.writeInt(os, WHFX.revolvepivotx[i]);
            StreamUtils.writeInt(os, WHFX.revolvepivoty[i]);
        }
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeShort(os, WHFX.revolveclip[i]);
        }
        StreamUtils.writeShort(os, WHTAG.ironbarscnt);
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeShort(os, WHTAG.ironbarsector[i]);
            StreamUtils.writeInt(os, WHTAG.ironbarsgoal[i]);
            StreamUtils.writeInt(os, WHTAG.ironbarsgoal1[i]);
            StreamUtils.writeInt(os, WHTAG.ironbarsgoal2[i]);
            StreamUtils.writeShort(os, WHTAG.ironbarsdone[i]);
            StreamUtils.writeShort(os, WHTAG.ironbarsanim[i]);
        }
    }

    public static void StuffSave(OutputStream os) throws IOException {
        int i;
        StreamUtils.writeInt(os, Globals.kills);
        StreamUtils.writeInt(os, Globals.killcnt);
        StreamUtils.writeInt(os, Globals.treasurescnt);
        StreamUtils.writeInt(os, Globals.treasuresfound);
        StreamUtils.writeInt(os, Globals.hours);
        StreamUtils.writeInt(os, Globals.minutes);
        StreamUtils.writeInt(os, Globals.seconds);
        StreamUtils.writeInt(os, Engine.visibility);
        StreamUtils.writeInt(os, WHFX.thunderflash);
        StreamUtils.writeInt(os, WHFX.thundertime);
        StreamUtils.writeInt(os, Main.engine.getrand());
        Engine.show2dsector.writeObject(os);
        Engine.show2dwall.writeObject(os);
        Engine.show2dsprite.writeObject(os);
        StreamUtils.writeByte(os, Engine.automapping);
        StreamUtils.writeShort(os, Engine.pskybits);
        WHRenderer renderer = Main.game.getRenderer();
        StreamUtils.writeInt(os, renderer.getParallaxScale());
        for (i = 0; i < 256; ++i) {
            StreamUtils.writeShort(os, Engine.pskyoff[i]);
        }
        StreamUtils.writeShort(os, Mmulti.connecthead);
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeShort(os, Mmulti.connectpoint2[i]);
        }
        for (i = 0; i < 16; ++i) {
            WHPLR.player[i].writeObject(os);
        }
        StreamUtils.writeInt(os, WHPLR.player[Mmulti.myconnectindex].getDropshieldcnt());
        StreamUtils.writeByte(os, WHPLR.player[Mmulti.myconnectindex].isDroptheshield() ? 1 : 0);
        StreamUtils.writeInt(os, Globals.floormirrorcnt);
        for (i = 0; i < 64; ++i) {
            StreamUtils.writeShort(os, Globals.floormirrorsector[i]);
        }
        for (i = 0; i < 100; ++i) {
            StreamUtils.writeShort(os, Globals.arrowsprite[i]);
        }
        for (i = 0; i < 100; ++i) {
            StreamUtils.writeShort(os, Globals.throwpikesprite[i]);
        }
        StreamUtils.writeInt(os, Engine.MAXSECTORS);
        for (i = 0; i < Engine.MAXSECTORS; ++i) {
            StreamUtils.writeByte(os, Globals.ceilingshadearray[i]);
            StreamUtils.writeByte(os, Globals.floorshadearray[i]);
        }
        StreamUtils.writeInt(os, Engine.MAXWALLS);
        for (i = 0; i < Engine.MAXWALLS; ++i) {
            StreamUtils.writeByte(os, Globals.wallshadearray[i]);
        }
    }

    public static void MapSave(OutputStream os) throws IOException {
        Board board = Main.boardService.getBoard();
        Sector[] sectors = board.getSectors();
        StreamUtils.writeInt(os, sectors.length);
        for (Sector s : sectors) {
            s.writeObject(os);
        }
        Wall[] walls = board.getWalls();
        StreamUtils.writeInt(os, walls.length);
        for (Wall wal : walls) {
            wal.writeObject(os);
        }
        List<Sprite> sprites = board.getSprites();
        StreamUtils.writeInt(os, sprites.size());
        for (Sprite s : sprites) {
            s.writeObject(os);
        }
    }

    public static void SaveVersion(OutputStream os, int nVersion) throws IOException {
        StreamUtils.writeString(os, savsign);
        StreamUtils.writeShort(os, nVersion);
    }

    public static void AnimationSave(OutputStream os) throws IOException {
        for (int i = 0; i < 512; ++i) {
            StreamUtils.writeShort(os, Animate.gAnimationData[i].id);
            StreamUtils.writeByte(os, Animate.gAnimationData[i].type);
            StreamUtils.writeInt(os, Animate.gAnimationData[i].goal);
            StreamUtils.writeInt(os, Animate.gAnimationData[i].vel);
            StreamUtils.writeInt(os, Animate.gAnimationData[i].acc);
        }
        StreamUtils.writeInt(os, Animate.gAnimationCount);
    }

    public static void quicksave() {
        if (WHPLR.player[Mmulti.myconnectindex].getHealth() != 0) {
            gQuickSaving = true;
        }
    }

    static {
        lsInf = new LSInfo();
        quickslot = 0;
        loader = new SafeLoader();
    }
}

