#ifndef __SIMPLEVECTOR_H_
#define __SIMPLEVECTOR_H_

#include <malloc.h>
#include <stdlib.h>

template <class T> class SimpleVectorMember
{
  public:
	  SimpleVectorMember():
		next(NULL),
		prev(NULL)
  {
  }
  ~SimpleVectorMember(){}
  
  T data;
  SimpleVectorMember* next;
  SimpleVectorMember* prev;
};

template <class T> class SimpleVector
{
private:
	SimpleVectorMember<T> *front_data;
	SimpleVectorMember<T> *back_data;
	int m_nSize;
	
public:
	SimpleVector():
		front_data(NULL),
		back_data(NULL),
		m_nSize(0)
	{
	}

	~SimpleVector()
	{
		if(front_data != NULL)
		{
			FreeStack();
		} 
	}	

	class iterator
	{
		public: 
			iterator():
			  data(NULL),
			  iterations(0)
			{
			}

			iterator(SimpleVectorMember<T>* in):
			iterations(0)
			{
				data = in;
			}

			~iterator()
			{
			}

			T* operator++()
			{
				if(iterations == 0)
				{
					++iterations;
					return &(data->data);
				}else
				{
					++iterations;
					data = data->next;
					return &(data->data);
				}

				++iterations;
				// should never get here
				return &(data->data);
			}

			bool operator!=(const SimpleVectorMember<T>* in)
			{
				return (data->next != in);
			}

			SimpleVectorMember<T>* operator=(SimpleVectorMember<T>* in)
			{
				iterations = 0;
				data = in;
				return data;
			}

			bool isValid()
			{
				return (data != NULL);
			}
		private:
			SimpleVectorMember<T>* data;
			unsigned long iterations;
	};
	
	//
	int GetSize()
	{
		return m_nSize;
	}
	
	//
	void FreeStack()
	{
		SimpleVectorMember<T> *_data = front_data;
		
		for(;_data;)
		{
			SimpleVectorMember<T> *pNext;
			pNext = _data->next;
			free(_data);
			_data = pNext;
		}
		front_data = NULL;
		back_data = NULL;
	}

	//
	void push_front(T value)
	{
		SimpleVectorMember<T> *stackmember;            
		stackmember = (SimpleVectorMember<T>*)malloc( sizeof(SimpleVectorMember<T>) );      
		if( stackmember != NULL )
		{
			stackmember->data = value;
			stackmember->prev = NULL;
			
			if(front_data != NULL)
			{
				front_data->prev = stackmember;
			}

			if(back_data == NULL)
			{
				back_data = stackmember;
			}

			stackmember->next = front_data;
			front_data = stackmember;
			m_nSize++;
		}
	}

	//
	void push_back(T value)
	{
		SimpleVectorMember<T> *stackmember;            
		stackmember = (SimpleVectorMember<T>*)malloc( sizeof(SimpleVectorMember<T>) );      
		if( stackmember != NULL )
		{
			stackmember->data = value;
			stackmember->prev = back_data;
			
			if(back_data != NULL)
			{
				back_data->next = stackmember;
			}

			if(front_data == NULL)
			{
				front_data = stackmember;
			}

			stackmember->next = NULL;
			back_data = stackmember;
			m_nSize++;
		}
	}

	SimpleVectorMember<T>* begin()
	{
		return front_data;
	}

	SimpleVectorMember<T>* end()
	{
		return back_data + sizeof(back_data);
	}

	//
	SimpleVectorMember<T>* peek_front()
	{
		return front_data;
	}

	//
	SimpleVectorMember<T>* peek_back()
	{
		return back_data;
	}

	// Remove an element by index
	void Remove(unsigned int i)
	{
		SimpleVectorMember<T> *pPrev = NULL;
		SimpleVectorMember<T> *pThis;
		pThis = data;

		if(NULL != data)
		for(unsigned int j = 0; j < m_nSize; j++)
		{
			if(j == i)
			{
				if(NULL == pPrev)
				{
					data = pThis->next;
				}
				else
				{
					pPrev->next = pThis->next;
				}

				if(pThis)
				{
					free(pThis);
					m_nSize--;
				}				

				return;
			}
			
			pPrev = pThis;
			pThis = pThis->next;
		}		
	}

	// Remove an element by value...
	void Remove(T element)
	{

	}
	
};

#endif //__SIMPLEVECTOR_H_

