/*
  Lame duke to Duke 3D map converter.
  By Mark Jaskolski (Mark_Jaskolski@Hotmail.com)

  Basically, this program converts the tile numbers
  used in Lameduke to their equivilent numbers in the
  Duke 3D tileset. Where no close match was available,
  I have simply picked a tile which I thought was
  close enough (Which doesn't always look as good).

  The program expects to find the original lameduke
  maps (Converted up to version 7 format) in the
  directory

  C:\LAMEDUKE\

  And all converted maps are placed into this
  directory here (Previous maps with the same name
  will be overwritten).

  C:\LAMECONV\

  You can change these directories if you want, but
  you will have to recompile the source.

  If you don't like the tile conversions I have used,
  you can change them. Just modify the entries in the
  huge switch statement towards the end of the file.
  The leftmost number is the LameDuke tile number, and
  the rightmost number (the one before the break) is
  the Duke3D tile to convert it to.

  Do what you want with this program, It's being
  released to the public domain as-is. Let's face it,
  you can't exactly make this program worse anyway.  
*/

short tileconv(short oldtile);

//Directory that holds the original lameduke maps
static const char *inpath = "C:\\LAMEDUKE\\";

//Directory where the converted maps will be placed
static const char *outpath = "C:\\LAMECONV\\";

//Holds x/y coord of last bad tile
static long x;
static long y;

//Number of tiles processed
static long tilecount = 0;

//Number of tiles which weren't converted
static long badcount = 0;

//Names of the map files to convert
#define LEVELCOUNT 29
static const char *filename[] =
{
  "L1","L2","L3","L4","L5","L6","L7","L8",
  "M1","M2","M3","M4","M5","M6","M7",
  "N1","N2","N3","N4","N5","N6","N7","N8",
  "O1","O2","O3","O4",
  "WAR1","WAR2"
};

#include <malloc.h>;
#include <fcntl.h>;

void main()
{
  char *temp;
  char *tempptr;

  char buffer[256];
  char infile[256];
  char outfile[256];
 
  char level;

  char inhandle;
  char outhandle;

  long version;
  long readsize;
  long writesize;
  short itemcount;

  long l;

  temp = malloc(262144);

  for(level=0;level<LEVELCOUNT;level++)
  {

    strcpy(buffer,filename[level]);
    strcat(buffer,".MAP");
    printf("**** PROCESSING %s ****\n",buffer);

    strcpy(infile,inpath);
    strcat(infile,buffer);
    strcpy(outfile,outpath);
    strcat(outfile,buffer);

    inhandle = open(infile,O_RDONLY|O_BINARY);
    if(inhandle == -1)
    {
      printf("Unable to open infile %s!\n",infile);
      break;
    }

    outhandle = open(outfile,O_WRONLY|O_CREAT|O_TRUNC|O_BINARY);
    if(outhandle == -1)
    {
      printf("Unable to open outfile %s!\n",outfile);
      close(inhandle);
      break;
    }

    x = -1;
    y = -1;

    readsize = read(inhandle,&version,4);
    if(readsize != 4 || version != 7)
    {
      printf("Mapfile %s is corrupt!\n",infile);
      close(inhandle);
      close(outhandle);
      break;
    }
    writesize = write(outhandle,&version,4);
    readsize = read(inhandle,temp,16);
    writesize = write(outhandle,temp,16);

    //Convert sector floor and ceilings.

    readsize = read(inhandle,&itemcount,2);
    writesize = write(outhandle,&itemcount,2);
    readsize = read(inhandle,temp,itemcount*40);   
    tempptr = temp;
    printf("  Converting %d sectors.\n",itemcount);
    for(l=0;l<itemcount;l++)
    {
      tempptr += 16;
      *((short *) tempptr) = tileconv(*((short *) tempptr)); //Ceiling texture
      tempptr += 8;
      *((short *) tempptr) = tileconv(*((short *) tempptr)); //Floor texture
      tempptr += 16;
    }
    writesize = write(outhandle,temp,itemcount*40);

    //Convert walls

    readsize = read(inhandle,&itemcount,2);
    writesize = write(outhandle,&itemcount,2);
    readsize = read(inhandle,temp,itemcount*32);
    tempptr = temp;
    printf("  Converting %d walls.\n",itemcount);
    for(l=0;l<itemcount;l++)
    {
      x = *((long *) tempptr);
      tempptr+=4;
      y = *((long *) tempptr);
      tempptr+=12;
      *((short *) tempptr) = tileconv(*((short *) tempptr)); //Wall tile
      tempptr+=2;
      *((short *) tempptr) = tileconv(*((short *) tempptr)); //Mask tile
      tempptr+=14;
    }
    writesize = write(outhandle,temp,itemcount*32);

    //Convert sprites

    readsize = read(inhandle,&itemcount,2);
    writesize = write(outhandle,&itemcount,2);
    readsize = read(inhandle,temp,itemcount*44);
    tempptr = temp;
    printf("  Converting %d sprites.\n",itemcount);
    for(l=0;l<itemcount;l++)
    {
      x = *((long *) tempptr);
      tempptr+=4;
      y = *((long *) tempptr);
      tempptr+=10;
      *((short *) tempptr) = tileconv(*((short *) tempptr)); //Sprite tile
      tempptr+=30;
    }
    writesize = write(outhandle,temp,itemcount*44);

    close(inhandle);
    close(outhandle);
  }
  free(temp);

  printf("Processed %d tiles (%d tiles were not converted).\n\n",tilecount,badcount);
  printf("Done!\n");
}

short tileconv(short oldtile)
{
  short newtile;

  tilecount++;
  switch(oldtile)
  {
    case -1: newtile = 0; break; //CHECK!
    case 0: newtile = 0; break;
    case 1: newtile = 804; break;
    case 3: newtile = 396; break;
    case 4: newtile = 397; break;
    case 5: newtile = 5; break;
    case 6: newtile = 241; break;
    case 7: newtile = 241; break;
    case 9: newtile = 722; break;
    case 10: newtile = 241; break;
    case 11: newtile = 755; break;
    case 12: newtile = 756; break;
    case 13: newtile = 740; break;
    case 14: newtile = 1015; break;
    case 16: newtile = 241; break;
    case 17: newtile = 241; break;
    case 18: newtile = 750; break;
    case 19: newtile = 397; break;
    case 21: newtile = 757; break;
    case 22: newtile = 241; break;
    case 23: newtile = 4; break;
    case 24: newtile = 241; break;
    case 25: newtile = 789; break;
    case 26: newtile = 701; break;
    case 27: newtile = 340; break; //FIX
    case 28: newtile = 772; break;
    case 29: newtile = 241; break;
    case 30: newtile = 618; break;
    case 31: newtile = 2; break;
    case 32: newtile = 3; break;
    case 33: newtile = 937; break;
    case 34: newtile = 6; break;
    case 35: newtile = 703; break;
    case 36: newtile = 705; break;
    case 37: newtile = 619; break;
    case 38: newtile = 22; break;
    case 39: newtile = 346; break;
    case 40: newtile = 347; break;
    case 41: newtile = 348; break;
    case 42: newtile = 345; break;
    case 43: newtile = 347; break;
    case 44: newtile = 347; break; //FIX
    case 45: newtile = 346; break;
    case 49: newtile = 336; break;
    case 50: newtile = 336; break;
    case 51: newtile = 8; break;
    case 52: newtile = 1174; break; //FIX
    case 53: newtile = 1169; break;
    case 54: newtile = 880; break;
    case 55: newtile = 741; break;
    case 56: newtile = 0; break; //CHECK!
    case 57: newtile = 1247; break;
    case 58: newtile = 1169; break; //FIX
    case 59: newtile = 966; break;
    case 60: newtile = 51; break;
    case 68: newtile = 350; break;
    case 69: newtile = 350; break;
    case 70: newtile = 616; break;
    case 71: newtile = 1169; break;
    case 72: newtile = 1174; break;
    case 73: newtile = 401; break;
    case 74: newtile = 843; break;
    case 75: newtile = 875; break;
    case 76: newtile = 887; break;
    case 77: newtile = 725; break;
    case 78: newtile = 1169; break;
    case 79: newtile = 1169; break;
    case 81: newtile = 1169; break;
    case 83: newtile = 771; break;
    case 84: newtile = 3420; break;
    case 85: newtile = 868; break;
    case 86: newtile = 914; break;
    case 87: newtile = 350; break;
    case 88: newtile = 350; break;
    case 89: newtile = 89; break;
    case 90: newtile = 3420; break;
    case 91: newtile = 353; break;
    case 92: newtile = 354; break;
    case 93: newtile = 355; break;
    case 94: newtile = 99; break;
    case 95: newtile = 980; break;
    case 96: newtile = 419; break;
    case 100: newtile = 2969; break;
    case 167: newtile = 977; break;
    case 168: newtile = 800; break;
    case 169: newtile = 801; break;
    case 170: newtile = 802; break;
    case 171: newtile = 803; break;
    case 172: newtile = 978; break;
    case 173: newtile = 979; break;
    case 175: newtile = 1; break;
    case 176: newtile = 805; break;
    case 177: newtile = 805; break;
    case 178: newtile = 198; break;
    case 179: newtile = 503; break;
    case 180: newtile = 232; break;
    case 181: newtile = 981; break;
    case 183: newtile = 805; break;
    case 184: newtile = 805; break;
    case 185: newtile = 763; break;
    case 186: newtile = 759; break;
    case 189: newtile = 759; break;
    case 190: newtile = 399; break;
    case 195: newtile = 983; break;
    case 196: newtile = 984; break;
    case 197: newtile = 985; break;
    case 200: newtile = 988; break;
    case 202: newtile = 84; break;
    case 203: newtile = 815; break;
    case 204: newtile = 814; break;
    case 205: newtile = 815; break;
    case 206: newtile = 816; break;
    case 207: newtile = 817; break;
    case 208: newtile = 818; break;
    case 209: newtile = 182; break;
    case 210: newtile = 183; break;
    case 211: newtile = 182; break;
    case 212: newtile = 124; break;
    case 213: newtile = 572; break;
    case 216: newtile = 622; break;
    case 217: newtile = 407; break;
    case 220: newtile = 734; break; //FIX
    case 221: newtile = 821; break;
    case 222: newtile = 822; break;
    case 223: newtile = 355; break;
    case 224: newtile = 823; break;
    case 225: newtile = 340; break; //FIX
    case 226: newtile = 460; break;
    case 227: newtile = 186; break;
    case 228: newtile = 187; break;
    case 229: newtile = 188; break;
    case 230: newtile = 189; break;
    case 231: newtile = 191; break;
    case 232: newtile = 191; break;
    case 233: newtile = 1088; break;
    case 234: newtile = 192; break;
    case 262: newtile = 395; break; //FIX
    case 263: newtile = 2370; break;
    case 265: newtile = 621; break;
    case 266: newtile = 621; break;
    case 267: newtile = 621; break;
    case 268: newtile = 621; break;
    case 280: newtile = 454; break;
    case 281: newtile = 318; break;
    case 282: newtile = 365; break;
    case 283: newtile = 1405; break;
    case 284: newtile = 1406; break;
    case 291: newtile = 197; break;
    case 292: newtile = 318; break;
    case 293: newtile = 318; break;
    case 294: newtile = 827; break;
    case 295: newtile = 827; break;
    case 296: newtile = 827; break;
    case 303: newtile = 0; break; //SOME CONTROLLER 'C'
    case 305: newtile = 634; break;
    case 310: newtile = 10; break;
    case 313: newtile = 1005; break;
    case 314: newtile = 995; break;
    case 315: newtile = 996; break;
    case 318: newtile = 403; break;
    case 320: newtile = 404; break;
    case 321: newtile = 405; break;
    case 322: newtile = 406; break;
    case 327: newtile = 1255; break;
    case 331: newtile = 503; break;
    case 332: newtile = 385; break;
    case 333: newtile = 739; break;
    case 334: newtile = 407; break;
    case 338: newtile = 340; break;
    case 342: newtile = 887; break;
    case 343: newtile = 967; break;
    case 344: newtile = 968; break;
    case 345: newtile = 886; break;
    case 347: newtile = 970; break;
    case 349: newtile = 1173; break; //FIX
    case 350: newtile = 1173; break;
    case 351: newtile = 150; break;
    case 352: newtile = 150; break;
    case 354: newtile = 460; break;
    case 355: newtile = 454; break;
    case 356: newtile = 887; break;
    case 357: newtile = 3411; break;
    case 358: newtile = 711; break;
    case 359: newtile = 726; break;
    case 360: newtile = 727; break;
    case 362: newtile = 887; break;
    case 363: newtile = 1151; break;
    case 364: newtile = 1151; break;
    case 365: newtile = 1141; break;
    case 368: newtile = 720; break;
    case 369: newtile = 355; break;
    case 371: newtile = 834; break;
    case 372: newtile = 835; break;
    case 373: newtile = 836; break;
    case 374: newtile = 843; break;
    case 375: newtile = 837; break;
    case 376: newtile = 222; break;
    case 377: newtile = 0; break; //CHECK
    case 378: newtile = 937; break;
    case 379: newtile = 232; break;
    case 380: newtile = 222; break;
    case 381: newtile = 998; break;
    case 384: newtile = 1000; break;
    case 385: newtile = 1001; break;
    case 386: newtile = 222; break;
    case 387: newtile = 259; break;
    case 388: newtile = 222; break;
    case 395: newtile = 132; break;
    case 398: newtile = 203; break;
    case 399: newtile = 203; break;
    case 400: newtile = 850; break;
    case 401: newtile = 929; break;
    case 402: newtile = 203; break;
    case 403: newtile = 204; break;
    case 404: newtile = 205; break;
    case 405: newtile = 164; break;
    case 406: newtile = 165; break;
    case 407: newtile = 913; break;
    case 408: newtile = 1680; break;
    case 457: newtile = 1702; break;
    case 477: newtile = 754; break;
    case 478: newtile = 754; break;
    case 479: newtile = 754; break;
    case 480: newtile = 754; break;
    case 483: newtile = 840; break;
    case 485: newtile = 840; break;
    case 488: newtile = 1226; break; //PAL=2
    case 490: newtile = 1920; break;
    case 570: newtile = 560; break;
    case 572: newtile = 562; break; //FIX
    case 573: newtile = 198; break; //FIX
    case 574: newtile = 504; break;
    case 579: newtile = 1880; break;
    case 593: newtile = 887; break;
    case 594: newtile = 887; break;
    case 595: newtile = 887; break;
    case 596: newtile = 887; break;
    case 598: newtile = 887; break;
    case 600: newtile = 243; break;
    case 601: newtile = 244; break;
    case 602: newtile = 828; break;
    case 603: newtile = 829; break;
    case 604: newtile = 365; break;
    case 605: newtile = 719; break;
    case 606: newtile = 569; break;
    case 607: newtile = 570; break;
    case 608: newtile = 1353; break; //FIX
    case 609: newtile = 572; break;
    case 620: newtile = 1088; break;
    case 626: newtile = 886; break;
    case 627: newtile = 1238; break;
    case 628: newtile = 1034; break;
    case 631: newtile = 1355; break;
    case 633: newtile = 955; break;
    case 634: newtile = 1015; break;
    case 635: newtile = 365; break;
    case 636: newtile = 770; break;
    case 637: newtile = 771; break;
    case 638: newtile = 812; break;
    case 639: newtile = 773; break;
    case 660: newtile = 128; break; //PURPLE
    case 661: newtile = 128; break; //BLUE
    case 662: newtile = 128; break; //GREEN
    case 663: newtile = 128; break; //BLUE
    case 664: newtile = 704; break;
    case 665: newtile = 706; break;
    case 670: newtile = 702; break;
    case 671: newtile = 125; break;
    case 672: newtile = 243; break;
    case 677: newtile = 621; break;
    case 690: newtile = 2333; break;
    case 720: newtile = 100; break;
    case 721: newtile = 26; break;
    case 722: newtile = 52; break;
    case 723: newtile = 40; break;
    case 724: newtile = 55; break;
    case 726: newtile = 54; break;
    case 728: newtile = 57; break;
    case 730: newtile = 325; break; //FIX
    case 733: newtile = 325; break; //FIX
    case 734: newtile = 311; break;
    case 735: newtile = 158; break;
    case 736: newtile = 400; break;
    case 737: newtile = 260; break; //PAL=2 IN LAMEDUKE
    case 741: newtile = 153; break;
    case 742: newtile = 311; break;
    case 740: newtile = 152; break;
    case 748: newtile = 311; break;
    case 751: newtile = 311; break;
    case 753: newtile = 311; break;
    case 754: newtile = 311; break;
    case 756: newtile = 263; break;
    case 757: newtile = 264; break;
    case 758: newtile = 265; break;
    case 759: newtile = 266; break;
    case 760: newtile = 267; break;
    case 761: newtile = 268; break;
    case 764: newtile = 271; break;
    case 765: newtile = 272; break;
    case 766: newtile = 273; break;
    case 767: newtile = 274; break;
    case 768: newtile = 275; break;
    case 769: newtile = 1289; break;
    case 774: newtile = 311; break;
    case 775: newtile = 311; break;
    case 777: newtile = 276; break;
    case 779: newtile = 311; break;
    case 781: newtile = 311; break;
    case 782: newtile = 311; break;
    case 784: newtile = 311; break;
    case 785: newtile = 311; break;
    case 786: newtile = 685; break;
    case 787: newtile = 1006; break;
    case 788: newtile = 1007; break;
    case 789: newtile = 1008; break;
    case 790: newtile = 758; break;
    case 793: newtile = 1009; break;
    case 796: newtile = 954; break;
    case 797: newtile = 956; break; //FIX
    case 798: newtile = 94; break;
    case 799: newtile = 797; break;
    case 800: newtile = 278; break;
    case 808: newtile = 285; break;
    case 809: newtile = 286; break;
    case 810: newtile = 595; break; //FIX XREPEAT
    case 811: newtile = 288; break;
    case 812: newtile = 289; break;
    case 813: newtile = 290; break;
    case 814: newtile = 291; break;
    case 817: newtile = 747; break;
    case 818: newtile = 748; break;
    case 819: newtile = 293; break;
    case 823: newtile = 301; break;
    case 827: newtile = 1022; break;
    case 828: newtile = 1023; break;
    case 830: newtile = 310; break;
    case 831: newtile = 1024; break;
    case 832: newtile = 311; break;
    case 833: newtile = 312; break;
    case 834: newtile = 313; break;
    case 835: newtile = 314; break; //FIX
    case 836: newtile = 315; break;
    case 837: newtile = 315; break;
    case 838: newtile = 1025; break;
    case 839: newtile = 749; break;
    case 841: newtile = 318; break;
    case 842: newtile = 742; break;
    case 843: newtile = 743; break;
    case 844: newtile = 880; break;
    case 845: newtile = 370; break;
    case 846: newtile = 370; break;
    case 847: newtile = 319; break;
    case 848: newtile = 344; break;
    case 849: newtile = 319; break; //797
    case 850: newtile = 322; break;
    case 851: newtile = 323; break;
    case 852: newtile = 324; break;
    case 853: newtile = 1098; break;
    case 854: newtile = 311; break;
    case 855: newtile = 326; break;
    case 856: newtile = 327; break;
    case 857: newtile = 328; break;
    case 859: newtile = 1097; break;
    case 860: newtile = 297; break;
    case 864: newtile = 305; break;
    case 868: newtile = 1020; break;
    case 869: newtile = 1021; break;
    case 888: newtile = 278; break;
    case 890: newtile = 311; break;
    case 891: newtile = 311; break;
    case 892: newtile = 311; break;
    case 893: newtile = 311; break;
    case 894: newtile = 311; break;
    case 895: newtile = 311; break;
    case 897: newtile = 331; break;
    case 898: newtile = 332; break;
    case 899: newtile = 191; break;
    case 900: newtile = 355; break;
    case 901: newtile = 976; break;
    case 905: newtile = 904; break;
    case 908: newtile = 908; break;
    case 909: newtile = 909; break;
    case 910: newtile = 0; break; //NO TILE, CHECK THIS!
    case 921: newtile = 0; break; //NO TILE, CHECK THIS!
    case 930: newtile = 2360; break;
    case 931: newtile = 2360; break;
    case 940: newtile = 940; break;
    case 957: newtile = 1061; break;
    case 959: newtile = 977; break;
    case 960: newtile = 660; break;
    case 961: newtile = 2370; break;
    case 974: newtile = 1026; break;
    case 981: newtile = 216; break;
    case 982: newtile = 758; break;
    case 983: newtile = 758; break;
    case 984: newtile = 925; break;
    case 985: newtile = 926; break;
    case 986: newtile = 964; break;
    case 987: newtile = 3411; break;
    case 988: newtile = 3411; break;
    case 990: newtile = 723; break;
    case 991: newtile = 3394; break;
    case 992: newtile = 3396; break;
    case 994: newtile = 764; break;
    case 995: newtile = 723; break;
    case 996: newtile = 725; break;
    case 998: newtile = 335; break;
    case 1002: newtile = 791; break;
    case 1004: newtile = 767; break;
    case 1006: newtile = 767; break;
    case 1007: newtile = 767; break;
    case 1010: newtile = 767; break;
    case 1012: newtile = 797; break;
    case 1013: newtile = 285; break;
    case 1014: newtile = 286; break;
    case 1015: newtile = 286; break;
    case 1016: newtile = 767; break;
    case 1018: newtile = 218; break;
    case 1019: newtile = 1196; break;
    case 1021: newtile = 218; break;
    case 1119: newtile = 44; break;
    case 1120: newtile = 41; break;
    case 1121: newtile = 23; break;
    case 1123: newtile = 160; break;
    case 1124: newtile = 25; break; //FIX
    case 1125: newtile = 21; break;
    case 1174: newtile = 1221; break;
    case 1175: newtile = 1222; break;
    case 1184: newtile = 663; break;
    case 1200: newtile = 1232; break;
    case 1220: newtile = 701; break;
    case 1221: newtile = 702; break;
    case 1222: newtile = 929; break;
    case 1223: newtile = 930; break;
    case 1224: newtile = 931; break;
    case 1225: newtile = 932; break;
    case 1226: newtile = 933; break;
    case 1227: newtile = 934; break;
    case 1228: newtile = 936; break;
    case 1260: newtile = 707; break;
    case 1263: newtile = 322; break; //FIX
    case 1265: newtile = 1140; break;
    case 1280: newtile = 1550; break;
    case 1320: newtile = 640; break;
    case 1321: newtile = 641; break;
    case 1322: newtile = 642; break;
    case 1323: newtile = 643; break;
    case 1324: newtile = 644; break;
    case 1325: newtile = 645; break;
    case 1326: newtile = 646; break;
    case 1327: newtile = 647; break;
    case 1328: newtile = 648; break;
    case 1329: newtile = 649; break;
    case 1330: newtile = 650; break;
    case 1331: newtile = 651; break;
    case 1332: newtile = 652; break;
    case 1333: newtile = 653; break;
    case 1334: newtile = 654; break;
    case 1335: newtile = 655; break;
    case 1336: newtile = 656; break;
    case 1337: newtile = 657; break;
    case 1408: newtile = 502; break;
    case 1536: newtile = 2000; break;
    case 1680: newtile = 2120; break;
    case 1820: newtile = 1820; break;
    default:
    {
      if(x==-1|y==-1)
      {
        printf("TILE %d NOT RECOGNIZED!\n",oldtile);
      }
      else
      {
        printf("TILE %d NOT RECOGNIZED! [%d,%d]\n",oldtile,x,y);
      }
      newtile = oldtile;
      badcount++;
      break;
    }
  }

  return newtile;
}
