// These functions help an actor orient toward other actors or determine their
// orientation/angle in relation to another actor.
// This also includes a function to determine a more accurate line-of-sight to
// the player actor.

gamevar a_t 0 2
gamevar a_tx 0 2
gamevar a_mx 0 2
gamevar a_ty 0 2
gamevar a_my 0 2
gamevar a_return 0 2

gamevar sp_origang 0 2
gamevar sp_x 0 2
gamevar sp_y 0 2
gamevar sp_z 0 2
gamevar sp_sect 0 2
gamevar sp_ang 0 2
gamevar sp_sin 0 2
gamevar sp_cos 0 2
gamevar sp_zvel 0 2
gamevar sp_horiz 0 2
gamevar sp_temp 0 2
gamevar sp_tempz1 0 2
gamevar sp_tempz2 0 2

gamevar sp_return 0 2

gamevar vert_t 0 2
gamevar vert_mz 0 2
gamevar vert_tz 0 2
gamevar vert_tz_mod 0 2
gamevar vert_return 0 2

gamevar hitsect 0 2
gamevar hitwall 0 2
gamevar hitsprite 0 2
gamevar hitx 0 2
gamevar hity 0 2
gamevar hitz 0 2

gamevar OTHERACTOR 0 2
gamevar MCOUNT 0 2

state face_actor
        getactor[a_t].x a_tx
        getactor[a_t].y a_ty
        getactor[THISACTOR].x a_mx
        getactor[THISACTOR].y a_my
        subvarvar a_tx a_mx
        subvarvar a_ty a_my
        getangle a_return a_tx a_ty
        setactor[THISACTOR].ang a_return
ends

state face_vertical
        ldist vert_return THISACTOR vert_t
        getactor[THISACTOR].z vert_mz
        subvar vert_mz 0 // Offset the Z. Assumes center of actor is the same as the player
        getactor[vert_t].z vert_tz
        subvar vert_tz 8192 // Offset the Z. Assumes center of actor is the same as the player
        subvarvar vert_tz vert_tz_mod
        subvarvar vert_tz vert_mz
        shiftvarl vert_tz 8
        divvarvar vert_tz vert_return
        mulvar vert_tz 72
        setvarvar vert_return vert_tz
        setvar vert_tz_mod 0
ends

state see_player // Determine Line-of-Sight to the player
    setvar sp_return 0
    setvar sp_temp 0
       
    getactor[THISACTOR].ang sp_origang    

    getplayer[THISACTOR].i a_t    
    
    state face_actor
    
    getplayer[THISACTOR].i vert_t
    state face_vertical   
    setvarvar sp_zvel vert_return

    getactor[THISACTOR].x sp_x
    getactor[THISACTOR].y sp_y
    getactor[THISACTOR].z sp_z
    // subvar sp_z 8192
    getactor[THISACTOR].sectnum sp_sect
    getactor[THISACTOR].ang sp_ang
        
    cos sp_cos sp_ang
    sin sp_sin sp_ang
    
   // setvarvar sp_zvel mzvels
    hitscan sp_x sp_y sp_z sp_sect sp_cos sp_sin sp_zvel hitsect hitwall hitsprite hitx hity hitz CLIPMASK0
    /* espawn 104
    setactor[RETURN].x hitx
    setactor[RETURN].y hity
    setactor[RETURN].z hitz
    setactor[RETURN].sectnum hitsect
    setactor[RETURN].cstat 32768
    setactor[RETURN].xrepeat 64
    setactor[RETURN].yrepeat 64 
    setactorvar[RETURN].OTHERACTOR THISACTOR */
    ifvarn hitsprite -1
    {
        getplayer[THISACTOR].i sp_temp
        ifvarvarn hitsprite sp_temp
            setvar sp_return 1
    }
    else ifvarn hitsect -1
    {
        getplayer[THISACTOR].cursectnum sp_temp
        ifvarvarn hitsect sp_temp 
            setvar sp_return 1
    }
    else ifvarn hitwall -1
        setvar sp_return 1
    
    setactor[THISACTOR].ang sp_origang
ends

/*
useractor notenemy 104
    cstat 0
    addvar MCOUNT 1
    ifcanseetarget ifcanshoottarget
    {
        setactorvar[OTHERACTOR].sp_return 0
    }
    ifvare MCOUNT 3
        killit
enda */

